/*
 * Decompiled with CFR 0.152.
 */
package com.artofsolving.jodconverter.openoffice.converter;

import com.artofsolving.jodconverter.DocumentFormat;
import com.artofsolving.jodconverter.DocumentFormatRegistry;
import com.artofsolving.jodconverter.openoffice.connection.OpenOfficeConnection;
import com.artofsolving.jodconverter.openoffice.connection.OpenOfficeException;
import com.artofsolving.jodconverter.openoffice.converter.AbstractOpenOfficeDocumentConverter;
import com.sun.star.frame.XComponentLoader;
import com.sun.star.frame.XStorable;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XComponent;
import com.sun.star.task.ErrorCodeIOException;
import com.sun.star.ucb.XFileIdentifierConverter;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.util.CloseVetoException;
import com.sun.star.util.XCloseable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenOfficeDocumentConverter
extends AbstractOpenOfficeDocumentConverter {
    private static final Logger logger = LoggerFactory.getLogger((Class)OpenOfficeDocumentConverter.class);

    public OpenOfficeDocumentConverter(OpenOfficeConnection connection) {
        super(connection);
    }

    public OpenOfficeDocumentConverter(OpenOfficeConnection connection, DocumentFormatRegistry formatRegistry) {
        super(connection, formatRegistry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void convertInternal(InputStream inputStream, DocumentFormat inputFormat, OutputStream outputStream, DocumentFormat outputFormat) {
        File inputFile = null;
        File outputFile = null;
        try {
            inputFile = File.createTempFile("document", "." + inputFormat.getFileExtension());
            FileOutputStream inputFileStream = null;
            try {
                inputFileStream = new FileOutputStream(inputFile);
                IOUtils.copy((InputStream)inputStream, (OutputStream)inputFileStream);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputFileStream);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)inputFileStream);
            outputFile = File.createTempFile("document", "." + outputFormat.getFileExtension());
            this.convert(inputFile, inputFormat, outputFile, outputFormat);
            FileInputStream outputFileStream = null;
            try {
                outputFileStream = new FileInputStream(outputFile);
                IOUtils.copy((InputStream)outputFileStream, (OutputStream)outputStream);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(outputFileStream);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)outputFileStream);
        }
        catch (IOException ioException) {
            throw new OpenOfficeException("conversion failed", ioException);
        }
        finally {
            if (inputFile != null) {
                inputFile.delete();
            }
            if (outputFile != null) {
                outputFile.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void convertInternal(File inputFile, DocumentFormat inputFormat, File outputFile, DocumentFormat outputFormat) {
        HashMap loadProperties = new HashMap();
        loadProperties.putAll(this.getDefaultLoadProperties());
        loadProperties.putAll(inputFormat.getImportOptions());
        Map storeProperties = outputFormat.getExportOptions(inputFormat.getFamily());
        OpenOfficeConnection openOfficeConnection = this.openOfficeConnection;
        synchronized (openOfficeConnection) {
            XFileIdentifierConverter fileContentProvider = this.openOfficeConnection.getFileContentProvider();
            String inputUrl = fileContentProvider.getFileURLFromSystemPath("", inputFile.getAbsolutePath());
            String outputUrl = fileContentProvider.getFileURLFromSystemPath("", outputFile.getAbsolutePath());
            this.loadAndExport(inputUrl, loadProperties, outputUrl, storeProperties);
        }
    }

    private void loadAndExport(String inputUrl, Map loadProperties, String outputUrl, Map storeProperties) throws OpenOfficeException {
        XComponent document;
        try {
            document = this.loadDocument(inputUrl, loadProperties);
        }
        catch (ErrorCodeIOException errorCodeIOException) {
            throw new OpenOfficeException("conversion failed: could not load input document; OOo errorCode: " + errorCodeIOException.ErrCode, errorCodeIOException);
        }
        catch (Exception otherException) {
            throw new OpenOfficeException("conversion failed: could not load input document", otherException);
        }
        if (document == null) {
            throw new OpenOfficeException("conversion failed: could not load input document");
        }
        this.refreshDocument(document);
        try {
            this.storeDocument(document, outputUrl, storeProperties);
        }
        catch (ErrorCodeIOException errorCodeIOException) {
            throw new OpenOfficeException("conversion failed: could not save output document; OOo errorCode: " + errorCodeIOException.ErrCode, errorCodeIOException);
        }
        catch (Exception otherException) {
            throw new OpenOfficeException("conversion failed: could not save output document", otherException);
        }
    }

    private XComponent loadDocument(String inputUrl, Map loadProperties) throws com.sun.star.io.IOException, IllegalArgumentException {
        XComponentLoader desktop = this.openOfficeConnection.getDesktop();
        return desktop.loadComponentFromURL(inputUrl, "_blank", 0, OpenOfficeDocumentConverter.toPropertyValues(loadProperties));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeDocument(XComponent document, String outputUrl, Map storeProperties) throws com.sun.star.io.IOException {
        XCloseable closeable;
        try {
            XStorable storable = (XStorable)UnoRuntime.queryInterface((Class)XStorable.class, (Object)document);
            storable.storeToURL(outputUrl, OpenOfficeDocumentConverter.toPropertyValues(storeProperties));
            closeable = (XCloseable)UnoRuntime.queryInterface((Class)XCloseable.class, (Object)document);
        }
        catch (Throwable throwable) {
            XCloseable closeable2 = (XCloseable)UnoRuntime.queryInterface((Class)XCloseable.class, (Object)document);
            if (closeable2 != null) {
                try {
                    closeable2.close(true);
                }
                catch (CloseVetoException closeVetoException) {
                    logger.warn("document.close() vetoed");
                }
            } else {
                document.dispose();
            }
            throw throwable;
        }
        if (closeable != null) {
            try {
                closeable.close(true);
            }
            catch (CloseVetoException closeVetoException) {
                logger.warn("document.close() vetoed");
            }
        } else {
            document.dispose();
        }
    }
}

