/*
 * Decompiled with CFR 0.152.
 */
package za.co.absa.hyperdrive.trigger.scheduler.sensors.time;

import org.quartz.CronExpression;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.TriggerKey;
import scala.Function2;
import scala.collection.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import za.co.absa.hyperdrive.trigger.models.Event;
import za.co.absa.hyperdrive.trigger.models.Sensor;
import za.co.absa.hyperdrive.trigger.models.TimeSensorProperties;
import za.co.absa.hyperdrive.trigger.scheduler.sensors.time.TimeSensor;
import za.co.absa.hyperdrive.trigger.scheduler.sensors.time.TimeSensorQuartzSchedulerManager$;

public final class TimeSensor$ {
    public static TimeSensor$ MODULE$;
    private final String PUSH_FUNCTION_JOB_DATA_MAP_KEY;
    private final String SENSOR_ID_JOB_DATA_MAP_KEY;
    private final String JOB_GROUP_NAME;
    private final String JOB_TRIGGER_GROUP_NAME;

    static {
        new TimeSensor$();
    }

    public String PUSH_FUNCTION_JOB_DATA_MAP_KEY() {
        return this.PUSH_FUNCTION_JOB_DATA_MAP_KEY;
    }

    public String SENSOR_ID_JOB_DATA_MAP_KEY() {
        return this.SENSOR_ID_JOB_DATA_MAP_KEY;
    }

    public String JOB_GROUP_NAME() {
        return this.JOB_GROUP_NAME;
    }

    public String JOB_TRIGGER_GROUP_NAME() {
        return this.JOB_TRIGGER_GROUP_NAME;
    }

    public TimeSensor apply(Function2<Seq<Event>, Object, Future<Object>> eventsProcessor, Sensor<TimeSensorProperties> sensorDefinition, ExecutionContext executionContext) {
        Scheduler quartzScheduler = TimeSensorQuartzSchedulerManager$.MODULE$.getScheduler();
        TimeSensor sensor = new TimeSensor(eventsProcessor, sensorDefinition, quartzScheduler, executionContext);
        this.validateJobKeys(sensor.jobKey(), sensor.jobTriggerKey(), quartzScheduler, sensorDefinition.id());
        this.validateCronExpression(((TimeSensorProperties)sensorDefinition.properties()).cronExpression(), sensorDefinition.id());
        sensor.launchQuartzJob(new CronExpression(((TimeSensorProperties)sensorDefinition.properties()).cronExpression()), sensorDefinition.id());
        return sensor;
    }

    private void validateJobKeys(JobKey jobKey, TriggerKey triggerKey, Scheduler scheduler, long sensorId) {
        if (scheduler.checkExists(jobKey)) {
            throw new IllegalArgumentException(new StringBuilder(73).append("A Quartz Job with key (").append(jobKey).append(") already exists. Cannot create job for sensor (#").append(sensorId).append(")").toString());
        }
        if (scheduler.checkExists(triggerKey)) {
            throw new IllegalArgumentException(new StringBuilder(81).append("A Quartz Job-Trigger with key (").append(triggerKey).append(") already exists. Cannot create job for sensor (#").append(sensorId).append(")").toString());
        }
    }

    private void validateCronExpression(String cronExpression, long sensorId) {
        if (!CronExpression.isValidExpression((String)cronExpression)) {
            throw new IllegalArgumentException(new StringBuilder(39).append("Invalid cron expression ").append(cronExpression).append(" for sensor (#").append(sensorId).append(")").toString());
        }
    }

    private TimeSensor$() {
        MODULE$ = this;
        this.PUSH_FUNCTION_JOB_DATA_MAP_KEY = "pushFunction";
        this.SENSOR_ID_JOB_DATA_MAP_KEY = "sensorId";
        this.JOB_GROUP_NAME = "time-sensor-job-group";
        this.JOB_TRIGGER_GROUP_NAME = "time-sensor-job-trigger-group";
    }
}

