/*
 * Decompiled with CFR 0.152.
 */
package za.co.absa.hyperdrive.trigger.api.rest.services;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import javax.inject.Inject;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSeqLike;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.SortedMap;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import za.co.absa.hyperdrive.trigger.api.rest.services.JobTemplateService;
import za.co.absa.hyperdrive.trigger.api.rest.services.WorkflowValidationService;
import za.co.absa.hyperdrive.trigger.api.rest.utils.ValidationServiceUtil$;
import za.co.absa.hyperdrive.trigger.models.AbsaKafkaSensorProperties;
import za.co.absa.hyperdrive.trigger.models.JobDefinition;
import za.co.absa.hyperdrive.trigger.models.JobDefinitionParameters;
import za.co.absa.hyperdrive.trigger.models.JobTemplate;
import za.co.absa.hyperdrive.trigger.models.KafkaSensorProperties;
import za.co.absa.hyperdrive.trigger.models.RecurringSensorProperties;
import za.co.absa.hyperdrive.trigger.models.SensorProperties;
import za.co.absa.hyperdrive.trigger.models.ShellDefinitionParameters;
import za.co.absa.hyperdrive.trigger.models.SparkDefinitionParameters;
import za.co.absa.hyperdrive.trigger.models.TimeSensorProperties;
import za.co.absa.hyperdrive.trigger.models.WorkflowJoined;
import za.co.absa.hyperdrive.trigger.models.enums.JobTypes;
import za.co.absa.hyperdrive.trigger.models.errors.ApiError;
import za.co.absa.hyperdrive.trigger.models.errors.ApiException;
import za.co.absa.hyperdrive.trigger.models.errors.BulkOperationError;
import za.co.absa.hyperdrive.trigger.models.errors.BulkOperationError$;
import za.co.absa.hyperdrive.trigger.models.errors.ValidationError;
import za.co.absa.hyperdrive.trigger.models.errors.ValidationError$;
import za.co.absa.hyperdrive.trigger.persistance.WorkflowRepository;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@ScalaSignature(bytes="\u0006\u0001\u0005=g\u0001B\n\u0015\u0001\u0015B\u0001\u0002\r\u0001\u0003\u0006\u0004%\t%\r\u0005\tq\u0001\u0011\t\u0011)A\u0005e!A\u0011\b\u0001BC\u0002\u0013\u0005#\b\u0003\u0005?\u0001\t\u0005\t\u0015!\u0003<\u0011\u0015y\u0004\u0001\"\u0001A\u0011\u0015i\u0005\u0001\"\u0011O\u0011\u0015i\u0005\u0001\"\u0011g\u0011\u00159\b\u0001\"\u0011y\u0011\u0019y\b\u0001\"\u0003\u0002\u0002!9\u0011\u0011\u0004\u0001\u0005\n\u0005m\u0001bBA\u0012\u0001\u0011%\u0011Q\u0005\u0005\b\u0003G\u0001A\u0011BA\u0015\u0011!\ti\u0003\u0001C\u0001)\u0005=\u0002bBA\u001d\u0001\u0011%\u00111\b\u0005\b\u0003#\u0002A\u0011BA*\u0011!\t\u0019\u0007\u0001C\u0001)\u0005\u0015\u0004\u0002CAF\u0001\u0011\u0005A#!$\t\u000f\u0005\u0015\u0006\u0001\"\u0003\u0002(\nirk\u001c:lM2|wOV1mS\u0012\fG/[8o'\u0016\u0014h/[2f\u00136\u0004HN\u0003\u0002\u0016-\u0005A1/\u001a:wS\u000e,7O\u0003\u0002\u00181\u0005!!/Z:u\u0015\tI\"$A\u0002ba&T!a\u0007\u000f\u0002\u000fQ\u0014\u0018nZ4fe*\u0011QDH\u0001\u000bQf\u0004XM\u001d3sSZ,'BA\u0010!\u0003\u0011\t'm]1\u000b\u0005\u0005\u0012\u0013AA2p\u0015\u0005\u0019\u0013A\u0001>b\u0007\u0001\u00192\u0001\u0001\u0014-!\t9#&D\u0001)\u0015\u0005I\u0013!B:dC2\f\u0017BA\u0016)\u0005\u0019\te.\u001f*fMB\u0011QFL\u0007\u0002)%\u0011q\u0006\u0006\u0002\u001a/>\u00148N\u001a7poZ\u000bG.\u001b3bi&|gnU3sm&\u001cW-\u0001\nx_J\\g\r\\8x%\u0016\u0004xn]5u_JLX#\u0001\u001a\u0011\u0005M2T\"\u0001\u001b\u000b\u0005UR\u0012a\u00039feNL7\u000f^1oG\u0016L!a\u000e\u001b\u0003%]{'o\u001b4m_^\u0014V\r]8tSR|'/_\u0001\u0014o>\u00148N\u001a7poJ+\u0007o\\:ji>\u0014\u0018\u0010I\u0001\u0013U>\u0014G+Z7qY\u0006$XmU3sm&\u001cW-F\u0001<!\tiC(\u0003\u0002>)\t\u0011\"j\u001c2UK6\u0004H.\u0019;f'\u0016\u0014h/[2f\u0003MQwN\u0019+f[Bd\u0017\r^3TKJ4\u0018nY3!\u0003\u0019a\u0014N\\5u}Q\u0019\u0011IQ\"\u0011\u00055\u0002\u0001\"\u0002\u0019\u0006\u0001\u0004\u0011\u0004\"B\u001d\u0006\u0001\u0004Y\u0004FA\u0003F!\t15*D\u0001H\u0015\tA\u0015*\u0001\u0004j]*,7\r\u001e\u0006\u0002\u0015\u0006)!.\u0019<bq&\u0011Aj\u0012\u0002\u0007\u0013:TWm\u0019;\u0002!Y\fG.\u001b3bi\u0016|e.\u00138tKJ$HCA(_)\t\u0001\u0016\fE\u0002R)Zk\u0011A\u0015\u0006\u0003'\"\n!bY8oGV\u0014(/\u001a8u\u0013\t)&K\u0001\u0004GkR,(/\u001a\t\u0003O]K!\u0001\u0017\u0015\u0003\tUs\u0017\u000e\u001e\u0005\u00065\u001a\u0001\u001daW\u0001\u0003K\u000e\u0004\"!\u0015/\n\u0005u\u0013&\u0001E#yK\u000e,H/[8o\u0007>tG/\u001a=u\u0011\u0015yf\u00011\u0001a\u0003!9xN]6gY><\bCA1e\u001b\u0005\u0011'BA2\u001b\u0003\u0019iw\u000eZ3mg&\u0011QM\u0019\u0002\u000f/>\u00148N\u001a7po*{\u0017N\\3e)\t9\u0017\u000e\u0006\u0002QQ\")!l\u0002a\u00027\")!n\u0002a\u0001W\u0006Iqo\u001c:lM2|wo\u001d\t\u0004YR\u0004gBA7s\u001d\tq\u0017/D\u0001p\u0015\t\u0001H%\u0001\u0004=e>|GOP\u0005\u0002S%\u00111\u000fK\u0001\ba\u0006\u001c7.Y4f\u0013\t)hOA\u0002TKFT!a\u001d\u0015\u0002!Y\fG.\u001b3bi\u0016|e.\u00169eCR,GcA=|{R\u0011\u0001K\u001f\u0005\u00065\"\u0001\u001da\u0017\u0005\u0006y\"\u0001\r\u0001Y\u0001\u0011_JLw-\u001b8bY^{'o\u001b4m_^DQA \u0005A\u0002\u0001\fq\"\u001e9eCR,GmV8sW\u001adwn^\u0001\u001am\u0006d\u0017\u000eZ1uK^{'o\u001b4m_^tu\u000e^#ySN$8\u000f\u0006\u0003\u0002\u0004\u0005]A\u0003BA\u0003\u0003+\u0001B!\u0015+\u0002\bA!A\u000e^A\u0005!\u0011\tY!!\u0005\u000e\u0005\u00055!bAA\bE\u00061QM\u001d:peNLA!a\u0005\u0002\u000e\tA\u0011\t]5FeJ|'\u000fC\u0003[\u0013\u0001\u000f1\fC\u0003k\u0013\u0001\u00071.\u0001\rwC2LG-\u0019;f/>\u00148N\u001a7po&\u001bXK\\5rk\u0016$B!!\b\u0002\"Q!\u0011QAA\u0010\u0011\u0015Q&\u0002q\u0001\\\u0011\u0015y&\u00021\u0001a\u0003e1\u0018\r\\5eCR,\u0007K]8kK\u000e$\u0018j\u001d(pi\u0016k\u0007\u000f^=\u0015\t\u0005\u0015\u0011q\u0005\u0005\u0006?.\u0001\r\u0001\u0019\u000b\u0005\u0003\u000b\tY\u0003C\u0003k\u0019\u0001\u00071.\u0001\u000bwC2LG-\u0019;f/>\u00148N\u001a7po\u0012\u000bG/\u0019\u000b\u0007\u0003c\t)$a\u000e\u0015\t\u0005\u0015\u00111\u0007\u0005\u000656\u0001\u001da\u0017\u0005\u0006y6\u0001\r\u0001\u0019\u0005\u0006}6\u0001\r\u0001Y\u0001\u0019m\u0006d\u0017\u000eZ1uKN+gn]8s!J|\u0007/\u001a:uS\u0016\u001cHCBA\u001f\u0003\u0007\ni\u0005E\u0002(\u0003\u007fI1!!\u0011)\u0005\u001d\u0011un\u001c7fC:Dq!!\u0012\u000f\u0001\u0004\t9%\u0001\rpe&<\u0017N\\1m'\u0016t7o\u001c:Qe>\u0004XM\u001d;jKN\u00042!YA%\u0013\r\tYE\u0019\u0002\u0011'\u0016t7o\u001c:Qe>\u0004XM\u001d;jKNDq!a\u0014\u000f\u0001\u0004\t9%A\fva\u0012\fG/\u001a3TK:\u001cxN\u001d)s_B,'\u000f^5fg\u0006)b/\u00197jI\u0006$XMS8c!\u0006\u0014\u0018-\\3uKJ\u001cHCBA\u001f\u0003+\ny\u0006C\u0004\u0002X=\u0001\r!!\u0017\u0002+=\u0014\u0018nZ5oC2TuN\u0019)be\u0006lW\r^3sgB\u0019\u0011-a\u0017\n\u0007\u0005u#MA\fK_\n$UMZ5oSRLwN\u001c)be\u0006lW\r^3sg\"9\u0011\u0011M\bA\u0002\u0005e\u0013\u0001F;qI\u0006$X\r\u001a&pEB\u000b'/Y7fi\u0016\u00148/\u0001\u0007be\u0016l\u0015\r]:FcV\fG\u000e\u0006\u0004\u0002>\u0005\u001d\u0014q\u0011\u0005\b\u0003S\u0002\u0002\u0019AA6\u0003\u001daWM\u001a;NCB\u0004\u0002\"!\u001c\u0002v\u0005m\u0014\u0011\u0011\b\u0005\u0003_\n\t\b\u0005\u0002oQ%\u0019\u00111\u000f\u0015\u0002\rA\u0013X\rZ3g\u0013\u0011\t9(!\u001f\u0003\u00075\u000b\u0007OC\u0002\u0002t!\u0002B!!\u001c\u0002~%!\u0011qPA=\u0005\u0019\u0019FO]5oOB)A.a!\u0002|%\u0019\u0011Q\u0011<\u0003\t1K7\u000f\u001e\u0005\b\u0003\u0013\u0003\u0002\u0019AA6\u0003!\u0011\u0018n\u001a5u\u001b\u0006\u0004\u0018AE1sK6\u000b\u0007o](g\u001b\u0006\u00048/R9vC2$b!!\u0010\u0002\u0010\u0006\r\u0006bBA5#\u0001\u0007\u0011\u0011\u0013\t\t\u0003[\n)(a\u001f\u0002\u0014BA\u0011QSAP\u0003w\nY(\u0004\u0002\u0002\u0018*!\u0011\u0011TAN\u0003%IW.\\;uC\ndWMC\u0002\u0002\u001e\"\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\t\t+a&\u0003\u0013M{'\u000f^3e\u001b\u0006\u0004\bbBAE#\u0001\u0007\u0011\u0011S\u0001\u0016m\u0006d\u0017\u000eZ1uK*{'\rR3gS:LG/[8o)\u0011\tI+!,\u0015\t\u0005\u0015\u00111\u0016\u0005\u00065J\u0001\u001da\u0017\u0005\b\u0003_\u0013\u0002\u0019AAY\u00039QwN\u0019#fM&t\u0017\u000e^5p]N\u0004B\u0001\u001c;\u00024B\u0019\u0011-!.\n\u0007\u0005]&MA\u0007K_\n$UMZ5oSRLwN\u001c\u0015\u0004\u0001\u0005m\u0006\u0003BA_\u0003\u0017l!!a0\u000b\t\u0005\u0005\u00171Y\u0001\u000bgR,'/Z8usB,'\u0002BAc\u0003\u000f\fqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0003\u0003\u0013\f1a\u001c:h\u0013\u0011\ti-a0\u0003\u000fM+'O^5dK\u0002")
public class WorkflowValidationServiceImpl
implements WorkflowValidationService {
    private final WorkflowRepository workflowRepository;
    private final JobTemplateService jobTemplateService;

    public WorkflowRepository workflowRepository() {
        return this.workflowRepository;
    }

    public JobTemplateService jobTemplateService() {
        return this.jobTemplateService;
    }

    public Future<BoxedUnit> validateOnInsert(WorkflowJoined workflow, ExecutionContext ec) {
        return this.validateOnInsert((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new WorkflowJoined[]{workflow})), ec).transform((Function1 & Serializable & scala.Serializable)x -> {
            WorkflowValidationServiceImpl.$anonfun$validateOnInsert$1((BoxedUnit)x);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable & scala.Serializable)x0$1 -> {
            Throwable throwable = x0$1;
            if (!(throwable instanceof ApiException)) {
                throw new MatchError((Object)throwable);
            }
            ApiException apiException = (ApiException)throwable;
            ApiException apiException2 = new ApiException((Seq)apiException.apiErrors().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.unwrapError(), Seq$.MODULE$.canBuildFrom()));
            return apiException2;
        }, ec);
    }

    public Future<BoxedUnit> validateOnInsert(Seq<WorkflowJoined> workflows, ExecutionContext ec) {
        Seq validators = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Future[]{this.validateWorkflowNotExists(workflows, ec), this.validateProjectIsNotEmpty(workflows), this.validateJobDefinition((Seq)workflows.flatMap((Function1 & Serializable & scala.Serializable)x$2 -> x$2.dagDefinitionJoined().jobDefinitions(), Seq$.MODULE$.canBuildFrom()), ec)}));
        return ValidationServiceUtil$.MODULE$.reduce(validators, ec);
    }

    public Future<BoxedUnit> validateOnUpdate(WorkflowJoined originalWorkflow, WorkflowJoined updatedWorkflow, ExecutionContext ec) {
        Seq validators = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Future[]{this.validateWorkflowIsUnique(updatedWorkflow, ec), this.validateProjectIsNotEmpty(updatedWorkflow), this.validateWorkflowData(originalWorkflow, updatedWorkflow, ec), this.validateJobDefinition(updatedWorkflow.dagDefinitionJoined().jobDefinitions(), ec)}));
        return ValidationServiceUtil$.MODULE$.reduce(validators, ec).transform((Function1 & Serializable & scala.Serializable)x -> {
            WorkflowValidationServiceImpl.$anonfun$validateOnUpdate$1((BoxedUnit)x);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable & scala.Serializable)x0$1 -> {
            Throwable throwable = x0$1;
            if (!(throwable instanceof ApiException)) {
                throw new MatchError((Object)throwable);
            }
            ApiException apiException = (ApiException)throwable;
            ApiException apiException2 = new ApiException((Seq)apiException.apiErrors().map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.unwrapError(), Seq$.MODULE$.canBuildFrom()));
            return apiException2;
        }, ec);
    }

    private Future<Seq<ApiError>> validateWorkflowNotExists(Seq<WorkflowJoined> workflows, ExecutionContext ec) {
        return this.workflowRepository().existsWorkflows((Seq)workflows.map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.name(), Seq$.MODULE$.canBuildFrom()), ec).map((Function1 & Serializable & scala.Serializable)existingNames -> (Seq)((TraversableLike)workflows.filter((Function1 & Serializable & scala.Serializable)workflow -> BoxesRunTime.boxToBoolean((boolean)WorkflowValidationServiceImpl.$anonfun$validateWorkflowNotExists$3((Seq)existingNames, (WorkflowJoined)workflow)))).map((Function1 & Serializable & scala.Serializable)workflow -> BulkOperationError$.MODULE$.apply(workflow, (ApiError)new ValidationError("Workflow name already exists", ValidationError$.MODULE$.apply$default$2())), Seq$.MODULE$.canBuildFrom()), ec);
    }

    private Future<Seq<ApiError>> validateWorkflowIsUnique(WorkflowJoined workflow, ExecutionContext ec) {
        return this.workflowRepository().existsOtherWorkflow(workflow.name(), workflow.id(), ec).map((Function1 & Serializable & scala.Serializable)exists -> WorkflowValidationServiceImpl.$anonfun$validateWorkflowIsUnique$1((boolean)BoxesRunTime.unboxToBoolean((Object)exists)), ec);
    }

    private Future<Seq<ApiError>> validateProjectIsNotEmpty(WorkflowJoined workflow) {
        return this.validateProjectIsNotEmpty((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new WorkflowJoined[]{workflow})));
    }

    private Future<Seq<ApiError>> validateProjectIsNotEmpty(Seq<WorkflowJoined> workflows) {
        Seq errors = (Seq)((TraversableLike)((TraversableLike)workflows.map((Function1 & Serializable & scala.Serializable)workflow -> {
            boolean bl = false;
            Some some = null;
            Option option = Option$.MODULE$.apply((Object)workflow.project());
            if (option instanceof Some) {
                bl = true;
                some = (Some)option;
                String v = (String)some.value();
                if (v.isEmpty()) {
                    return new Some((Object)BulkOperationError$.MODULE$.apply(workflow, (ApiError)new ValidationError("Project must not be empty", ValidationError$.MODULE$.apply$default$2())));
                }
            }
            if (bl) {
                return None$.MODULE$;
            }
            if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
            return new Some((Object)BulkOperationError$.MODULE$.apply(workflow, (ApiError)new ValidationError("Project must be set", ValidationError$.MODULE$.apply$default$2())));
        }, Seq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)WorkflowValidationServiceImpl.$anonfun$validateProjectIsNotEmpty$2((Option)x$5)))).map((Function1 & Serializable & scala.Serializable)x$6 -> (BulkOperationError)x$6.get(), Seq$.MODULE$.canBuildFrom());
        return Future$.MODULE$.successful((Object)errors);
    }

    public Future<Seq<ApiError>> validateWorkflowData(WorkflowJoined originalWorkflow, WorkflowJoined updatedWorkflow, ExecutionContext ec) {
        boolean[] blArray = new boolean[3];
        String string = originalWorkflow.name();
        String string2 = updatedWorkflow.name();
        blArray[0] = !(string != null ? !string.equals(string2) : string2 != null);
        blArray[1] = originalWorkflow.isActive() == updatedWorkflow.isActive();
        String string3 = originalWorkflow.project();
        String string4 = updatedWorkflow.project();
        blArray[2] = !(string3 != null ? !string3.equals(string4) : string4 != null);
        Seq workflowDetailsVerification = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(blArray));
        boolean workflowSensorVerification = this.validateSensorProperties(originalWorkflow.sensor().properties(), updatedWorkflow.sensor().properties());
        Seq workflowJobsVerification = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{originalWorkflow.dagDefinitionJoined().jobDefinitions().length() == updatedWorkflow.dagDefinitionJoined().jobDefinitions().length()})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{((GenSeqLike)originalWorkflow.dagDefinitionJoined().jobDefinitions().map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToInteger((int)WorkflowValidationServiceImpl.$anonfun$validateWorkflowData$1((JobDefinition)x$7)), Seq$.MODULE$.canBuildFrom())).equals(updatedWorkflow.dagDefinitionJoined().jobDefinitions().map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToInteger((int)WorkflowValidationServiceImpl.$anonfun$validateWorkflowData$2((JobDefinition)x$8)), Seq$.MODULE$.canBuildFrom()))})), (Seq)originalWorkflow.dagDefinitionJoined().jobDefinitions().flatMap((Function1 & Serializable & scala.Serializable)originalJob -> {
            Option updatedJobOption = updatedWorkflow.dagDefinitionJoined().jobDefinitions().find((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)WorkflowValidationServiceImpl.$anonfun$validateWorkflowData$4((JobDefinition)originalJob, (JobDefinition)x$9)));
            return (Seq)updatedJobOption.map((Function1 & Serializable & scala.Serializable)updatedJob -> {
                boolean[] blArray = new boolean[4];
                String string = originalJob.name();
                String string2 = updatedJob.name();
                blArray[0] = !(string != null ? !string.equals(string2) : string2 != null);
                Option option = originalJob.jobTemplateId();
                Option option2 = updatedJob.jobTemplateId();
                blArray[1] = !(option != null ? !option.equals(option2) : option2 != null);
                blArray[2] = originalJob.order() == updatedJob.order();
                blArray[3] = this.validateJobParameters(originalJob.jobParameters(), updatedJob.jobParameters());
                return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(blArray));
            }).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{false})));
        }, Seq$.MODULE$.canBuildFrom())})).flatten((Function1)Predef$.MODULE$.$conforms());
        return ((SeqLike)((SeqLike)workflowDetailsVerification.$plus$plus((GenTraversableOnce)workflowJobsVerification, Seq$.MODULE$.canBuildFrom())).$colon$plus((Object)BoxesRunTime.boxToBoolean((boolean)workflowSensorVerification), Seq$.MODULE$.canBuildFrom())).contains((Object)BoxesRunTime.boxToBoolean((boolean)false)) ? Future$.MODULE$.successful((Object)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)) : Future$.MODULE$.successful((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ValidationError[]{new ValidationError("Nothing to update", ValidationError$.MODULE$.apply$default$2())})));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean validateSensorProperties(SensorProperties originalSensorProperties, SensorProperties updatedSensorProperties) {
        Tuple2 tuple2 = new Tuple2((Object)originalSensorProperties, (Object)updatedSensorProperties);
        if (tuple2 != null) {
            SensorProperties original = (SensorProperties)tuple2._1();
            SensorProperties updated = (SensorProperties)tuple2._2();
            if (original instanceof KafkaSensorProperties) {
                KafkaSensorProperties kafkaSensorProperties = (KafkaSensorProperties)original;
                if (updated instanceof KafkaSensorProperties) {
                    KafkaSensorProperties kafkaSensorProperties2 = (KafkaSensorProperties)updated;
                    return kafkaSensorProperties.equals((Object)kafkaSensorProperties2);
                }
            }
        }
        if (tuple2 != null) {
            SensorProperties original = (SensorProperties)tuple2._1();
            SensorProperties updated = (SensorProperties)tuple2._2();
            if (original instanceof AbsaKafkaSensorProperties) {
                AbsaKafkaSensorProperties absaKafkaSensorProperties = (AbsaKafkaSensorProperties)original;
                if (updated instanceof AbsaKafkaSensorProperties) {
                    AbsaKafkaSensorProperties absaKafkaSensorProperties2 = (AbsaKafkaSensorProperties)updated;
                    return absaKafkaSensorProperties.equals((Object)absaKafkaSensorProperties2);
                }
            }
        }
        if (tuple2 != null) {
            SensorProperties original = (SensorProperties)tuple2._1();
            SensorProperties updated = (SensorProperties)tuple2._2();
            if (original instanceof RecurringSensorProperties) {
                RecurringSensorProperties recurringSensorProperties = (RecurringSensorProperties)original;
                if (updated instanceof RecurringSensorProperties) {
                    RecurringSensorProperties recurringSensorProperties2 = (RecurringSensorProperties)updated;
                    return recurringSensorProperties.equals((Object)recurringSensorProperties2);
                }
            }
        }
        if (tuple2 == null) return false;
        SensorProperties original = (SensorProperties)tuple2._1();
        SensorProperties updated = (SensorProperties)tuple2._2();
        if (!(original instanceof TimeSensorProperties)) return false;
        TimeSensorProperties timeSensorProperties = (TimeSensorProperties)original;
        if (!(updated instanceof TimeSensorProperties)) return false;
        TimeSensorProperties timeSensorProperties2 = (TimeSensorProperties)updated;
        return timeSensorProperties.equals((Object)timeSensorProperties2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean validateJobParameters(JobDefinitionParameters originalJobParameters, JobDefinitionParameters updatedJobParameters) {
        Tuple2 tuple2 = new Tuple2((Object)originalJobParameters, (Object)updatedJobParameters);
        if (tuple2 != null) {
            JobDefinitionParameters original = (JobDefinitionParameters)tuple2._1();
            JobDefinitionParameters updated = (JobDefinitionParameters)tuple2._2();
            if (original instanceof SparkDefinitionParameters) {
                SparkDefinitionParameters sparkDefinitionParameters = (SparkDefinitionParameters)original;
                if (updated instanceof SparkDefinitionParameters) {
                    SparkDefinitionParameters sparkDefinitionParameters2 = (SparkDefinitionParameters)updated;
                    return sparkDefinitionParameters.equals((Object)sparkDefinitionParameters2);
                }
            }
        }
        if (tuple2 == null) return false;
        JobDefinitionParameters original = (JobDefinitionParameters)tuple2._1();
        JobDefinitionParameters updated = (JobDefinitionParameters)tuple2._2();
        if (!(original instanceof ShellDefinitionParameters)) return false;
        ShellDefinitionParameters shellDefinitionParameters = (ShellDefinitionParameters)original;
        if (!(updated instanceof ShellDefinitionParameters)) return false;
        ShellDefinitionParameters shellDefinitionParameters2 = (ShellDefinitionParameters)updated;
        return shellDefinitionParameters.equals((Object)shellDefinitionParameters2);
    }

    public boolean areMapsEqual(Map<String, List<String>> leftMap, Map<String, List<String>> rightMap) {
        return leftMap.keys().equals(rightMap.keys()) && !((TraversableOnce)leftMap.map((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)WorkflowValidationServiceImpl.$anonfun$areMapsEqual$1((Map)rightMap, (Tuple2)x0$1)), Iterable$.MODULE$.canBuildFrom())).toSeq().contains((Object)BoxesRunTime.boxToBoolean((boolean)false));
    }

    public boolean areMapsOfMapsEqual(Map<String, SortedMap<String, String>> leftMap, Map<String, SortedMap<String, String>> rightMap) {
        return leftMap.keys().equals(rightMap.keys()) && !((TraversableOnce)leftMap.map((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)WorkflowValidationServiceImpl.$anonfun$areMapsOfMapsEqual$1((Map)rightMap, (Tuple2)x0$1)), Iterable$.MODULE$.canBuildFrom())).toSeq().contains((Object)BoxesRunTime.boxToBoolean((boolean)false));
    }

    private Future<Seq<ApiError>> validateJobDefinition(Seq<JobDefinition> jobDefinitions, ExecutionContext ec) {
        return Future$.MODULE$.sequence((TraversableOnce)jobDefinitions.map(arg_0 -> WorkflowValidationServiceImpl.$anonfun$validateJobDefinition$1(this, ec, arg_0), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom(), ec).map((Function1 & Serializable & scala.Serializable)x$12 -> (Seq)x$12.flatten((Function1)Predef$.MODULE$.$conforms()), ec);
    }

    public static final /* synthetic */ void $anonfun$validateOnInsert$1(BoxedUnit x) {
        Predef$.MODULE$.identity((Object)x);
    }

    public static final /* synthetic */ void $anonfun$validateOnUpdate$1(BoxedUnit x) {
        Predef$.MODULE$.identity((Object)x);
    }

    public static final /* synthetic */ boolean $anonfun$validateWorkflowNotExists$3(Seq existingNames$1, WorkflowJoined workflow) {
        return existingNames$1.contains((Object)workflow.name());
    }

    public static final /* synthetic */ Seq $anonfun$validateWorkflowIsUnique$1(boolean exists) {
        return exists ? (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ValidationError[]{new ValidationError("Workflow name already exists", ValidationError$.MODULE$.apply$default$2())})) : (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
    }

    public static final /* synthetic */ boolean $anonfun$validateProjectIsNotEmpty$2(Option x$5) {
        return x$5.isDefined();
    }

    public static final /* synthetic */ int $anonfun$validateWorkflowData$1(JobDefinition x$7) {
        return x$7.order();
    }

    public static final /* synthetic */ int $anonfun$validateWorkflowData$2(JobDefinition x$8) {
        return x$8.order();
    }

    public static final /* synthetic */ boolean $anonfun$validateWorkflowData$4(JobDefinition originalJob$1, JobDefinition x$9) {
        return x$9.order() == originalJob$1.order();
    }

    public static final /* synthetic */ boolean $anonfun$areMapsEqual$2(String x2$1, Tuple2 x$10) {
        Object object = x$10._1();
        String string = x2$1;
        return !(object != null ? !object.equals(string) : string != null);
    }

    public static final /* synthetic */ boolean $anonfun$areMapsEqual$3(List x3$1, Tuple2 x0$2) {
        List valueRight;
        block3: {
            Tuple2 tuple2;
            block2: {
                tuple2 = x0$2;
                if (tuple2 == null) break block2;
                valueRight = (List)tuple2._2();
                if (tuple2._1() != null && valueRight != null) break block3;
            }
            throw new MatchError((Object)tuple2);
        }
        List list = valueRight;
        boolean bl = x3$1.equals((Object)list);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$areMapsEqual$1(Map rightMap$1, Tuple2 x0$1) {
        String string;
        List valueLeft;
        block3: {
            Tuple2 tuple2;
            block2: {
                tuple2 = x0$1;
                if (tuple2 == null) break block2;
                String keyLeft = (String)tuple2._1();
                valueLeft = (List)tuple2._2();
                if (keyLeft == null) break block2;
                string = keyLeft;
                if (valueLeft != null) break block3;
            }
            throw new MatchError((Object)tuple2);
        }
        List list = valueLeft;
        boolean bl = rightMap$1.find((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)WorkflowValidationServiceImpl.$anonfun$areMapsEqual$2((String)string, (Tuple2)x$10))).exists((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)WorkflowValidationServiceImpl.$anonfun$areMapsEqual$3((List)list, (Tuple2)x0$2)));
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$areMapsOfMapsEqual$2(String x2$2, Tuple2 x$11) {
        Object object = x$11._1();
        String string = x2$2;
        return !(object != null ? !object.equals(string) : string != null);
    }

    public static final /* synthetic */ boolean $anonfun$areMapsOfMapsEqual$3(SortedMap x3$2, Tuple2 x0$2) {
        SortedMap valueRight;
        block3: {
            Tuple2 tuple2;
            block2: {
                tuple2 = x0$2;
                if (tuple2 == null) break block2;
                valueRight = (SortedMap)tuple2._2();
                if (tuple2._1() != null && valueRight != null) break block3;
            }
            throw new MatchError((Object)tuple2);
        }
        SortedMap sortedMap = valueRight;
        boolean bl = x3$2.equals((Object)sortedMap);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$areMapsOfMapsEqual$1(Map rightMap$2, Tuple2 x0$1) {
        String string;
        SortedMap valueLeft;
        block3: {
            Tuple2 tuple2;
            block2: {
                tuple2 = x0$1;
                if (tuple2 == null) break block2;
                String keyLeft = (String)tuple2._1();
                valueLeft = (SortedMap)tuple2._2();
                if (keyLeft == null) break block2;
                string = keyLeft;
                if (valueLeft != null) break block3;
            }
            throw new MatchError((Object)tuple2);
        }
        SortedMap sortedMap = valueLeft;
        boolean bl = rightMap$2.find((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)WorkflowValidationServiceImpl.$anonfun$areMapsOfMapsEqual$2((String)string, (Tuple2)x$11))).exists((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)WorkflowValidationServiceImpl.$anonfun$areMapsOfMapsEqual$3((SortedMap)sortedMap, (Tuple2)x0$2)));
        return bl;
    }

    public static final /* synthetic */ Seq $anonfun$validateJobDefinition$2(JobDefinition jobDefinition$1, JobTemplate jobTemplate) {
        JobTypes.JobType jobType = jobTemplate.jobParameters().jobType();
        JobTypes.JobType jobType2 = jobDefinition$1.jobParameters().jobType();
        return (jobType == null ? jobType2 != null : !jobType.equals(jobType2)) ? (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ValidationError[]{new ValidationError(new StringBuilder(92).append("Template's job type has to be the same as job's job type. Template - ").append(jobTemplate.jobParameters().jobType()).append(" is not equal to Job - ").append(jobDefinition$1.jobParameters().jobType()).toString(), ValidationError$.MODULE$.apply$default$2())})) : (Seq)Seq$.MODULE$.empty();
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ Future $anonfun$validateJobDefinition$1(WorkflowValidationServiceImpl $this, ExecutionContext ec$1, JobDefinition jobDefinition) {
        block10: {
            block6: {
                block8: {
                    block9: {
                        block7: {
                            var5_3 = jobDefinition.jobTemplateId();
                            if (!None$.MODULE$.equals(var5_3)) break block6;
                            var6_4 = false;
                            var7_5 = null;
                            var8_6 = false;
                            var9_7 = null;
                            var10_8 = jobDefinition.jobParameters();
                            if (!(var10_8 instanceof SparkDefinitionParameters)) break block7;
                            var6_4 = true;
                            var7_5 = (SparkDefinitionParameters)var10_8;
                            jobType = var7_5.jobType();
                            jobJar = var7_5.jobJar();
                            mainClass = var7_5.mainClass();
                            if (!jobJar.isEmpty() && !mainClass.isEmpty()) break block7;
                            var4_12 = Future$.MODULE$.successful((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ValidationError[]{new ValidationError(new StringBuilder(82).append("Job jar and main class cannot be empty in case of ").append(jobType).append(" job type when template is empty").toString(), ValidationError$.MODULE$.apply$default$2())})));
                            break block8;
                        }
                        if (!var6_4) break block9;
                        var4_12 = Future$.MODULE$.successful((Object)Seq$.MODULE$.empty());
                        break block8;
                    }
                    if (!(var10_8 instanceof ShellDefinitionParameters)) ** GOTO lbl-1000
                    var8_6 = true;
                    var9_7 = (ShellDefinitionParameters)var10_8;
                    jobType = var9_7.jobType();
                    scriptLocation = var9_7.scriptLocation();
                    if (scriptLocation.isEmpty()) {
                        var4_12 = Future$.MODULE$.successful((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ValidationError[]{new ValidationError(new StringBuilder(75).append("Script location cannot be empty in case of ").append(jobType).append(" job type when template is empty").toString(), ValidationError$.MODULE$.apply$default$2())})));
                    } else if (var8_6) {
                        var4_12 = Future$.MODULE$.successful((Object)Seq$.MODULE$.empty());
                    } else {
                        throw new MatchError((Object)var10_8);
                    }
                }
                var3_15 = var4_12;
                break block10;
            }
            if (var5_3 instanceof Some) {
                var16_16 = (Some)var5_3;
                jobTemplateId = BoxesRunTime.unboxToLong((Object)var16_16.value());
                var3_15 = $this.jobTemplateService().getJobTemplate(jobTemplateId, ec$1).map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$validateJobDefinition$2(za.co.absa.hyperdrive.trigger.models.JobDefinition za.co.absa.hyperdrive.trigger.models.JobTemplate ), (Lza/co/absa/hyperdrive/trigger/models/JobTemplate;)Lscala/collection/Seq;)((JobDefinition)jobDefinition), ec$1);
            } else {
                throw new MatchError((Object)var5_3);
            }
        }
        return var3_15;
    }

    @Inject
    public WorkflowValidationServiceImpl(WorkflowRepository workflowRepository, JobTemplateService jobTemplateService) {
        this.workflowRepository = workflowRepository;
        this.jobTemplateService = jobTemplateService;
    }
}

