/*
 * Decompiled with CFR 0.152.
 */
package za.co.absa.hyperdrive.trigger.api.rest.health;

import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import javax.inject.Inject;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import za.co.absa.hyperdrive.trigger.configuration.application.HealthConfig;
import za.co.absa.hyperdrive.trigger.configuration.application.SparkConfig;

@Component
@ScalaSignature(bytes="\u0006\u0001}3Aa\u0002\u0005\u00013!Aq\u0006\u0001B\u0001B\u0003%\u0001\u0007\u0003\u00059\u0001\t\u0005\t\u0015!\u0003:\u0011\u0015a\u0004\u0001\"\u0001>\u0011\u001dY\u0005A1A\u0005\u00021Caa\u0015\u0001!\u0002\u0013i\u0005\"B\u0005\u0001\t#\"&!H-be:\u001cuN\u001c8fGRLwN\u001c%fC2$\b.\u00138eS\u000e\fGo\u001c:\u000b\u0005%Q\u0011A\u00025fC2$\bN\u0003\u0002\f\u0019\u0005!!/Z:u\u0015\tia\"A\u0002ba&T!a\u0004\t\u0002\u000fQ\u0014\u0018nZ4fe*\u0011\u0011CE\u0001\u000bQf\u0004XM\u001d3sSZ,'BA\n\u0015\u0003\u0011\t'm]1\u000b\u0005U1\u0012AA2p\u0015\u00059\u0012A\u0001>b\u0007\u0001\u00192\u0001\u0001\u000e#!\tY\u0002%D\u0001\u001d\u0015\tib$\u0001\u0003mC:<'\"A\u0010\u0002\t)\fg/Y\u0005\u0003Cq\u0011aa\u00142kK\u000e$\bCA\u0012.\u001b\u0005!#BA\u0005&\u0015\t1s%A\u0004bGR,\u0018\r^3\u000b\u0005!J\u0013\u0001\u00022p_RT!AK\u0016\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T\u0011\u0001L\u0001\u0004_J<\u0017B\u0001\u0018%\u0005=AU-\u00197uQ&sG-[2bi>\u0014\u0018aC:qCJ\\7i\u001c8gS\u001e\u0004\"!\r\u001c\u000e\u0003IR!a\r\u001b\u0002\u0017\u0005\u0004\b\u000f\\5dCRLwN\u001c\u0006\u0003k9\tQbY8oM&<WO]1uS>t\u0017BA\u001c3\u0005-\u0019\u0006/\u0019:l\u0007>tg-[4\u0002\u0019!,\u0017\r\u001c;i\u0007>tg-[4\u0011\u0005ER\u0014BA\u001e3\u00051AU-\u00197uQ\u000e{gNZ5h\u0003\u0019a\u0014N\\5u}Q\u0019a\bQ!\u0011\u0005}\u0002Q\"\u0001\u0005\t\u000b=\u001a\u0001\u0019\u0001\u0019\t\u000ba\u001a\u0001\u0019A\u001d)\u0005\r\u0019\u0005C\u0001#J\u001b\u0005)%B\u0001$H\u0003\u0019IgN[3di*\t\u0001*A\u0003kCZ\f\u00070\u0003\u0002K\u000b\n1\u0011J\u001c6fGR\f1b];dG\u0016\u001c8oQ8eKV\tQ\n\u0005\u0002O#6\tqJC\u0001Q\u0003\u0015\u00198-\u00197b\u0013\t\u0011vJA\u0002J]R\fAb];dG\u0016\u001c8oQ8eK\u0002\"\u0012!\u0016\t\u0003GYK!a\u0016\u0013\u0003\r!+\u0017\r\u001c;iQ\t\u0001\u0011\f\u0005\u0002[;6\t1L\u0003\u0002]S\u0005Q1\u000f^3sK>$\u0018\u0010]3\n\u0005y[&!C\"p[B|g.\u001a8u\u0001")
public class YarnConnectionHealthIndicator
implements HealthIndicator {
    private final SparkConfig sparkConfig;
    private final HealthConfig healthConfig;
    private final int successCode;

    public Health getHealth(boolean includeDetails) {
        return super.getHealth(includeDetails);
    }

    public int successCode() {
        return this.successCode;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Health health() {
        String yarnBaseUrl = new StringOps(Predef$.MODULE$.augmentString(this.sparkConfig.hadoopResourceManagerUrlBase())).stripSuffix("/");
        String yarnTestEndpoint = new StringOps(Predef$.MODULE$.augmentString(this.healthConfig.yarnConnectionTestEndpoint())).stripPrefix("/");
        boolean bl = false;
        Failure failure = null;
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> new URL(new StringBuilder(1).append(yarnBaseUrl).append("/").append(yarnTestEndpoint).toString())).flatMap((Function1 & Serializable & scala.Serializable)url -> Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            $this.healthConfig.yarnConnectionTimeoutMillis().foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$1 -> connection.setConnectTimeout(x$1));
            return connection.getResponseCode() == this.successCode();
        }));
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            boolean healthy = BoxesRunTime.unboxToBoolean((Object)success.value());
            return healthy ? Health.up().build() : Health.down().build();
        }
        if (try_ instanceof Failure) {
            bl = true;
            failure = (Failure)try_;
            Throwable ex = failure.exception();
            if (ex instanceof MalformedURLException) {
                MalformedURLException malformedURLException = (MalformedURLException)ex;
                return Health.unknown().withException((Throwable)malformedURLException).build();
            }
        }
        if (!bl) throw new MatchError((Object)try_);
        Throwable ex = failure.exception();
        return Health.down().withException(ex).build();
    }

    @Inject
    public YarnConnectionHealthIndicator(SparkConfig sparkConfig, HealthConfig healthConfig) {
        this.sparkConfig = sparkConfig;
        this.healthConfig = healthConfig;
        this.successCode = 200;
    }
}

