/*
 * Decompiled with CFR 0.152.
 */
package za.co.absa.hyperdrive.trigger.api.rest.controllers;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.context.request.WebRequest;
import scala.reflect.ScalaSignature;
import za.co.absa.hyperdrive.trigger.models.errors.ApiException;

@RestControllerAdvice
@ScalaSignature(bytes="\u0006\u0001\u0005\u001db\u0001\u0002\u0005\n\u0001iAQ!\t\u0001\u0005\u0002\tBq!\n\u0001C\u0002\u0013%a\u0005\u0003\u00040\u0001\u0001\u0006Ia\n\u0005\u0006a\u0001!\t!\r\u0005\u0006G\u0002!\t\u0001\u001a\u0005\u0006a\u0002!\t!\u001d\u0005\u0007\u007f\u0002!\t!!\u0001\u0003!I+7\u000f^#se>\u0014\b*\u00198eY\u0016\u0014(B\u0001\u0006\f\u0003-\u0019wN\u001c;s_2dWM]:\u000b\u00051i\u0011\u0001\u0002:fgRT!AD\b\u0002\u0007\u0005\u0004\u0018N\u0003\u0002\u0011#\u00059AO]5hO\u0016\u0014(B\u0001\n\u0014\u0003)A\u0017\u0010]3sIJLg/\u001a\u0006\u0003)U\tA!\u00192tC*\u0011acF\u0001\u0003G>T\u0011\u0001G\u0001\u0003u\u0006\u001c\u0001a\u0005\u0002\u00017A\u0011AdH\u0007\u0002;)\ta$A\u0003tG\u0006d\u0017-\u0003\u0002!;\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A\u0012\u0011\u0005\u0011\u0002Q\"A\u0005\u0002\r1|wmZ3s+\u00059\u0003C\u0001\u0015.\u001b\u0005I#B\u0001\u0016,\u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005a\u0013aA8sO&\u0011a&\u000b\u0002\u0007\u0019><w-\u001a:\u0002\u000f1|wmZ3sA\u0005\u0011\u0002.\u00198eY\u0016\f\u0005/[#yG\u0016\u0004H/[8o)\r\u0011$\t\u0014\t\u0004gaRT\"\u0001\u001b\u000b\u0005U2\u0014\u0001\u00025uiBT!aN\u0016\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.L!!\u000f\u001b\u0003\u001dI+7\u000f]8og\u0016,e\u000e^5usB\u00111\bQ\u0007\u0002y)\u0011QHP\u0001\u0005Y\u0006twMC\u0001@\u0003\u0011Q\u0017M^1\n\u0005\u0005c$AB(cU\u0016\u001cG\u000fC\u0003D\t\u0001\u0007A)\u0001\u0002fqB\u0011QIS\u0007\u0002\r*\u0011q\tS\u0001\u0007KJ\u0014xN]:\u000b\u0005%{\u0011AB7pI\u0016d7/\u0003\u0002L\r\na\u0011\t]5Fq\u000e,\u0007\u000f^5p]\")Q\n\u0002a\u0001\u001d\u00069!/Z9vKN$\bCA(V\u001b\u0005\u0001&BA'R\u0015\t\u00116+A\u0004d_:$X\r\u001f;\u000b\u0005Q3\u0014aA<fE&\u0011a\u000b\u0015\u0002\u000b/\u0016\u0014'+Z9vKN$\b\u0006\u0002\u0003YA\u0006\u0004\"!\u00170\u000e\u0003iS!a\u0017/\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0002^'\u0006!!-\u001b8e\u0013\ty&L\u0001\tFq\u000e,\u0007\u000f^5p]\"\u000bg\u000e\u001a7fe\u0006)a/\u00197vK2\n!mI\u0001E\u0003\u0015B\u0017M\u001c3mK6+G\u000f[8e\u0003J<W/\\3oi:{GOV1mS\u0012,\u0005pY3qi&|g\u000eF\u00023K2DQaQ\u0003A\u0002\u0019\u0004\"a\u001a6\u000e\u0003!T!!\u001b\u001b\u0002\u0013\r|gN^3si\u0016\u0014\u0018BA6i\u0005}AE\u000f\u001e9NKN\u001c\u0018mZ3O_R\u0014V-\u00193bE2,W\t_2faRLwN\u001c\u0005\u0006\u001b\u0016\u0001\rA\u0014\u0015\u0005\u000ba\u0003g\u000eL\u0001pG\u00051\u0017a\u00075b]\u0012dW-Q2dKN\u001cH)\u001a8jK\u0012,\u0005pY3qi&|g\u000eF\u00023enDQa\u0011\u0004A\u0002M\u0004\"\u0001^=\u000e\u0003UT!A^<\u0002\r\u0005\u001c7-Z:t\u0015\tAh'\u0001\u0005tK\u000e,(/\u001b;z\u0013\tQXOA\u000bBG\u000e,7o\u001d#f]&,G-\u0012=dKB$\u0018n\u001c8\t\u000b53\u0001\u0019\u0001()\t\u0019A\u0006- \u0017\u0002}\u000e\n1/A\biC:$G.\u001a+ie><\u0018M\u00197f)\r\u0011\u00141\u0001\u0005\u0007\u0007\u001e\u0001\r!!\u0002\u0011\t\u0005\u001d\u0011q\u0003\b\u0005\u0003\u0013\t\u0019B\u0004\u0003\u0002\f\u0005EQBAA\u0007\u0015\r\ty!G\u0001\u0007yI|w\u000e\u001e \n\u0003yI1!!\u0006\u001e\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\u0007\u0002\u001c\tIA\u000b\u001b:po\u0006\u0014G.\u001a\u0006\u0004\u0003+i\u0002FA\u0004YQ\r\u0001\u0011\u0011\u0005\t\u00043\u0006\r\u0012bAA\u00135\n!\"+Z:u\u0007>tGO]8mY\u0016\u0014\u0018\t\u001a<jG\u0016\u0004")
public class RestErrorHandler {
    private final Logger logger = LoggerFactory.getLogger((Class)this.getClass());

    private Logger logger() {
        return this.logger;
    }

    @ExceptionHandler(value={ApiException.class})
    public ResponseEntity<Object> handleApiException(ApiException ex, WebRequest request) {
        this.logger().error("ApiException occurred", (Throwable)ex);
        return new ResponseEntity((Object)ex.apiErrors(), HttpStatus.UNPROCESSABLE_ENTITY);
    }

    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    public ResponseEntity<Object> handleMethodArgumentNotValidException(HttpMessageNotReadableException ex, WebRequest request) {
        this.logger().error("Probably Jackson Deserialization failed", (Throwable)ex);
        return new ResponseEntity(HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={AccessDeniedException.class})
    public ResponseEntity<Object> handleAccessDeniedException(AccessDeniedException ex, WebRequest request) {
        this.logger().error("Access is denied", (Throwable)ex);
        return new ResponseEntity(HttpStatus.UNAUTHORIZED);
    }

    @ExceptionHandler
    public ResponseEntity<Object> handleThrowable(Throwable ex) {
        this.logger().error("Unexpected error occurred", ex);
        return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
    }
}

