/*
 * Decompiled with CFR 0.152.
 */
package xyz.junerver.utils.ex;

import android.app.Activity;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.Base64;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.TextView;
import androidx.annotation.ColorRes;
import androidx.annotation.DrawableRes;
import androidx.core.content.ContextCompat;
import androidx.core.content.FileProvider;
import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.junerver.utils.ByteUtils;
import xyz.junerver.utils.TopFuncKt;
import xyz.junerver.utils.ex.ExtensionsKt;
import xyz.junerver.utils.ex.TextChangedListenerDsl;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\u00be\u0001\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\f\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\n\n\u0002\b\r\n\u0002\u0010\u0000\n\u0002\b\u0006\u001a\u001f\u0010\u0005\u001a\u00020\u00062\u0012\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\b\"\u00020\u0002\u00a2\u0006\u0002\u0010\t\u001a\u001f\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\b\"\u00020\r\u00a2\u0006\u0002\u0010\u000e\u001a\u001f\u0010\u000f\u001a\u00020\u000b2\u0012\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\b\"\u00020\r\u00a2\u0006\u0002\u0010\u000e\u001a\u001f\u0010\u0010\u001a\u00020\u000b2\u0012\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\b\"\u00020\r\u00a2\u0006\u0002\u0010\u000e\u001a|\u0010\u0011\u001a\u00020\u000b*\u00020\u00122\u0016\b\u0006\u0010\u0013\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0015\u0012\u0004\u0012\u00020\u000b0\u00142(\b\u0006\u0010\u0016\u001a\"\u0012\u0006\u0012\u0004\u0018\u00010\u0018\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u000b0\u00172(\b\u0006\u0010\u001a\u001a\"\u0012\u0006\u0012\u0004\u0018\u00010\u0018\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u000b0\u0017H\u0086\b\u00f8\u0001\u0000\u001a#\u0010\u001b\u001a\u00020\u000b*\u00020\u00122\u0017\u0010\u001c\u001a\u0013\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u000b0\u0014\u00a2\u0006\u0002\b\u001e\u001a\n\u0010\u001f\u001a\u00020 *\u00020\u0001\u001a\n\u0010!\u001a\u00020\u0006*\u00020\"\u001a\n\u0010#\u001a\u00020\u000b*\u00020\u0002\u001a\u0014\u0010$\u001a\u00020\u000b*\u00020\u00122\b\b\u0001\u0010%\u001a\u00020\u0019\u001a\"\u0010&\u001a\u00020\u000b*\u00020\"2\u0006\u0010'\u001a\u00020\u00012\u0006\u0010(\u001a\u00020\u00012\u0006\u0010)\u001a\u00020\u0001\u001a\n\u0010*\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010+\u001a\u00020,*\u00020\"\u001a\u0012\u0010-\u001a\u00020,*\u00020\r2\u0006\u0010.\u001a\u00020,\u001a\u0014\u0010/\u001a\u00020\u000b*\u00020\u00122\b\b\u0001\u0010%\u001a\u00020\u0019\u001a\u0014\u00100\u001a\u00020\u000b*\u00020\u00122\b\b\u0001\u0010%\u001a\u00020\u0019\u001a\u0014\u00101\u001a\u00020\u000b*\u00020\u00122\b\b\u0001\u0010%\u001a\u00020\u0019\u001a\u0014\u00102\u001a\u00020\u000b*\u00020\u00122\b\b\u0001\u0010%\u001a\u00020\u0019\u001a\u0014\u00103\u001a\u00020\u0019*\u00020\"2\b\b\u0001\u0010%\u001a\u00020\u0019\u001a\u0014\u00104\u001a\u000205*\u00020\"2\b\b\u0001\u0010%\u001a\u00020\u0019\u001a*\u00106\u001a\u0002H7\"\u0006\b\u0000\u00107\u0018\u0001*\u00020\"2\u0006\u00108\u001a\u00020\u00012\u0006\u00109\u001a\u0002H7H\u0086\b\u00a2\u0006\u0002\u0010:\u001a\u0012\u0010;\u001a\u00020<*\u00020\"2\u0006\u0010=\u001a\u00020>\u001a\n\u0010?\u001a\u00020\u000b*\u00020\r\u001a\u0018\u0010@\u001a\b\u0012\u0004\u0012\u00020\u00010A*\u00020\u00012\u0006\u0010B\u001a\u00020\u0019\u001a\n\u0010C\u001a\u00020\u000b*\u00020D\u001a\u0012\u0010E\u001a\u00020\r*\u00020\"2\u0006\u0010F\u001a\u00020\u0019\u001a\"\u0010E\u001a\u00020\r*\u00020\"2\u0006\u0010F\u001a\u00020\u00192\u0006\u0010G\u001a\u00020H2\u0006\u0010I\u001a\u00020\u0006\u001a\n\u0010J\u001a\u00020\u000b*\u00020\r\u001a\n\u0010K\u001a\u00020\u0006*\u00020\u0001\u001a\n\u0010L\u001a\u00020\u0006*\u00020\u0002\u001a\n\u0010M\u001a\u00020\u0006*\u00020\u0001\u001a\n\u0010N\u001a\u00020\u0006*\u00020\u0002\u001a\n\u0010O\u001a\u00020\u0006*\u00020\u0001\u001a\u001a\u0010P\u001a\u00020\u0001*\u00020\u00012\u0006\u0010Q\u001a\u00020\u00192\u0006\u0010R\u001a\u00020S\u001a\u001a\u0010T\u001a\u00020\u0001*\u00020\u00012\u0006\u0010Q\u001a\u00020\u00192\u0006\u0010R\u001a\u00020S\u001a\u0012\u0010U\u001a\u00020,*\u00020\r2\u0006\u0010V\u001a\u00020,\u001a\n\u0010W\u001a\u00020X*\u00020\u0001\u001a\n\u0010Y\u001a\u00020\u0019*\u00020\u0001\u001a\n\u0010Z\u001a\u00020[*\u00020\u0001\u001a\n\u0010\\\u001a\u00020]*\u00020\u0001\u001a\n\u0010^\u001a\u00020\u0019*\u00020\"\u001a\n\u0010_\u001a\u00020\u0019*\u00020\"\u001a\n\u0010`\u001a\u00020\u000b*\u00020\u0002\u001a\u0012\u0010a\u001a\u00020,*\u00020\r2\u0006\u0010b\u001a\u00020,\u001a\n\u0010c\u001a\u00020\u0019*\u00020\"\u001a\n\u0010d\u001a\u00020\u0001*\u00020\u0012\u001a\n\u0010e\u001a\u00020\u0001*\u00020\u0001\u001a.\u0010f\u001a\u0002H7\"\u0006\b\u0000\u00107\u0018\u0001*\u00020\u00012\b\b\u0002\u0010g\u001a\u00020\u00012\b\b\u0002\u0010h\u001a\u00020\u0006H\u0086\b\u00a2\u0006\u0002\u0010i\u001a0\u0010j\u001a\u00020\u0001*\u00020k2\b\b\u0002\u0010g\u001a\u00020\u00012\b\b\u0002\u0010h\u001a\u00020\u00062\u0010\b\u0002\u0010l\u001a\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010A\u001a\n\u0010m\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010n\u001a\u00020\u0019*\u00020\"\u001a\n\u0010o\u001a\u00020\u0001*\u00020\"\u001a\n\u0010p\u001a\u00020\u000b*\u00020\r\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006q"}, d2={"trimTextStr", "", "Landroid/widget/EditText;", "getTrimTextStr", "(Landroid/widget/EditText;)Ljava/lang/String;", "checkAll", "", "all", "", "([Landroid/widget/EditText;)Z", "gones", "", "views", "Landroid/view/View;", "([Landroid/view/View;)V", "invisibles", "visibles", "addTextChangedListenerClosure", "Landroid/widget/TextView;", "afterTextChanged", "Lkotlin/Function1;", "Landroid/text/Editable;", "beforeTextChanged", "Lkotlin/Function4;", "", "", "onTextChanged", "addTextChangedListenerDsl", "init", "Lxyz/junerver/utils/ex/TextChangedListenerDsl;", "Lkotlin/ExtensionFunctionType;", "base64toByteArray", "", "checkDeviceHasNavigationBar", "Landroid/content/Context;", "clear", "color", "id", "copyAssetFile", "assetName", "savePath", "saveName", "decodeBase64", "density", "", "dp2px", "dipValue", "drawableBottom", "drawableLeft", "drawableRight", "drawableTop", "getColorRes", "getDrawableRes", "Landroid/graphics/drawable/Drawable;", "getMeteData", "T", "key", "def", "(Landroid/content/Context;Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/Object;", "getUriForFile", "Landroid/net/Uri;", "file", "Ljava/io/File;", "gone", "groupByLength", "", "length", "hideBottomUIMenu", "Landroid/app/Activity;", "inflater", "resource", "root", "Landroid/view/ViewGroup;", "attachToRoot", "invisible", "isEmail", "isEmpty", "isMobile", "isNotEmpty", "isPhone", "padLeft", "len", "ch", "", "padRight", "px2dp", "pxValue", "safeConvertToDouble", "", "safeConvertToInt", "safeConvertToLong", "", "safeConvertToShort", "", "screenHeight", "screenWidth", "setOnlyDecimal", "sp2px", "spValue", "statusBarHeight", "stringTrim", "toBase64", "toBean", "dateFormat", "lenient", "(Ljava/lang/String;Ljava/lang/String;Z)Ljava/lang/Object;", "toJson", "", "excludeFields", "upperFirstLetter", "versionCode", "versionName", "visible", "utils_release"})
public final class ExtensionsKt {
    public static final float dp2px(@NotNull View $this$dp2px, float dipValue) {
        Intrinsics.checkNotNullParameter((Object)$this$dp2px, (String)"<this>");
        return dipValue * $this$dp2px.getResources().getDisplayMetrics().density + 0.5f;
    }

    public static final float px2dp(@NotNull View $this$px2dp, float pxValue) {
        Intrinsics.checkNotNullParameter((Object)$this$px2dp, (String)"<this>");
        return pxValue / $this$px2dp.getResources().getDisplayMetrics().density + 0.5f;
    }

    public static final float sp2px(@NotNull View $this$sp2px, float spValue) {
        Intrinsics.checkNotNullParameter((Object)$this$sp2px, (String)"<this>");
        return spValue * $this$sp2px.getResources().getDisplayMetrics().scaledDensity + 0.5f;
    }

    public static final void hideBottomUIMenu(@NotNull Activity $this$hideBottomUIMenu) {
        Intrinsics.checkNotNullParameter((Object)$this$hideBottomUIMenu, (String)"<this>");
        int n = Build.VERSION.SDK_INT;
        boolean bl = 12 <= n ? n <= 18 : false;
        if (bl) {
            View view = $this$hideBottomUIMenu.getWindow().getDecorView();
            Intrinsics.checkNotNullExpressionValue((Object)view, (String)"this.window.decorView");
            View v = view;
            v.setSystemUiVisibility(8);
        } else if (Build.VERSION.SDK_INT >= 19) {
            View view = $this$hideBottomUIMenu.getWindow().getDecorView();
            Intrinsics.checkNotNullExpressionValue((Object)view, (String)"window.decorView");
            View decorView = view;
            int uiOptions = 4102;
            decorView.setSystemUiVisibility(uiOptions);
        }
    }

    public static final void gone(@NotNull View $this$gone) {
        Intrinsics.checkNotNullParameter((Object)$this$gone, (String)"<this>");
        $this$gone.setVisibility(8);
    }

    public static final void gones(View ... views) {
        Intrinsics.checkNotNullParameter((Object)views, (String)"views");
        View[] $this$forEach$iv = views;
        boolean $i$f$forEach = false;
        View[] viewArray = $this$forEach$iv;
        int n = viewArray.length;
        for (int i = 0; i < n; ++i) {
            View element$iv;
            View it = element$iv = viewArray[i];
            boolean bl = false;
            ExtensionsKt.gone(it);
        }
    }

    public static final void invisible(@NotNull View $this$invisible) {
        Intrinsics.checkNotNullParameter((Object)$this$invisible, (String)"<this>");
        $this$invisible.setVisibility(4);
    }

    public static final void invisibles(View ... views) {
        Intrinsics.checkNotNullParameter((Object)views, (String)"views");
        View[] $this$forEach$iv = views;
        boolean $i$f$forEach = false;
        View[] viewArray = $this$forEach$iv;
        int n = viewArray.length;
        for (int i = 0; i < n; ++i) {
            View element$iv;
            View it = element$iv = viewArray[i];
            boolean bl = false;
            ExtensionsKt.invisible(it);
        }
    }

    public static final void visible(@NotNull View $this$visible) {
        Intrinsics.checkNotNullParameter((Object)$this$visible, (String)"<this>");
        $this$visible.setVisibility(0);
    }

    public static final void visibles(View ... views) {
        Intrinsics.checkNotNullParameter((Object)views, (String)"views");
        View[] $this$forEach$iv = views;
        boolean $i$f$forEach = false;
        View[] viewArray = $this$forEach$iv;
        int n = viewArray.length;
        for (int i = 0; i < n; ++i) {
            View element$iv;
            View it = element$iv = viewArray[i];
            boolean bl = false;
            ExtensionsKt.visible(it);
        }
    }

    @NotNull
    public static final String getTrimTextStr(@NotNull EditText $this$trimTextStr) {
        Intrinsics.checkNotNullParameter((Object)$this$trimTextStr, (String)"<this>");
        String string = $this$trimTextStr.getText().toString();
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        return ((Object)StringsKt.trim((CharSequence)string2)).toString();
    }

    public static final boolean isEmpty(@NotNull EditText $this$isEmpty) {
        Intrinsics.checkNotNullParameter((Object)$this$isEmpty, (String)"<this>");
        CharSequence charSequence = $this$isEmpty.getText().toString();
        boolean bl = false;
        String string = charSequence;
        if (string == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        charSequence = ((Object)StringsKt.trim((CharSequence)string)).toString();
        bl = false;
        return charSequence.length() == 0;
    }

    public static final boolean isNotEmpty(@NotNull EditText $this$isNotEmpty) {
        Intrinsics.checkNotNullParameter((Object)$this$isNotEmpty, (String)"<this>");
        CharSequence charSequence = $this$isNotEmpty.getText().toString();
        boolean bl = false;
        String string = charSequence;
        if (string == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        charSequence = ((Object)StringsKt.trim((CharSequence)string)).toString();
        bl = false;
        return charSequence.length() > 0;
    }

    public static final void clear(@NotNull EditText $this$clear) {
        Intrinsics.checkNotNullParameter((Object)$this$clear, (String)"<this>");
        $this$clear.setText((CharSequence)"");
    }

    public static final void setOnlyDecimal(@NotNull EditText $this$setOnlyDecimal) {
        Intrinsics.checkNotNullParameter((Object)$this$setOnlyDecimal, (String)"<this>");
        $this$setOnlyDecimal.setInputType(8194);
        $this$setOnlyDecimal.addTextChangedListener(new TextWatcher($this$setOnlyDecimal){
            final /* synthetic */ EditText $this_setOnlyDecimal;
            {
                this.$this_setOnlyDecimal = $receiver;
            }

            public void onTextChanged(@NotNull CharSequence s, int start, int before, int count) {
                Intrinsics.checkNotNullParameter((Object)s, (String)"s");
                if (StringsKt.contains$default((CharSequence)((Object)s).toString(), (CharSequence)".", (boolean)false, (int)2, null) && s.length() - 1 - StringsKt.indexOf$default((CharSequence)((Object)s).toString(), (String)".", (int)0, (boolean)false, (int)6, null) > 2) {
                    this.$this_setOnlyDecimal.setText(((Object)s).toString().subSequence(0, StringsKt.indexOf$default((CharSequence)((Object)s).toString(), (String)".", (int)0, (boolean)false, (int)6, null) + 3));
                    this.$this_setOnlyDecimal.setSelection(((Object)s).toString().subSequence(0, StringsKt.indexOf$default((CharSequence)((Object)s).toString(), (String)".", (int)0, (boolean)false, (int)6, null) + 3).length());
                }
                String string = ((Object)s).toString();
                int n = 0;
                String string2 = string;
                if (string2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                string = ((Object)StringsKt.trim((CharSequence)string2)).toString();
                n = 0;
                int n2 = 0;
                String string3 = string;
                if (string3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string4 = string3.substring(n);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
                if (Intrinsics.areEqual((Object)string4, (Object)".")) {
                    this.$this_setOnlyDecimal.setText((CharSequence)Intrinsics.stringPlus((String)"0", (Object)s));
                    this.$this_setOnlyDecimal.setSelection(2);
                }
                if (StringsKt.startsWith$default((String)((Object)s).toString(), (String)"0", (boolean)false, (int)2, null)) {
                    string = ((Object)s).toString();
                    n = 0;
                    String string5 = string;
                    if (string5 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                    }
                    if (((Object)StringsKt.trim((CharSequence)string5)).toString().length() > 1) {
                        string = ((Object)s).toString();
                        n = 1;
                        n2 = 2;
                        boolean bl = false;
                        String string6 = string;
                        if (string6 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string7 = string6.substring(n, n2);
                        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                        if (!Intrinsics.areEqual((Object)string7, (Object)".")) {
                            this.$this_setOnlyDecimal.setText(s.subSequence(0, 1));
                            this.$this_setOnlyDecimal.setSelection(1);
                            return;
                        }
                    }
                }
            }

            public void beforeTextChanged(@NotNull CharSequence s, int start, int count, int after) {
                Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            }

            public void afterTextChanged(@NotNull Editable s) {
                Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            }
        });
    }

    public static final boolean checkAll(EditText ... all) {
        Intrinsics.checkNotNullParameter((Object)all, (String)"all");
        EditText[] $this$forEach$iv = all;
        boolean $i$f$forEach = false;
        EditText[] editTextArray = $this$forEach$iv;
        int n = editTextArray.length;
        for (int i = 0; i < n; ++i) {
            EditText element$iv;
            EditText it = element$iv = editTextArray[i];
            boolean bl = false;
            if (!ExtensionsKt.isEmpty(it)) continue;
            return false;
        }
        return true;
    }

    public static final void drawableLeft(@NotNull TextView $this$drawableLeft, @DrawableRes int id2) {
        Intrinsics.checkNotNullParameter((Object)$this$drawableLeft, (String)"<this>");
        Context context = $this$drawableLeft.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        Drawable d = ExtensionsKt.getDrawableRes(context, id2);
        d.setBounds(0, 0, d.getMinimumWidth(), d.getMinimumHeight());
        $this$drawableLeft.setCompoundDrawables(d, null, null, null);
    }

    public static final void drawableBottom(@NotNull TextView $this$drawableBottom, @DrawableRes int id2) {
        Intrinsics.checkNotNullParameter((Object)$this$drawableBottom, (String)"<this>");
        Context context = $this$drawableBottom.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        Drawable d = ExtensionsKt.getDrawableRes(context, id2);
        d.setBounds(0, 0, d.getMinimumWidth(), d.getMinimumHeight());
        $this$drawableBottom.setCompoundDrawables(null, null, null, d);
    }

    public static final void drawableRight(@NotNull TextView $this$drawableRight, @DrawableRes int id2) {
        Intrinsics.checkNotNullParameter((Object)$this$drawableRight, (String)"<this>");
        Context context = $this$drawableRight.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        Drawable d = ExtensionsKt.getDrawableRes(context, id2);
        d.setBounds(0, 0, d.getMinimumWidth(), d.getMinimumHeight());
        $this$drawableRight.setCompoundDrawables(null, null, d, null);
    }

    public static final void drawableTop(@NotNull TextView $this$drawableTop, @DrawableRes int id2) {
        Intrinsics.checkNotNullParameter((Object)$this$drawableTop, (String)"<this>");
        Context context = $this$drawableTop.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        Drawable d = ExtensionsKt.getDrawableRes(context, id2);
        d.setBounds(0, 0, d.getMinimumWidth(), d.getMinimumHeight());
        $this$drawableTop.setCompoundDrawables(null, d, null, null);
    }

    public static final void addTextChangedListenerDsl(@NotNull TextView $this$addTextChangedListenerDsl, @NotNull Function1<? super TextChangedListenerDsl, Unit> init) {
        Intrinsics.checkNotNullParameter((Object)$this$addTextChangedListenerDsl, (String)"<this>");
        Intrinsics.checkNotNullParameter(init, (String)"init");
        TextChangedListenerDsl listener2 = new TextChangedListenerDsl();
        init.invoke((Object)listener2);
        $this$addTextChangedListenerDsl.addTextChangedListener((TextWatcher)listener2);
    }

    public static final void addTextChangedListenerClosure(@NotNull TextView $this$addTextChangedListenerClosure, @NotNull Function1<? super Editable, Unit> afterTextChanged, @NotNull Function4<? super CharSequence, ? super Integer, ? super Integer, ? super Integer, Unit> beforeTextChanged, @NotNull Function4<? super CharSequence, ? super Integer, ? super Integer, ? super Integer, Unit> onTextChanged) {
        Intrinsics.checkNotNullParameter((Object)$this$addTextChangedListenerClosure, (String)"<this>");
        Intrinsics.checkNotNullParameter(afterTextChanged, (String)"afterTextChanged");
        Intrinsics.checkNotNullParameter(beforeTextChanged, (String)"beforeTextChanged");
        Intrinsics.checkNotNullParameter(onTextChanged, (String)"onTextChanged");
        boolean $i$f$addTextChangedListenerClosure = false;
        TextWatcher listener2 = new TextWatcher(afterTextChanged, beforeTextChanged, onTextChanged){
            final /* synthetic */ Function1<Editable, Unit> $afterTextChanged;
            final /* synthetic */ Function4<CharSequence, Integer, Integer, Integer, Unit> $beforeTextChanged;
            final /* synthetic */ Function4<CharSequence, Integer, Integer, Integer, Unit> $onTextChanged;
            {
                this.$afterTextChanged = $afterTextChanged;
                this.$beforeTextChanged = $beforeTextChanged;
                this.$onTextChanged = $onTextChanged;
            }

            public void afterTextChanged(@Nullable Editable s) {
                String string = "afterTextChanged";
                boolean bl = false;
                System.out.println((Object)string);
                this.$afterTextChanged.invoke((Object)s);
                string = "afterTextChanged--end";
                bl = false;
                System.out.println((Object)string);
            }

            public void beforeTextChanged(@Nullable CharSequence s, int start, int count, int after) {
                String string = "beforeTextChanged";
                boolean bl = false;
                System.out.println((Object)string);
                this.$beforeTextChanged.invoke((Object)s, (Object)start, (Object)count, (Object)after);
                string = "beforeTextChanged--end";
                bl = false;
                System.out.println((Object)string);
            }

            public void onTextChanged(@Nullable CharSequence s, int start, int before, int count) {
                String string = "onTextChanged";
                boolean bl = false;
                System.out.println((Object)string);
                this.$onTextChanged.invoke((Object)s, (Object)start, (Object)before, (Object)count);
                string = "onTextChanged--end";
                bl = false;
                System.out.println((Object)string);
            }
        };
        $this$addTextChangedListenerClosure.addTextChangedListener(listener2);
    }

    public static /* synthetic */ void addTextChangedListenerClosure$default(TextView $this$addTextChangedListenerClosure_u24default, Function1 afterTextChanged, Function4 beforeTextChanged, Function4 onTextChanged, int n, Object object) {
        if ((n & 1) != 0) {
            afterTextChanged = addTextChangedListenerClosure.1.INSTANCE;
        }
        if ((n & 2) != 0) {
            beforeTextChanged = addTextChangedListenerClosure.2.INSTANCE;
        }
        if ((n & 4) != 0) {
            onTextChanged = addTextChangedListenerClosure.3.INSTANCE;
        }
        Intrinsics.checkNotNullParameter((Object)$this$addTextChangedListenerClosure_u24default, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)afterTextChanged, (String)"afterTextChanged");
        Intrinsics.checkNotNullParameter((Object)beforeTextChanged, (String)"beforeTextChanged");
        Intrinsics.checkNotNullParameter((Object)onTextChanged, (String)"onTextChanged");
        boolean $i$f$addTextChangedListenerClosure = false;
        TextWatcher listener2 = new /* invalid duplicate definition of identical inner class */;
        $this$addTextChangedListenerClosure_u24default.addTextChangedListener(listener2);
    }

    public static final void color(@NotNull TextView $this$color, @ColorRes int id2) {
        Intrinsics.checkNotNullParameter((Object)$this$color, (String)"<this>");
        Context ctx = $this$color.getContext();
        $this$color.setTextColor(ContextCompat.getColor((Context)ctx, (int)id2));
    }

    @NotNull
    public static final String stringTrim(@NotNull TextView $this$stringTrim) {
        Intrinsics.checkNotNullParameter((Object)$this$stringTrim, (String)"<this>");
        String string = ((Object)$this$stringTrim.getText()).toString();
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        return ((Object)StringsKt.trim((CharSequence)string2)).toString();
    }

    public static final boolean isMobile(@NotNull String $this$isMobile) {
        Intrinsics.checkNotNullParameter((Object)$this$isMobile, (String)"<this>");
        String regex = "(\\+\\d+)?1[34578]\\d{9}$";
        return Pattern.matches(regex, $this$isMobile);
    }

    public static final boolean isPhone(@NotNull String $this$isPhone) {
        Intrinsics.checkNotNullParameter((Object)$this$isPhone, (String)"<this>");
        String regex = "(\\+\\d+)?(\\d{3,4}\\-?)?\\d{7,8}$";
        return Pattern.matches(regex, $this$isPhone);
    }

    public static final boolean isEmail(@NotNull String $this$isEmail) {
        Intrinsics.checkNotNullParameter((Object)$this$isEmail, (String)"<this>");
        Pattern emailPattern = Pattern.compile("\\w+([-+.]\\w+)*@\\w+([-.]\\w+)*\\.\\w+([-.]\\w+)*");
        Matcher matcher = emailPattern.matcher($this$isEmail);
        return matcher.find();
    }

    public static final int safeConvertToInt(@NotNull String $this$safeConvertToInt) {
        int n;
        Intrinsics.checkNotNullParameter((Object)$this$safeConvertToInt, (String)"<this>");
        try {
            String string = $this$safeConvertToInt;
            boolean bl = false;
            n = Integer.parseInt(string);
        }
        catch (Exception e) {
            n = 0;
        }
        return n;
    }

    public static final long safeConvertToLong(@NotNull String $this$safeConvertToLong) {
        long l;
        Intrinsics.checkNotNullParameter((Object)$this$safeConvertToLong, (String)"<this>");
        try {
            String string = $this$safeConvertToLong;
            boolean bl = false;
            l = Long.parseLong(string);
        }
        catch (Exception e) {
            l = 0L;
        }
        return l;
    }

    public static final double safeConvertToDouble(@NotNull String $this$safeConvertToDouble) {
        double d;
        Intrinsics.checkNotNullParameter((Object)$this$safeConvertToDouble, (String)"<this>");
        try {
            String string = $this$safeConvertToDouble;
            boolean bl = false;
            d = Double.parseDouble(string);
        }
        catch (Exception e) {
            d = 0.0;
        }
        return d;
    }

    public static final short safeConvertToShort(@NotNull String $this$safeConvertToShort) {
        short s;
        Intrinsics.checkNotNullParameter((Object)$this$safeConvertToShort, (String)"<this>");
        try {
            String string = $this$safeConvertToShort;
            boolean bl = false;
            s = Short.parseShort(string);
        }
        catch (Exception e) {
            s = 0;
        }
        return s;
    }

    @NotNull
    public static final String toBase64(@NotNull String $this$toBase64) {
        Intrinsics.checkNotNullParameter((Object)$this$toBase64, (String)"<this>");
        String string = $this$toBase64;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        return ByteUtils.INSTANCE.toBase64(byArray);
    }

    @NotNull
    public static final byte[] base64toByteArray(@NotNull String $this$base64toByteArray) {
        Intrinsics.checkNotNullParameter((Object)$this$base64toByteArray, (String)"<this>");
        byte[] byArray = Base64.decode((String)$this$base64toByteArray, (int)2);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"decode(this, Base64.NO_WRAP)");
        return byArray;
    }

    @NotNull
    public static final String decodeBase64(@NotNull String $this$decodeBase64) {
        Intrinsics.checkNotNullParameter((Object)$this$decodeBase64, (String)"<this>");
        byte[] byArray = ExtensionsKt.base64toByteArray($this$decodeBase64);
        boolean bl = false;
        return new String(byArray, Charsets.UTF_8);
    }

    @NotNull
    public static final List<String> groupByLength(@NotNull String $this$groupByLength, int length) {
        Intrinsics.checkNotNullParameter((Object)$this$groupByLength, (String)"<this>");
        return TopFuncKt.groupStringByLength($this$groupByLength, length);
    }

    @NotNull
    public static final String upperFirstLetter(@NotNull String $this$upperFirstLetter) {
        Intrinsics.checkNotNullParameter((Object)$this$upperFirstLetter, (String)"<this>");
        CharSequence charSequence = $this$upperFirstLetter;
        boolean bl = false;
        int n = 0;
        if (!(charSequence.length() == 0)) {
            if (!Character.isLowerCase($this$upperFirstLetter.charAt(0))) {
                return $this$upperFirstLetter;
            }
            char c = $this$upperFirstLetter.charAt(0);
            bl = false;
            c = (char)(c - 32);
            String string = $this$upperFirstLetter;
            n = 1;
            boolean bl2 = false;
            String string2 = string.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
            string = string2;
            n = 0;
            return String.valueOf(c) + string;
        }
        return "";
    }

    @NotNull
    public static final String padLeft(@NotNull String $this$padLeft, int len, char ch) {
        Intrinsics.checkNotNullParameter((Object)$this$padLeft, (String)"<this>");
        int diff = len - $this$padLeft.length();
        if (diff <= 0) {
            return $this$padLeft;
        }
        char[] charr = new char[len];
        String string = $this$padLeft;
        boolean bl = false;
        char[] cArray = string.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
        System.arraycopy(cArray, 0, charr, 0, $this$padLeft.length());
        int n = $this$padLeft.length();
        if (n < len) {
            do {
                int i = n++;
                charr[i] = ch;
            } while (n < len);
        }
        n = 0;
        return new String(charr);
    }

    @NotNull
    public static final String padRight(@NotNull String $this$padRight, int len, char ch) {
        Intrinsics.checkNotNullParameter((Object)$this$padRight, (String)"<this>");
        int diff = len - $this$padRight.length();
        if (diff <= 0) {
            return $this$padRight;
        }
        char[] charr = new char[len];
        String string = $this$padRight;
        boolean bl = false;
        char[] cArray = string.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
        System.arraycopy(cArray, 0, charr, diff, $this$padRight.length());
        int n = 0;
        if (n < diff) {
            do {
                int i = n++;
                charr[i] = ch;
            } while (n < diff);
        }
        n = 0;
        return new String(charr);
    }

    @NotNull
    public static final String toJson(@NotNull Object $this$toJson, @NotNull String dateFormat, boolean lenient, @Nullable List<String> excludeFields) {
        Intrinsics.checkNotNullParameter((Object)$this$toJson, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dateFormat, (String)"dateFormat");
        GsonBuilder gsonBuilder = new GsonBuilder().setDateFormat(dateFormat);
        boolean bl = false;
        boolean bl2 = false;
        GsonBuilder $this$toJson_u24lambda_u2d4 = gsonBuilder;
        boolean bl3 = false;
        if (lenient) {
            $this$toJson_u24lambda_u2d4.setLenient();
        }
        ExclusionStrategy[] exclusionStrategyArray = (ExclusionStrategy[])excludeFields;
        boolean bl4 = false;
        boolean bl5 = false;
        if (!(exclusionStrategyArray == null || exclusionStrategyArray.isEmpty())) {
            exclusionStrategyArray = new ExclusionStrategy[]{new ExclusionStrategy(excludeFields){
                final /* synthetic */ List<String> $excludeFields;
                {
                    this.$excludeFields = $excludeFields;
                }

                public boolean shouldSkipField(@Nullable FieldAttributes f) {
                    return f != null && this.$excludeFields.contains(f.getName());
                }

                public boolean shouldSkipClass(@Nullable Class<?> clazz) {
                    return false;
                }
            }};
            $this$toJson_u24lambda_u2d4.setExclusionStrategies(exclusionStrategyArray);
        }
        String string = gsonBuilder.create().toJson($this$toJson);
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    public static /* synthetic */ String toJson$default(Object object, String string, boolean bl, List list, int n, Object object2) {
        if ((n & 1) != 0) {
            string = "yyyy-MM-dd HH:mm:ss";
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            list = null;
        }
        return ExtensionsKt.toJson(object, string, bl, list);
    }

    public static final /* synthetic */ <T> T toBean(String $this$toBean, String dateFormat, boolean lenient) {
        Intrinsics.checkNotNullParameter((Object)$this$toBean, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dateFormat, (String)"dateFormat");
        boolean $i$f$toBean = false;
        GsonBuilder gsonBuilder = new GsonBuilder().setDateFormat(dateFormat);
        boolean bl = false;
        boolean bl2 = false;
        GsonBuilder $this$toBean_u24lambda_u2d5 = gsonBuilder;
        boolean bl3 = false;
        if (lenient) {
            $this$toBean_u24lambda_u2d5.setLenient();
        }
        Gson gson = gsonBuilder.create();
        Intrinsics.needClassReification();
        Object object = gson.fromJson($this$toBean, new TypeToken<T>(){}.getType());
        Intrinsics.checkNotNull((Object)object);
        return (T)object;
    }

    public static /* synthetic */ Object toBean$default(String $this$toBean_u24default, String dateFormat, boolean lenient, int n, Object object) {
        if ((n & 1) != 0) {
            dateFormat = "yyyy-MM-dd HH:mm:ss";
        }
        if ((n & 2) != 0) {
            lenient = false;
        }
        Intrinsics.checkNotNullParameter((Object)$this$toBean_u24default, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dateFormat, (String)"dateFormat");
        boolean $i$f$toBean = false;
        object = new GsonBuilder().setDateFormat(dateFormat);
        boolean bl = false;
        boolean bl2 = false;
        Object $this$toBean_u24lambda_u2d5 = object;
        boolean bl3 = false;
        if (lenient) {
            $this$toBean_u24lambda_u2d5.setLenient();
        }
        Gson gson = object.create();
        Intrinsics.needClassReification();
        Object object2 = gson.fromJson($this$toBean_u24default, new /* invalid duplicate definition of identical inner class */.getType());
        Intrinsics.checkNotNull((Object)object2);
        return object2;
    }

    @NotNull
    public static final Drawable getDrawableRes(@NotNull Context $this$getDrawableRes, @DrawableRes int id2) {
        Intrinsics.checkNotNullParameter((Object)$this$getDrawableRes, (String)"<this>");
        Drawable drawable = ContextCompat.getDrawable((Context)$this$getDrawableRes, (int)id2);
        Intrinsics.checkNotNull((Object)drawable);
        Drawable drawable2 = drawable;
        Intrinsics.checkNotNullExpressionValue((Object)drawable2, (String)"getDrawable(this, id)!!");
        return drawable2;
    }

    public static final int getColorRes(@NotNull Context $this$getColorRes, @ColorRes int id2) {
        Intrinsics.checkNotNullParameter((Object)$this$getColorRes, (String)"<this>");
        return ContextCompat.getColor((Context)$this$getColorRes, (int)id2);
    }

    @NotNull
    public static final View inflater(@NotNull Context $this$inflater, int resource) {
        Intrinsics.checkNotNullParameter((Object)$this$inflater, (String)"<this>");
        View view = LayoutInflater.from((Context)$this$inflater).inflate(resource, null);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"from(this).inflate(resource, null)");
        return view;
    }

    @NotNull
    public static final View inflater(@NotNull Context $this$inflater, int resource, @NotNull ViewGroup root, boolean attachToRoot) {
        Intrinsics.checkNotNullParameter((Object)$this$inflater, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        View view = LayoutInflater.from((Context)$this$inflater).inflate(resource, root, attachToRoot);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"from(this).inflate(resource, root, attachToRoot)");
        return view;
    }

    public static final int screenWidth(@NotNull Context $this$screenWidth) {
        Intrinsics.checkNotNullParameter((Object)$this$screenWidth, (String)"<this>");
        return $this$screenWidth.getResources().getDisplayMetrics().widthPixels;
    }

    public static final int screenHeight(@NotNull Context $this$screenHeight) {
        Intrinsics.checkNotNullParameter((Object)$this$screenHeight, (String)"<this>");
        return $this$screenHeight.getResources().getDisplayMetrics().heightPixels;
    }

    public static final int statusBarHeight(@NotNull Context $this$statusBarHeight) {
        Intrinsics.checkNotNullParameter((Object)$this$statusBarHeight, (String)"<this>");
        int resourceId = $this$statusBarHeight.getResources().getIdentifier("status_bar_height", "dimen", "android");
        int statusBarHeight = 0;
        if (resourceId > 0) {
            statusBarHeight = $this$statusBarHeight.getResources().getDimensionPixelSize(resourceId);
        }
        return statusBarHeight;
    }

    public static final int versionCode(@NotNull Context $this$versionCode) {
        Intrinsics.checkNotNullParameter((Object)$this$versionCode, (String)"<this>");
        return Build.VERSION.SDK_INT < 28 ? $this$versionCode.getPackageManager().getPackageInfo((String)$this$versionCode.getPackageName(), (int)0).versionCode : (int)$this$versionCode.getPackageManager().getPackageInfo($this$versionCode.getPackageName(), 0).getLongVersionCode();
    }

    @NotNull
    public static final String versionName(@NotNull Context $this$versionName) {
        Intrinsics.checkNotNullParameter((Object)$this$versionName, (String)"<this>");
        String string = $this$versionName.getPackageManager().getPackageInfo((String)$this$versionName.getPackageName(), (int)0).versionName;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"packageManager.getPackag\u2026ckageName, 0).versionName");
        return string;
    }

    public static final float density(@NotNull Context $this$density) {
        Intrinsics.checkNotNullParameter((Object)$this$density, (String)"<this>");
        return $this$density.getResources().getDisplayMetrics().density;
    }

    public static final boolean checkDeviceHasNavigationBar(@NotNull Context $this$checkDeviceHasNavigationBar) {
        Intrinsics.checkNotNullParameter((Object)$this$checkDeviceHasNavigationBar, (String)"<this>");
        boolean hasNavigationBar = false;
        Resources rs = $this$checkDeviceHasNavigationBar.getResources();
        int id2 = rs.getIdentifier("config_showNavigationBar", "bool", "android");
        if (id2 > 0) {
            hasNavigationBar = rs.getBoolean(id2);
        }
        try {
            Class<?> systemPropertiesClass = Class.forName("android.os.SystemProperties");
            Class[] classArray = new Class[]{String.class};
            Method m = systemPropertiesClass.getMethod("get", classArray);
            Object[] objectArray = new Object[]{"qemu.hw.mainkeys"};
            Object object = m.invoke(systemPropertiesClass, objectArray);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
            }
            String navBarOverride = (String)object;
            if (Intrinsics.areEqual((Object)"1", (Object)navBarOverride)) {
                hasNavigationBar = false;
            } else if (Intrinsics.areEqual((Object)"0", (Object)navBarOverride)) {
                hasNavigationBar = true;
            }
        }
        catch (Exception e) {
            Log.e((String)"ContextExtend", (String)"\u68c0\u67e5\u865a\u62df\u952e\u76d8\uff1a");
        }
        return hasNavigationBar;
    }

    @NotNull
    public static final Uri getUriForFile(@NotNull Context $this$getUriForFile, @NotNull File file) {
        Uri uri;
        Intrinsics.checkNotNullParameter((Object)$this$getUriForFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (Build.VERSION.SDK_INT > 24) {
            Uri uri2 = FileProvider.getUriForFile((Context)$this$getUriForFile.getApplicationContext(), (String)Intrinsics.stringPlus((String)$this$getUriForFile.getPackageName(), (Object)".FileProvider"), (File)file);
            Intrinsics.checkNotNullExpressionValue((Object)uri2, (String)"{\n        FileProvider.g\u2026     file\n        )\n    }");
            uri = uri2;
        } else {
            Uri uri3 = Uri.fromFile((File)file);
            Intrinsics.checkNotNullExpressionValue((Object)uri3, (String)"{\n        Uri.fromFile(file)\n    }");
            uri = uri3;
        }
        return uri;
    }

    public static final /* synthetic */ <T> T getMeteData(Context $this$getMeteData, String key, T def) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$getMeteData, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        boolean $i$f$getMeteData = false;
        ApplicationInfo applicationInfo = $this$getMeteData.getPackageManager().getApplicationInfo($this$getMeteData.getPackageName(), 128);
        Intrinsics.checkNotNullExpressionValue((Object)applicationInfo, (String)"this.packageManager.getA\u2026ageManager.GET_META_DATA)");
        ApplicationInfo applicationInfo2 = applicationInfo;
        Object data = applicationInfo2.metaData.get(key);
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        KClass kClass = Reflection.getOrCreateKotlinClass(Object.class);
        if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
            if (data == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
            }
            object = (int)((Integer)data);
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(String.class))) {
            if (data == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
            }
            object = (String)data;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
            if (data == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
            }
            object = (long)((Float)data).floatValue();
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
            if (data == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
            }
            object = Float.valueOf(((Float)data).floatValue());
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Boolean.TYPE))) {
            if (data == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Boolean");
            }
            object = (boolean)((Boolean)data);
        } else {
            throw new IllegalArgumentException("METE-DATA \u7c7b\u578b\u9519\u8bef");
        }
        Intrinsics.reifiedOperationMarker((int)1, (String)"T");
        return (T)object;
    }

    public static final void copyAssetFile(@NotNull Context $this$copyAssetFile, @NotNull String assetName, @NotNull String savePath, @NotNull String saveName) throws IOException {
        File dbf;
        Intrinsics.checkNotNullParameter((Object)$this$copyAssetFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)assetName, (String)"assetName");
        Intrinsics.checkNotNullParameter((Object)savePath, (String)"savePath");
        Intrinsics.checkNotNullParameter((Object)saveName, (String)"saveName");
        File dir = new File(savePath);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if ((dbf = new File(Intrinsics.stringPlus((String)savePath, (Object)saveName))).exists()) {
            dbf.delete();
        }
        String outFileName = Intrinsics.stringPlus((String)savePath, (Object)saveName);
        FileOutputStream myOutput = new FileOutputStream(outFileName);
        InputStream inputStream = $this$copyAssetFile.getAssets().open(assetName);
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"this.assets.open(assetName)");
        InputStream myInput = inputStream;
        byte[] buffer = new byte[1024];
        int length = 0;
        while (true) {
            int n = myInput.read(buffer);
            boolean bl = false;
            boolean bl2 = false;
            int it = n;
            boolean bl3 = false;
            length = it;
            if (n <= 0) break;
            myOutput.write(buffer, 0, length);
        }
        myOutput.flush();
        myInput.close();
        myOutput.close();
    }
}

