/*
 * Decompiled with CFR 0.152.
 */
package xyz.junerver.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u0012\n\u0002\b\u0005\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0005\u001a\u0006\u0010\u0007\u001a\u00020\u0001\u001a\u001c\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u0005\u001a\u001c\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00010\t2\u0006\u0010\u000e\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u0005\u00a8\u0006\u000f"}, d2={"dataFormat", "", "total", "", "getTotalPiece", "", "piece", "getUUID", "groupByteArrayByLength", "", "", "ba", "length", "groupStringByLength", "str", "utils_release"})
public final class TopFuncKt {
    @NotNull
    public static final String dataFormat(long total) {
        String string;
        String result = null;
        int speedReal = (int)(total / (long)1024);
        if (speedReal < 512) {
            string = speedReal + " KB";
        } else {
            double mSpeed = (double)speedReal / 1024.0;
            string = (double)Math.round(mSpeed * (double)100) / 100.0 + " MB";
        }
        result = string;
        return result;
    }

    @NotNull
    public static final String getUUID() {
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID().toString()");
        return string;
    }

    @NotNull
    public static final List<String> groupStringByLength(@NotNull String str, int length) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        List list = new ArrayList();
        int num = TopFuncKt.getTotalPiece(str.length(), length);
        int n = 0;
        if (n < num) {
            do {
                int i;
                list.add(StringsKt.substring((String)str, (IntRange)RangesKt.until((int)(i * length), (int)((i = n++) == num - 1 ? str.length() : i * length + length))));
            } while (n < num);
        }
        return list;
    }

    @NotNull
    public static final List<byte[]> groupByteArrayByLength(@NotNull byte[] ba, int length) {
        Intrinsics.checkNotNullParameter((Object)ba, (String)"ba");
        List list = new ArrayList();
        int num = TopFuncKt.getTotalPiece(ba.length, length);
        int n = 0;
        if (n < num) {
            do {
                int i = n++;
                byte[] byArray = ba;
                int n2 = i * length;
                int n3 = i == num - 1 ? ba.length : i * length + length;
                boolean bl = false;
                list.add(ArraysKt.copyOfRange((byte[])byArray, (int)n2, (int)n3));
            } while (n < num);
        }
        return list;
    }

    public static final int getTotalPiece(long total, int piece) {
        return total % (long)piece > 0L ? (int)(total / (long)piece) + 1 : (int)(total / (long)piece);
    }
}

