/*
 * Decompiled with CFR 0.152.
 */
package xyz.junerver.utils;

import android.app.ActivityManager;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import androidx.annotation.NonNull;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.junerver.utils.Utils;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\t\u001a\u00020\n2\u000e\b\u0001\u0010\r\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000eJ\u0012\u0010\t\u001a\u00020\n2\n\b\u0001\u0010\u000f\u001a\u0004\u0018\u00010\bJ\u0012\u0010\u0010\u001a\u00020\u00042\n\b\u0001\u0010\u000b\u001a\u0004\u0018\u00010\fJ\u0016\u0010\u0010\u001a\u00020\u00042\u000e\b\u0001\u0010\r\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000eJ\u0012\u0010\u0010\u001a\u00020\u00042\n\b\u0001\u0010\u000f\u001a\u0004\u0018\u00010\b\u00a8\u0006\u0011"}, d2={"Lxyz/junerver/utils/ServiceUtils;", "", "()V", "isServiceRunning", "", "context", "Landroid/content/Context;", "serviceName", "", "startService", "", "intent", "Landroid/content/Intent;", "cls", "Ljava/lang/Class;", "className", "stopService", "utils_release"})
public final class ServiceUtils {
    @NotNull
    public static final ServiceUtils INSTANCE = new ServiceUtils();

    private ServiceUtils() {
    }

    public final boolean isServiceRunning(@NotNull String serviceName) {
        Intrinsics.checkNotNullParameter((Object)serviceName, (String)"serviceName");
        Context context = Utils.getApp().getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getApp().applicationContext");
        return this.isServiceRunning(context, serviceName);
    }

    public final boolean isServiceRunning(@NotNull Context context, @NotNull String serviceName) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)serviceName, (String)"serviceName");
        Object object = context.getSystemService("activity");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.app.ActivityManager");
        }
        ActivityManager manager = (ActivityManager)object;
        List serviceInfoList = manager.getRunningServices(200);
        if (serviceInfoList.size() <= 0) {
            return false;
        }
        for (ActivityManager.RunningServiceInfo info : serviceInfoList) {
            if (!Intrinsics.areEqual((Object)info.service.getClassName(), (Object)serviceName)) continue;
            return true;
        }
        return false;
    }

    public final void startService(@NotNull Intent intent) {
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        try {
            intent.setFlags(32);
            if (Build.VERSION.SDK_INT >= 26) {
                Utils.getApp().startForegroundService(intent);
            } else {
                Utils.getApp().startService(intent);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public final void startService(@NonNull @Nullable String className) {
        try {
            this.startService(Class.forName(className));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public final void startService(@NonNull @Nullable Class<?> cls) {
        this.startService(new Intent((Context)Utils.getApp(), cls));
    }

    public final boolean stopService(@NonNull @Nullable String className) {
        boolean bl;
        try {
            bl = this.stopService(Class.forName(className));
        }
        catch (Exception e) {
            e.printStackTrace();
            bl = false;
        }
        return bl;
    }

    public final boolean stopService(@NonNull @Nullable Class<?> cls) {
        return this.stopService(new Intent((Context)Utils.getApp(), cls));
    }

    public final boolean stopService(@NonNull @Nullable Intent intent) {
        boolean bl;
        try {
            bl = Utils.getApp().stopService(intent);
        }
        catch (Exception e) {
            e.printStackTrace();
            bl = false;
        }
        return bl;
    }
}

