/*
 * Decompiled with CFR 0.152.
 */
package xyz.junerver.utils;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.telephony.TelephonyManager;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import xyz.junerver.utils.Utils;

public class NetworkUtils {
    public static final int NETWORK_WIFI = 1;
    public static final int NETWORK_4G = 4;
    public static final int NETWORK_3G = 3;
    public static final int NETWORK_2G = 2;
    public static final int NETWORK_UNKNOWN = 5;
    public static final int NETWORK_NO = -1;
    private static final int NETWORK_TYPE_GSM = 16;
    private static final int NETWORK_TYPE_TD_SCDMA = 17;
    private static final int NETWORK_TYPE_IWLAN = 18;

    private NetworkUtils() {
        throw new UnsupportedOperationException("\u4e0d\u5141\u8bb8\u521b\u5efaNetworkUtils\u6784\u9020\u5668");
    }

    public static void openWirelessSettings(Context context) {
        if (Build.VERSION.SDK_INT > 10) {
            context.startActivity(new Intent("android.settings.WIRELESS_SETTINGS"));
        } else {
            context.startActivity(new Intent("android.settings.SETTINGS"));
        }
    }

    @SuppressLint(value={"MissingPermission"})
    private static NetworkInfo getActiveNetworkInfo(Context context) {
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        return cm.getActiveNetworkInfo();
    }

    public static boolean isConnected() {
        NetworkInfo info = NetworkUtils.getActiveNetworkInfo((Context)Utils.getApp());
        return info != null && info.isConnected();
    }

    public static void setDataEnabled(Context context, boolean enabled) {
        try {
            TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
            Method setMobileDataEnabledMethod = tm.getClass().getDeclaredMethod("setDataEnabled", Boolean.TYPE);
            if (null != setMobileDataEnabledMethod) {
                setMobileDataEnabledMethod.invoke((Object)tm, enabled);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean is4G(Context context) {
        NetworkInfo info = NetworkUtils.getActiveNetworkInfo(context);
        return info != null && info.isAvailable() && info.getSubtype() == 13;
    }

    public static boolean getWifiEnabled(Context context) {
        WifiManager wifiManager = (WifiManager)context.getSystemService("wifi");
        return wifiManager.isWifiEnabled();
    }

    public static void setWifiEnabled(Context context, boolean enabled) {
        WifiManager wifiManager = (WifiManager)context.getSystemService("wifi");
        if (enabled ? !wifiManager.isWifiEnabled() : wifiManager.isWifiEnabled()) {
            // empty if block
        }
    }

    @SuppressLint(value={"MissingPermission"})
    public static boolean isWifiConnected(Context context) {
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        return cm != null && cm.getActiveNetworkInfo() != null && cm.getActiveNetworkInfo().getType() == 1;
    }

    public static String getNetworkOperatorName(Context context) {
        TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
        return tm != null ? tm.getNetworkOperatorName() : null;
    }

    public static int getNetworkType(Context context) {
        int netType = -1;
        NetworkInfo info = NetworkUtils.getActiveNetworkInfo(context);
        if (info != null && info.isAvailable()) {
            if (info.getType() == 1) {
                netType = 1;
            } else if (info.getType() == 0) {
                switch (info.getSubtype()) {
                    case 1: 
                    case 2: 
                    case 4: 
                    case 7: 
                    case 11: 
                    case 16: {
                        netType = 2;
                        break;
                    }
                    case 3: 
                    case 5: 
                    case 6: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 12: 
                    case 14: 
                    case 15: 
                    case 17: {
                        netType = 3;
                        break;
                    }
                    case 13: 
                    case 18: {
                        netType = 4;
                        break;
                    }
                    default: {
                        String subtypeName = info.getSubtypeName();
                        if ("TD-SCDMA".equalsIgnoreCase(subtypeName) || "WCDMA".equalsIgnoreCase(subtypeName) || "CDMA2000".equalsIgnoreCase(subtypeName)) {
                            netType = 3;
                            break;
                        }
                        netType = 5;
                        break;
                    }
                }
            } else {
                netType = 5;
            }
        }
        return netType;
    }

    public static String getNetworkTypeName(Context context) {
        switch (NetworkUtils.getNetworkType(context)) {
            case 1: {
                return "NETWORK_WIFI";
            }
            case 4: {
                return "NETWORK_4G";
            }
            case 3: {
                return "NETWORK_3G";
            }
            case 2: {
                return "NETWORK_2G";
            }
            case -1: {
                return "NETWORK_NO";
            }
        }
        return "NETWORK_UNKNOWN";
    }

    public static String getIPAddress(boolean useIPv4) {
        try {
            Enumeration<NetworkInterface> nis = NetworkInterface.getNetworkInterfaces();
            while (nis.hasMoreElements()) {
                NetworkInterface ni = nis.nextElement();
                if (!ni.isUp()) continue;
                Enumeration<InetAddress> addresses = ni.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    boolean isIPv4;
                    InetAddress inetAddress = addresses.nextElement();
                    if (inetAddress.isLoopbackAddress()) continue;
                    String hostAddress = inetAddress.getHostAddress();
                    boolean bl = isIPv4 = hostAddress.indexOf(58) < 0;
                    if (useIPv4) {
                        if (!isIPv4) continue;
                        return hostAddress;
                    }
                    if (isIPv4) continue;
                    int index = hostAddress.indexOf(37);
                    return index < 0 ? hostAddress.toUpperCase() : hostAddress.substring(0, index).toUpperCase();
                }
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        return null;
    }
}

