/*
 * Decompiled with CFR 0.152.
 */
package xyz.junerver.utils;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import xyz.junerver.utils.ex.ExtensionsKt;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\u0010\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0001\u001a\n\u0010\u0005\u001a\u00020\u0001*\u00020\u0003\u001a\n\u0010\u0005\u001a\u00020\u0001*\u00020\u0001\u00a8\u0006\u0006"}, d2={"MD5", "", "file", "Ljava/io/File;", "str", "md5", "utils_release"})
public final class MD5UtilKt {
    @NotNull
    public static final String MD5(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        CharSequence charSequence = str;
        boolean bl = false;
        if (charSequence.length() == 0) {
            return "";
        }
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        char[] hexDigits = cArray;
        MessageDigest md5 = null;
        try {
            MessageDigest messageDigest = md5 = MessageDigest.getInstance("MD5");
            Intrinsics.checkNotNull((Object)messageDigest);
            String string = str;
            Object object = "UTF-8";
            boolean bl2 = false;
            Charset charset = Charset.forName((String)object);
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"Charset.forName(charsetName)");
            object = charset;
            bl2 = false;
            byte[] byArray = string.getBytes((Charset)object);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            messageDigest.update(byArray);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        byte[] encodedValue = md5.digest();
        int j = encodedValue.length;
        char[] finalValue = new char[j * 2];
        int k = 0;
        int n = 0;
        if (n < j) {
            do {
                int i = n++;
                byte encoded = encodedValue[i];
                int n2 = k;
                k = n2 + 1;
                finalValue[n2] = hexDigits[encoded >> 4 & 0xF];
                n2 = k;
                k = n2 + 1;
                finalValue[n2] = hexDigits[encoded & 0xF];
            } while (n < j);
        }
        n = 0;
        return new String(finalValue);
    }

    @NotNull
    public static final String md5(@NotNull String $this$md5) {
        Intrinsics.checkNotNullParameter((Object)$this$md5, (String)"<this>");
        return MD5UtilKt.MD5($this$md5);
    }

    @NotNull
    public static final String MD5(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (file.length() > Integer.MIN_VALUE) {
            throw new IllegalArgumentException("too large!");
        }
        MessageDigest digest = MessageDigest.getInstance("MD5");
        digest.update(FilesKt.readBytes((File)file));
        String string = new BigInteger(1, digest.digest()).toString(16);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"BigInteger(1, digest.digest()).toString(16)");
        return ExtensionsKt.padLeft(string, 32, '0');
    }

    @NotNull
    public static final String md5(@NotNull File $this$md5) {
        Intrinsics.checkNotNullParameter((Object)$this$md5, (String)"<this>");
        return MD5UtilKt.MD5($this$md5);
    }
}

