/*
 * Decompiled with CFR 0.152.
 */
package xyz.junerver.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0015\n\u0002\b\u0007\n\u0002\u0010\u0019\n\u0002\b\t\n\u0002\u0010\n\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0011\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001bJ\u0010\u0010\u001c\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001d\u001a\u00020\nJ\u0015\u0010\u001e\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001d\u001a\u00020\n\u00a2\u0006\u0002\u0010\u001fJ\u0010\u0010 \u001a\u0004\u0018\u00010\n2\u0006\u0010\u001d\u001a\u00020\nJ\u000e\u0010!\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\nJ\u000e\u0010\"\u001a\u00020\n2\u0006\u0010#\u001a\u00020\u0004J\u0015\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010\u001d\u001a\u00020\n\u00a2\u0006\u0002\u0010&J\u0010\u0010'\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001d\u001a\u00020\nJ\u0015\u0010(\u001a\u0004\u0018\u00010%2\u0006\u0010\u001d\u001a\u00020\n\u00a2\u0006\u0002\u0010&J\u000e\u0010)\u001a\u00020\u00042\u0006\u0010*\u001a\u00020\u0013J\u0010\u0010+\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001d\u001a\u00020\nJ\u0015\u0010,\u001a\u0004\u0018\u00010%2\u0006\u0010\u001d\u001a\u00020\n\u00a2\u0006\u0002\u0010&J\u0012\u0010-\u001a\u00020.2\b\u0010/\u001a\u0004\u0018\u00010\nH\u0002J\u000e\u00100\u001a\u00020.2\u0006\u0010\u001d\u001a\u00020\nJ \u00101\u001a\u00020.2\u0006\u00102\u001a\u00020\u00042\u0006\u00103\u001a\u00020\u00042\u0006\u00104\u001a\u00020\u0004H\u0002J\u000e\u00105\u001a\u00020.2\u0006\u0010\u001d\u001a\u00020\nJ\u001d\u00106\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\n\u0018\u0001072\u0006\u0010\u001d\u001a\u00020\n\u00a2\u0006\u0002\u00108J\u000e\u00109\u001a\u00020.2\u0006\u0010\u001d\u001a\u00020\nJ\u0010\u0010:\u001a\u00020.2\b\u0010\u001d\u001a\u0004\u0018\u00010\nJ\u000e\u0010;\u001a\u00020.2\u0006\u0010\u001d\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R&\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR&\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00040\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\f\"\u0004\b\u0011\u0010\u000eR\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R&\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00040\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\f\"\u0004\b\u0018\u0010\u000e\u00a8\u0006<"}, d2={"Lxyz/junerver/utils/IDCardUtil;", "", "()V", "CHINA_ID_MAX_LENGTH", "", "CHINA_ID_MIN_LENGTH", "getCHINA_ID_MIN_LENGTH", "()I", "cityCodes", "", "", "getCityCodes", "()Ljava/util/Map;", "setCityCodes", "(Ljava/util/Map;)V", "hkFirstCode", "getHkFirstCode", "setHkFirstCode", "power", "", "getPower", "()[I", "twFirstCode", "getTwFirstCode", "setTwFirstCode", "converCharToInt", "ca", "", "convert15CardTo18", "idCard", "getAgeByIdCard", "(Ljava/lang/String;)Ljava/lang/Integer;", "getBirthByIdCard", "getBirthdayByIdCard", "getCheckCode18", "iSum", "getDateByIdCard", "", "(Ljava/lang/String;)Ljava/lang/Short;", "getGenderByIdCard", "getMonthByIdCard", "getPowerSum", "iArr", "getProvinceByIdCard", "getYearByIdCard", "isNum", "", "val", "validateCard", "validateDateSmllerThenNow", "iYear", "iMonth", "iDate", "validateHKCard", "validateIdCard10", "", "(Ljava/lang/String;)[Ljava/lang/String;", "validateIdCard15", "validateIdCard18", "validateTWCard", "utils_release"})
public final class IDCardUtil {
    @NotNull
    public static final IDCardUtil INSTANCE = new IDCardUtil();
    @NotNull
    private static final int[] power;
    private static final int CHINA_ID_MAX_LENGTH;
    private static final int CHINA_ID_MIN_LENGTH;
    @NotNull
    private static Map<String, String> cityCodes;
    @NotNull
    private static Map<String, Integer> twFirstCode;
    @NotNull
    private static Map<String, Integer> hkFirstCode;

    private IDCardUtil() {
    }

    @NotNull
    public final int[] getPower() {
        return power;
    }

    public final int getCHINA_ID_MIN_LENGTH() {
        return CHINA_ID_MIN_LENGTH;
    }

    @NotNull
    public final Map<String, String> getCityCodes() {
        return cityCodes;
    }

    public final void setCityCodes(@NotNull Map<String, String> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        cityCodes = map;
    }

    @NotNull
    public final Map<String, Integer> getTwFirstCode() {
        return twFirstCode;
    }

    public final void setTwFirstCode(@NotNull Map<String, Integer> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        twFirstCode = map;
    }

    @NotNull
    public final Map<String, Integer> getHkFirstCode() {
        return hkFirstCode;
    }

    public final void setHkFirstCode(@NotNull Map<String, Integer> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        hkFirstCode = map;
    }

    public final int getPowerSum(@NotNull int[] iArr) {
        int n;
        int n2;
        Intrinsics.checkNotNullParameter((Object)iArr, (String)"iArr");
        int iSum = 0;
        if (power.length == iArr.length && (n2 = 0) <= (n = iArr.length + -1)) {
            do {
                int i = n2++;
                int n3 = 0;
                int n4 = power.length + -1;
                if (n3 > n4) continue;
                do {
                    int j;
                    if (i != (j = n3++)) continue;
                    iSum += iArr[i] * power[j];
                } while (n3 <= n4);
            } while (n2 <= n);
        }
        return iSum;
    }

    @NotNull
    public final String getCheckCode18(int iSum) {
        String sCode = "";
        int n = iSum % 11;
        switch (n) {
            case 10: {
                sCode = "2";
                break;
            }
            case 9: {
                sCode = "3";
                break;
            }
            case 8: {
                sCode = "4";
                break;
            }
            case 7: {
                sCode = "5";
                break;
            }
            case 6: {
                sCode = "6";
                break;
            }
            case 5: {
                sCode = "7";
                break;
            }
            case 4: {
                sCode = "8";
                break;
            }
            case 3: {
                sCode = "9";
                break;
            }
            case 2: {
                sCode = "x";
                break;
            }
            case 1: {
                sCode = "0";
                break;
            }
            case 0: {
                sCode = "1";
            }
        }
        return sCode;
    }

    @NotNull
    public final int[] converCharToInt(@NotNull char[] ca) {
        Intrinsics.checkNotNullParameter((Object)ca, (String)"ca");
        int len = ca.length;
        int[] iArr = new int[len];
        try {
            int n = 0;
            if (n < len) {
                do {
                    int i = n++;
                    iArr[i] = Integer.parseInt(String.valueOf(ca[i]));
                } while (n < len);
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        return iArr;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isNum(String val) {
        if (val == null) return false;
        if (Intrinsics.areEqual((Object)"", (Object)val)) return false;
        CharSequence charSequence = val;
        String string = "^[0-9]*$";
        boolean bl = false;
        string = new Regex(string);
        bl = false;
        if (!string.matches(charSequence)) return false;
        return true;
    }

    public final boolean validateIdCard18(@Nullable String idCard) {
        boolean bTrue = false;
        if (idCard == null) {
            return false;
        }
        if (idCard.length() == CHINA_ID_MAX_LENGTH) {
            String string = idCard;
            int n = 0;
            int n2 = 17;
            int n3 = 0;
            String string2 = string.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String code17 = string2;
            String string3 = idCard;
            n2 = 17;
            n3 = CHINA_ID_MAX_LENGTH;
            boolean bl = false;
            String string4 = string3.substring(n2, n3);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String code18 = string4;
            if (this.isNum(code17)) {
                int[] iCard;
                int iSum17;
                String val;
                String string5 = code17;
                n3 = 0;
                String string6 = string5;
                if (string6 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                char[] cArray = string6.toCharArray();
                Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
                char[] cArr = cArray;
                if (cArr != null && (val = this.getCheckCode18(iSum17 = this.getPowerSum(iCard = this.converCharToInt(cArr)))).length() > 0 && StringsKt.equals((String)val, (String)code18, (boolean)true)) {
                    bTrue = true;
                }
            }
        }
        return bTrue;
    }

    public final boolean validateIdCard15(@NotNull String idCard) {
        Intrinsics.checkNotNullParameter((Object)idCard, (String)"idCard");
        if (idCard.length() != CHINA_ID_MIN_LENGTH) {
            return false;
        }
        if (this.isNum(idCard)) {
            int n;
            String string = idCard;
            int n2 = 0;
            int n3 = 2;
            int n4 = 0;
            String string2 = string.substring(n2, n3);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String proCode = string2;
            if (cityCodes.get(proCode) == null) {
                return false;
            }
            String string3 = idCard;
            n3 = 6;
            n4 = 12;
            int n5 = 0;
            String string4 = string3.substring(n3, n4);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String birthCode = string4;
            Date birthDate = null;
            try {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yy");
                String string5 = birthCode;
                n4 = 0;
                n5 = 2;
                n = 0;
                String string6 = string5;
                if (string6 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string7 = string6.substring(n4, n5);
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                birthDate = simpleDateFormat.parse(string7);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            Calendar cal = Calendar.getInstance();
            if (birthDate != null) {
                cal.setTime(birthDate);
            }
            int n6 = cal.get(1);
            String string8 = birthCode;
            n = 2;
            int n7 = 4;
            boolean bl = false;
            String string9 = string8;
            if (string9 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string10 = string9.substring(n, n7);
            Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            Integer n8 = Integer.valueOf(string10);
            Intrinsics.checkNotNullExpressionValue((Object)n8, (String)"valueOf(birthCode.substring(2, 4))");
            int n9 = ((Number)n8).intValue();
            string8 = birthCode;
            n = 4;
            n7 = 6;
            bl = false;
            String string11 = string8;
            if (string11 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string12 = string11.substring(n, n7);
            Intrinsics.checkNotNullExpressionValue((Object)string12, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            n8 = Integer.valueOf(string12);
            Intrinsics.checkNotNullExpressionValue((Object)n8, (String)"valueOf(birthCode.substring(4, 6))");
            return this.validateDateSmllerThenNow(n6, n9, ((Number)n8).intValue());
        }
        return false;
    }

    private final boolean validateDateSmllerThenNow(int iYear, int iMonth, int iDate) {
        Calendar cal = Calendar.getInstance();
        int year = cal.get(1);
        int datePerMonth = 0;
        int MIN = 1930;
        if (iYear < MIN || iYear >= year) {
            return false;
        }
        if (iMonth < 1 || iMonth > 12) {
            return false;
        }
        int n = iMonth;
        switch (n) {
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                datePerMonth = 30;
                break;
            }
            case 2: {
                boolean dm = (iYear % 4 == 0 && iYear % 100 != 0 || iYear % 400 == 0) && iYear > MIN && iYear < year;
                datePerMonth = dm ? 29 : 28;
                break;
            }
            default: {
                datePerMonth = 31;
            }
        }
        return iDate >= 1 && iDate <= datePerMonth;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final String convert15CardTo18(@NotNull String idCard) {
        Intrinsics.checkNotNullParameter((Object)idCard, (String)"idCard");
        String idCard18 = "";
        if (idCard.length() != CHINA_ID_MIN_LENGTH) {
            return null;
        }
        if (!this.isNum(idCard)) return null;
        String string = idCard;
        int n = 6;
        int n2 = 12;
        boolean bl = false;
        String string2 = string.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String birthday = string2;
        Date birthDate = null;
        try {
            birthDate = new SimpleDateFormat("yyMMdd").parse(birthday);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        Calendar cal = Calendar.getInstance();
        if (birthDate != null) {
            cal.setTime(birthDate);
        }
        String sYear = String.valueOf(cal.get(1));
        StringBuilder stringBuilder = new StringBuilder();
        String string3 = idCard;
        int n3 = 0;
        int n4 = 6;
        boolean bl2 = false;
        String string4 = string3.substring(n3, n4);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        StringBuilder stringBuilder2 = stringBuilder.append(string4).append(sYear);
        string3 = idCard;
        n3 = 8;
        n4 = 0;
        String string5 = string3.substring(n3);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
        String string6 = idCard18 = stringBuilder2.append(string5).toString();
        n4 = 0;
        String string7 = string6;
        if (string7 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        char[] cArray = string7.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
        char[] cArr = cArray;
        if (cArr == null) return idCard18;
        int[] iCard = this.converCharToInt(cArr);
        int iSum17 = this.getPowerSum(iCard);
        String sVal = this.getCheckCode18(iSum17);
        if (sVal.length() <= 0) return null;
        return Intrinsics.stringPlus((String)idCard18, (Object)sVal);
    }

    public final boolean validateTWCard(@NotNull String idCard) {
        Integer iStart;
        Intrinsics.checkNotNullParameter((Object)idCard, (String)"idCard");
        String string = idCard;
        int n = 0;
        int n2 = 1;
        int n3 = 0;
        String string2 = string.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String start = string2;
        String string3 = idCard;
        n2 = 1;
        n3 = 9;
        int n4 = 0;
        String string4 = string3.substring(n2, n3);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String mid = string4;
        String string5 = idCard;
        n3 = 9;
        n4 = 10;
        boolean bl = false;
        String string6 = string5.substring(n3, n4);
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String end = string6;
        Integer n5 = iStart = twFirstCode.get(start);
        Intrinsics.checkNotNull((Object)n5);
        int sum = n5 / 10 + iStart % 10 * 9;
        String string7 = mid;
        boolean bl2 = false;
        String string8 = string7;
        if (string8 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        char[] cArray = string8.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
        char[] chars = cArray;
        int iflag = 8;
        char[] cArray2 = chars;
        int n6 = 0;
        int n7 = cArray2.length;
        while (n6 < n7) {
            int c = cArray2[n6];
            ++n6;
            int n8 = c;
            String string9 = "";
            boolean bl3 = false;
            sum += Integer.valueOf(String.valueOf((char)n8) + string9) * iflag;
            n8 = iflag;
            iflag = n8 + -1;
        }
        Integer n9 = Integer.valueOf(end);
        return n9 != null && (sum % 10 == 0 ? 0 : 10 - sum % 10) == n9;
    }

    public final boolean validateHKCard(@NotNull String idCard) {
        int n;
        int n2;
        Intrinsics.checkNotNullParameter((Object)idCard, (String)"idCard");
        CharSequence charSequence = idCard;
        String string = "[\\(|\\)]";
        boolean bl = false;
        string = new Regex(string);
        String string2 = "";
        int n3 = 0;
        String card = string.replace(charSequence, string2);
        int sum = 0;
        if (card.length() == 9) {
            string = card;
            n2 = 0;
            n3 = 1;
            n = 0;
            String string3 = string;
            if (string3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.substring(n2, n3);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            string = string4;
            n2 = 0;
            String string5 = string;
            if (string5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string6 = string5.toUpperCase();
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.String).toUpperCase()");
            string = string6;
            n2 = 0;
            String string7 = string;
            if (string7 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            char[] cArray = string7.toCharArray();
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
            int n4 = (cArray[0] - 55) * 9;
            string = card;
            n2 = 1;
            n3 = 2;
            n = 0;
            String string8 = string;
            if (string8 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string9 = string8.substring(n2, n3);
            Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            string = string9;
            n2 = 0;
            String string10 = string;
            if (string10 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string11 = string10.toUpperCase();
            Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"(this as java.lang.String).toUpperCase()");
            string = string11;
            n2 = 0;
            String string12 = string;
            if (string12 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            char[] cArray2 = string12.toCharArray();
            Intrinsics.checkNotNullExpressionValue((Object)cArray2, (String)"(this as java.lang.String).toCharArray()");
            sum = n4 + (cArray2[0] - 55) * 8;
            string = card;
            n2 = 1;
            n3 = 9;
            n = 0;
            String string13 = string;
            if (string13 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string14 = string13.substring(n2, n3);
            Intrinsics.checkNotNullExpressionValue((Object)string14, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            card = string14;
        } else {
            string = card;
            n2 = 0;
            n3 = 1;
            n = 0;
            String string15 = string;
            if (string15 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string16 = string15.substring(n2, n3);
            Intrinsics.checkNotNullExpressionValue((Object)string16, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            string = string16;
            n2 = 0;
            String string17 = string;
            if (string17 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string18 = string17.toUpperCase();
            Intrinsics.checkNotNullExpressionValue((Object)string18, (String)"(this as java.lang.String).toUpperCase()");
            string = string18;
            n2 = 0;
            String string19 = string;
            if (string19 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            char[] cArray = string19.toCharArray();
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
            sum = 522 + (cArray[0] - 55) * 8;
        }
        String string20 = card;
        n3 = 1;
        n = 7;
        int n5 = 0;
        String string21 = string20;
        if (string21 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string22 = string21.substring(n3, n);
        Intrinsics.checkNotNullExpressionValue((Object)string22, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String mid = string22;
        String string23 = card;
        n = 7;
        n5 = 8;
        int n6 = 0;
        String string24 = string23;
        if (string24 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string25 = string24.substring(n, n5);
        Intrinsics.checkNotNullExpressionValue((Object)string25, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String end = string25;
        String string26 = mid;
        n5 = 0;
        String string27 = string26;
        if (string27 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        char[] cArray = string27.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
        char[] chars = cArray;
        int iflag = 7;
        Object object = chars;
        n6 = 0;
        int n7 = ((char[])object).length;
        while (n6 < n7) {
            int c = object[n6];
            ++n6;
            int n8 = c;
            String string28 = "";
            boolean bl2 = false;
            sum += Integer.valueOf(String.valueOf((char)n8) + string28) * iflag;
            n8 = iflag;
            iflag = n8 + -1;
        }
        object = end;
        n6 = 0;
        Object object2 = object;
        if (object2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string29 = ((String)object2).toUpperCase();
        Intrinsics.checkNotNullExpressionValue((Object)string29, (String)"(this as java.lang.String).toUpperCase()");
        if (Intrinsics.areEqual((Object)string29, (Object)"A")) {
            sum += 10;
        } else {
            object = Integer.valueOf(end);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"valueOf(end)");
            sum += ((Number)object).intValue();
        }
        return sum % 11 == 0;
    }

    @Nullable
    public final String[] validateIdCard10(@NotNull String idCard) {
        Intrinsics.checkNotNullParameter((Object)idCard, (String)"idCard");
        String[] info = new String[3];
        CharSequence charSequence = idCard;
        String string = "[\\(|\\)]";
        boolean bl = false;
        string = new Regex(string);
        String string2 = "";
        int n = 0;
        String card = string.replace(charSequence, string2);
        if (card.length() != 8 && card.length() != 9 && idCard.length() != 10) {
            return null;
        }
        charSequence = idCard;
        string = "^[a-zA-Z][0-9]{9}$";
        int n2 = 0;
        string = new Regex(string);
        n2 = 0;
        if (string.matches(charSequence)) {
            info[0] = "\u53f0\u6e7e";
            string = idCard;
            n2 = 1;
            n = 2;
            boolean bl2 = false;
            String string3 = string.substring(n2, n);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String char2 = string3;
            if (Intrinsics.areEqual((Object)char2, (Object)"1")) {
                info[1] = "M";
            } else if (Intrinsics.areEqual((Object)char2, (Object)"2")) {
                info[1] = "F";
            } else {
                info[1] = "N";
                info[2] = "false";
                return info;
            }
            info[2] = this.validateTWCard(idCard) ? "true" : "false";
        } else {
            charSequence = idCard;
            string = "^[1|5|7][0-9]{6}\\(?[0-9A-Z]\\)?$";
            n2 = 0;
            string = new Regex(string);
            n2 = 0;
            if (string.matches(charSequence)) {
                info[0] = "\u6fb3\u95e8";
                info[1] = "N";
            } else {
                charSequence = idCard;
                string = "^[A-Z]{1,2}[0-9]{6}\\(?[0-9A]\\)?$";
                n2 = 0;
                string = new Regex(string);
                n2 = 0;
                if (string.matches(charSequence)) {
                    info[0] = "\u9999\u6e2f";
                    info[1] = "N";
                    info[2] = this.validateHKCard(idCard) ? "true" : "false";
                } else {
                    return null;
                }
            }
        }
        return info;
    }

    public final boolean validateCard(@NotNull String idCard) {
        String card;
        Intrinsics.checkNotNullParameter((Object)idCard, (String)"idCard");
        String $this$trim$iv = idCard;
        boolean $i$f$trim = false;
        CharSequence $this$trim$iv$iv = $this$trim$iv;
        boolean $i$f$trim2 = false;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            boolean match$iv$iv;
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            char it = $this$trim$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        if (this.validateIdCard18(card = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString())) {
            return true;
        }
        if (this.validateIdCard15(card)) {
            return true;
        }
        String[] cardval = this.validateIdCard10(card);
        return cardval != null && Intrinsics.areEqual((Object)cardval[2], (Object)"true");
    }

    @Nullable
    public final Integer getAgeByIdCard(@NotNull String idCard) {
        Intrinsics.checkNotNullParameter((Object)idCard, (String)"idCard");
        String idCard2 = idCard;
        int iAge = 0;
        if (idCard2.length() == CHINA_ID_MIN_LENGTH) {
            String string = this.convert15CardTo18(idCard2);
            if (string == null) {
                return null;
            }
            idCard2 = string;
        }
        String string = idCard2;
        int n = 6;
        int n2 = 10;
        boolean bl = false;
        String string2 = string.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String year = string2;
        Calendar cal = Calendar.getInstance();
        int iCurrYear = cal.get(1);
        Integer n3 = Integer.valueOf(year);
        Intrinsics.checkNotNullExpressionValue((Object)n3, (String)"valueOf(year)");
        iAge = iCurrYear - ((Number)n3).intValue();
        return iAge;
    }

    @Nullable
    public final String getBirthByIdCard(@NotNull String idCard) {
        String string;
        Intrinsics.checkNotNullParameter((Object)idCard, (String)"idCard");
        String idCard2 = idCard;
        int len = idCard2.length();
        if (len < CHINA_ID_MIN_LENGTH) {
            return null;
        }
        if (len == CHINA_ID_MIN_LENGTH) {
            string = this.convert15CardTo18(idCard2);
            if (string == null) {
                return null;
            }
            idCard2 = string;
        }
        string = idCard2;
        int n = 6;
        int n2 = 14;
        boolean bl = false;
        String string2 = string.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        return string2;
    }

    @NotNull
    public final String getBirthdayByIdCard(@NotNull String idCard) {
        Intrinsics.checkNotNullParameter((Object)idCard, (String)"idCard");
        String string = this.getBirthByIdCard(idCard);
        Intrinsics.checkNotNull((Object)string);
        CharSequence charSequence = string;
        String string2 = "(\\d{4})(\\d{2})(\\d{2})";
        boolean bl = false;
        string2 = new Regex(string2);
        String string3 = "$1-$2-$3";
        boolean bl2 = false;
        return string2.replace(charSequence, string3);
    }

    @Nullable
    public final Short getYearByIdCard(@NotNull String idCard) {
        String string;
        Intrinsics.checkNotNullParameter((Object)idCard, (String)"idCard");
        String idCard2 = idCard;
        int len = idCard2.length();
        if (len < CHINA_ID_MIN_LENGTH) {
            return null;
        }
        if (len == CHINA_ID_MIN_LENGTH) {
            string = this.convert15CardTo18(idCard2);
            if (string == null) {
                return null;
            }
            idCard2 = string;
        }
        string = idCard2;
        int n = 6;
        int n2 = 10;
        boolean bl = false;
        String string2 = string.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        return Short.valueOf(string2);
    }

    @Nullable
    public final Short getMonthByIdCard(@NotNull String idCard) {
        String string;
        Intrinsics.checkNotNullParameter((Object)idCard, (String)"idCard");
        String idCard2 = idCard;
        int len = idCard2.length();
        if (len < CHINA_ID_MIN_LENGTH) {
            return null;
        }
        if (len == CHINA_ID_MIN_LENGTH) {
            string = this.convert15CardTo18(idCard2);
            if (string == null) {
                return null;
            }
            idCard2 = string;
        }
        string = idCard2;
        int n = 10;
        int n2 = 12;
        boolean bl = false;
        String string2 = string.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        return Short.valueOf(string2);
    }

    @Nullable
    public final Short getDateByIdCard(@NotNull String idCard) {
        String string;
        Intrinsics.checkNotNullParameter((Object)idCard, (String)"idCard");
        String idCard2 = idCard;
        int len = idCard2.length();
        if (len < CHINA_ID_MIN_LENGTH) {
            return null;
        }
        if (len == CHINA_ID_MIN_LENGTH) {
            string = this.convert15CardTo18(idCard2);
            if (string == null) {
                return null;
            }
            idCard2 = string;
        }
        string = idCard2;
        int n = 12;
        int n2 = 14;
        boolean bl = false;
        String string2 = string.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        return Short.valueOf(string2);
    }

    @Nullable
    public final String getGenderByIdCard(@NotNull String idCard) {
        Intrinsics.checkNotNullParameter((Object)idCard, (String)"idCard");
        String idCard2 = idCard;
        String sGender = "\u672a\u77e5";
        if (idCard2.length() == CHINA_ID_MIN_LENGTH) {
            String string = this.convert15CardTo18(idCard2);
            if (string == null) {
                return null;
            }
            idCard2 = string;
        }
        String string = idCard2;
        int n = 16;
        int n2 = 17;
        boolean bl = false;
        String string2 = string.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String sCardNum = string2;
        sGender = Integer.parseInt(sCardNum) % 2 != 0 ? "\u7537" : "\u5973";
        return sGender;
    }

    @Nullable
    public final String getProvinceByIdCard(@NotNull String idCard) {
        Intrinsics.checkNotNullParameter((Object)idCard, (String)"idCard");
        int len = idCard.length();
        String sProvince = null;
        String sProvinNum = "";
        if (len == CHINA_ID_MIN_LENGTH || len == CHINA_ID_MAX_LENGTH) {
            String string = idCard;
            int n = 0;
            int n2 = 2;
            boolean bl = false;
            String string2 = string.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            sProvinNum = string2;
        }
        sProvince = cityCodes.get(sProvinNum);
        return sProvince;
    }

    static {
        Object object = new int[]{7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2};
        power = object;
        CHINA_ID_MAX_LENGTH = 18;
        CHINA_ID_MIN_LENGTH = 15;
        cityCodes = new HashMap();
        twFirstCode = new HashMap();
        hkFirstCode = new HashMap();
        object = cityCodes;
        String string = "11";
        Object object2 = "\u5317\u4eac";
        boolean bl = false;
        object.put(string, object2);
        object = cityCodes;
        string = "12";
        object2 = "\u5929\u6d25";
        bl = false;
        object.put(string, object2);
        object = cityCodes;
        string = "13";
        object2 = "\u6cb3\u5317";
        bl = false;
        object.put(string, object2);
        object = cityCodes;
        string = "14";
        object2 = "\u5c71\u897f";
        bl = false;
        object.put(string, object2);
        object = cityCodes;
        string = "15";
        object2 = "\u5185\u8499\u53e4";
        bl = false;
        object.put(string, object2);
        object = cityCodes;
        string = "21";
        object2 = "\u8fbd\u5b81";
        bl = false;
        object.put(string, object2);
        object = cityCodes;
        string = "22";
        object2 = "\u5409\u6797";
        bl = false;
        object.put(string, object2);
        object = cityCodes;
        string = "23";
        object2 = "\u9ed1\u9f99\u6c5f";
        bl = false;
        object.put(string, object2);
        object = cityCodes;
        string = "31";
        object2 = "\u4e0a\u6d77";
        bl = false;
        object.put(string, object2);
        object = cityCodes;
        string = "32";
        object2 = "\u6c5f\u82cf";
        bl = false;
        object.put(string, object2);
        object = cityCodes;
        string = "33";
        object2 = "\u6d59\u6c5f";
        bl = false;
        object.put(string, object2);
        object = cityCodes;
        string = "34";
        object2 = "\u5b89\u5fbd";
        bl = false;
        object.put(string, object2);
        object = cityCodes;
        string = "35";
        object2 = "\u798f\u5efa";
        bl = false;
        object.put(string, object2);
        object = cityCodes;
        string = "36";
        object2 = "\u6c5f\u897f";
        bl = false;
        object.put(string, object2);
        object = cityCodes;
        string = "37";
        object2 = "\u5c71\u4e1c";
        bl = false;
        object.put(string, object2);
        object = cityCodes;
        string = "41";
        object2 = "\u6cb3\u5357";
        bl = false;
        object.put(string, object2);
        object = cityCodes;
        string = "42";
        object2 = "\u6e56\u5317";
        bl = false;
        object.put(string, object2);
        object = cityCodes;
        string = "43";
        object2 = "\u6e56\u5357";
        bl = false;
        object.put(string, object2);
        object = cityCodes;
        string = "44";
        object2 = "\u5e7f\u4e1c";
        bl = false;
        object.put(string, object2);
        object = cityCodes;
        string = "45";
        object2 = "\u5e7f\u897f";
        bl = false;
        object.put(string, object2);
        object = cityCodes;
        string = "46";
        object2 = "\u6d77\u5357";
        bl = false;
        object.put(string, object2);
        object = cityCodes;
        string = "50";
        object2 = "\u91cd\u5e86";
        bl = false;
        object.put(string, object2);
        object = cityCodes;
        string = "51";
        object2 = "\u56db\u5ddd";
        bl = false;
        object.put(string, object2);
        object = cityCodes;
        string = "52";
        object2 = "\u8d35\u5dde";
        bl = false;
        object.put(string, object2);
        object = cityCodes;
        string = "53";
        object2 = "\u4e91\u5357";
        bl = false;
        object.put(string, object2);
        object = cityCodes;
        string = "54";
        object2 = "\u897f\u85cf";
        bl = false;
        object.put(string, object2);
        object = cityCodes;
        string = "61";
        object2 = "\u9655\u897f";
        bl = false;
        object.put(string, object2);
        object = cityCodes;
        string = "62";
        object2 = "\u7518\u8083";
        bl = false;
        object.put(string, object2);
        object = cityCodes;
        string = "63";
        object2 = "\u9752\u6d77";
        bl = false;
        object.put(string, object2);
        object = cityCodes;
        string = "64";
        object2 = "\u5b81\u590f";
        bl = false;
        object.put(string, object2);
        object = cityCodes;
        string = "65";
        object2 = "\u65b0\u7586";
        bl = false;
        object.put(string, object2);
        object = cityCodes;
        string = "71";
        object2 = "\u53f0\u6e7e";
        bl = false;
        object.put(string, object2);
        object = cityCodes;
        string = "81";
        object2 = "\u9999\u6e2f";
        bl = false;
        object.put(string, object2);
        object = cityCodes;
        string = "82";
        object2 = "\u6fb3\u95e8";
        bl = false;
        object.put(string, object2);
        object = cityCodes;
        string = "91";
        object2 = "\u56fd\u5916";
        bl = false;
        object.put(string, object2);
        object = twFirstCode;
        string = "A";
        object2 = 10;
        bl = false;
        object.put(string, object2);
        object = twFirstCode;
        string = "B";
        object2 = 11;
        bl = false;
        object.put(string, object2);
        object = twFirstCode;
        string = "C";
        object2 = 12;
        bl = false;
        object.put(string, object2);
        object = twFirstCode;
        string = "D";
        object2 = 13;
        bl = false;
        object.put(string, object2);
        object = twFirstCode;
        string = "E";
        object2 = 14;
        bl = false;
        object.put(string, object2);
        object = twFirstCode;
        string = "F";
        object2 = 15;
        bl = false;
        object.put(string, object2);
        object = twFirstCode;
        string = "G";
        object2 = 16;
        bl = false;
        object.put(string, object2);
        object = twFirstCode;
        string = "H";
        object2 = 17;
        bl = false;
        object.put(string, object2);
        object = twFirstCode;
        string = "J";
        object2 = 18;
        bl = false;
        object.put(string, object2);
        object = twFirstCode;
        string = "K";
        object2 = 19;
        bl = false;
        object.put(string, object2);
        object = twFirstCode;
        string = "L";
        object2 = 20;
        bl = false;
        object.put(string, object2);
        object = twFirstCode;
        string = "M";
        object2 = 21;
        bl = false;
        object.put(string, object2);
        object = twFirstCode;
        string = "N";
        object2 = 22;
        bl = false;
        object.put(string, object2);
        object = twFirstCode;
        string = "P";
        object2 = 23;
        bl = false;
        object.put(string, object2);
        object = twFirstCode;
        string = "Q";
        object2 = 24;
        bl = false;
        object.put(string, object2);
        object = twFirstCode;
        string = "R";
        object2 = 25;
        bl = false;
        object.put(string, object2);
        object = twFirstCode;
        string = "S";
        object2 = 26;
        bl = false;
        object.put(string, object2);
        object = twFirstCode;
        string = "T";
        object2 = 27;
        bl = false;
        object.put(string, object2);
        object = twFirstCode;
        string = "U";
        object2 = 28;
        bl = false;
        object.put(string, object2);
        object = twFirstCode;
        string = "V";
        object2 = 29;
        bl = false;
        object.put(string, object2);
        object = twFirstCode;
        string = "X";
        object2 = 30;
        bl = false;
        object.put(string, object2);
        object = twFirstCode;
        string = "Y";
        object2 = 31;
        bl = false;
        object.put(string, object2);
        object = twFirstCode;
        string = "W";
        object2 = 32;
        bl = false;
        object.put(string, object2);
        object = twFirstCode;
        string = "Z";
        object2 = 33;
        bl = false;
        object.put(string, object2);
        object = twFirstCode;
        string = "I";
        object2 = 34;
        bl = false;
        object.put(string, object2);
        object = twFirstCode;
        string = "O";
        object2 = 35;
        bl = false;
        object.put(string, object2);
        object = hkFirstCode;
        string = "A";
        object2 = 1;
        bl = false;
        object.put(string, object2);
        object = hkFirstCode;
        string = "B";
        object2 = 2;
        bl = false;
        object.put(string, object2);
        object = hkFirstCode;
        string = "C";
        object2 = 3;
        bl = false;
        object.put(string, object2);
        object = hkFirstCode;
        string = "R";
        object2 = 18;
        bl = false;
        object.put(string, object2);
        object = hkFirstCode;
        string = "U";
        object2 = 21;
        bl = false;
        object.put(string, object2);
        object = hkFirstCode;
        string = "Z";
        object2 = 26;
        bl = false;
        object.put(string, object2);
        object = hkFirstCode;
        string = "X";
        object2 = 24;
        bl = false;
        object.put(string, object2);
        object = hkFirstCode;
        string = "W";
        object2 = 23;
        bl = false;
        object.put(string, object2);
        object = hkFirstCode;
        string = "O";
        object2 = 15;
        bl = false;
        object.put(string, object2);
        object = hkFirstCode;
        string = "N";
        object2 = 14;
        bl = false;
        object.put(string, object2);
    }
}

