/*
 * Decompiled with CFR 0.152.
 */
package xyz.junerver.utils;

import android.content.ContentResolver;
import android.content.Intent;
import android.content.res.AssetFileDescriptor;
import android.net.Uri;
import android.os.Build;
import android.os.StatFs;
import android.text.TextUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.net.ssl.HttpsURLConnection;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.junerver.utils.ConvertUtils;
import xyz.junerver.utils.Utils;
import xyz.junerver.utils.UtilsBridge;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0019\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0010\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001QB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\t2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\fJ\u001a\u0010\u0006\u001a\u00020\u00072\b\u0010\r\u001a\u0004\u0018\u00010\u00042\b\u0010\u000e\u001a\u0004\u0018\u00010\u0004J$\u0010\u0006\u001a\u00020\u00072\b\u0010\r\u001a\u0004\u0018\u00010\u00042\b\u0010\u000e\u001a\u0004\u0018\u00010\u00042\b\u0010\u000b\u001a\u0004\u0018\u00010\fJ$\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\t2\b\u0010\u0011\u001a\u0004\u0018\u00010\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J$\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\t2\b\u0010\u0014\u001a\u0004\u0018\u00010\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J.\u0010\u0015\u001a\u00020\u00072\b\u0010\u0010\u001a\u0004\u0018\u00010\t2\b\u0010\u0011\u001a\u0004\u0018\u00010\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0016\u001a\u00020\u0007H\u0002J.\u0010\u0017\u001a\u00020\u00072\b\u0010\u0013\u001a\u0004\u0018\u00010\t2\b\u0010\u0014\u001a\u0004\u0018\u00010\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0016\u001a\u00020\u0007H\u0002J\u0012\u0010\u0018\u001a\u00020\u00072\b\u0010\u0019\u001a\u0004\u0018\u00010\tH\u0007J\u0010\u0010\u0018\u001a\u00020\u00072\b\u0010\u001a\u001a\u0004\u0018\u00010\u0004J\u0012\u0010\u001b\u001a\u00020\u00072\b\u0010\u0019\u001a\u0004\u0018\u00010\tH\u0007J\u0010\u0010\u001b\u001a\u00020\u00072\b\u0010\u001c\u001a\u0004\u0018\u00010\u0004J\u0012\u0010\u001d\u001a\u00020\u00072\b\u0010\u0019\u001a\u0004\u0018\u00010\tH\u0007J\u0010\u0010\u001d\u001a\u00020\u00072\b\u0010\u001a\u001a\u0004\u0018\u00010\u0004J\u0010\u0010\u001e\u001a\u00020\u00072\b\u0010\u0019\u001a\u0004\u0018\u00010\tJ\u0010\u0010\u001e\u001a\u00020\u00072\b\u0010\u001a\u001a\u0004\u0018\u00010\u0004J\u0012\u0010\u001f\u001a\u00020\u00072\b\u0010 \u001a\u0004\u0018\u00010\tH\u0007J\u0010\u0010\u001f\u001a\u00020\u00072\b\u0010\u001c\u001a\u0004\u0018\u00010\u0004J\u0012\u0010!\u001a\u00020\u00072\b\u0010 \u001a\u0004\u0018\u00010\tH\u0002J\u0012\u0010\"\u001a\u00020\u00072\b\u0010\u0019\u001a\u0004\u0018\u00010\tH\u0002J\u0010\u0010#\u001a\u00020\u00072\b\u0010 \u001a\u0004\u0018\u00010\tJ\u0010\u0010#\u001a\u00020\u00072\b\u0010\u001c\u001a\u0004\u0018\u00010\u0004J\u001a\u0010$\u001a\u00020\u00072\b\u0010 \u001a\u0004\u0018\u00010\t2\b\u0010%\u001a\u0004\u0018\u00010&J\u001a\u0010$\u001a\u00020\u00072\b\u0010\u001c\u001a\u0004\u0018\u00010\u00042\b\u0010%\u001a\u0004\u0018\u00010&J\u0010\u0010'\u001a\u00020(2\u0006\u0010 \u001a\u00020\tH\u0002J\u0010\u0010)\u001a\u00020\u00042\b\u0010\u0019\u001a\u0004\u0018\u00010\tJ\u000e\u0010)\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0004J\u0010\u0010*\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\tH\u0002J\u0014\u0010+\u001a\u0004\u0018\u00010\t2\b\u0010\u001a\u001a\u0004\u0018\u00010\u0004H\u0007J\u0010\u0010,\u001a\u00020\u00042\b\u0010\u0019\u001a\u0004\u0018\u00010\tJ\u0010\u0010,\u001a\u00020\u00042\b\u0010\u001a\u001a\u0004\u0018\u00010\u0004J\u0010\u0010-\u001a\u00020\u00042\b\u0010\u0019\u001a\u0004\u0018\u00010\tJ\u000e\u0010-\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0004J\u0010\u0010.\u001a\u00020(2\b\u0010\u0019\u001a\u0004\u0018\u00010\tJ\u0010\u0010.\u001a\u00020(2\b\u0010\u001a\u001a\u0004\u0018\u00010\u0004J\u0012\u0010/\u001a\u00020(2\b\u0010\u0019\u001a\u0004\u0018\u00010\tH\u0002J\u000e\u0010/\u001a\u00020(2\u0006\u0010\u001a\u001a\u00020\u0004J\u0010\u00100\u001a\u0002012\b\u0010\u0019\u001a\u0004\u0018\u00010\tJ\u0010\u00100\u001a\u0002012\b\u0010\u001a\u001a\u0004\u0018\u00010\u0004J\u0012\u00102\u001a\u0004\u0018\u0001032\b\u0010\u0019\u001a\u0004\u0018\u00010\tJ\u0012\u00102\u001a\u0004\u0018\u0001032\b\u0010\u001a\u001a\u0004\u0018\u00010\u0004J\u0010\u00104\u001a\u00020\u00042\b\u0010\u0019\u001a\u0004\u0018\u00010\tJ\u0010\u00104\u001a\u00020\u00042\b\u0010\u001a\u001a\u0004\u0018\u00010\u0004J\u0010\u00105\u001a\u00020\u00042\b\u0010\u0019\u001a\u0004\u0018\u00010\tJ\u000e\u00105\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0004J\u0010\u00106\u001a\u00020\u00042\b\u0010\u0019\u001a\u0004\u0018\u00010\tJ\u000e\u00106\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0004J\u0010\u00107\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\tH\u0002J\u0012\u00108\u001a\u00020(2\b\u00109\u001a\u0004\u0018\u00010\u0004H\u0007J\u0012\u0010:\u001a\u00020(2\b\u00109\u001a\u0004\u0018\u00010\u0004H\u0007J\u0010\u0010;\u001a\u00020(2\b\u0010\u0019\u001a\u0004\u0018\u00010\tJ\u0010\u0010;\u001a\u00020(2\b\u0010\u001a\u001a\u0004\u0018\u00010\u0004J\u0010\u0010<\u001a\u00020\u00042\b\u0010\u0019\u001a\u0004\u0018\u00010\tJ\u0010\u0010<\u001a\u00020\u00042\b\u0010\u001a\u001a\u0004\u0018\u00010\u0004J\u0010\u0010=\u001a\u00020\u00072\b\u0010\u0019\u001a\u0004\u0018\u00010\tJ\u0010\u0010=\u001a\u00020\u00072\b\u0010\u001c\u001a\u0004\u0018\u00010\u0004J\u0010\u0010>\u001a\u00020\u00072\b\u0010\u0019\u001a\u0004\u0018\u00010\tJ\u0010\u0010>\u001a\u00020\u00072\b\u0010\u001a\u001a\u0004\u0018\u00010\u0004J\u0012\u0010?\u001a\u00020\u00072\b\u0010\u0019\u001a\u0004\u0018\u00010\tH\u0007J\u0010\u0010?\u001a\u00020\u00072\b\u0010\u001a\u001a\u0004\u0018\u00010\u0004J\u0012\u0010@\u001a\u00020\u00072\b\u0010\u001a\u001a\u0004\u0018\u00010\u0004H\u0002J\u0010\u0010A\u001a\u00020\u00072\b\u0010\u0019\u001a\u0004\u0018\u00010\tJ\u0010\u0010A\u001a\u0002012\u0006\u0010B\u001a\u000203H\u0002J\u0010\u0010A\u001a\u00020\u00072\b\u0010\u001a\u001a\u0004\u0018\u00010\u0004J,\u0010C\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0D2\b\u0010 \u001a\u0004\u0018\u00010\t2\u0012\b\u0002\u0010E\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\t\u0018\u00010FJ4\u0010C\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0D2\b\u0010 \u001a\u0004\u0018\u00010\t2\u0006\u0010G\u001a\u00020\u00072\u0012\b\u0002\u0010E\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\t\u0018\u00010FJ,\u0010C\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0D2\b\u0010\u001c\u001a\u0004\u0018\u00010\u00042\u0012\b\u0002\u0010E\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\t\u0018\u00010FJ \u0010C\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0D2\b\u0010\u001c\u001a\u0004\u0018\u00010\u00042\u0006\u0010G\u001a\u00020\u0007J2\u0010C\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0D2\b\u0010\u001c\u001a\u0004\u0018\u00010\u00042\u0006\u0010G\u001a\u00020\u00072\u0010\u0010E\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\t\u0018\u00010FJ2\u0010H\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0D2\b\u0010 \u001a\u0004\u0018\u00010\t2\u0006\u0010%\u001a\u00020&2\u0010\u0010E\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\t\u0018\u00010FJ>\u0010H\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0D2\b\u0010 \u001a\u0004\u0018\u00010\t2\u0006\u0010%\u001a\u00020&2\b\b\u0002\u0010G\u001a\u00020\u00072\u0012\b\u0002\u0010E\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\t\u0018\u00010FJ \u0010H\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0D2\b\u0010\u001c\u001a\u0004\u0018\u00010\u00042\u0006\u0010%\u001a\u00020&J2\u0010H\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0D2\b\u0010\u001c\u001a\u0004\u0018\u00010\u00042\u0006\u0010%\u001a\u00020&2\u0010\u0010E\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\t\u0018\u00010FJ(\u0010H\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0D2\b\u0010\u001c\u001a\u0004\u0018\u00010\u00042\u0006\u0010%\u001a\u00020&2\u0006\u0010G\u001a\u00020\u0007J:\u0010H\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0D2\b\u0010\u001c\u001a\u0004\u0018\u00010\u00042\u0006\u0010%\u001a\u00020&2\u0006\u0010G\u001a\u00020\u00072\u0010\u0010E\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\t\u0018\u00010FJ*\u0010I\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0D2\b\u0010 \u001a\u0004\u0018\u00010\t2\u0006\u0010%\u001a\u00020&2\u0006\u0010G\u001a\u00020\u0007H\u0002J&\u0010J\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\t2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\fJ\u001a\u0010J\u001a\u00020\u00072\b\u0010\r\u001a\u0004\u0018\u00010\u00042\b\u0010\u000e\u001a\u0004\u0018\u00010\u0004J$\u0010J\u001a\u00020\u00072\b\u0010\r\u001a\u0004\u0018\u00010\u00042\b\u0010\u000e\u001a\u0004\u0018\u00010\u00042\b\u0010\u000b\u001a\u0004\u0018\u00010\fJ$\u0010K\u001a\u00020\u00072\b\u0010\u0010\u001a\u0004\u0018\u00010\t2\b\u0010\u0011\u001a\u0004\u0018\u00010\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\fJ$\u0010L\u001a\u00020\u00072\b\u0010\u0013\u001a\u0004\u0018\u00010\t2\b\u0010\u0014\u001a\u0004\u0018\u00010\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\fJ\u0012\u0010M\u001a\u00020N2\b\u0010\u0019\u001a\u0004\u0018\u00010\tH\u0007J\u0010\u0010M\u001a\u00020N2\b\u0010\u001a\u001a\u0004\u0018\u00010\u0004J\u0018\u0010O\u001a\u00020\u00072\b\u0010\u0019\u001a\u0004\u0018\u00010\t2\u0006\u0010P\u001a\u00020\u0004J\u0018\u0010O\u001a\u00020\u00072\b\u0010\u001a\u001a\u0004\u0018\u00010\u00042\u0006\u0010P\u001a\u00020\u0004R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006R"}, d2={"Lxyz/junerver/utils/FileUtils;", "", "()V", "LINE_SEP", "", "kotlin.jvm.PlatformType", "copy", "", "src", "Ljava/io/File;", "dest", "listener", "Lxyz/junerver/utils/FileUtils$OnReplaceListener;", "srcPath", "destPath", "copyDir", "srcDir", "destDir", "copyFile", "srcFile", "destFile", "copyOrMoveDir", "isMove", "copyOrMoveFile", "createFileByDeleteOldFile", "file", "filePath", "createOrExistsDir", "dirPath", "createOrExistsFile", "delete", "deleteAllInDir", "dir", "deleteDir", "deleteFile", "deleteFilesInDir", "deleteFilesInDirWithFilter", "filter", "Ljava/io/FileFilter;", "getDirLength", "", "getDirName", "getDirSize", "getFileByPath", "getFileCharsetSimple", "getFileExtension", "getFileLastModified", "getFileLength", "getFileLines", "", "getFileMD5", "", "getFileMD5ToString", "getFileName", "getFileNameNoExtension", "getFileSize", "getFsAvailableSize", "anyPathInFs", "getFsTotalSize", "getLength", "getSize", "isDir", "isFile", "isFileExists", "isFileExistsApi29", "isUtf8", "raw", "listFilesInDir", "", "comparator", "Ljava/util/Comparator;", "isRecursive", "listFilesInDirWithFilter", "listFilesInDirWithFilterInner", "move", "moveDir", "moveFile", "notifySystemToScan", "", "rename", "newName", "OnReplaceListener", "utils_release"})
public final class FileUtils {
    @NotNull
    public static final FileUtils INSTANCE = new FileUtils();
    private static final String LINE_SEP = System.getProperty("line.separator");

    private FileUtils() {
    }

    @JvmStatic
    @Nullable
    public static final File getFileByPath(@Nullable String filePath) {
        return UtilsBridge.isSpace(filePath) ? null : new File(filePath);
    }

    @JvmStatic
    public static final boolean isFileExists(@Nullable File file) {
        if (file == null) {
            return false;
        }
        return file.exists() ? true : INSTANCE.isFileExists(file.getAbsolutePath());
    }

    public final boolean isFileExists(@Nullable String filePath) {
        File file = FileUtils.getFileByPath(filePath);
        if (file == null) {
            return false;
        }
        File file2 = file;
        return file2.exists() ? true : this.isFileExistsApi29(filePath);
    }

    private final boolean isFileExistsApi29(String filePath) {
        if (Build.VERSION.SDK_INT >= 29) {
            try {
                AssetFileDescriptor assetFileDescriptor;
                Uri uri = Uri.parse((String)filePath);
                ContentResolver cr = Utils.getApp().getContentResolver();
                AssetFileDescriptor assetFileDescriptor2 = cr.openAssetFileDescriptor(uri, "r");
                if (assetFileDescriptor2 == null) {
                    return false;
                }
                AssetFileDescriptor afd = assetFileDescriptor = assetFileDescriptor2;
                try {
                    afd.close();
                }
                catch (IOException iOException) {}
            }
            catch (FileNotFoundException e) {
                return false;
            }
            return true;
        }
        return false;
    }

    public final boolean rename(@Nullable String filePath, @NotNull String newName) {
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        return this.rename(FileUtils.getFileByPath(filePath), newName);
    }

    public final boolean rename(@Nullable File file, @NotNull String newName) {
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        if (file == null || !file.exists()) {
            return false;
        }
        if (UtilsBridge.isSpace(newName)) {
            return false;
        }
        if (Intrinsics.areEqual((Object)newName, (Object)file.getName())) {
            return true;
        }
        File newFile = new File(file.getParent() + File.separator + newName);
        return !newFile.exists() && file.renameTo(newFile);
    }

    public final boolean isDir(@Nullable String dirPath) {
        return this.isDir(FileUtils.getFileByPath(dirPath));
    }

    public final boolean isDir(@Nullable File file) {
        return file != null && file.exists() && file.isDirectory();
    }

    public final boolean isFile(@Nullable String filePath) {
        return this.isFile(FileUtils.getFileByPath(filePath));
    }

    public final boolean isFile(@Nullable File file) {
        return file != null && file.exists() && file.isFile();
    }

    public final boolean createOrExistsDir(@Nullable String dirPath) {
        return FileUtils.createOrExistsDir(FileUtils.getFileByPath(dirPath));
    }

    @JvmStatic
    public static final boolean createOrExistsDir(@Nullable File file) {
        return file != null && (file.exists() ? file.isDirectory() : file.mkdirs());
    }

    public final boolean createOrExistsFile(@Nullable String filePath) {
        return FileUtils.createOrExistsFile(FileUtils.getFileByPath(filePath));
    }

    @JvmStatic
    public static final boolean createOrExistsFile(@Nullable File file) {
        boolean bl;
        if (file == null) {
            return false;
        }
        if (file.exists()) {
            return file.isFile();
        }
        if (!FileUtils.createOrExistsDir(file.getParentFile())) {
            bl = false;
        } else {
            boolean bl2;
            try {
                bl2 = file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
                bl2 = false;
            }
            bl = bl2;
        }
        return bl;
    }

    public final boolean createFileByDeleteOldFile(@Nullable String filePath) {
        return FileUtils.createFileByDeleteOldFile(FileUtils.getFileByPath(filePath));
    }

    @JvmStatic
    public static final boolean createFileByDeleteOldFile(@Nullable File file) {
        boolean bl;
        if (file == null) {
            return false;
        }
        if (file.exists() && !file.delete()) {
            return false;
        }
        if (!FileUtils.createOrExistsDir(file.getParentFile())) {
            bl = false;
        } else {
            boolean bl2;
            try {
                bl2 = file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
                bl2 = false;
            }
            bl = bl2;
        }
        return bl;
    }

    public final boolean copy(@Nullable String srcPath, @Nullable String destPath) {
        return this.copy(FileUtils.getFileByPath(srcPath), FileUtils.getFileByPath(destPath), null);
    }

    public final boolean copy(@Nullable String srcPath, @Nullable String destPath, @Nullable OnReplaceListener listener2) {
        return this.copy(FileUtils.getFileByPath(srcPath), FileUtils.getFileByPath(destPath), listener2);
    }

    public final boolean copy(@Nullable File src, @Nullable File dest, @Nullable OnReplaceListener listener2) {
        if (src == null) {
            return false;
        }
        return src.isDirectory() ? this.copyDir(src, dest, listener2) : this.copyFile(src, dest, listener2);
    }

    public static /* synthetic */ boolean copy$default(FileUtils fileUtils, File file, File file2, OnReplaceListener onReplaceListener, int n, Object object) {
        if ((n & 4) != 0) {
            onReplaceListener = null;
        }
        return fileUtils.copy(file, file2, onReplaceListener);
    }

    private final boolean copyDir(File srcDir, File destDir, OnReplaceListener listener2) {
        return this.copyOrMoveDir(srcDir, destDir, listener2, false);
    }

    private final boolean copyFile(File srcFile, File destFile, OnReplaceListener listener2) {
        return this.copyOrMoveFile(srcFile, destFile, listener2, false);
    }

    public final boolean move(@Nullable String srcPath, @Nullable String destPath) {
        return this.move(FileUtils.getFileByPath(srcPath), FileUtils.getFileByPath(destPath), null);
    }

    public final boolean move(@Nullable String srcPath, @Nullable String destPath, @Nullable OnReplaceListener listener2) {
        return this.move(FileUtils.getFileByPath(srcPath), FileUtils.getFileByPath(destPath), listener2);
    }

    public final boolean move(@Nullable File src, @Nullable File dest, @Nullable OnReplaceListener listener2) {
        if (src == null) {
            return false;
        }
        return src.isDirectory() ? this.moveDir(src, dest, listener2) : this.moveFile(src, dest, listener2);
    }

    public static /* synthetic */ boolean move$default(FileUtils fileUtils, File file, File file2, OnReplaceListener onReplaceListener, int n, Object object) {
        if ((n & 4) != 0) {
            onReplaceListener = null;
        }
        return fileUtils.move(file, file2, onReplaceListener);
    }

    public final boolean moveDir(@Nullable File srcDir, @Nullable File destDir, @Nullable OnReplaceListener listener2) {
        return this.copyOrMoveDir(srcDir, destDir, listener2, true);
    }

    public final boolean moveFile(@Nullable File srcFile, @Nullable File destFile, @Nullable OnReplaceListener listener2) {
        return this.copyOrMoveFile(srcFile, destFile, listener2, true);
    }

    private final boolean copyOrMoveDir(File srcDir, File destDir, OnReplaceListener listener2, boolean isMove) {
        if (srcDir == null || destDir == null) {
            return false;
        }
        String srcPath = Intrinsics.stringPlus((String)srcDir.getPath(), (Object)File.separator);
        String destPath = Intrinsics.stringPlus((String)destDir.getPath(), (Object)File.separator);
        if (StringsKt.contains$default((CharSequence)destPath, (CharSequence)srcPath, (boolean)false, (int)2, null)) {
            return false;
        }
        if (!srcDir.exists() || !srcDir.isDirectory()) {
            return false;
        }
        if (!FileUtils.createOrExistsDir(destDir)) {
            return false;
        }
        File[] files = srcDir.listFiles();
        if (files != null && files.length > 0) {
            for (File file : files) {
                File oneDestFile = new File(Intrinsics.stringPlus((String)destPath, (Object)file.getName()));
                if (!(file.isFile() ? !this.copyOrMoveFile(file, oneDestFile, listener2, isMove) : file.isDirectory() && !this.copyOrMoveDir(file, oneDestFile, listener2, isMove))) continue;
                return false;
            }
        }
        return !isMove || this.deleteDir(srcDir);
    }

    private final boolean copyOrMoveFile(File srcFile, File destFile, OnReplaceListener listener2, boolean isMove) {
        boolean bl;
        if (srcFile == null || destFile == null) {
            return false;
        }
        if (Intrinsics.areEqual((Object)srcFile, (Object)destFile)) {
            return false;
        }
        if (!srcFile.exists() || !srcFile.isFile()) {
            return false;
        }
        if (destFile.exists()) {
            if (listener2 == null || listener2.onReplace(srcFile, destFile)) {
                if (!destFile.delete()) {
                    return false;
                }
            } else {
                return true;
            }
        }
        if (!FileUtils.createOrExistsDir(destFile.getParentFile())) {
            bl = false;
        } else {
            boolean bl2;
            try {
                bl2 = UtilsBridge.writeFileFromIS(destFile.getAbsolutePath(), new FileInputStream(srcFile)) && (!isMove || this.deleteFile(srcFile));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                bl2 = false;
            }
            bl = bl2;
        }
        return bl;
    }

    public final boolean delete(@Nullable String filePath) {
        return this.delete(FileUtils.getFileByPath(filePath));
    }

    public final boolean delete(@Nullable File file) {
        if (file == null) {
            return false;
        }
        return file.isDirectory() ? this.deleteDir(file) : this.deleteFile(file);
    }

    private final boolean deleteDir(File dir) {
        if (dir == null) {
            return false;
        }
        if (!dir.exists()) {
            return true;
        }
        if (!dir.isDirectory()) {
            return false;
        }
        File[] files = dir.listFiles();
        if (files != null && files.length > 0) {
            for (File file : files) {
                if (!(file.isFile() ? !file.delete() : file.isDirectory() && !this.deleteDir(file))) continue;
                return false;
            }
        }
        return dir.delete();
    }

    private final boolean deleteFile(File file) {
        return file != null && (!file.exists() || file.isFile() && file.delete());
    }

    public final boolean deleteAllInDir(@Nullable String dirPath) {
        return FileUtils.deleteAllInDir(FileUtils.getFileByPath(dirPath));
    }

    @JvmStatic
    public static final boolean deleteAllInDir(@Nullable File dir) {
        return INSTANCE.deleteFilesInDirWithFilter(dir, FileUtils::deleteAllInDir$lambda-0);
    }

    public final boolean deleteFilesInDir(@Nullable String dirPath) {
        return this.deleteFilesInDir(FileUtils.getFileByPath(dirPath));
    }

    public final boolean deleteFilesInDir(@Nullable File dir) {
        return this.deleteFilesInDirWithFilter(dir, FileUtils::deleteFilesInDir$lambda-1);
    }

    public final boolean deleteFilesInDirWithFilter(@Nullable String dirPath, @Nullable FileFilter filter) {
        return this.deleteFilesInDirWithFilter(FileUtils.getFileByPath(dirPath), filter);
    }

    public final boolean deleteFilesInDirWithFilter(@Nullable File dir, @Nullable FileFilter filter) {
        if (dir == null || filter == null) {
            return false;
        }
        if (!dir.exists()) {
            return true;
        }
        if (!dir.isDirectory()) {
            return false;
        }
        File[] files = dir.listFiles();
        if (files != null && files.length != 0) {
            for (File file : files) {
                if (!filter.accept(file) || !(file.isFile() ? !file.delete() : file.isDirectory() && !this.deleteDir(file))) continue;
                return false;
            }
        }
        return true;
    }

    @NotNull
    public final List<File> listFilesInDir(@Nullable String dirPath, @Nullable Comparator<File> comparator) {
        return this.listFilesInDir(FileUtils.getFileByPath(dirPath), false, comparator);
    }

    public static /* synthetic */ List listFilesInDir$default(FileUtils fileUtils, String string, Comparator comparator, int n, Object object) {
        if ((n & 2) != 0) {
            comparator = null;
        }
        return fileUtils.listFilesInDir(string, (Comparator<File>)comparator);
    }

    @NotNull
    public final List<File> listFilesInDir(@Nullable File dir, @Nullable Comparator<File> comparator) {
        return this.listFilesInDir(dir, false, comparator);
    }

    public static /* synthetic */ List listFilesInDir$default(FileUtils fileUtils, File file, Comparator comparator, int n, Object object) {
        if ((n & 2) != 0) {
            comparator = null;
        }
        return fileUtils.listFilesInDir(file, (Comparator<File>)comparator);
    }

    @NotNull
    public final List<File> listFilesInDir(@Nullable String dirPath, boolean isRecursive) {
        return FileUtils.listFilesInDir$default(this, FileUtils.getFileByPath(dirPath), isRecursive, null, 4, null);
    }

    @NotNull
    public final List<File> listFilesInDir(@Nullable String dirPath, boolean isRecursive, @Nullable Comparator<File> comparator) {
        return this.listFilesInDir(FileUtils.getFileByPath(dirPath), isRecursive, comparator);
    }

    @NotNull
    public final List<File> listFilesInDir(@Nullable File dir, boolean isRecursive, @Nullable Comparator<File> comparator) {
        return this.listFilesInDirWithFilter(dir, FileUtils::listFilesInDir$lambda-2, isRecursive, comparator);
    }

    public static /* synthetic */ List listFilesInDir$default(FileUtils fileUtils, File file, boolean bl, Comparator comparator, int n, Object object) {
        if ((n & 4) != 0) {
            comparator = null;
        }
        return fileUtils.listFilesInDir(file, bl, (Comparator<File>)comparator);
    }

    @NotNull
    public final List<File> listFilesInDirWithFilter(@Nullable String dirPath, @NotNull FileFilter filter) {
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        return FileUtils.listFilesInDirWithFilter$default(this, FileUtils.getFileByPath(dirPath), filter, false, null, 12, null);
    }

    @NotNull
    public final List<File> listFilesInDirWithFilter(@Nullable String dirPath, @NotNull FileFilter filter, @Nullable Comparator<File> comparator) {
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        return this.listFilesInDirWithFilter(FileUtils.getFileByPath(dirPath), filter, comparator);
    }

    @NotNull
    public final List<File> listFilesInDirWithFilter(@Nullable File dir, @NotNull FileFilter filter, @Nullable Comparator<File> comparator) {
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        return this.listFilesInDirWithFilter(dir, filter, false, comparator);
    }

    @NotNull
    public final List<File> listFilesInDirWithFilter(@Nullable String dirPath, @NotNull FileFilter filter, boolean isRecursive) {
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        return FileUtils.listFilesInDirWithFilter$default(this, FileUtils.getFileByPath(dirPath), filter, isRecursive, null, 8, null);
    }

    @NotNull
    public final List<File> listFilesInDirWithFilter(@Nullable String dirPath, @NotNull FileFilter filter, boolean isRecursive, @Nullable Comparator<File> comparator) {
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        return this.listFilesInDirWithFilter(FileUtils.getFileByPath(dirPath), filter, isRecursive, comparator);
    }

    @NotNull
    public final List<File> listFilesInDirWithFilter(@Nullable File dir, @NotNull FileFilter filter, boolean isRecursive, @Nullable Comparator<File> comparator) {
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        List<File> files = this.listFilesInDirWithFilterInner(dir, filter, isRecursive);
        if (comparator != null) {
            Collections.sort(files, comparator);
        }
        return files;
    }

    public static /* synthetic */ List listFilesInDirWithFilter$default(FileUtils fileUtils, File file, FileFilter fileFilter, boolean bl, Comparator comparator, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            comparator = null;
        }
        return fileUtils.listFilesInDirWithFilter(file, fileFilter, bl, (Comparator<File>)comparator);
    }

    private final List<File> listFilesInDirWithFilterInner(File dir, FileFilter filter, boolean isRecursive) {
        List list = new ArrayList();
        if (!this.isDir(dir)) {
            return list;
        }
        File file = dir;
        Intrinsics.checkNotNull((Object)file);
        File[] files = file.listFiles();
        if (files != null && files.length > 0) {
            File[] fileArray = files;
            int n = 0;
            int n2 = fileArray.length;
            while (n < n2) {
                File file2 = fileArray[n];
                ++n;
                if (filter.accept(file2)) {
                    list.add(file2);
                }
                if (!isRecursive || !file2.isDirectory()) continue;
                list.addAll((Collection)this.listFilesInDirWithFilterInner(file2, filter, true));
            }
        }
        return list;
    }

    public final long getFileLastModified(@Nullable String filePath) {
        return this.getFileLastModified(FileUtils.getFileByPath(filePath));
    }

    public final long getFileLastModified(@Nullable File file) {
        long l;
        File file2 = file;
        return file2 == null ? -1L : (l = file2.lastModified());
    }

    @NotNull
    public final String getFileCharsetSimple(@Nullable String filePath) {
        return this.getFileCharsetSimple(FileUtils.getFileByPath(filePath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public final String getFileCharsetSimple(@Nullable File file) {
        if (file == null) {
            return "";
        }
        if (this.isUtf8(file)) {
            return "UTF-8";
        }
        int p = 0;
        InputStream is = null;
        try {
            is = new BufferedInputStream(new FileInputStream(file));
            p = (((BufferedInputStream)is).read() << 8) + ((BufferedInputStream)is).read();
            try {
                InputStream inputStream = is;
                inputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                InputStream e = is;
                if (e != null) {
                    e.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        int n = p;
        switch (n) {
            case 65534: {
                return "Unicode";
            }
            case 65279: {
                return "UTF-16BE";
            }
        }
        return "GBK";
    }

    public final boolean isUtf8(@Nullable String filePath) {
        return this.isUtf8(FileUtils.getFileByPath(filePath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public final boolean isUtf8(@Nullable File file) {
        block15: {
            if (file == null) {
                return false;
            }
            is = null;
            try {
                bytes = new byte[24];
                is = new BufferedInputStream(new FileInputStream(file));
                read = ((BufferedInputStream)is).read(bytes);
                if (read != -1) {
                    readArr = new byte[read];
                    System.arraycopy(bytes, 0, readArr, 0, read);
                    v0 = this.isUtf8(readArr) == 100;
                } else {
                    v0 = false;
                }
                var5_12 = v0;
                ** try [egrp 1[TRYBLOCK] [0 : 90->102)] { 
            }
            catch (IOException e) {
                e.printStackTrace();
                break block15;
            }
            finally {
                try {
                    e = is;
                    if (e != null) {
                        e.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
lbl-1000:
            // 1 sources

            {
                var6_13 = is;
                var6_13.close();
            }
lbl21:
            // 1 sources

            catch (IOException e) {
                e.printStackTrace();
            }
            return var5_12;
        }
        return false;
    }

    private final int isUtf8(byte[] raw) {
        int i = 0;
        int len = 0;
        int utf8 = 0;
        int ascii = 0;
        if (raw.length > 3 && raw[0] == -17 && raw[1] == -69 && raw[2] == -65) {
            return 100;
        }
        len = raw.length;
        int child = 0;
        i = 0;
        while (i < len) {
            int n;
            int n2;
            byte by;
            int n3;
            int n4;
            block16: {
                block15: {
                    n4 = raw[i];
                    n3 = -1;
                    by = 0;
                    if ((byte)(n4 & n3) == -1) break block15;
                    n4 = raw[i];
                    n3 = -2;
                    by = 0;
                    if ((byte)(n4 & n3) != -2) break block16;
                }
                return 0;
            }
            if (child == 0) {
                n4 = raw[i];
                n3 = 127;
                by = 0;
                if ((byte)(n4 & n3) == raw[i] && raw[i] != 0) {
                    n4 = ascii;
                    ascii = n4 + 1;
                } else {
                    n4 = raw[i];
                    n3 = -64;
                    by = 0;
                    if ((byte)(n4 & n3) == -64) {
                        n4 = 0;
                        do {
                            int bit = n4++;
                            by = (byte)(128 >> bit);
                            n2 = raw[i];
                            n = 0;
                            if ((byte)(by & n2) != (byte)(128 >> bit)) break;
                            child = bit;
                        } while (n4 <= 7);
                        n4 = utf8;
                        utf8 = n4 + 1;
                    }
                }
                n4 = i;
                i = n4 + 1;
                continue;
            }
            child = raw.length - i > child ? child : raw.length - i;
            boolean currentNotUtf8 = false;
            n3 = 0;
            if (n3 < child) {
                do {
                    int children = n3++;
                    n2 = raw[i + children];
                    n = -128;
                    boolean bl = false;
                    if ((byte)(n2 & n) == -128) continue;
                    n2 = raw[i + children];
                    n = 127;
                    bl = false;
                    if ((byte)(n2 & n) == raw[i + children] && raw[i] != 0) {
                        n2 = ascii;
                        ascii = n2 + 1;
                    }
                    currentNotUtf8 = true;
                } while (n3 < child);
            }
            if (currentNotUtf8) {
                n3 = utf8;
                utf8 = n3 + -1;
                n3 = i;
                i = n3 + 1;
            } else {
                utf8 += child;
                i += child;
            }
            child = 0;
        }
        return ascii == len ? 100 : (int)((float)100 * ((float)(utf8 + ascii) / (float)len));
    }

    public final int getFileLines(@Nullable String filePath) {
        return this.getFileLines(FileUtils.getFileByPath(filePath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public final int getFileLines(@Nullable File file) {
        block19: {
            count = 1;
            is = null;
            try {
                is = new BufferedInputStream(new FileInputStream(file));
                buffer = new byte[1024];
                readChars = 0;
                var6_13 = FileUtils.LINE_SEP;
                Intrinsics.checkNotNullExpressionValue((Object)var6_13, (String)"LINE_SEP");
                if (StringsKt.endsWith$default((String)var6_13, (String)"\n", (boolean)false, (int)2, null)) {
                    while (true) {
                        var6_14 = ((BufferedInputStream)is).read((byte[])buffer, 0, 1024);
                        var7_16 = false;
                        var8_18 = false;
                        it = var6_14;
                        $i$a$-also-FileUtils$getFileLines$1 = false;
                        readChars = it;
                        if (var6_14 != -1) {
                            var6_14 = 0;
                            if (var6_14 >= readChars) continue;
                            do {
                                if ((char)buffer[i = var6_14++] != '\n') continue;
                                ++count;
                            } while (var6_14 < readChars);
                            continue;
                        }
                        break;
                    }
                } else {
                    while (true) {
                        var6_15 = ((BufferedInputStream)is).read((byte[])buffer, 0, 1024);
                        i = 0;
                        var8_19 = false;
                        it = var6_15;
                        $i$a$-also-FileUtils$getFileLines$2 = false;
                        readChars = it;
                        if (var6_15 == -1) break;
                        var6_15 = 0;
                        if (var6_15 >= readChars) continue;
                        do {
                            if ((char)buffer[i = var6_15++] != '\r') continue;
                            ++count;
                        } while (var6_15 < readChars);
                    }
                }
                ** try [egrp 1[TRYBLOCK] [0 : 222->234)] { 
            }
            catch (IOException e) {
                e.printStackTrace();
                break block19;
            }
            finally {
                try {
                    e = is;
                    if (e != null) {
                        e.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
lbl-1000:
            // 1 sources

            {
                buffer = is;
                buffer.close();
            }
lbl47:
            // 1 sources

            catch (IOException e) {
                e.printStackTrace();
            }
            {
            }
        }
        return count;
    }

    @NotNull
    public final String getSize(@Nullable String filePath) {
        return this.getSize(FileUtils.getFileByPath(filePath));
    }

    @NotNull
    public final String getSize(@Nullable File file) {
        if (file == null) {
            return "";
        }
        return file.isDirectory() ? this.getDirSize(file) : this.getFileSize(file);
    }

    private final String getDirSize(File dir) {
        String string;
        long len = this.getDirLength(dir);
        if (len == -1L) {
            string = "";
        } else {
            String string2 = UtilsBridge.byte2FitMemorySize(len);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"byte2FitMemorySize(len)");
            string = string2;
        }
        return string;
    }

    private final String getFileSize(File file) {
        String string;
        long len = this.getFileLength(file);
        if (len == -1L) {
            string = "";
        } else {
            String string2 = UtilsBridge.byte2FitMemorySize(len);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"byte2FitMemorySize(len)");
            string = string2;
        }
        return string;
    }

    public final long getLength(@Nullable String filePath) {
        return this.getLength(FileUtils.getFileByPath(filePath));
    }

    public final long getLength(@Nullable File file) {
        if (file == null) {
            return 0L;
        }
        return file.isDirectory() ? this.getDirLength(file) : this.getFileLength(file);
    }

    private final long getDirLength(File dir) {
        if (!this.isDir(dir)) {
            return 0L;
        }
        long len = 0L;
        File[] files = dir.listFiles();
        if (files != null && files.length > 0) {
            File[] fileArray = files;
            int n = 0;
            int n2 = fileArray.length;
            while (n < n2) {
                long l;
                File file = fileArray[n];
                ++n;
                if (file.isDirectory()) {
                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file");
                    l = this.getDirLength(file);
                } else {
                    l = file.length();
                }
                len += l;
            }
        }
        return len;
    }

    public final long getFileLength(@NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        CharSequence charSequence = filePath;
        Object object = new Regex("[a-zA-z]+://[^\\s]*");
        boolean bl = false;
        boolean isURL = object.matches(charSequence);
        if (isURL) {
            try {
                object = new URL(filePath).openConnection();
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type javax.net.ssl.HttpsURLConnection");
                }
                HttpsURLConnection conn = (HttpsURLConnection)object;
                conn.setRequestProperty("Accept-Encoding", "identity");
                conn.connect();
                return conn.getResponseCode() == 200 ? (long)conn.getContentLength() : -1L;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return this.getFileLength(FileUtils.getFileByPath(filePath));
    }

    private final long getFileLength(File file) {
        long l;
        if (!this.isFile(file)) {
            l = -1L;
        } else {
            File file2 = file;
            Intrinsics.checkNotNull((Object)file2);
            l = file2.length();
        }
        return l;
    }

    @NotNull
    public final String getFileMD5ToString(@Nullable String filePath) {
        File file = UtilsBridge.isSpace(filePath) ? null : new File(filePath);
        return this.getFileMD5ToString(file);
    }

    @NotNull
    public final String getFileMD5ToString(@Nullable File file) {
        String string = ConvertUtils.bytes2HexString(this.getFileMD5(file));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"bytes2HexString(getFileMD5(file))");
        return string;
    }

    @Nullable
    public final byte[] getFileMD5(@Nullable String filePath) {
        return this.getFileMD5(FileUtils.getFileByPath(filePath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Nullable
    public final byte[] getFileMD5(@Nullable File file) {
        block18: {
            if (file == null) {
                return null;
            }
            dis = null;
            try {
                fis = new FileInputStream(file);
                md = MessageDigest.getInstance("MD5");
                dis = new DigestInputStream(fis, md);
                buffer = new byte[262144];
                while (dis.read(buffer) > 0) {
                }
                md = dis.getMessageDigest();
                var6_15 = md.digest();
                ** try [egrp 1[TRYBLOCK] [0 : 73->85)] { 
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
                break block18;
            }
            catch (IOException e) {
                e.printStackTrace();
                break block18;
                {
                    catch (Throwable var3_10) {
                        throw var3_10;
                    }
                }
            }
            finally {
                try {
                    e = dis;
                    if (e != null) {
                        e.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
lbl-1000:
            // 1 sources

            {
                var7_16 = dis;
                var7_16.close();
            }
lbl20:
            // 1 sources

            catch (IOException e) {
                e.printStackTrace();
            }
            return var6_15;
        }
        return null;
    }

    @NotNull
    public final String getDirName(@Nullable File file) {
        String string;
        if (file == null) {
            string = "";
        } else {
            String string2 = file.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"file.absolutePath");
            string = this.getDirName(string2);
        }
        return string;
    }

    @NotNull
    public final String getDirName(@NotNull String filePath) {
        String string;
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        if (UtilsBridge.isSpace(filePath)) {
            return "";
        }
        CharSequence charSequence = filePath;
        String string2 = File.separator;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"separator");
        int lastSep = StringsKt.lastIndexOf$default((CharSequence)charSequence, (String)string2, (int)0, (boolean)false, (int)6, null);
        if (lastSep == -1) {
            string = "";
        } else {
            string2 = filePath;
            int n = 0;
            int n2 = lastSep + 1;
            boolean bl = false;
            String string3 = string2.substring(n, n2);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        }
        return string;
    }

    @NotNull
    public final String getFileName(@Nullable File file) {
        String string;
        if (file == null) {
            string = "";
        } else {
            String string2 = file.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"file.absolutePath");
            string = this.getFileName(string2);
        }
        return string;
    }

    @NotNull
    public final String getFileName(@NotNull String filePath) {
        String string;
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        if (UtilsBridge.isSpace(filePath)) {
            return "";
        }
        CharSequence charSequence = filePath;
        String string2 = File.separator;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"separator");
        int lastSep = StringsKt.lastIndexOf$default((CharSequence)charSequence, (String)string2, (int)0, (boolean)false, (int)6, null);
        if (lastSep == -1) {
            string = filePath;
        } else {
            string2 = filePath;
            int n = lastSep + 1;
            boolean bl = false;
            String string3 = string2.substring(n);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
        }
        return string;
    }

    @NotNull
    public final String getFileNameNoExtension(@Nullable File file) {
        String string;
        if (file == null) {
            string = "";
        } else {
            String string2 = file.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"file.path");
            string = this.getFileNameNoExtension(string2);
        }
        return string;
    }

    @NotNull
    public final String getFileNameNoExtension(@NotNull String filePath) {
        String string;
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        if (UtilsBridge.isSpace(filePath)) {
            return "";
        }
        int lastPoi = StringsKt.lastIndexOf$default((CharSequence)filePath, (char)'.', (int)0, (boolean)false, (int)6, null);
        CharSequence charSequence = filePath;
        String string2 = File.separator;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"separator");
        int lastSep = StringsKt.lastIndexOf$default((CharSequence)charSequence, (String)string2, (int)0, (boolean)false, (int)6, null);
        if (lastSep == -1) {
            String string3;
            if (lastPoi == -1) {
                string3 = filePath;
            } else {
                string2 = filePath;
                int n = 0;
                boolean bl = false;
                String string4 = string2.substring(n, lastPoi);
                string3 = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            }
            return string3;
        }
        if (lastPoi == -1 || lastSep > lastPoi) {
            string2 = filePath;
            int n = lastSep + 1;
            boolean bl = false;
            String string5 = string2.substring(n);
            string = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
        } else {
            string2 = filePath;
            int n = lastSep + 1;
            boolean bl = false;
            String string6 = string2.substring(n, lastPoi);
            string = string6;
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        }
        return string;
    }

    @NotNull
    public final String getFileExtension(@Nullable File file) {
        String string;
        if (file == null) {
            string = "";
        } else {
            String string2 = file.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"file.path");
            string = this.getFileExtension(string2);
        }
        return string;
    }

    @NotNull
    public final String getFileExtension(@NotNull String filePath) {
        String string;
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        if (UtilsBridge.isSpace(filePath)) {
            return "";
        }
        int lastPoi = StringsKt.lastIndexOf$default((CharSequence)filePath, (char)'.', (int)0, (boolean)false, (int)6, null);
        CharSequence charSequence = filePath;
        String string2 = File.separator;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"separator");
        int lastSep = StringsKt.lastIndexOf$default((CharSequence)charSequence, (String)string2, (int)0, (boolean)false, (int)6, null);
        if (lastPoi == -1 || lastSep >= lastPoi) {
            string = "";
        } else {
            string2 = filePath;
            int n = lastPoi + 1;
            boolean bl = false;
            String string3 = string2.substring(n);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
        }
        return string;
    }

    public final void notifySystemToScan(@Nullable String filePath) {
        FileUtils.notifySystemToScan(FileUtils.getFileByPath(filePath));
    }

    @JvmStatic
    public static final void notifySystemToScan(@Nullable File file) {
        if (file == null || !file.exists()) {
            return;
        }
        Intent intent = new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE");
        intent.setData(Uri.parse((String)Intrinsics.stringPlus((String)"file://", (Object)file.getAbsolutePath())));
        Utils.getApp().sendBroadcast(intent);
    }

    @JvmStatic
    public static final long getFsTotalSize(@Nullable String anyPathInFs) {
        if (TextUtils.isEmpty((CharSequence)anyPathInFs)) {
            return 0L;
        }
        StatFs statFs = new StatFs(anyPathInFs);
        long blockSize = 0L;
        long totalSize = 0L;
        if (Build.VERSION.SDK_INT >= 18) {
            blockSize = statFs.getBlockSizeLong();
            totalSize = statFs.getBlockCountLong();
        } else {
            blockSize = statFs.getBlockSize();
            totalSize = statFs.getBlockCount();
        }
        return blockSize * totalSize;
    }

    @JvmStatic
    public static final long getFsAvailableSize(@Nullable String anyPathInFs) {
        if (TextUtils.isEmpty((CharSequence)anyPathInFs)) {
            return 0L;
        }
        StatFs statFs = new StatFs(anyPathInFs);
        long blockSize = 0L;
        long availableSize = 0L;
        if (Build.VERSION.SDK_INT >= 18) {
            blockSize = statFs.getBlockSizeLong();
            availableSize = statFs.getAvailableBlocksLong();
        } else {
            blockSize = statFs.getBlockSize();
            availableSize = statFs.getAvailableBlocks();
        }
        return blockSize * availableSize;
    }

    private static final boolean deleteAllInDir$lambda-0(File it) {
        return true;
    }

    private static final boolean deleteFilesInDir$lambda-1(File pathname) {
        return pathname.isFile();
    }

    private static final boolean listFilesInDir$lambda-2(File it) {
        return true;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u001c\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005H&\u00a8\u0006\u0007"}, d2={"Lxyz/junerver/utils/FileUtils$OnReplaceListener;", "", "onReplace", "", "srcFile", "Ljava/io/File;", "destFile", "utils_release"})
    public static interface OnReplaceListener {
        public boolean onReplace(@Nullable File var1, @Nullable File var2);
    }
}

