/*
 * Decompiled with CFR 0.152.
 */
package xyz.junerver.utils;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.Intent;
import android.content.res.Resources;
import android.net.Uri;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import androidx.annotation.RequiresApi;
import androidx.annotation.RequiresPermission;
import java.io.File;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.UUID;
import xyz.junerver.utils.ShellUtils;
import xyz.junerver.utils.Utils;
import xyz.junerver.utils.UtilsBridge;

public final class DeviceUtils {
    private static final String KEY_UDID = "KEY_UDID";
    private static volatile String udid;

    private DeviceUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static boolean isDeviceRooted() {
        String[] locations;
        String su = "su";
        for (String location : locations = new String[]{"/system/bin/", "/system/xbin/", "/sbin/", "/system/sd/xbin/", "/system/bin/failsafe/", "/data/local/xbin/", "/data/local/bin/", "/data/local/", "/system/sbin/", "/usr/bin/", "/vendor/bin/"}) {
            if (!new File(location + su).exists()) continue;
            return true;
        }
        return false;
    }

    @RequiresApi(api=17)
    public static boolean isAdbEnabled() {
        return Settings.Secure.getInt((ContentResolver)Utils.getApp().getContentResolver(), (String)"adb_enabled", (int)0) > 0;
    }

    public static String getSDKVersionName() {
        return Build.VERSION.RELEASE;
    }

    public static int getSDKVersionCode() {
        return Build.VERSION.SDK_INT;
    }

    @SuppressLint(value={"HardwareIds"})
    public static String getAndroidID() {
        String id2 = Settings.Secure.getString((ContentResolver)Utils.getApp().getContentResolver(), (String)"android_id");
        if ("9774d56d682e549c".equals(id2)) {
            return "";
        }
        return id2 == null ? "" : id2;
    }

    @RequiresPermission(allOf={"android.permission.ACCESS_WIFI_STATE", "android.permission.CHANGE_WIFI_STATE"})
    public static String getMacAddress() {
        String macAddress = DeviceUtils.getMacAddress(null);
        if (!TextUtils.isEmpty((CharSequence)macAddress) || DeviceUtils.getWifiEnabled()) {
            return macAddress;
        }
        DeviceUtils.setWifiEnabled(true);
        DeviceUtils.setWifiEnabled(false);
        return DeviceUtils.getMacAddress(null);
    }

    private static boolean getWifiEnabled() {
        WifiManager manager = (WifiManager)Utils.getApp().getSystemService("wifi");
        if (manager == null) {
            return false;
        }
        return manager.isWifiEnabled();
    }

    @RequiresPermission(value="android.permission.CHANGE_WIFI_STATE")
    private static void setWifiEnabled(boolean enabled) {
        WifiManager manager = (WifiManager)Utils.getApp().getSystemService("wifi");
        if (manager == null) {
            return;
        }
        if (enabled == manager.isWifiEnabled()) {
            return;
        }
        manager.setWifiEnabled(enabled);
    }

    @RequiresPermission(allOf={"android.permission.ACCESS_WIFI_STATE"})
    public static String getMacAddress(String ... excepts) {
        String macAddress = DeviceUtils.getMacAddressByNetworkInterface();
        if (DeviceUtils.isAddressNotInExcepts(macAddress, excepts)) {
            return macAddress;
        }
        macAddress = DeviceUtils.getMacAddressByInetAddress();
        if (DeviceUtils.isAddressNotInExcepts(macAddress, excepts)) {
            return macAddress;
        }
        macAddress = DeviceUtils.getMacAddressByWifiInfo();
        if (DeviceUtils.isAddressNotInExcepts(macAddress, excepts)) {
            return macAddress;
        }
        macAddress = DeviceUtils.getMacAddressByFile();
        if (DeviceUtils.isAddressNotInExcepts(macAddress, excepts)) {
            return macAddress;
        }
        return "";
    }

    private static boolean isAddressNotInExcepts(String address, String ... excepts) {
        if (TextUtils.isEmpty((CharSequence)address)) {
            return false;
        }
        if ("02:00:00:00:00:00".equals(address)) {
            return false;
        }
        if (excepts == null || excepts.length == 0) {
            return true;
        }
        for (String filter : excepts) {
            if (filter == null || !filter.equals(address)) continue;
            return false;
        }
        return true;
    }

    @RequiresPermission(value="android.permission.ACCESS_WIFI_STATE")
    private static String getMacAddressByWifiInfo() {
        try {
            String macAddress;
            WifiInfo info;
            WifiManager wifi = (WifiManager)Utils.getApp().getApplicationContext().getSystemService("wifi");
            if (wifi != null && (info = wifi.getConnectionInfo()) != null && !TextUtils.isEmpty((CharSequence)(macAddress = info.getMacAddress()))) {
                return macAddress;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "02:00:00:00:00:00";
    }

    private static String getMacAddressByNetworkInterface() {
        try {
            Enumeration<NetworkInterface> nis = NetworkInterface.getNetworkInterfaces();
            while (nis.hasMoreElements()) {
                byte[] macBytes;
                NetworkInterface ni = nis.nextElement();
                if (ni == null || !ni.getName().equalsIgnoreCase("wlan0") || (macBytes = ni.getHardwareAddress()) == null || macBytes.length <= 0) continue;
                StringBuilder sb = new StringBuilder();
                for (byte b : macBytes) {
                    sb.append(String.format("%02x:", b));
                }
                return sb.substring(0, sb.length() - 1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "02:00:00:00:00:00";
    }

    private static String getMacAddressByInetAddress() {
        try {
            byte[] macBytes;
            NetworkInterface ni;
            InetAddress inetAddress = DeviceUtils.getInetAddress();
            if (inetAddress != null && (ni = NetworkInterface.getByInetAddress(inetAddress)) != null && (macBytes = ni.getHardwareAddress()) != null && macBytes.length > 0) {
                StringBuilder sb = new StringBuilder();
                for (byte b : macBytes) {
                    sb.append(String.format("%02x:", b));
                }
                return sb.substring(0, sb.length() - 1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "02:00:00:00:00:00";
    }

    private static InetAddress getInetAddress() {
        try {
            Enumeration<NetworkInterface> nis = NetworkInterface.getNetworkInterfaces();
            while (nis.hasMoreElements()) {
                NetworkInterface ni = nis.nextElement();
                if (!ni.isUp()) continue;
                Enumeration<InetAddress> addresses = ni.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    String hostAddress;
                    InetAddress inetAddress = addresses.nextElement();
                    if (inetAddress.isLoopbackAddress() || (hostAddress = inetAddress.getHostAddress()).indexOf(58) >= 0) continue;
                    return inetAddress;
                }
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        return null;
    }

    private static String getMacAddressByFile() {
        String name;
        ShellUtils.CommandResult result = UtilsBridge.execCmd("getprop wifi.interface", false);
        if (result.result == 0 && (name = result.successMsg) != null) {
            String address;
            result = UtilsBridge.execCmd("cat /sys/class/net/" + name + "/address", false);
            if (result.result == 0 && (address = result.successMsg) != null && address.length() > 0) {
                return address;
            }
        }
        return "02:00:00:00:00:00";
    }

    public static String getManufacturer() {
        return Build.MANUFACTURER;
    }

    public static String getModel() {
        String model = Build.MODEL;
        model = model != null ? model.trim().replaceAll("\\s*", "") : "";
        return model;
    }

    public static String[] getABIs() {
        if (Build.VERSION.SDK_INT >= 21) {
            return Build.SUPPORTED_ABIS;
        }
        if (!TextUtils.isEmpty((CharSequence)Build.CPU_ABI2)) {
            return new String[]{Build.CPU_ABI, Build.CPU_ABI2};
        }
        return new String[]{Build.CPU_ABI};
    }

    public static boolean isTablet() {
        return (Resources.getSystem().getConfiguration().screenLayout & 0xF) >= 3;
    }

    public static boolean isEmulator() {
        boolean checkDial;
        boolean checkOperatorName;
        String name;
        boolean checkProperty;
        boolean bl = checkProperty = Build.FINGERPRINT.startsWith("generic") || Build.FINGERPRINT.toLowerCase().contains("vbox") || Build.FINGERPRINT.toLowerCase().contains("test-keys") || Build.MODEL.contains("google_sdk") || Build.MODEL.contains("Emulator") || Build.MODEL.contains("Android SDK built for x86") || Build.MANUFACTURER.contains("Genymotion") || Build.BRAND.startsWith("generic") && Build.DEVICE.startsWith("generic") || "google_sdk".equals(Build.PRODUCT);
        if (checkProperty) {
            return true;
        }
        String operatorName = "";
        TelephonyManager tm = (TelephonyManager)Utils.getApp().getSystemService("phone");
        if (tm != null && (name = tm.getNetworkOperatorName()) != null) {
            operatorName = name;
        }
        if (checkOperatorName = operatorName.toLowerCase().equals("android")) {
            return true;
        }
        String url = "tel:123456";
        Intent intent = new Intent();
        intent.setData(Uri.parse((String)url));
        intent.setAction("android.intent.action.DIAL");
        boolean bl2 = checkDial = intent.resolveActivity(Utils.getApp().getPackageManager()) == null;
        return checkDial;
    }

    @RequiresApi(api=17)
    public static boolean isDevelopmentSettingsEnabled() {
        return Settings.Global.getInt((ContentResolver)Utils.getApp().getContentResolver(), (String)"development_settings_enabled", (int)0) > 0;
    }

    public static String getUniqueDeviceId() {
        return DeviceUtils.getUniqueDeviceId("", true);
    }

    public static String getUniqueDeviceId(String prefix) {
        return DeviceUtils.getUniqueDeviceId(prefix, true);
    }

    public static String getUniqueDeviceId(boolean useCache) {
        return DeviceUtils.getUniqueDeviceId("", useCache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getUniqueDeviceId(String prefix, boolean useCache) {
        if (!useCache) {
            return DeviceUtils.getUniqueDeviceIdReal(prefix);
        }
        if (udid != null) return udid;
        Class<DeviceUtils> clazz = DeviceUtils.class;
        synchronized (DeviceUtils.class) {
            if (udid != null) return udid;
            String id2 = UtilsBridge.getSpUtils4Utils().getString(KEY_UDID, null);
            if (id2 == null) return DeviceUtils.getUniqueDeviceIdReal(prefix);
            udid = id2;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return udid;
        }
    }

    private static String getUniqueDeviceIdReal(String prefix) {
        try {
            String androidId = DeviceUtils.getAndroidID();
            if (!TextUtils.isEmpty((CharSequence)androidId)) {
                return DeviceUtils.saveUdid(prefix + 2, androidId);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return DeviceUtils.saveUdid(prefix + 9, "");
    }

    @RequiresPermission(allOf={"android.permission.ACCESS_WIFI_STATE", "android.permission.INTERNET", "android.permission.CHANGE_WIFI_STATE"})
    public static boolean isSameDevice(String uniqueDeviceId) {
        if (TextUtils.isEmpty((CharSequence)uniqueDeviceId) && uniqueDeviceId.length() < 33) {
            return false;
        }
        if (uniqueDeviceId.equals(udid)) {
            return true;
        }
        String cachedId = UtilsBridge.getSpUtils4Utils().getString(KEY_UDID, null);
        if (uniqueDeviceId.equals(cachedId)) {
            return true;
        }
        int st = uniqueDeviceId.length() - 33;
        String type = uniqueDeviceId.substring(st, st + 1);
        if (type.startsWith("1")) {
            String macAddress = DeviceUtils.getMacAddress();
            if (macAddress.equals("")) {
                return false;
            }
            return uniqueDeviceId.substring(st + 1).equals(DeviceUtils.getUdid("", macAddress));
        }
        if (type.startsWith("2")) {
            String androidId = DeviceUtils.getAndroidID();
            if (TextUtils.isEmpty((CharSequence)androidId)) {
                return false;
            }
            return uniqueDeviceId.substring(st + 1).equals(DeviceUtils.getUdid("", androidId));
        }
        return false;
    }

    private static String saveUdid(String prefix, String id2) {
        udid = DeviceUtils.getUdid(prefix, id2);
        UtilsBridge.getSpUtils4Utils().put(KEY_UDID, udid);
        return udid;
    }

    private static String getUdid(String prefix, String id2) {
        if (id2.equals("")) {
            return prefix + UUID.randomUUID().toString().replace("-", "");
        }
        return prefix + UUID.nameUUIDFromBytes(id2.getBytes()).toString().replace("-", "");
    }
}

