/*
 * Decompiled with CFR 0.152.
 */
package xyz.junerver.utils;

import android.util.Base64;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import kotlin.Metadata;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0010\u0010\r\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000e\u001a\u00020\u0006J \u0010\r\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010J\u0010\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0006H\u0007J\u0016\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\u0017H\u0007J\u000e\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u0015J\u0018\u0010\u0018\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u0010J\u0018\u0010\u001b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u0010J\u000e\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u0004J\u0010\u0010\u001f\u001a\u00020\u00062\u0006\u0010 \u001a\u00020!H\u0007J\u0010\u0010\"\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0006H\u0007J\n\u0010#\u001a\u00020\u0006*\u00020\u0006J\n\u0010$\u001a\u00020\u0004*\u00020\u0006J\n\u0010%\u001a\u00020\u0006*\u00020\fJ\n\u0010&\u001a\u00020\u0006*\u00020\u0006\u00a8\u0006'"}, d2={"Lxyz/junerver/utils/ByteUtils;", "", "()V", "byteArray2Base64", "", "ba", "", "byteToHex", "byte", "", "bytebuffer2ByteArray", "buffer", "Ljava/nio/ByteBuffer;", "bytes2HexStr", "src", "dec", "", "length", "compresByGzip", "data", "countByteArrayList", "", "l", "", "decimal2fitHex", "num", "strLength", "fitDecimalStr", "dicimal", "hexStr2decimal", "hex", "readBytes", "file", "Ljava/io/File;", "uncompressByGzip", "gzipCompress", "toBase64", "toByteArray", "uncompressGzip", "utils_release"})
public final class ByteUtils {
    @NotNull
    public static final ByteUtils INSTANCE = new ByteUtils();

    private ByteUtils() {
    }

    @JvmStatic
    @NotNull
    public static final byte[] bytebuffer2ByteArray(@NotNull ByteBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        byte[] byArray = new byte[buffer.capacity()];
        boolean bl = false;
        boolean bl2 = false;
        byte[] $this$bytebuffer2ByteArray_u24lambda_u2d0 = byArray;
        boolean bl3 = false;
        buffer.get($this$bytebuffer2ByteArray_u24lambda_u2d0);
        return byArray;
    }

    @NotNull
    public final byte[] toByteArray(@NotNull ByteBuffer $this$toByteArray) {
        Intrinsics.checkNotNullParameter((Object)$this$toByteArray, (String)"<this>");
        return ByteUtils.bytebuffer2ByteArray($this$toByteArray);
    }

    @NotNull
    public final String toBase64(@NotNull byte[] $this$toBase64) {
        Intrinsics.checkNotNullParameter((Object)$this$toBase64, (String)"<this>");
        String string = Base64.encodeToString((byte[])$this$toBase64, (int)2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encodeToString(this, Base64.NO_WRAP)");
        return string;
    }

    @JvmStatic
    @NotNull
    public static final String byteArray2Base64(@NotNull byte[] ba) {
        Intrinsics.checkNotNullParameter((Object)ba, (String)"ba");
        return INSTANCE.toBase64(ba);
    }

    @JvmStatic
    @NotNull
    public static final byte[] compresByGzip(@NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        boolean bl = false;
        boolean bl2 = false;
        ByteArrayOutputStream $this$compresByGzip_u24lambda_u2d2 = byteArrayOutputStream;
        boolean bl3 = false;
        GZIPOutputStream gZIPOutputStream = new GZIPOutputStream($this$compresByGzip_u24lambda_u2d2);
        boolean bl4 = false;
        boolean bl5 = false;
        GZIPOutputStream $this$compresByGzip_u24lambda_u2d2_u24lambda_u2d1 = gZIPOutputStream;
        boolean bl6 = false;
        $this$compresByGzip_u24lambda_u2d2_u24lambda_u2d1.write(data);
        $this$compresByGzip_u24lambda_u2d2_u24lambda_u2d1.finish();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"ByteArrayOutputStream().\u2026    }\n    }.toByteArray()");
        return byArray;
    }

    @NotNull
    public final byte[] gzipCompress(@NotNull byte[] $this$gzipCompress) {
        Intrinsics.checkNotNullParameter((Object)$this$gzipCompress, (String)"<this>");
        return ByteUtils.compresByGzip($this$gzipCompress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    @NotNull
    public static final byte[] uncompressByGzip(@NotNull byte[] data) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Object object = data;
        boolean bl = false;
        object = new GZIPInputStream(new ByteArrayInputStream((byte[])object));
        bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            GZIPInputStream it = (GZIPInputStream)object;
            boolean bl3 = false;
            byArray = ByteStreamsKt.readBytes((InputStream)it);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        return byArray;
    }

    @NotNull
    public final byte[] uncompressGzip(@NotNull byte[] $this$uncompressGzip) {
        Intrinsics.checkNotNullParameter((Object)$this$uncompressGzip, (String)"<this>");
        return ByteUtils.uncompressByGzip($this$uncompressGzip);
    }

    @NotNull
    public final String byteToHex(byte by) {
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = "%02x";
        Object[] objectArray = new Object[]{by & 0xFF};
        boolean bl = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
        return string2;
    }

    @JvmStatic
    @NotNull
    public static final byte[] readBytes(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return FilesKt.readBytes((File)file);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final long countByteArrayList(@NotNull List<byte[]> l) {
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter(l, (String)"l");
        Iterable iterable = l;
        long initial$iv = 0L;
        boolean $i$f$fold = false;
        long accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void i;
            byte[] byArray = (byte[])element$iv;
            long a = accumulator$iv;
            boolean bl = false;
            accumulator$iv = a + (long)((void)i).length;
        }
        return accumulator$iv;
    }

    @Nullable
    public final String bytes2HexStr(@NotNull byte[] src) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        StringBuilder builder = new StringBuilder();
        byte[] byArray = src;
        int n = 0;
        if (byArray.length == 0) {
            return "";
        }
        char[] buffer = new char[2];
        n = 0;
        int n2 = src.length + -1;
        if (n <= n2) {
            do {
                int i = n++;
                buffer[0] = Character.forDigit(src[i] >>> 4 & 0xF, 16);
                byte by = src[i];
                int n3 = 15;
                boolean bl = false;
                buffer[1] = Character.forDigit((byte)(by & n3), 16);
                builder.append(buffer);
            } while (n <= n2);
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"builder.toString()");
        n2 = 0;
        String string2 = string.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026.toUpperCase(Locale.ROOT)");
        return string2;
    }

    @Nullable
    public final String bytes2HexStr(@NotNull byte[] src, int dec, int length) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        byte[] temp = new byte[length];
        System.arraycopy(src, dec, temp, 0, length);
        return this.bytes2HexStr(temp);
    }

    public final long hexStr2decimal(@NotNull String hex) {
        Intrinsics.checkNotNullParameter((Object)hex, (String)"hex");
        String string = hex;
        int n = 16;
        boolean bl = false;
        return Long.parseLong(string, CharsKt.checkRadix((int)n));
    }

    @NotNull
    public final String decimal2fitHex(long num) {
        String string;
        String string2 = Long.toHexString(num);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toHexString(num)");
        boolean bl = false;
        String string3 = string2.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026.toUpperCase(Locale.ROOT)");
        String hex = string3;
        if (hex.length() % 2 != 0) {
            string = Intrinsics.stringPlus((String)"0", (Object)hex);
        } else {
            string2 = hex;
            bl = false;
            String string4 = string2;
            if (string4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.toUpperCase(Locale.ROOT);
            string = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.Strin\u2026.toUpperCase(Locale.ROOT)");
        }
        return string;
    }

    @Nullable
    public final String decimal2fitHex(long num, int strLength) {
        String hexStr = this.decimal2fitHex(num);
        StringBuilder stringBuilder = new StringBuilder(hexStr);
        while (stringBuilder.length() < strLength) {
            stringBuilder.insert(0, '0');
        }
        return stringBuilder.toString();
    }

    @Nullable
    public final String fitDecimalStr(int dicimal, int strLength) {
        StringBuilder builder = new StringBuilder(String.valueOf(dicimal));
        while (builder.length() < strLength) {
            builder.insert(0, "0");
        }
        return builder.toString();
    }
}

