/*
 * Decompiled with CFR 0.152.
 */
package xyz.junerver.utils;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import android.util.Log;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Stack;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0002J\b\u0010\t\u001a\u00020\u0007H\u0007J\u000e\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005J\u0016\u0010\n\u001a\u00020\u00072\u000e\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\fJ\u0012\u0010\r\u001a\u00020\u000e2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\fJ\u0006\u0010\u000f\u001a\u00020\u0007J\u0012\u0010\u0010\u001a\u00020\u00072\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\fJ'\u0010\u0011\u001a\u0004\u0018\u0001H\u0012\"\b\b\u0000\u0010\u0012*\u00020\u00052\u000e\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\f\u00a2\u0006\u0002\u0010\u0013J\u0006\u0010\u0014\u001a\u00020\u0005J\u000e\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0017J\u0010\u0010\u0018\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lxyz/junerver/utils/ActivityManager;", "", "()V", "activityStack", "Ljava/util/Stack;", "Landroid/app/Activity;", "add", "", "activity", "appExit", "finish", "clazz", "Ljava/lang/Class;", "finishActivityAfter", "", "finishAll", "finishAllExclude", "get", "A", "(Ljava/lang/Class;)Landroid/app/Activity;", "peek", "register", "app", "Landroid/app/Application;", "remove", "utils_release"})
public final class ActivityManager {
    @NotNull
    public static final ActivityManager INSTANCE = new ActivityManager();
    @NotNull
    private static final Stack<Activity> activityStack = new Stack();

    private ActivityManager() {
    }

    public final void register(@NotNull Application app) {
        Intrinsics.checkNotNullParameter((Object)app, (String)"app");
        app.registerActivityLifecycleCallbacks(new Application.ActivityLifecycleCallbacks(){

            public void onActivityCreated(@NotNull Activity activity, @Nullable Bundle savedInstanceState) {
                Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
                ActivityManager.access$add(ActivityManager.INSTANCE, activity);
            }

            public void onActivityStarted(@NotNull Activity activity) {
                Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            }

            public void onActivityResumed(@NotNull Activity activity) {
                Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            }

            public void onActivityPaused(@NotNull Activity activity) {
                Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            }

            public void onActivityStopped(@NotNull Activity activity) {
                Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            }

            public void onActivitySaveInstanceState(@NotNull Activity activity, @NotNull Bundle outState) {
                Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
                Intrinsics.checkNotNullParameter((Object)outState, (String)"outState");
            }

            public void onActivityDestroyed(@NotNull Activity activity) {
                Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
                ActivityManager.access$remove(ActivityManager.INSTANCE, activity);
            }
        });
    }

    private final void add(Activity activity) {
        activityStack.add(activity);
        Log.d((String)"AppManager---->>", (String)("add---->>" + activity + " size---->>" + activityStack.size()));
    }

    private final void remove(Activity activity) {
        if (activityStack.contains(activity)) {
            activityStack.remove(activity);
            Log.d((String)"AppManager---->>", (String)("remove---->>" + activity + " size---->>" + activityStack.size()));
        }
    }

    public final void finish(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        if (activityStack.contains(activity) && !activity.isFinishing()) {
            activity.finish();
        }
    }

    public final void finish(@NotNull Class<? extends Activity> clazz) {
        Activity del;
        Object v0;
        Activity it;
        block3: {
            Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
            List $this$lastOrNull$iv = activityStack;
            boolean $i$f$lastOrNull = false;
            ListIterator iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
            while (iterator$iv.hasPrevious()) {
                Object element$iv = iterator$iv.previous();
                it = (Activity)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getClass(), clazz)) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        Activity activity = del = (Activity)v0;
        if (activity != null) {
            Activity activity2 = activity;
            boolean bl = false;
            boolean bl2 = false;
            it = activity2;
            boolean bl3 = false;
            if (!it.isFinishing()) {
                it.finish();
            }
        }
    }

    @NotNull
    public final Activity peek() {
        Activity activity = activityStack.peek();
        Intrinsics.checkNotNullExpressionValue((Object)activity, (String)"activityStack.peek()");
        return activity;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final <A extends Activity> A get(@NotNull Class<? extends Activity> clazz) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Activity target = null;
        Iterable $this$filter$iv = activityStack;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Activity it = (Activity)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual(it.getClass(), clazz)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Activity it = (Activity)element$iv;
            boolean bl = false;
            if (it == null) {
                throw new NullPointerException("null cannot be cast to non-null type A of xyz.junerver.utils.ActivityManager.get$lambda-3");
            }
            target = it;
        }
        return (A)target;
    }

    public final void finishAll() {
        for (Activity activity : activityStack) {
            activity.finish();
        }
        activityStack.clear();
        Log.d((String)"AppManager---->>", (String)"Finish All Activity!");
    }

    /*
     * WARNING - void declaration
     */
    public final void finishAllExclude(@NotNull Class<?> clazz) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Log.d((String)"AppManager---->>", (String)Intrinsics.stringPlus((String)"\u8c03\u7528\u4e86\u5173\u95ed\u4e1a\u52a1\uff0c\u6392\u9664", (Object)clazz.getName()));
        Iterable $this$filter$iv = activityStack;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Activity it = (Activity)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual(it.getClass(), clazz))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Activity it = (Activity)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            INSTANCE.finish(it);
        }
    }

    public final boolean finishActivityAfter(@NotNull Class<?> clazz) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Activity last = this.peek();
        if (Intrinsics.areEqual(last.getClass(), clazz)) {
            return true;
        }
        this.finish(last);
        Log.d((String)"AppManager---->>", (String)Intrinsics.stringPlus((String)"+++++++\u6267\u884c\u5173\u95ed\uff1a", (Object)last));
        this.finishActivityAfter(clazz);
        return false;
    }

    @SuppressLint(value={"MissingPermission"})
    public final void appExit() {
        try {
            this.finishAll();
            Object object = this.peek().getSystemService("activity");
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.app.ActivityManager");
            }
            android.app.ActivityManager activityMgr = (android.app.ActivityManager)object;
            activityMgr.killBackgroundProcesses(this.peek().getPackageName());
            int n = 0;
            boolean bl = false;
            System.exit(n);
            throw (Throwable)new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
        catch (Exception e) {
            Log.d((String)"AppManager---->>", (String)"Application Exit!");
            return;
        }
    }

    public static final /* synthetic */ void access$add(ActivityManager $this, Activity activity) {
        $this.add(activity);
    }

    public static final /* synthetic */ void access$remove(ActivityManager $this, Activity activity) {
        $this.remove(activity);
    }
}

