/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.api;

import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.framework.qual.DefaultQualifier;
import xyz.jpenilla.squaremap.api.MapWorld;
import xyz.jpenilla.squaremap.api.Point;
import xyz.jpenilla.squaremap.api.WorldIdentifier;

@DefaultQualifier(value=NonNull.class)
public final class BukkitAdapter {
    private BukkitAdapter() {
    }

    public static WorldIdentifier worldIdentifier(World world) {
        return WorldIdentifier.create(world.key().namespace(), world.key().value());
    }

    public static NamespacedKey namespacedKey(WorldIdentifier worldIdentifier) {
        return Objects.requireNonNull(NamespacedKey.fromString((String)worldIdentifier.asString()));
    }

    public static World bukkitWorld(MapWorld world) {
        return Objects.requireNonNull(Bukkit.getWorld((NamespacedKey)BukkitAdapter.namespacedKey(world.identifier())));
    }

    public static Point point(Location location) {
        return Point.point(location.getBlockX(), location.getBlockZ());
    }
}

