/*
 * Decompiled with CFR 0.152.
 */
package xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model.OneOfFDUserAccountUpdateTransactionRequestAccountKey;

@Schema(description="User Fee Delegation account update transaction request schema")
public class FDUserAccountUpdateTransactionRequest {
    @SerializedName(value="from")
    private String from = null;
    @SerializedName(value="accountKey")
    private OneOfFDUserAccountUpdateTransactionRequestAccountKey accountKey = null;
    @SerializedName(value="nonce")
    private Long nonce = null;
    @SerializedName(value="gas")
    private Long gas = 100000L;
    @SerializedName(value="submit")
    private Boolean submit = null;
    @SerializedName(value="feeRatio")
    private Long feeRatio = null;
    @SerializedName(value="feePayer")
    private String feePayer = null;

    public FDUserAccountUpdateTransactionRequest from(String from) {
        this.from = from;
        return this;
    }

    @Schema(example="17167676035064863860407789534899914070776312344", required=true, description="Klaytn transaction address to send transaction")
    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public FDUserAccountUpdateTransactionRequest accountKey(OneOfFDUserAccountUpdateTransactionRequestAccountKey accountKey) {
        this.accountKey = accountKey;
        return this;
    }

    @Schema(description="")
    public OneOfFDUserAccountUpdateTransactionRequestAccountKey getAccountKey() {
        return this.accountKey;
    }

    public void setAccountKey(OneOfFDUserAccountUpdateTransactionRequestAccountKey accountKey) {
        this.accountKey = accountKey;
    }

    public FDUserAccountUpdateTransactionRequest nonce(Long nonce) {
        this.nonce = nonce;
        return this;
    }

    @Schema(example="0", description="Unique identifier for the transactions being sent (By entering 0, the nonce will be automatically determined)")
    public Long getNonce() {
        return this.nonce;
    }

    public void setNonce(Long nonce) {
        this.nonce = nonce;
    }

    public FDUserAccountUpdateTransactionRequest gas(Long gas) {
        this.gas = gas;
        return this;
    }

    @Schema(example="0", description="Maximum gas fee to be used for sending the transaction (By entering 0, it will be set to default value))")
    public Long getGas() {
        return this.gas;
    }

    public void setGas(Long gas) {
        this.gas = gas;
    }

    public FDUserAccountUpdateTransactionRequest submit(Boolean submit) {
        this.submit = submit;
        return this;
    }

    @Schema(example="true", description="Shows whether to send the transaction to Klaytn")
    public Boolean isSubmit() {
        return this.submit;
    }

    public void setSubmit(Boolean submit) {
        this.submit = submit;
    }

    public FDUserAccountUpdateTransactionRequest feeRatio(Long feeRatio) {
        this.feeRatio = feeRatio;
        return this;
    }

    @Schema(example="20", description="The ratio of the gas fee to be delegated. When it's empty or 0, the entire fee will be delegated.")
    public Long getFeeRatio() {
        return this.feeRatio;
    }

    public void setFeeRatio(Long feeRatio) {
        this.feeRatio = feeRatio;
    }

    public FDUserAccountUpdateTransactionRequest feePayer(String feePayer) {
        this.feePayer = feePayer;
        return this;
    }

    @Schema(example="415487481437216765516808935831180170585317837885", required=true, description="Account address for user Fee Delegation")
    public String getFeePayer() {
        return this.feePayer;
    }

    public void setFeePayer(String feePayer) {
        this.feePayer = feePayer;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FDUserAccountUpdateTransactionRequest fdUserAccountUpdateTransactionRequest = (FDUserAccountUpdateTransactionRequest)o;
        return Objects.equals(this.from, fdUserAccountUpdateTransactionRequest.from) && Objects.equals(this.accountKey, fdUserAccountUpdateTransactionRequest.accountKey) && Objects.equals(this.nonce, fdUserAccountUpdateTransactionRequest.nonce) && Objects.equals(this.gas, fdUserAccountUpdateTransactionRequest.gas) && Objects.equals(this.submit, fdUserAccountUpdateTransactionRequest.submit) && Objects.equals(this.feeRatio, fdUserAccountUpdateTransactionRequest.feeRatio) && Objects.equals(this.feePayer, fdUserAccountUpdateTransactionRequest.feePayer);
    }

    public int hashCode() {
        return Objects.hash(this.from, this.accountKey, this.nonce, this.gas, this.submit, this.feeRatio, this.feePayer);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FDUserAccountUpdateTransactionRequest {\n");
        sb.append("    from: ").append(this.toIndentedString(this.from)).append("\n");
        sb.append("    accountKey: ").append(this.toIndentedString(this.accountKey)).append("\n");
        sb.append("    nonce: ").append(this.toIndentedString(this.nonce)).append("\n");
        sb.append("    gas: ").append(this.toIndentedString(this.gas)).append("\n");
        sb.append("    submit: ").append(this.toIndentedString(this.submit)).append("\n");
        sb.append("    feeRatio: ").append(this.toIndentedString(this.feeRatio)).append("\n");
        sb.append("    feePayer: ").append(this.toIndentedString(this.feePayer)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

