/*
 * Decompiled with CFR 0.152.
 */
package xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model.Signature;

@Schema(description="Data on Fee Delegation transaction sent to Klaytn")
public class FDTransactionResult {
    @SerializedName(value="feePayer")
    private String feePayer = null;
    @SerializedName(value="from")
    private String from = null;
    @SerializedName(value="gas")
    private Long gas = null;
    @SerializedName(value="gasPrice")
    private String gasPrice = null;
    @SerializedName(value="input")
    private String input = null;
    @SerializedName(value="nonce")
    private Long nonce = null;
    @SerializedName(value="rlp")
    private String rlp = null;
    @SerializedName(value="signatures")
    private List<Signature> signatures = null;
    @SerializedName(value="status")
    private String status = null;
    @SerializedName(value="to")
    private String to = null;
    @SerializedName(value="transactionHash")
    private String transactionHash = null;
    @SerializedName(value="typeInt")
    private Long typeInt = null;
    @SerializedName(value="value")
    private String value = null;
    @SerializedName(value="feeRatio")
    private Long feeRatio = null;
    @SerializedName(value="transactionId")
    private String transactionId = null;
    @SerializedName(value="accountKey")
    private String accountKey = null;

    public FDTransactionResult feePayer(String feePayer) {
        this.feePayer = feePayer;
        return this;
    }

    @Schema(example="763432954551381522585311052201016684070466679514", required=true, description="Account address for Fee Delegation")
    public String getFeePayer() {
        return this.feePayer;
    }

    public void setFeePayer(String feePayer) {
        this.feePayer = feePayer;
    }

    public FDTransactionResult from(String from) {
        this.from = from;
        return this;
    }

    @Schema(example="494412890328984143338987764305042337754097889212", required=true, description="Klaytn account address that sent the transaction")
    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public FDTransactionResult gas(Long gas) {
        this.gas = gas;
        return this;
    }

    @Schema(example="1000000", required=true, description="Maximum gas fee to be used for sending the transaction")
    public Long getGas() {
        return this.gas;
    }

    public void setGas(Long gas) {
        this.gas = gas;
    }

    public FDTransactionResult gasPrice(String gasPrice) {
        this.gasPrice = gasPrice;
        return this;
    }

    @Schema(example="25000000000", required=true, description="Gas fee used for sending the transaction")
    public String getGasPrice() {
        return this.gasPrice;
    }

    public void setGasPrice(String gasPrice) {
        this.gasPrice = gasPrice;
    }

    public FDTransactionResult input(String input) {
        this.input = input;
        return this;
    }

    @Schema(example="1835363695", description="Data that's sent along with the transaction to Klaytn")
    public String getInput() {
        return this.input;
    }

    public void setInput(String input) {
        this.input = input;
    }

    public FDTransactionResult nonce(Long nonce) {
        this.nonce = nonce;
        return this;
    }

    @Schema(example="0", required=true, description="Number of total transactions from the sender of the current transaction")
    public Long getNonce() {
        return this.nonce;
    }

    public void setNonce(Long nonce) {
        this.nonce = nonce;
    }

    public FDTransactionResult rlp(String rlp) {
        this.rlp = rlp;
        return this;
    }

    @Schema(example="21543362170862987160532759405285724341688488119401133512121888728211325996462256971786373065473031659212716670441833881856001534901178767123646838253624894611469466893475337455453397403159804173560093149933180980094405894306461531443732612155779657439595599045719136621253478003193473435175308136001282310571142403422714371273192950930064426224597891791601791371479447361008614572790547368994874414445579505020169137783489227466624328708754519410434727390909639121990723093494144098934859152971353631304707621970684205850747173643374216117003756964214", required=true, description="RLP serialization of the transaction")
    public String getRlp() {
        return this.rlp;
    }

    public void setRlp(String rlp) {
        this.rlp = rlp;
    }

    public FDTransactionResult signatures(List<Signature> signatures) {
        this.signatures = signatures;
        return this;
    }

    public FDTransactionResult addSignaturesItem(Signature signaturesItem) {
        if (this.signatures == null) {
            this.signatures = new ArrayList<Signature>();
        }
        this.signatures.add(signaturesItem);
        return this;
    }

    @Schema(description="")
    public List<Signature> getSignatures() {
        return this.signatures;
    }

    public void setSignatures(List<Signature> signatures) {
        this.signatures = signatures;
    }

    public FDTransactionResult status(String status) {
        this.status = status;
        return this;
    }

    @Schema(example="Submitted", description="Status after the transaction has been sent (\"Submitted\" or \"Pending\")")
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public FDTransactionResult to(String to) {
        this.to = to;
        return this;
    }

    @Schema(example="271349404039472841903043818917408955243066032220", description="KLAY receiver's Klaytn account address")
    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public FDTransactionResult transactionHash(String transactionHash) {
        this.transactionHash = transactionHash;
        return this;
    }

    @Schema(example="5080561897477723819943394876527736912860154607131733465668295064399354889168", description="Hash value of the transaction")
    public String getTransactionHash() {
        return this.transactionHash;
    }

    public void setTransactionHash(String transactionHash) {
        this.transactionHash = transactionHash;
    }

    public FDTransactionResult typeInt(Long typeInt) {
        this.typeInt = typeInt;
        return this;
    }

    @Schema(example="17", required=true, description="Integer that represents the transaction type")
    public Long getTypeInt() {
        return this.typeInt;
    }

    public void setTypeInt(Long typeInt) {
        this.typeInt = typeInt;
    }

    public FDTransactionResult value(String value) {
        this.value = value;
        return this;
    }

    @Schema(example="18", description="KLAY converted into PEB")
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public FDTransactionResult feeRatio(Long feeRatio) {
        this.feeRatio = feeRatio;
        return this;
    }

    @Schema(example="30", description="Fee ratio between the sender's account and fee payer account")
    public Long getFeeRatio() {
        return this.feeRatio;
    }

    public void setFeeRatio(Long feeRatio) {
        this.feeRatio = feeRatio;
    }

    public FDTransactionResult transactionId(String transactionId) {
        this.transactionId = transactionId;
        return this;
    }

    @Schema(example="30146440150934903265559699252189987398379850178886863518502813646572303540142", description="Multisig transaction ID")
    public String getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public FDTransactionResult accountKey(String accountKey) {
        this.accountKey = accountKey;
        return this;
    }

    @Schema(example="448", description="Newly updated account key")
    public String getAccountKey() {
        return this.accountKey;
    }

    public void setAccountKey(String accountKey) {
        this.accountKey = accountKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FDTransactionResult fdTransactionResult = (FDTransactionResult)o;
        return Objects.equals(this.feePayer, fdTransactionResult.feePayer) && Objects.equals(this.from, fdTransactionResult.from) && Objects.equals(this.gas, fdTransactionResult.gas) && Objects.equals(this.gasPrice, fdTransactionResult.gasPrice) && Objects.equals(this.input, fdTransactionResult.input) && Objects.equals(this.nonce, fdTransactionResult.nonce) && Objects.equals(this.rlp, fdTransactionResult.rlp) && Objects.equals(this.signatures, fdTransactionResult.signatures) && Objects.equals(this.status, fdTransactionResult.status) && Objects.equals(this.to, fdTransactionResult.to) && Objects.equals(this.transactionHash, fdTransactionResult.transactionHash) && Objects.equals(this.typeInt, fdTransactionResult.typeInt) && Objects.equals(this.value, fdTransactionResult.value) && Objects.equals(this.feeRatio, fdTransactionResult.feeRatio) && Objects.equals(this.transactionId, fdTransactionResult.transactionId) && Objects.equals(this.accountKey, fdTransactionResult.accountKey);
    }

    public int hashCode() {
        return Objects.hash(this.feePayer, this.from, this.gas, this.gasPrice, this.input, this.nonce, this.rlp, this.signatures, this.status, this.to, this.transactionHash, this.typeInt, this.value, this.feeRatio, this.transactionId, this.accountKey);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FDTransactionResult {\n");
        sb.append("    feePayer: ").append(this.toIndentedString(this.feePayer)).append("\n");
        sb.append("    from: ").append(this.toIndentedString(this.from)).append("\n");
        sb.append("    gas: ").append(this.toIndentedString(this.gas)).append("\n");
        sb.append("    gasPrice: ").append(this.toIndentedString(this.gasPrice)).append("\n");
        sb.append("    input: ").append(this.toIndentedString(this.input)).append("\n");
        sb.append("    nonce: ").append(this.toIndentedString(this.nonce)).append("\n");
        sb.append("    rlp: ").append(this.toIndentedString(this.rlp)).append("\n");
        sb.append("    signatures: ").append(this.toIndentedString(this.signatures)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    to: ").append(this.toIndentedString(this.to)).append("\n");
        sb.append("    transactionHash: ").append(this.toIndentedString(this.transactionHash)).append("\n");
        sb.append("    typeInt: ").append(this.toIndentedString(this.typeInt)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    feeRatio: ").append(this.toIndentedString(this.feeRatio)).append("\n");
        sb.append("    transactionId: ").append(this.toIndentedString(this.transactionId)).append("\n");
        sb.append("    accountKey: ").append(this.toIndentedString(this.accountKey)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

