/*
 * Decompiled with CFR 0.152.
 */
package xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.ApiCallback;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.ApiClient;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.ApiException;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.ApiResponse;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.Configuration;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.Pair;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.ProgressRequestBody;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.ProgressResponseBody;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model.MultisigTransactionStatus;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model.MultisigTransactions;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model.SignPendingTransactionBySigRequest;

public class MultisigTxApi {
    private ApiClient apiClient;

    public MultisigTxApi() {
        this(Configuration.getDefaultApiClient());
    }

    public MultisigTxApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call retrieveMultisigTransactionsCall(String xChainId, String address, Long size, String cursor, Long toTimestamp, Long fromTimestamp, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v2/multisig/account/{address}/tx".replaceAll("\\{address\\}", this.apiClient.escapeString(address.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (size != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("size", size));
        }
        if (cursor != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("cursor", cursor));
        }
        if (toTimestamp != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("to-timestamp", toTimestamp));
        }
        if (fromTimestamp != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("from-timestamp", fromTimestamp));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xChainId != null) {
            localVarHeaderParams.put("x-chain-id", this.apiClient.parameterToString(xChainId));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call retrieveMultisigTransactionsValidateBeforeCall(String xChainId, String address, Long size, String cursor, Long toTimestamp, Long fromTimestamp, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (xChainId == null) {
            throw new ApiException("Missing the required parameter 'xChainId' when calling retrieveMultisigTransactions(Async)");
        }
        if (address == null) {
            throw new ApiException("Missing the required parameter 'address' when calling retrieveMultisigTransactions(Async)");
        }
        Call call = this.retrieveMultisigTransactionsCall(xChainId, address, size, cursor, toTimestamp, fromTimestamp, progressListener, progressRequestListener);
        return call;
    }

    public MultisigTransactions retrieveMultisigTransactions(String xChainId, String address, Long size, String cursor, Long toTimestamp, Long fromTimestamp) throws ApiException {
        ApiResponse<MultisigTransactions> resp = this.retrieveMultisigTransactionsWithHttpInfo(xChainId, address, size, cursor, toTimestamp, fromTimestamp);
        return resp.getData();
    }

    public ApiResponse<MultisigTransactions> retrieveMultisigTransactionsWithHttpInfo(String xChainId, String address, Long size, String cursor, Long toTimestamp, Long fromTimestamp) throws ApiException {
        Call call = this.retrieveMultisigTransactionsValidateBeforeCall(xChainId, address, size, cursor, toTimestamp, fromTimestamp, null, null);
        Type localVarReturnType = new TypeToken<MultisigTransactions>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call retrieveMultisigTransactionsAsync(String xChainId, String address, Long size, String cursor, Long toTimestamp, Long fromTimestamp, final ApiCallback<MultisigTransactions> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.retrieveMultisigTransactionsValidateBeforeCall(xChainId, address, size, cursor, toTimestamp, fromTimestamp, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<MultisigTransactions>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call signPendingTransactionCall(String xChainId, String address, String transactionId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v2/multisig/account/{address}/tx/{transaction-id}/sign".replaceAll("\\{address\\}", this.apiClient.escapeString(address.toString())).replaceAll("\\{transaction-id\\}", this.apiClient.escapeString(transactionId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xChainId != null) {
            localVarHeaderParams.put("x-chain-id", this.apiClient.parameterToString(xChainId));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call signPendingTransactionValidateBeforeCall(String xChainId, String address, String transactionId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (xChainId == null) {
            throw new ApiException("Missing the required parameter 'xChainId' when calling signPendingTransaction(Async)");
        }
        if (address == null) {
            throw new ApiException("Missing the required parameter 'address' when calling signPendingTransaction(Async)");
        }
        if (transactionId == null) {
            throw new ApiException("Missing the required parameter 'transactionId' when calling signPendingTransaction(Async)");
        }
        Call call = this.signPendingTransactionCall(xChainId, address, transactionId, progressListener, progressRequestListener);
        return call;
    }

    public MultisigTransactionStatus signPendingTransaction(String xChainId, String address, String transactionId) throws ApiException {
        ApiResponse<MultisigTransactionStatus> resp = this.signPendingTransactionWithHttpInfo(xChainId, address, transactionId);
        return resp.getData();
    }

    public ApiResponse<MultisigTransactionStatus> signPendingTransactionWithHttpInfo(String xChainId, String address, String transactionId) throws ApiException {
        Call call = this.signPendingTransactionValidateBeforeCall(xChainId, address, transactionId, null, null);
        Type localVarReturnType = new TypeToken<MultisigTransactionStatus>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call signPendingTransactionAsync(String xChainId, String address, String transactionId, final ApiCallback<MultisigTransactionStatus> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.signPendingTransactionValidateBeforeCall(xChainId, address, transactionId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<MultisigTransactionStatus>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call signPendingTransactionBySigCall(String xChainId, String transactionId, SignPendingTransactionBySigRequest body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        SignPendingTransactionBySigRequest localVarPostBody = body;
        String localVarPath = "/v2/multisig/tx/{transaction-id}/sign".replaceAll("\\{transaction-id\\}", this.apiClient.escapeString(transactionId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xChainId != null) {
            localVarHeaderParams.put("x-chain-id", this.apiClient.parameterToString(xChainId));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call signPendingTransactionBySigValidateBeforeCall(String xChainId, String transactionId, SignPendingTransactionBySigRequest body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (xChainId == null) {
            throw new ApiException("Missing the required parameter 'xChainId' when calling signPendingTransactionBySig(Async)");
        }
        if (transactionId == null) {
            throw new ApiException("Missing the required parameter 'transactionId' when calling signPendingTransactionBySig(Async)");
        }
        Call call = this.signPendingTransactionBySigCall(xChainId, transactionId, body, progressListener, progressRequestListener);
        return call;
    }

    public MultisigTransactionStatus signPendingTransactionBySig(String xChainId, String transactionId, SignPendingTransactionBySigRequest body) throws ApiException {
        ApiResponse<MultisigTransactionStatus> resp = this.signPendingTransactionBySigWithHttpInfo(xChainId, transactionId, body);
        return resp.getData();
    }

    public ApiResponse<MultisigTransactionStatus> signPendingTransactionBySigWithHttpInfo(String xChainId, String transactionId, SignPendingTransactionBySigRequest body) throws ApiException {
        Call call = this.signPendingTransactionBySigValidateBeforeCall(xChainId, transactionId, body, null, null);
        Type localVarReturnType = new TypeToken<MultisigTransactionStatus>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call signPendingTransactionBySigAsync(String xChainId, String transactionId, SignPendingTransactionBySigRequest body, final ApiCallback<MultisigTransactionStatus> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.signPendingTransactionBySigValidateBeforeCall(xChainId, transactionId, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<MultisigTransactionStatus>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

