/*
 * Decompiled with CFR 0.152.
 */
package xyz.groundx.caver_ext_kas.kas.kip17;

import com.squareup.okhttp.Call;
import java.math.BigInteger;
import org.web3j.utils.Numeric;
import xyz.groundx.caver_ext_kas.kas.kip17.KIP17QueryOptions;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.ApiCallback;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.ApiClient;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.ApiException;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip17.api.Kip17ContractApi;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip17.api.Kip17TokenApi;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip17.model.ApproveAllKip17Request;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip17.model.ApproveKip17TokenRequest;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip17.model.BurnKip17TokenRequest;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip17.model.DeployKip17ContractRequest;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip17.model.GetKip17TokenHistoryResponse;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip17.model.GetKip17TokenResponse;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip17.model.GetOwnerKip17TokensResponse;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip17.model.Kip17ContractInfoResponse;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip17.model.Kip17ContractListResponse;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip17.model.Kip17DeployResponse;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip17.model.Kip17FeePayerOptions;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip17.model.Kip17TokenListResponse;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip17.model.Kip17TransactionStatusResponse;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip17.model.MintKip17TokenRequest;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip17.model.TransferKip17TokenRequest;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip17.model.UpdateKip17ContractRequest;

public class KIP17 {
    Kip17ContractApi kip17ContractApi;
    Kip17TokenApi kip17TokenApi;
    String chainId;
    ApiClient apiClient;

    public KIP17(String chainId, ApiClient client) {
        this.setChainId(chainId);
        this.setApiClient(client);
    }

    public Kip17DeployResponse deploy(String name, String symbol, String alias) throws ApiException {
        return this.deploy(name, symbol, alias, null);
    }

    public Kip17DeployResponse deploy(String name, String symbol, String alias, Kip17FeePayerOptions options) throws ApiException {
        DeployKip17ContractRequest request = new DeployKip17ContractRequest();
        request.setName(name);
        request.setSymbol(symbol);
        request.setAlias(alias);
        request.setOptions(options);
        return this.kip17ContractApi.deployContract(this.chainId, request);
    }

    public Call deployAsync(String name, String symbol, String alias, ApiCallback<Kip17DeployResponse> callback) throws ApiException {
        return this.deployAsync(name, symbol, alias, null, callback);
    }

    public Call deployAsync(String name, String symbol, String alias, Kip17FeePayerOptions options, ApiCallback<Kip17DeployResponse> callback) throws ApiException {
        DeployKip17ContractRequest request = new DeployKip17ContractRequest();
        request.setName(name);
        request.setSymbol(symbol);
        request.setAlias(alias);
        request.setOptions(options);
        return this.kip17ContractApi.deployContractAsync(this.chainId, request, callback);
    }

    public Kip17ContractInfoResponse updateContractOptions(String addressOrAlias) throws ApiException {
        return this.updateContractOptions(addressOrAlias, null);
    }

    public Kip17ContractInfoResponse updateContractOptions(String addressOrAlias, Kip17FeePayerOptions options) throws ApiException {
        UpdateKip17ContractRequest request = new UpdateKip17ContractRequest();
        request.setOptions(options);
        return this.kip17ContractApi.updateContract(this.chainId, addressOrAlias, request);
    }

    public Call updateContractOptionsAsync(String addressOrAlias, ApiCallback<Kip17ContractInfoResponse> callback) throws ApiException {
        return this.updateContractOptionsAsync(addressOrAlias, null, callback);
    }

    public Call updateContractOptionsAsync(String addressOrAlias, Kip17FeePayerOptions options, ApiCallback<Kip17ContractInfoResponse> callback) throws ApiException {
        UpdateKip17ContractRequest request = new UpdateKip17ContractRequest();
        request.setOptions(options);
        return this.kip17ContractApi.updateContractAsync(this.chainId, addressOrAlias, request, callback);
    }

    public Kip17ContractListResponse getContractList() throws ApiException {
        KIP17QueryOptions options = new KIP17QueryOptions();
        return this.getContractList(options);
    }

    public Kip17ContractListResponse getContractList(KIP17QueryOptions options) throws ApiException {
        String size = options.getSize() != null ? Long.toString(options.getSize()) : null;
        return this.kip17ContractApi.listContractsInDeployerPool(this.chainId, size, options.getCursor());
    }

    public Call getContractListAsync(ApiCallback<Kip17ContractListResponse> callback) throws ApiException {
        KIP17QueryOptions options = new KIP17QueryOptions();
        return this.getContractListAsync(options, callback);
    }

    public Call getContractListAsync(KIP17QueryOptions options, ApiCallback<Kip17ContractListResponse> callback) throws ApiException {
        String size = options.getSize() != null ? Long.toString(options.getSize()) : null;
        return this.kip17ContractApi.listContractsInDeployerPoolAsync(this.chainId, size, options.getCursor(), callback);
    }

    public Kip17ContractInfoResponse getContract(String addressOrAlias) throws ApiException {
        return this.kip17ContractApi.getContract(this.chainId, addressOrAlias);
    }

    public Call getContractAsync(String addressOrAlias, ApiCallback<Kip17ContractInfoResponse> callback) throws ApiException {
        return this.kip17ContractApi.getContractAsync(this.chainId, addressOrAlias, callback);
    }

    public Kip17TransactionStatusResponse mint(String addressOrAlias, String to, BigInteger id, String uri) throws ApiException {
        return this.mint(addressOrAlias, to, Numeric.toHexStringWithPrefix((BigInteger)id), uri);
    }

    public Kip17TransactionStatusResponse mint(String addressOrAlias, String to, String id, String uri) throws ApiException {
        MintKip17TokenRequest request = new MintKip17TokenRequest();
        request.setId(id);
        request.setTo(to);
        request.setUri(uri);
        return this.kip17TokenApi.mintToken(this.chainId, addressOrAlias, request, null);
    }

    public Call mintAsync(String addressOrAlias, String to, BigInteger id, String uri, ApiCallback<Kip17TransactionStatusResponse> callback) throws ApiException {
        return this.mintAsync(addressOrAlias, to, Numeric.toHexStringWithPrefix((BigInteger)id), uri, callback);
    }

    public Call mintAsync(String addressOrAlias, String to, String id, String uri, ApiCallback<Kip17TransactionStatusResponse> callback) throws ApiException {
        MintKip17TokenRequest request = new MintKip17TokenRequest();
        request.setId(id);
        request.setTo(to);
        request.setUri(uri);
        return this.kip17TokenApi.mintTokenAsync(this.chainId, addressOrAlias, request, null, callback);
    }

    public Kip17TokenListResponse getTokenList(String addressOrAlias) throws ApiException {
        KIP17QueryOptions options = new KIP17QueryOptions();
        return this.getTokenList(addressOrAlias, options);
    }

    public Kip17TokenListResponse getTokenList(String addressOrAlias, KIP17QueryOptions options) throws ApiException {
        return this.kip17TokenApi.listTokens(this.chainId, addressOrAlias, options.getSize(), options.getCursor());
    }

    public Call getTokenListAsync(String addressOrAlias, ApiCallback<Kip17TokenListResponse> callback) throws ApiException {
        KIP17QueryOptions options = new KIP17QueryOptions();
        return this.getTokenListAsync(addressOrAlias, options, callback);
    }

    public Call getTokenListAsync(String addressOrAlias, KIP17QueryOptions options, ApiCallback<Kip17TokenListResponse> callback) throws ApiException {
        return this.kip17TokenApi.listTokensAsync(this.chainId, addressOrAlias, options.getSize(), options.getCursor(), callback);
    }

    public GetKip17TokenResponse getToken(String addressOrAlias, BigInteger tokenId) throws ApiException {
        return this.getToken(addressOrAlias, Numeric.toHexStringWithPrefix((BigInteger)tokenId));
    }

    public GetKip17TokenResponse getToken(String addressOrAlias, String tokenId) throws ApiException {
        return this.kip17TokenApi.getToken(this.chainId, addressOrAlias, tokenId);
    }

    public Call getTokenAsync(String addressOrAlias, BigInteger tokenId, ApiCallback<GetKip17TokenResponse> callback) throws ApiException {
        return this.getTokenAsync(addressOrAlias, Numeric.toHexStringWithPrefix((BigInteger)tokenId), callback);
    }

    public Call getTokenAsync(String addressOrAlias, String tokenId, ApiCallback<GetKip17TokenResponse> callback) throws ApiException {
        return this.kip17TokenApi.getTokenAsync(this.chainId, addressOrAlias, tokenId, callback);
    }

    public Kip17TransactionStatusResponse transfer(String addressOrAlias, String sender, String owner, String to, BigInteger tokenId) throws ApiException {
        return this.transfer(addressOrAlias, sender, owner, to, Numeric.toHexStringWithPrefix((BigInteger)tokenId));
    }

    public Kip17TransactionStatusResponse transfer(String addressOrAlias, String sender, String owner, String to, String tokenId) throws ApiException {
        TransferKip17TokenRequest request = new TransferKip17TokenRequest();
        request.setSender(sender);
        request.setOwner(owner);
        request.setTo(to);
        return this.kip17TokenApi.transferToken(this.chainId, addressOrAlias, tokenId, request, null);
    }

    public Call transferAsync(String addressOrAlias, String sender, String owner, String to, BigInteger tokenId, ApiCallback<Kip17TransactionStatusResponse> callback) throws ApiException {
        return this.transferAsync(addressOrAlias, sender, owner, to, Numeric.toHexStringWithPrefix((BigInteger)tokenId), callback);
    }

    public Call transferAsync(String addressOrAlias, String sender, String owner, String to, String tokenId, ApiCallback<Kip17TransactionStatusResponse> callback) throws ApiException {
        TransferKip17TokenRequest request = new TransferKip17TokenRequest();
        request.setSender(sender);
        request.setOwner(owner);
        request.setTo(to);
        return this.kip17TokenApi.transferTokenAsync(this.chainId, addressOrAlias, tokenId, request, null, callback);
    }

    public Kip17TransactionStatusResponse burn(String addressOrAlias, String from, BigInteger tokenId) throws ApiException {
        return this.burn(addressOrAlias, from, Numeric.toHexStringWithPrefix((BigInteger)tokenId));
    }

    public Kip17TransactionStatusResponse burn(String addressOrAlias, String from, String tokenId) throws ApiException {
        BurnKip17TokenRequest request = new BurnKip17TokenRequest();
        request.setFrom(from);
        return this.kip17TokenApi.burnToken(this.chainId, addressOrAlias, tokenId, request, null);
    }

    public Call burnAsync(String addressOrAlias, String from, BigInteger tokenId, ApiCallback<Kip17TransactionStatusResponse> callback) throws ApiException {
        return this.burnAsync(addressOrAlias, from, Numeric.toHexStringWithPrefix((BigInteger)tokenId), callback);
    }

    public Call burnAsync(String addressOrAlias, String from, String tokenId, ApiCallback<Kip17TransactionStatusResponse> callback) throws ApiException {
        BurnKip17TokenRequest request = new BurnKip17TokenRequest();
        request.setFrom(from);
        return this.kip17TokenApi.burnTokenAsync(this.chainId, addressOrAlias, tokenId, request, null, callback);
    }

    public Kip17TransactionStatusResponse approve(String addressOrAlias, String from, String to, BigInteger tokenId) throws ApiException {
        return this.approve(addressOrAlias, from, to, Numeric.toHexStringWithPrefix((BigInteger)tokenId));
    }

    public Kip17TransactionStatusResponse approve(String addressOrAlias, String from, String to, String tokenId) throws ApiException {
        ApproveKip17TokenRequest request = new ApproveKip17TokenRequest();
        request.setFrom(from);
        request.setTo(to);
        return this.kip17TokenApi.approveToken(this.chainId, addressOrAlias, tokenId, request, null);
    }

    public Call approveAsync(String addressOrAlias, String from, String to, BigInteger tokenId, ApiCallback<Kip17TransactionStatusResponse> callback) throws ApiException {
        return this.approveAsync(addressOrAlias, from, to, Numeric.toHexStringWithPrefix((BigInteger)tokenId), callback);
    }

    public Call approveAsync(String addressOrAlias, String from, String to, String tokenId, ApiCallback<Kip17TransactionStatusResponse> callback) throws ApiException {
        ApproveKip17TokenRequest request = new ApproveKip17TokenRequest();
        request.setFrom(from);
        request.setTo(to);
        return this.kip17TokenApi.approveTokenAsync(this.chainId, addressOrAlias, tokenId, request, null, callback);
    }

    public Kip17TransactionStatusResponse approveAll(String addressOrAlias, String from, String to, boolean approved) throws ApiException {
        ApproveAllKip17Request request = new ApproveAllKip17Request();
        request.setFrom(from);
        request.setTo(to);
        request.setApproved(approved);
        return this.kip17TokenApi.approveAll(this.chainId, addressOrAlias, request, null);
    }

    public Call approveAllAsync(String addressOrAlias, String from, String to, boolean approved, ApiCallback<Kip17TransactionStatusResponse> callback) throws ApiException {
        ApproveAllKip17Request request = new ApproveAllKip17Request();
        request.setFrom(from);
        request.setTo(to);
        request.setApproved(approved);
        return this.kip17TokenApi.approveAllAsync(this.chainId, addressOrAlias, request, null, callback);
    }

    public GetOwnerKip17TokensResponse getTokenListByOwner(String addressOrAlias, String owner) throws ApiException {
        KIP17QueryOptions options = new KIP17QueryOptions();
        return this.getTokenListByOwner(addressOrAlias, owner, options);
    }

    public GetOwnerKip17TokensResponse getTokenListByOwner(String addressOrAlias, String owner, KIP17QueryOptions options) throws ApiException {
        return this.kip17TokenApi.getOwnerTokens(this.chainId, addressOrAlias, owner, options.getSize(), options.getCursor());
    }

    public Call getTokenListByOwnerAsync(String addressOrAlias, String owner, ApiCallback<GetOwnerKip17TokensResponse> callback) throws ApiException {
        KIP17QueryOptions options = new KIP17QueryOptions();
        return this.getTokenListByOwnerAsync(addressOrAlias, owner, options, callback);
    }

    public Call getTokenListByOwnerAsync(String addressOrAlias, String owner, KIP17QueryOptions options, ApiCallback<GetOwnerKip17TokensResponse> callback) throws ApiException {
        return this.kip17TokenApi.getOwnerTokensAsync(this.chainId, addressOrAlias, owner, options.getSize(), options.getCursor(), callback);
    }

    public GetKip17TokenHistoryResponse getTransferHistory(String addressOrAlias, BigInteger tokenId) throws ApiException {
        KIP17QueryOptions options = new KIP17QueryOptions();
        return this.getTransferHistory(addressOrAlias, tokenId, options);
    }

    public GetKip17TokenHistoryResponse getTransferHistory(String addressOrAlias, BigInteger tokenId, KIP17QueryOptions options) throws ApiException {
        return this.kip17TokenApi.getTokenHistory(this.chainId, addressOrAlias, Numeric.toHexStringWithPrefix((BigInteger)tokenId), options.getSize(), options.getCursor());
    }

    public GetKip17TokenHistoryResponse getTransferHistory(String addressOrAlias, String tokenId) throws ApiException {
        KIP17QueryOptions options = new KIP17QueryOptions();
        return this.getTransferHistory(addressOrAlias, tokenId, options);
    }

    public GetKip17TokenHistoryResponse getTransferHistory(String addressOrAlias, String tokenId, KIP17QueryOptions options) throws ApiException {
        return this.kip17TokenApi.getTokenHistory(this.chainId, addressOrAlias, tokenId, options.getSize(), options.getCursor());
    }

    public Call getTransferHistoryAsync(String addressOrAlias, BigInteger tokenId, ApiCallback<GetKip17TokenHistoryResponse> callback) throws ApiException {
        KIP17QueryOptions options = new KIP17QueryOptions();
        return this.getTransferHistoryAsync(addressOrAlias, tokenId, options, callback);
    }

    public Call getTransferHistoryAsync(String addressOrAlias, BigInteger tokenId, KIP17QueryOptions options, ApiCallback<GetKip17TokenHistoryResponse> callback) throws ApiException {
        return this.kip17TokenApi.getTokenHistoryAsync(this.chainId, addressOrAlias, Numeric.toHexStringWithPrefix((BigInteger)tokenId), options.getSize(), options.getCursor(), callback);
    }

    public Call getTransferHistoryAsync(String addressOrAlias, String tokenId, ApiCallback<GetKip17TokenHistoryResponse> callback) throws ApiException {
        KIP17QueryOptions options = new KIP17QueryOptions();
        return this.getTransferHistoryAsync(addressOrAlias, tokenId, options, callback);
    }

    public Call getTransferHistoryAsync(String addressOrAlias, String tokenId, KIP17QueryOptions options, ApiCallback<GetKip17TokenHistoryResponse> callback) throws ApiException {
        return this.kip17TokenApi.getTokenHistoryAsync(this.chainId, addressOrAlias, tokenId, options.getSize(), options.getCursor(), callback);
    }

    public Kip17ContractApi getKip17ContractApi() {
        return this.kip17ContractApi;
    }

    public void setKip17ContractApi(Kip17ContractApi kip17ContractApi) {
        this.kip17ContractApi = kip17ContractApi;
    }

    public Kip17TokenApi getKip17TokenApi() {
        return this.kip17TokenApi;
    }

    public void setKip17TokenApi(Kip17TokenApi kip17TokenApi) {
        this.kip17TokenApi = kip17TokenApi;
    }

    public String getChainId() {
        return this.chainId;
    }

    public void setChainId(String chainId) {
        this.chainId = chainId;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
        this.setKip17ContractApi(new Kip17ContractApi(apiClient));
        this.setKip17TokenApi(new Kip17TokenApi(apiClient));
    }
}

