/*
 * Decompiled with CFR 0.152.
 */
package xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model.Signature;

@Schema(description="Data of transaction sent to Klaytn.")
public class TransactionResult {
    @SerializedName(value="from")
    private String from = null;
    @SerializedName(value="gas")
    private Long gas = null;
    @SerializedName(value="gasPrice")
    private String gasPrice = null;
    @SerializedName(value="input")
    private String input = null;
    @SerializedName(value="nonce")
    private Long nonce = null;
    @SerializedName(value="rlp")
    private String rlp = null;
    @SerializedName(value="signatures")
    private List<Signature> signatures = null;
    @SerializedName(value="status")
    private String status = null;
    @SerializedName(value="transactionHash")
    private String transactionHash = null;
    @SerializedName(value="typeInt")
    private Long typeInt = null;
    @SerializedName(value="value")
    private String value = null;
    @SerializedName(value="to")
    private String to = null;
    @SerializedName(value="code")
    private Long code = null;
    @SerializedName(value="message")
    private String message = null;
    @SerializedName(value="requestId")
    private String requestId = null;
    @SerializedName(value="transactionId")
    private String transactionId = null;
    @SerializedName(value="accountKey")
    private String accountKey = null;

    public TransactionResult from(String from) {
        this.from = from;
        return this;
    }

    @Schema(example="552714228230442729489415054454372803633806727088", required=true, description="Klaytn account address that sent the transaction.")
    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public TransactionResult gas(Long gas) {
        this.gas = gas;
        return this;
    }

    @Schema(example="1000000", required=true, description="Maximum gas fee for sending the transaction.")
    public Long getGas() {
        return this.gas;
    }

    public void setGas(Long gas) {
        this.gas = gas;
    }

    public TransactionResult gasPrice(String gasPrice) {
        this.gasPrice = gasPrice;
        return this;
    }

    @Schema(example="25000000000", required=true, description="Cost of gas fee for sending the transaction.")
    public String getGasPrice() {
        return this.gasPrice;
    }

    public void setGasPrice(String gasPrice) {
        this.gasPrice = gasPrice;
    }

    public TransactionResult input(String input) {
        this.input = input;
        return this;
    }

    @Schema(example="0x", description="Data that is sent along with the transaction to Klaytn")
    public String getInput() {
        return this.input;
    }

    public void setInput(String input) {
        this.input = input;
    }

    public TransactionResult nonce(Long nonce) {
        this.nonce = nonce;
        return this;
    }

    @Schema(example="1376", required=true, description="Number of transactions that the current sender has sent in the past.")
    public Long getNonce() {
        return this.nonce;
    }

    public void setNonce(Long nonce) {
        this.nonce = nonce;
    }

    public TransactionResult rlp(String rlp) {
        this.rlp = rlp;
        return this;
    }

    @Schema(example="318913737548327855678547148709189740555255578662765518962064477971033264818739737233733865458687147144330277409900962996999740279056253608312942190592868136507109945755195725675918434464152002629603766507599022", required=true, description="RLP serialization value for the transaction.")
    public String getRlp() {
        return this.rlp;
    }

    public void setRlp(String rlp) {
        this.rlp = rlp;
    }

    public TransactionResult signatures(List<Signature> signatures) {
        this.signatures = signatures;
        return this;
    }

    public TransactionResult addSignaturesItem(Signature signaturesItem) {
        if (this.signatures == null) {
            this.signatures = new ArrayList<Signature>();
        }
        this.signatures.add(signaturesItem);
        return this;
    }

    @Schema(description="")
    public List<Signature> getSignatures() {
        return this.signatures;
    }

    public void setSignatures(List<Signature> signatures) {
        this.signatures = signatures;
    }

    public TransactionResult status(String status) {
        this.status = status;
        return this;
    }

    @Schema(example="Submitted", description="Status after the transaction has been sent (\"Submitted\" or \"Pending\")")
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public TransactionResult transactionHash(String transactionHash) {
        this.transactionHash = transactionHash;
        return this;
    }

    @Schema(example="94531412257343489667002005200116064506288713654068768443223663636282552695006", description="Hash value for the transaction.")
    public String getTransactionHash() {
        return this.transactionHash;
    }

    public void setTransactionHash(String transactionHash) {
        this.transactionHash = transactionHash;
    }

    public TransactionResult typeInt(Long typeInt) {
        this.typeInt = typeInt;
        return this;
    }

    @Schema(example="0", required=true, description="Integer that represents the transaction type")
    public Long getTypeInt() {
        return this.typeInt;
    }

    public void setTypeInt(Long typeInt) {
        this.typeInt = typeInt;
    }

    public TransactionResult value(String value) {
        this.value = value;
        return this;
    }

    @Schema(example="0", description="KLAY converted into PEB")
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public TransactionResult to(String to) {
        this.to = to;
        return this;
    }

    @Schema(example="458589992856735687761939783085233253254964399530", description="KLAY receiver's Klaytn account address")
    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public TransactionResult code(Long code) {
        this.code = code;
        return this;
    }

    @Schema(example="1061608", description="")
    public Long getCode() {
        return this.code;
    }

    public void setCode(Long code) {
        this.code = code;
    }

    public TransactionResult message(String message) {
        this.message = message;
        return this;
    }

    @Schema(example="cannot be empty or zero value; to", description="")
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public TransactionResult requestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    @Schema(example="0cbbd3d6-88f7-9e09-b97a-e2961848f926", description="")
    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public TransactionResult transactionId(String transactionId) {
        this.transactionId = transactionId;
        return this;
    }

    @Schema(example="26870094904617105195110743147042126959649948730277961140158813703280988197378", description="Multisig transaction ID")
    public String getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public TransactionResult accountKey(String accountKey) {
        this.accountKey = accountKey;
        return this;
    }

    @Schema(example="19949820870118798113794361858927904195605027402474680352642247651879146314973387910", description="Newly updated account key.")
    public String getAccountKey() {
        return this.accountKey;
    }

    public void setAccountKey(String accountKey) {
        this.accountKey = accountKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactionResult transactionResult = (TransactionResult)o;
        return Objects.equals(this.from, transactionResult.from) && Objects.equals(this.gas, transactionResult.gas) && Objects.equals(this.gasPrice, transactionResult.gasPrice) && Objects.equals(this.input, transactionResult.input) && Objects.equals(this.nonce, transactionResult.nonce) && Objects.equals(this.rlp, transactionResult.rlp) && Objects.equals(this.signatures, transactionResult.signatures) && Objects.equals(this.status, transactionResult.status) && Objects.equals(this.transactionHash, transactionResult.transactionHash) && Objects.equals(this.typeInt, transactionResult.typeInt) && Objects.equals(this.value, transactionResult.value) && Objects.equals(this.to, transactionResult.to) && Objects.equals(this.code, transactionResult.code) && Objects.equals(this.message, transactionResult.message) && Objects.equals(this.requestId, transactionResult.requestId) && Objects.equals(this.transactionId, transactionResult.transactionId) && Objects.equals(this.accountKey, transactionResult.accountKey);
    }

    public int hashCode() {
        return Objects.hash(this.from, this.gas, this.gasPrice, this.input, this.nonce, this.rlp, this.signatures, this.status, this.transactionHash, this.typeInt, this.value, this.to, this.code, this.message, this.requestId, this.transactionId, this.accountKey);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransactionResult {\n");
        sb.append("    from: ").append(this.toIndentedString(this.from)).append("\n");
        sb.append("    gas: ").append(this.toIndentedString(this.gas)).append("\n");
        sb.append("    gasPrice: ").append(this.toIndentedString(this.gasPrice)).append("\n");
        sb.append("    input: ").append(this.toIndentedString(this.input)).append("\n");
        sb.append("    nonce: ").append(this.toIndentedString(this.nonce)).append("\n");
        sb.append("    rlp: ").append(this.toIndentedString(this.rlp)).append("\n");
        sb.append("    signatures: ").append(this.toIndentedString(this.signatures)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    transactionHash: ").append(this.toIndentedString(this.transactionHash)).append("\n");
        sb.append("    typeInt: ").append(this.toIndentedString(this.typeInt)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    to: ").append(this.toIndentedString(this.to)).append("\n");
        sb.append("    code: ").append(this.toIndentedString(this.code)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    requestId: ").append(this.toIndentedString(this.requestId)).append("\n");
        sb.append("    transactionId: ").append(this.toIndentedString(this.transactionId)).append("\n");
        sb.append("    accountKey: ").append(this.toIndentedString(this.accountKey)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

