/*
 * Decompiled with CFR 0.152.
 */
package xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip7.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.ApiCallback;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.ApiClient;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.ApiException;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.ApiResponse;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.Configuration;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.Pair;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.ProgressRequestBody;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.ProgressResponseBody;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip7.model.AddMinterKip7Request;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip7.model.ApproveKip7TokenRequest;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip7.model.BurnFromKip7TokenRequest;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip7.model.BurnKip7TokenRequest;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip7.model.Kip7TokenBalanceResponse;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip7.model.Kip7TransactionStatusResponse;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip7.model.MintKip7TokenRequest;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip7.model.TransferKip7TokenFromRequest;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip7.model.TransferKip7TokenRequest;

public class Kip7TokenApi {
    private ApiClient apiClient;

    public Kip7TokenApi() {
        this(Configuration.getDefaultApiClient());
    }

    public Kip7TokenApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call addMinterCall(String xChainId, String contractAddressOrAlias, AddMinterKip7Request body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        AddMinterKip7Request localVarPostBody = body;
        String localVarPath = "/v1/contract/{contract-address-or-alias}/minter".replaceAll("\\{contract-address-or-alias\\}", this.apiClient.escapeString(contractAddressOrAlias.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xChainId != null) {
            localVarHeaderParams.put("x-chain-id", this.apiClient.parameterToString(xChainId));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call addMinterValidateBeforeCall(String xChainId, String contractAddressOrAlias, AddMinterKip7Request body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (xChainId == null) {
            throw new ApiException("Missing the required parameter 'xChainId' when calling addMinter(Async)");
        }
        if (contractAddressOrAlias == null) {
            throw new ApiException("Missing the required parameter 'contractAddressOrAlias' when calling addMinter(Async)");
        }
        Call call = this.addMinterCall(xChainId, contractAddressOrAlias, body, progressListener, progressRequestListener);
        return call;
    }

    public Kip7TransactionStatusResponse addMinter(String xChainId, String contractAddressOrAlias, AddMinterKip7Request body) throws ApiException {
        ApiResponse<Kip7TransactionStatusResponse> resp = this.addMinterWithHttpInfo(xChainId, contractAddressOrAlias, body);
        return resp.getData();
    }

    public ApiResponse<Kip7TransactionStatusResponse> addMinterWithHttpInfo(String xChainId, String contractAddressOrAlias, AddMinterKip7Request body) throws ApiException {
        Call call = this.addMinterValidateBeforeCall(xChainId, contractAddressOrAlias, body, null, null);
        Type localVarReturnType = new TypeToken<Kip7TransactionStatusResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call addMinterAsync(String xChainId, String contractAddressOrAlias, AddMinterKip7Request body, final ApiCallback<Kip7TransactionStatusResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.addMinterValidateBeforeCall(xChainId, contractAddressOrAlias, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Kip7TransactionStatusResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call approveTokenCall(String xChainId, String contractAddressOrAlias, ApproveKip7TokenRequest body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ApproveKip7TokenRequest localVarPostBody = body;
        String localVarPath = "/v1/contract/{contract-address-or-alias}/approve".replaceAll("\\{contract-address-or-alias\\}", this.apiClient.escapeString(contractAddressOrAlias.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xChainId != null) {
            localVarHeaderParams.put("x-chain-id", this.apiClient.parameterToString(xChainId));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call approveTokenValidateBeforeCall(String xChainId, String contractAddressOrAlias, ApproveKip7TokenRequest body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (xChainId == null) {
            throw new ApiException("Missing the required parameter 'xChainId' when calling approveToken(Async)");
        }
        if (contractAddressOrAlias == null) {
            throw new ApiException("Missing the required parameter 'contractAddressOrAlias' when calling approveToken(Async)");
        }
        Call call = this.approveTokenCall(xChainId, contractAddressOrAlias, body, progressListener, progressRequestListener);
        return call;
    }

    public Kip7TransactionStatusResponse approveToken(String xChainId, String contractAddressOrAlias, ApproveKip7TokenRequest body) throws ApiException {
        ApiResponse<Kip7TransactionStatusResponse> resp = this.approveTokenWithHttpInfo(xChainId, contractAddressOrAlias, body);
        return resp.getData();
    }

    public ApiResponse<Kip7TransactionStatusResponse> approveTokenWithHttpInfo(String xChainId, String contractAddressOrAlias, ApproveKip7TokenRequest body) throws ApiException {
        Call call = this.approveTokenValidateBeforeCall(xChainId, contractAddressOrAlias, body, null, null);
        Type localVarReturnType = new TypeToken<Kip7TransactionStatusResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call approveTokenAsync(String xChainId, String contractAddressOrAlias, ApproveKip7TokenRequest body, final ApiCallback<Kip7TransactionStatusResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.approveTokenValidateBeforeCall(xChainId, contractAddressOrAlias, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Kip7TransactionStatusResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call burnFromTokenCall(String xChainId, String contractAddressOrAlias, BurnFromKip7TokenRequest body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        BurnFromKip7TokenRequest localVarPostBody = body;
        String localVarPath = "/v1/contract/{contract-address-or-alias}/burn-from".replaceAll("\\{contract-address-or-alias\\}", this.apiClient.escapeString(contractAddressOrAlias.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xChainId != null) {
            localVarHeaderParams.put("x-chain-id", this.apiClient.parameterToString(xChainId));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call burnFromTokenValidateBeforeCall(String xChainId, String contractAddressOrAlias, BurnFromKip7TokenRequest body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (xChainId == null) {
            throw new ApiException("Missing the required parameter 'xChainId' when calling burnFromToken(Async)");
        }
        if (contractAddressOrAlias == null) {
            throw new ApiException("Missing the required parameter 'contractAddressOrAlias' when calling burnFromToken(Async)");
        }
        Call call = this.burnFromTokenCall(xChainId, contractAddressOrAlias, body, progressListener, progressRequestListener);
        return call;
    }

    public Kip7TransactionStatusResponse burnFromToken(String xChainId, String contractAddressOrAlias, BurnFromKip7TokenRequest body) throws ApiException {
        ApiResponse<Kip7TransactionStatusResponse> resp = this.burnFromTokenWithHttpInfo(xChainId, contractAddressOrAlias, body);
        return resp.getData();
    }

    public ApiResponse<Kip7TransactionStatusResponse> burnFromTokenWithHttpInfo(String xChainId, String contractAddressOrAlias, BurnFromKip7TokenRequest body) throws ApiException {
        Call call = this.burnFromTokenValidateBeforeCall(xChainId, contractAddressOrAlias, body, null, null);
        Type localVarReturnType = new TypeToken<Kip7TransactionStatusResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call burnFromTokenAsync(String xChainId, String contractAddressOrAlias, BurnFromKip7TokenRequest body, final ApiCallback<Kip7TransactionStatusResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.burnFromTokenValidateBeforeCall(xChainId, contractAddressOrAlias, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Kip7TransactionStatusResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call burnTokenCall(String xChainId, String contractAddressOrAlias, BurnKip7TokenRequest body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        BurnKip7TokenRequest localVarPostBody = body;
        String localVarPath = "/v1/contract/{contract-address-or-alias}/burn".replaceAll("\\{contract-address-or-alias\\}", this.apiClient.escapeString(contractAddressOrAlias.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xChainId != null) {
            localVarHeaderParams.put("x-chain-id", this.apiClient.parameterToString(xChainId));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call burnTokenValidateBeforeCall(String xChainId, String contractAddressOrAlias, BurnKip7TokenRequest body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (xChainId == null) {
            throw new ApiException("Missing the required parameter 'xChainId' when calling burnToken(Async)");
        }
        if (contractAddressOrAlias == null) {
            throw new ApiException("Missing the required parameter 'contractAddressOrAlias' when calling burnToken(Async)");
        }
        Call call = this.burnTokenCall(xChainId, contractAddressOrAlias, body, progressListener, progressRequestListener);
        return call;
    }

    public Kip7TransactionStatusResponse burnToken(String xChainId, String contractAddressOrAlias, BurnKip7TokenRequest body) throws ApiException {
        ApiResponse<Kip7TransactionStatusResponse> resp = this.burnTokenWithHttpInfo(xChainId, contractAddressOrAlias, body);
        return resp.getData();
    }

    public ApiResponse<Kip7TransactionStatusResponse> burnTokenWithHttpInfo(String xChainId, String contractAddressOrAlias, BurnKip7TokenRequest body) throws ApiException {
        Call call = this.burnTokenValidateBeforeCall(xChainId, contractAddressOrAlias, body, null, null);
        Type localVarReturnType = new TypeToken<Kip7TransactionStatusResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call burnTokenAsync(String xChainId, String contractAddressOrAlias, BurnKip7TokenRequest body, final ApiCallback<Kip7TransactionStatusResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.burnTokenValidateBeforeCall(xChainId, contractAddressOrAlias, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Kip7TransactionStatusResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getTokenAllowanceCall(String xChainId, String contractAddressOrAlias, String owner, String spender, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v1/contract/{contract-address-or-alias}/account/{owner}/allowance/{spender}".replaceAll("\\{contract-address-or-alias\\}", this.apiClient.escapeString(contractAddressOrAlias.toString())).replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{spender\\}", this.apiClient.escapeString(spender.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xChainId != null) {
            localVarHeaderParams.put("x-chain-id", this.apiClient.parameterToString(xChainId));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getTokenAllowanceValidateBeforeCall(String xChainId, String contractAddressOrAlias, String owner, String spender, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (xChainId == null) {
            throw new ApiException("Missing the required parameter 'xChainId' when calling getTokenAllowance(Async)");
        }
        if (contractAddressOrAlias == null) {
            throw new ApiException("Missing the required parameter 'contractAddressOrAlias' when calling getTokenAllowance(Async)");
        }
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling getTokenAllowance(Async)");
        }
        if (spender == null) {
            throw new ApiException("Missing the required parameter 'spender' when calling getTokenAllowance(Async)");
        }
        Call call = this.getTokenAllowanceCall(xChainId, contractAddressOrAlias, owner, spender, progressListener, progressRequestListener);
        return call;
    }

    public Kip7TokenBalanceResponse getTokenAllowance(String xChainId, String contractAddressOrAlias, String owner, String spender) throws ApiException {
        ApiResponse<Kip7TokenBalanceResponse> resp = this.getTokenAllowanceWithHttpInfo(xChainId, contractAddressOrAlias, owner, spender);
        return resp.getData();
    }

    public ApiResponse<Kip7TokenBalanceResponse> getTokenAllowanceWithHttpInfo(String xChainId, String contractAddressOrAlias, String owner, String spender) throws ApiException {
        Call call = this.getTokenAllowanceValidateBeforeCall(xChainId, contractAddressOrAlias, owner, spender, null, null);
        Type localVarReturnType = new TypeToken<Kip7TokenBalanceResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getTokenAllowanceAsync(String xChainId, String contractAddressOrAlias, String owner, String spender, final ApiCallback<Kip7TokenBalanceResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getTokenAllowanceValidateBeforeCall(xChainId, contractAddressOrAlias, owner, spender, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Kip7TokenBalanceResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getTokenBalanceCall(String xChainId, String contractAddressOrAlias, String owner, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v1/contract/{contract-address-or-alias}/account/{owner}/balance".replaceAll("\\{contract-address-or-alias\\}", this.apiClient.escapeString(contractAddressOrAlias.toString())).replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xChainId != null) {
            localVarHeaderParams.put("x-chain-id", this.apiClient.parameterToString(xChainId));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getTokenBalanceValidateBeforeCall(String xChainId, String contractAddressOrAlias, String owner, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (xChainId == null) {
            throw new ApiException("Missing the required parameter 'xChainId' when calling getTokenBalance(Async)");
        }
        if (contractAddressOrAlias == null) {
            throw new ApiException("Missing the required parameter 'contractAddressOrAlias' when calling getTokenBalance(Async)");
        }
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling getTokenBalance(Async)");
        }
        Call call = this.getTokenBalanceCall(xChainId, contractAddressOrAlias, owner, progressListener, progressRequestListener);
        return call;
    }

    public Kip7TokenBalanceResponse getTokenBalance(String xChainId, String contractAddressOrAlias, String owner) throws ApiException {
        ApiResponse<Kip7TokenBalanceResponse> resp = this.getTokenBalanceWithHttpInfo(xChainId, contractAddressOrAlias, owner);
        return resp.getData();
    }

    public ApiResponse<Kip7TokenBalanceResponse> getTokenBalanceWithHttpInfo(String xChainId, String contractAddressOrAlias, String owner) throws ApiException {
        Call call = this.getTokenBalanceValidateBeforeCall(xChainId, contractAddressOrAlias, owner, null, null);
        Type localVarReturnType = new TypeToken<Kip7TokenBalanceResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getTokenBalanceAsync(String xChainId, String contractAddressOrAlias, String owner, final ApiCallback<Kip7TokenBalanceResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getTokenBalanceValidateBeforeCall(xChainId, contractAddressOrAlias, owner, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Kip7TokenBalanceResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call mintTokenCall(String xChainId, String contractAddressOrAlias, MintKip7TokenRequest body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        MintKip7TokenRequest localVarPostBody = body;
        String localVarPath = "/v1/contract/{contract-address-or-alias}/mint".replaceAll("\\{contract-address-or-alias\\}", this.apiClient.escapeString(contractAddressOrAlias.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xChainId != null) {
            localVarHeaderParams.put("x-chain-id", this.apiClient.parameterToString(xChainId));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call mintTokenValidateBeforeCall(String xChainId, String contractAddressOrAlias, MintKip7TokenRequest body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (xChainId == null) {
            throw new ApiException("Missing the required parameter 'xChainId' when calling mintToken(Async)");
        }
        if (contractAddressOrAlias == null) {
            throw new ApiException("Missing the required parameter 'contractAddressOrAlias' when calling mintToken(Async)");
        }
        Call call = this.mintTokenCall(xChainId, contractAddressOrAlias, body, progressListener, progressRequestListener);
        return call;
    }

    public Kip7TransactionStatusResponse mintToken(String xChainId, String contractAddressOrAlias, MintKip7TokenRequest body) throws ApiException {
        ApiResponse<Kip7TransactionStatusResponse> resp = this.mintTokenWithHttpInfo(xChainId, contractAddressOrAlias, body);
        return resp.getData();
    }

    public ApiResponse<Kip7TransactionStatusResponse> mintTokenWithHttpInfo(String xChainId, String contractAddressOrAlias, MintKip7TokenRequest body) throws ApiException {
        Call call = this.mintTokenValidateBeforeCall(xChainId, contractAddressOrAlias, body, null, null);
        Type localVarReturnType = new TypeToken<Kip7TransactionStatusResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call mintTokenAsync(String xChainId, String contractAddressOrAlias, MintKip7TokenRequest body, final ApiCallback<Kip7TransactionStatusResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.mintTokenValidateBeforeCall(xChainId, contractAddressOrAlias, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Kip7TransactionStatusResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call renounceMinterCall(String contractAddressOrAlias, String minterAddress, String xChainId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v1/contract/{contract-address-or-alias}/minter/{minter-address}".replaceAll("\\{contract-address-or-alias\\}", this.apiClient.escapeString(contractAddressOrAlias.toString())).replaceAll("\\{minter-address\\}", this.apiClient.escapeString(minterAddress.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xChainId != null) {
            localVarHeaderParams.put("x-chain-id", this.apiClient.parameterToString(xChainId));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call renounceMinterValidateBeforeCall(String contractAddressOrAlias, String minterAddress, String xChainId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (contractAddressOrAlias == null) {
            throw new ApiException("Missing the required parameter 'contractAddressOrAlias' when calling renounceMinter(Async)");
        }
        if (minterAddress == null) {
            throw new ApiException("Missing the required parameter 'minterAddress' when calling renounceMinter(Async)");
        }
        if (xChainId == null) {
            throw new ApiException("Missing the required parameter 'xChainId' when calling renounceMinter(Async)");
        }
        Call call = this.renounceMinterCall(contractAddressOrAlias, minterAddress, xChainId, progressListener, progressRequestListener);
        return call;
    }

    public Kip7TransactionStatusResponse renounceMinter(String contractAddressOrAlias, String minterAddress, String xChainId) throws ApiException {
        ApiResponse<Kip7TransactionStatusResponse> resp = this.renounceMinterWithHttpInfo(contractAddressOrAlias, minterAddress, xChainId);
        return resp.getData();
    }

    public ApiResponse<Kip7TransactionStatusResponse> renounceMinterWithHttpInfo(String contractAddressOrAlias, String minterAddress, String xChainId) throws ApiException {
        Call call = this.renounceMinterValidateBeforeCall(contractAddressOrAlias, minterAddress, xChainId, null, null);
        Type localVarReturnType = new TypeToken<Kip7TransactionStatusResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call renounceMinterAsync(String contractAddressOrAlias, String minterAddress, String xChainId, final ApiCallback<Kip7TransactionStatusResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.renounceMinterValidateBeforeCall(contractAddressOrAlias, minterAddress, xChainId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Kip7TransactionStatusResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call transferFromTokenCall(String xChainId, String contractAddressOrAlias, TransferKip7TokenFromRequest body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        TransferKip7TokenFromRequest localVarPostBody = body;
        String localVarPath = "/v1/contract/{contract-address-or-alias}/transfer-from".replaceAll("\\{contract-address-or-alias\\}", this.apiClient.escapeString(contractAddressOrAlias.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xChainId != null) {
            localVarHeaderParams.put("x-chain-id", this.apiClient.parameterToString(xChainId));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call transferFromTokenValidateBeforeCall(String xChainId, String contractAddressOrAlias, TransferKip7TokenFromRequest body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (xChainId == null) {
            throw new ApiException("Missing the required parameter 'xChainId' when calling transferFromToken(Async)");
        }
        if (contractAddressOrAlias == null) {
            throw new ApiException("Missing the required parameter 'contractAddressOrAlias' when calling transferFromToken(Async)");
        }
        Call call = this.transferFromTokenCall(xChainId, contractAddressOrAlias, body, progressListener, progressRequestListener);
        return call;
    }

    public Kip7TransactionStatusResponse transferFromToken(String xChainId, String contractAddressOrAlias, TransferKip7TokenFromRequest body) throws ApiException {
        ApiResponse<Kip7TransactionStatusResponse> resp = this.transferFromTokenWithHttpInfo(xChainId, contractAddressOrAlias, body);
        return resp.getData();
    }

    public ApiResponse<Kip7TransactionStatusResponse> transferFromTokenWithHttpInfo(String xChainId, String contractAddressOrAlias, TransferKip7TokenFromRequest body) throws ApiException {
        Call call = this.transferFromTokenValidateBeforeCall(xChainId, contractAddressOrAlias, body, null, null);
        Type localVarReturnType = new TypeToken<Kip7TransactionStatusResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call transferFromTokenAsync(String xChainId, String contractAddressOrAlias, TransferKip7TokenFromRequest body, final ApiCallback<Kip7TransactionStatusResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.transferFromTokenValidateBeforeCall(xChainId, contractAddressOrAlias, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Kip7TransactionStatusResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call transferTokenCall(String xChainId, String contractAddressOrAlias, TransferKip7TokenRequest body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        TransferKip7TokenRequest localVarPostBody = body;
        String localVarPath = "/v1/contract/{contract-address-or-alias}/transfer".replaceAll("\\{contract-address-or-alias\\}", this.apiClient.escapeString(contractAddressOrAlias.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xChainId != null) {
            localVarHeaderParams.put("x-chain-id", this.apiClient.parameterToString(xChainId));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call transferTokenValidateBeforeCall(String xChainId, String contractAddressOrAlias, TransferKip7TokenRequest body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (xChainId == null) {
            throw new ApiException("Missing the required parameter 'xChainId' when calling transferToken(Async)");
        }
        if (contractAddressOrAlias == null) {
            throw new ApiException("Missing the required parameter 'contractAddressOrAlias' when calling transferToken(Async)");
        }
        Call call = this.transferTokenCall(xChainId, contractAddressOrAlias, body, progressListener, progressRequestListener);
        return call;
    }

    public Kip7TransactionStatusResponse transferToken(String xChainId, String contractAddressOrAlias, TransferKip7TokenRequest body) throws ApiException {
        ApiResponse<Kip7TransactionStatusResponse> resp = this.transferTokenWithHttpInfo(xChainId, contractAddressOrAlias, body);
        return resp.getData();
    }

    public ApiResponse<Kip7TransactionStatusResponse> transferTokenWithHttpInfo(String xChainId, String contractAddressOrAlias, TransferKip7TokenRequest body) throws ApiException {
        Call call = this.transferTokenValidateBeforeCall(xChainId, contractAddressOrAlias, body, null, null);
        Type localVarReturnType = new TypeToken<Kip7TransactionStatusResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call transferTokenAsync(String xChainId, String contractAddressOrAlias, TransferKip7TokenRequest body, final ApiCallback<Kip7TransactionStatusResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.transferTokenValidateBeforeCall(xChainId, contractAddressOrAlias, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Kip7TransactionStatusResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

