/*
 * Decompiled with CFR 0.152.
 */
package xyz.groundx.caver_ext_kas.kas.kip37;

import com.squareup.okhttp.Call;
import java.math.BigInteger;
import java.util.Arrays;
import org.web3j.utils.Numeric;
import xyz.groundx.caver_ext_kas.kas.kip37.KIP37QueryOptions;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.ApiCallback;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.ApiClient;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.ApiException;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip37.api.Kip37ContractApi;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip37.api.Kip37DeployerApi;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip37.api.Kip37TokenApi;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip37.api.Kip37TokenOwnershipApi;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip37.model.ApproveAllKip37ContractRequest;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip37.model.BurnKip37TokenRequest;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip37.model.CreateKip37TokenRequest;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip37.model.DeployKip37ContractRequest;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip37.model.ImportKip37ContractRequest;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip37.model.Kip37Contract;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip37.model.Kip37ContractListResponse;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip37.model.Kip37DeployResponse;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip37.model.Kip37DeployerResponse;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip37.model.Kip37FeePayerOptions;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip37.model.Kip37TokenInfoListResponse;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip37.model.Kip37TokenListResponse;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip37.model.Kip37TransactionStatusResponse;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip37.model.MintKip37TokenRequest;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip37.model.OperateKip37ContractRequest;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip37.model.TransferKip37TokenRequest;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip37.model.UpdateKip37ContractRequest;

public class KIP37 {
    Kip37ContractApi contractApi;
    Kip37DeployerApi deployerApi;
    Kip37TokenApi tokenApi;
    Kip37TokenOwnershipApi tokenOwnershipApi;
    String chainId;
    ApiClient apiClient;

    public KIP37(String chainId, ApiClient apiClient) {
        this.chainId = chainId;
        this.setApiClient(apiClient);
    }

    public Kip37DeployResponse deploy(String uri, String alias) throws ApiException {
        return this.deploy(uri, alias, null);
    }

    public Kip37DeployResponse deploy(String uri, String alias, Kip37FeePayerOptions feePayerOptions) throws ApiException {
        DeployKip37ContractRequest request = new DeployKip37ContractRequest();
        request.setAlias(alias);
        request.setUri(uri);
        request.setOptions(feePayerOptions);
        return this.contractApi.deployContract(this.chainId, request);
    }

    public Call deployAsync(String uri, String alias, ApiCallback<Kip37DeployResponse> callback) throws ApiException {
        return this.deployAsync(uri, alias, null, callback);
    }

    public Call deployAsync(String uri, String alias, Kip37FeePayerOptions feePayerOptions, ApiCallback<Kip37DeployResponse> callback) throws ApiException {
        DeployKip37ContractRequest request = new DeployKip37ContractRequest();
        request.setAlias(alias);
        request.setUri(uri);
        request.setOptions(feePayerOptions);
        return this.contractApi.deployContractAsync(this.chainId, request, callback);
    }

    public Kip37ContractListResponse getContractList() throws ApiException {
        KIP37QueryOptions options = new KIP37QueryOptions();
        return this.getContractList(options);
    }

    public Kip37ContractListResponse getContractList(KIP37QueryOptions options) throws ApiException {
        return this.contractApi.listContractsInDeployerPool(this.chainId, options.getSize(), options.getCursor(), options.getStatus());
    }

    public Call getContractListAsync(ApiCallback<Kip37ContractListResponse> callback) throws ApiException {
        KIP37QueryOptions options = new KIP37QueryOptions();
        return this.getContractListAsync(options, callback);
    }

    public Call getContractListAsync(KIP37QueryOptions options, ApiCallback<Kip37ContractListResponse> callback) throws ApiException {
        return this.contractApi.listContractsInDeployerPoolAsync(this.chainId, options.getSize(), options.getCursor(), options.getStatus(), callback);
    }

    public Kip37Contract importContract(String contractAddress, String uri, String alias) throws ApiException {
        return this.importContract(contractAddress, uri, alias, null);
    }

    public Kip37Contract importContract(String contractAddress, String uri, String alias, Kip37FeePayerOptions feePayerOptions) throws ApiException {
        ImportKip37ContractRequest request = new ImportKip37ContractRequest();
        request.setAlias(alias);
        request.setUri(uri);
        request.setAddress(contractAddress);
        request.setOptions(feePayerOptions);
        return this.contractApi.importContract(this.chainId, request);
    }

    public Call importContractAsync(String contractAddress, String uri, String alias, ApiCallback<Kip37Contract> callback) throws ApiException {
        return this.importContractAsync(contractAddress, uri, alias, null, callback);
    }

    public Call importContractAsync(String contractAddress, String uri, String alias, Kip37FeePayerOptions feePayerOptions, ApiCallback<Kip37Contract> callback) throws ApiException {
        ImportKip37ContractRequest request = new ImportKip37ContractRequest();
        request.setAlias(alias);
        request.setUri(uri);
        request.setAddress(contractAddress);
        request.setOptions(feePayerOptions);
        return this.contractApi.importContractAsync(this.chainId, request, callback);
    }

    public Kip37Contract getContract(String addressOrAlias) throws ApiException {
        return this.contractApi.getContract(addressOrAlias, this.chainId);
    }

    public Call getContractAsync(String addressOrAlias, ApiCallback<Kip37Contract> callback) throws ApiException {
        return this.contractApi.getContractAsync(addressOrAlias, this.chainId, callback);
    }

    public Kip37Contract updateContractOptions(String addressOrAlias) throws ApiException {
        return this.updateContractOptions(addressOrAlias, null);
    }

    public Kip37Contract updateContractOptions(String addressOrAlias, Kip37FeePayerOptions feePayerOptions) throws ApiException {
        UpdateKip37ContractRequest request = new UpdateKip37ContractRequest();
        request.setOptions(feePayerOptions);
        return this.contractApi.putContract(this.chainId, addressOrAlias, request);
    }

    public Call updateContractOptionsAsync(String addressOrAlias, ApiCallback<Kip37Contract> callback) throws ApiException {
        return this.updateContractOptionsAsync(addressOrAlias, null, callback);
    }

    public Call updateContractOptionsAsync(String addressOrAlias, Kip37FeePayerOptions feePayerOptions, ApiCallback<Kip37Contract> callback) throws ApiException {
        UpdateKip37ContractRequest request = new UpdateKip37ContractRequest();
        request.setOptions(feePayerOptions);
        return this.contractApi.putContractAsync(this.chainId, addressOrAlias, request, callback);
    }

    public Kip37TransactionStatusResponse setApprovalForAll(String addressOrAlias, String from, String to) throws ApiException {
        return this.setApprovalForAll(addressOrAlias, from, to, true);
    }

    public Kip37TransactionStatusResponse setApprovalForAll(String addressOrAlias, String from, String to, boolean approved) throws ApiException {
        ApproveAllKip37ContractRequest request = new ApproveAllKip37ContractRequest();
        request.setFrom(from);
        request.setTo(to);
        request.setApproved(approved);
        return this.contractApi.approveAll(this.chainId, addressOrAlias, request);
    }

    public Call setApprovalForAllAsync(String addressOrAlias, String from, String to, ApiCallback<Kip37TransactionStatusResponse> callback) throws ApiException {
        return this.setApprovalForAllAsync(addressOrAlias, from, to, true, callback);
    }

    public Call setApprovalForAllAsync(String addressOrAlias, String from, String to, boolean approved, ApiCallback<Kip37TransactionStatusResponse> callback) throws ApiException {
        ApproveAllKip37ContractRequest request = new ApproveAllKip37ContractRequest();
        request.setFrom(from);
        request.setTo(to);
        request.setApproved(approved);
        return this.contractApi.approveAllAsync(this.chainId, addressOrAlias, request, callback);
    }

    public Kip37TransactionStatusResponse pause(String addressOrAlias) throws ApiException {
        return this.pause(addressOrAlias, null);
    }

    public Kip37TransactionStatusResponse pause(String addressOrAlias, String pauser) throws ApiException {
        OperateKip37ContractRequest request = new OperateKip37ContractRequest();
        request.setSender(pauser);
        return this.contractApi.pauseContract(this.chainId, addressOrAlias, request);
    }

    public Call pauseAsync(String addressOrAlias, ApiCallback<Kip37TransactionStatusResponse> callback) throws ApiException {
        return this.pauseAsync(addressOrAlias, null, callback);
    }

    public Call pauseAsync(String addressOrAlias, String pauser, ApiCallback<Kip37TransactionStatusResponse> callback) throws ApiException {
        OperateKip37ContractRequest request = new OperateKip37ContractRequest();
        request.setSender(pauser);
        return this.contractApi.pauseContractAsync(this.chainId, addressOrAlias, request, callback);
    }

    public Kip37TransactionStatusResponse unpause(String addressOrAlias) throws ApiException {
        return this.unpause(addressOrAlias, null);
    }

    public Kip37TransactionStatusResponse unpause(String addressOrAlias, String pauser) throws ApiException {
        OperateKip37ContractRequest request = new OperateKip37ContractRequest();
        request.setSender(pauser);
        return this.contractApi.unpauseContract(this.chainId, addressOrAlias, request);
    }

    public Call unpauseAsync(String addressOrAlias, ApiCallback<Kip37TransactionStatusResponse> callback) throws ApiException {
        return this.unpauseAsync(addressOrAlias, null, callback);
    }

    public Call unpauseAsync(String addressOrAlias, String pauser, ApiCallback<Kip37TransactionStatusResponse> callback) throws ApiException {
        OperateKip37ContractRequest request = new OperateKip37ContractRequest();
        request.setSender(pauser);
        return this.contractApi.unpauseContractAsync(this.chainId, addressOrAlias, request, callback);
    }

    public Kip37TransactionStatusResponse create(String addressOrAlias, BigInteger tokenId, BigInteger initialSupply, String uri) throws ApiException {
        return this.create(addressOrAlias, tokenId, initialSupply, uri, null);
    }

    public Kip37TransactionStatusResponse create(String addressOrAlias, String tokenId, String initialSupply, String uri) throws ApiException {
        return this.create(addressOrAlias, tokenId, initialSupply, uri, null);
    }

    public Kip37TransactionStatusResponse create(String addressOrAlias, BigInteger tokenId, BigInteger initialSupply, String uri, String sender) throws ApiException {
        return this.create(addressOrAlias, Numeric.toHexStringWithPrefix((BigInteger)tokenId), Numeric.toHexStringWithPrefix((BigInteger)initialSupply), uri, sender);
    }

    public Kip37TransactionStatusResponse create(String addressOrAlias, String tokenId, String initialSupply, String uri, String sender) throws ApiException {
        CreateKip37TokenRequest request = new CreateKip37TokenRequest();
        request.setSender(sender);
        request.setId(tokenId);
        request.setInitialSupply(initialSupply);
        request.setUri(uri);
        return this.tokenApi.createToken(this.chainId, addressOrAlias, request);
    }

    public Call createAsync(String addressOrAlias, BigInteger tokenId, BigInteger initialSupply, String uri, ApiCallback<Kip37TransactionStatusResponse> callback) throws ApiException {
        return this.createAsync(addressOrAlias, tokenId, initialSupply, uri, null, callback);
    }

    public Call createAsync(String addressOrAlias, String tokenId, String initialSupply, String uri, ApiCallback<Kip37TransactionStatusResponse> callback) throws ApiException {
        return this.createAsync(addressOrAlias, tokenId, initialSupply, uri, null, callback);
    }

    public Call createAsync(String addressOrAlias, BigInteger tokenId, BigInteger initialSupply, String uri, String sender, ApiCallback<Kip37TransactionStatusResponse> callback) throws ApiException {
        return this.createAsync(addressOrAlias, Numeric.toHexStringWithPrefix((BigInteger)tokenId), Numeric.toHexStringWithPrefix((BigInteger)initialSupply), uri, sender, callback);
    }

    public Call createAsync(String addressOrAlias, String tokenId, String initialSupply, String uri, String sender, ApiCallback<Kip37TransactionStatusResponse> callback) throws ApiException {
        CreateKip37TokenRequest request = new CreateKip37TokenRequest();
        request.setSender(sender);
        request.setId(tokenId);
        request.setInitialSupply(initialSupply);
        request.setUri(uri);
        return this.tokenApi.createTokenAsync(this.chainId, addressOrAlias, request, callback);
    }

    public Kip37TokenInfoListResponse getTokenList(String addressOrAlias) throws ApiException {
        return this.getTokenList(addressOrAlias, new KIP37QueryOptions());
    }

    public Kip37TokenInfoListResponse getTokenList(String addressOrAlias, KIP37QueryOptions queryOptions) throws ApiException {
        return this.tokenApi.getTokens(addressOrAlias, this.chainId, queryOptions.getSize(), queryOptions.getCursor());
    }

    public Call getTokenListAsync(String addressOrAlias, ApiCallback<Kip37TokenInfoListResponse> callback) throws ApiException {
        return this.getTokenListAsync(addressOrAlias, new KIP37QueryOptions(), callback);
    }

    public Call getTokenListAsync(String addressOrAlias, KIP37QueryOptions queryOptions, ApiCallback<Kip37TokenInfoListResponse> callback) throws ApiException {
        return this.tokenApi.getTokensAsync(addressOrAlias, this.chainId, queryOptions.getSize(), queryOptions.getCursor(), callback);
    }

    public Kip37TransactionStatusResponse burn(String addressOrAlias, BigInteger id, BigInteger amount) throws ApiException {
        return this.burn(addressOrAlias, id, amount, null);
    }

    public Kip37TransactionStatusResponse burn(String addressOrAlias, String id, String amount) throws ApiException {
        return this.burn(addressOrAlias, id, amount, null);
    }

    public Kip37TransactionStatusResponse burn(String addressOrAlias, BigInteger id, BigInteger amount, String from) throws ApiException {
        return this.burn(addressOrAlias, new BigInteger[]{id}, new BigInteger[]{amount}, from);
    }

    public Kip37TransactionStatusResponse burn(String addressOrAlias, String id, String amount, String from) throws ApiException {
        return this.burn(addressOrAlias, new String[]{id}, new String[]{amount}, from);
    }

    public Kip37TransactionStatusResponse burn(String addressOrAlias, BigInteger[] ids, BigInteger[] amounts) throws ApiException {
        String[] ids_hex = (String[])Arrays.stream(ids).map(Numeric::toHexStringWithPrefix).toArray(String[]::new);
        String[] amounts_hex = (String[])Arrays.stream(amounts).map(Numeric::toHexStringWithPrefix).toArray(String[]::new);
        return this.burn(addressOrAlias, ids_hex, amounts_hex, null);
    }

    public Kip37TransactionStatusResponse burn(String addressOrAlias, String[] ids, String[] amounts) throws ApiException {
        return this.burn(addressOrAlias, ids, amounts, null);
    }

    public Kip37TransactionStatusResponse burn(String addressOrAlias, BigInteger[] ids, BigInteger[] amounts, String from) throws ApiException {
        String[] ids_hex = (String[])Arrays.stream(ids).map(Numeric::toHexStringWithPrefix).toArray(String[]::new);
        String[] amounts_hex = (String[])Arrays.stream(amounts).map(Numeric::toHexStringWithPrefix).toArray(String[]::new);
        return this.burn(addressOrAlias, ids_hex, amounts_hex, from);
    }

    public Kip37TransactionStatusResponse burn(String addressOrAlias, String[] ids, String[] amounts, String from) throws ApiException {
        BurnKip37TokenRequest request = new BurnKip37TokenRequest();
        request.setFrom(from);
        request.setIds(Arrays.asList(ids));
        request.setAmounts(Arrays.asList(amounts));
        return this.tokenApi.burnToken(this.chainId, addressOrAlias, request);
    }

    public Call burnAsync(String addressOrAlias, BigInteger id, BigInteger amount, ApiCallback<Kip37TransactionStatusResponse> callback) throws ApiException {
        return this.burnAsync(addressOrAlias, id, amount, null, callback);
    }

    public Call burnAsync(String addressOrAlias, String id, String amount, ApiCallback<Kip37TransactionStatusResponse> callback) throws ApiException {
        return this.burnAsync(addressOrAlias, id, amount, null, callback);
    }

    public Call burnAsync(String addressOrAlias, BigInteger id, BigInteger amount, String from, ApiCallback<Kip37TransactionStatusResponse> callback) throws ApiException {
        return this.burnAsync(addressOrAlias, new BigInteger[]{id}, new BigInteger[]{amount}, from, callback);
    }

    public Call burnAsync(String addressOrAlias, String id, String amount, String from, ApiCallback<Kip37TransactionStatusResponse> callback) throws ApiException {
        return this.burnAsync(addressOrAlias, new String[]{id}, new String[]{amount}, from, callback);
    }

    public Call burnAsync(String addressOrAlias, BigInteger[] ids, BigInteger[] amounts, ApiCallback<Kip37TransactionStatusResponse> callback) throws ApiException {
        String[] ids_hex = (String[])Arrays.stream(ids).map(Numeric::toHexStringWithPrefix).toArray(String[]::new);
        String[] amounts_hex = (String[])Arrays.stream(amounts).map(Numeric::toHexStringWithPrefix).toArray(String[]::new);
        return this.burnAsync(addressOrAlias, ids_hex, amounts_hex, null, callback);
    }

    public Call burnAsync(String addressOrAlias, String[] ids, String[] amounts, ApiCallback<Kip37TransactionStatusResponse> callback) throws ApiException {
        return this.burnAsync(addressOrAlias, ids, amounts, null, callback);
    }

    public Call burnAsync(String addressOrAlias, BigInteger[] ids, BigInteger[] amounts, String from, ApiCallback<Kip37TransactionStatusResponse> callback) throws ApiException {
        String[] ids_hex = (String[])Arrays.stream(ids).map(Numeric::toHexStringWithPrefix).toArray(String[]::new);
        String[] amounts_hex = (String[])Arrays.stream(amounts).map(Numeric::toHexStringWithPrefix).toArray(String[]::new);
        return this.burnAsync(addressOrAlias, ids_hex, amounts_hex, from, callback);
    }

    public Call burnAsync(String addressOrAlias, String[] ids, String[] amounts, String from, ApiCallback<Kip37TransactionStatusResponse> callback) throws ApiException {
        BurnKip37TokenRequest request = new BurnKip37TokenRequest();
        request.setFrom(from);
        request.setIds(Arrays.asList(ids));
        request.setAmounts(Arrays.asList(amounts));
        return this.tokenApi.burnTokenAsync(this.chainId, addressOrAlias, request, callback);
    }

    public Kip37TransactionStatusResponse mint(String addressOrAlias, String to, BigInteger id, BigInteger amount) throws ApiException {
        return this.mint(addressOrAlias, to, id, amount, null);
    }

    public Kip37TransactionStatusResponse mint(String addressOrAlias, String to, String id, String amount) throws ApiException {
        return this.mint(addressOrAlias, to, id, amount, null);
    }

    public Kip37TransactionStatusResponse mint(String addressOrAlias, String to, BigInteger id, BigInteger amount, String minter) throws ApiException {
        return this.mint(addressOrAlias, to, new BigInteger[]{id}, new BigInteger[]{amount}, minter);
    }

    public Kip37TransactionStatusResponse mint(String addressOrAlias, String to, String id, String amount, String minter) throws ApiException {
        return this.mint(addressOrAlias, to, new String[]{id}, new String[]{amount}, minter);
    }

    public Kip37TransactionStatusResponse mint(String addressOrAlias, String to, BigInteger[] ids, BigInteger[] amounts) throws ApiException {
        return this.mint(addressOrAlias, to, ids, amounts, null);
    }

    public Kip37TransactionStatusResponse mint(String addressOrAlias, String to, String[] ids, String[] amounts) throws ApiException {
        return this.mint(addressOrAlias, to, ids, amounts, null);
    }

    public Kip37TransactionStatusResponse mint(String addressOrAlias, String to, BigInteger[] ids, BigInteger[] amounts, String minter) throws ApiException {
        String[] ids_hex = (String[])Arrays.stream(ids).map(Numeric::toHexStringWithPrefix).toArray(String[]::new);
        String[] amounts_hex = (String[])Arrays.stream(amounts).map(Numeric::toHexStringWithPrefix).toArray(String[]::new);
        return this.mint(addressOrAlias, to, ids_hex, amounts_hex, minter);
    }

    public Kip37TransactionStatusResponse mint(String addressOrAlias, String to, String[] ids, String[] amounts, String minter) throws ApiException {
        MintKip37TokenRequest request = new MintKip37TokenRequest();
        request.setSender(minter);
        request.setTo(to);
        request.setIds(Arrays.asList(ids));
        request.setAmounts(Arrays.asList(amounts));
        return this.tokenApi.mintToken(this.chainId, addressOrAlias, request);
    }

    public Call mintAsync(String addressOrAlias, String to, BigInteger id, BigInteger amount, ApiCallback<Kip37TransactionStatusResponse> callback) throws ApiException {
        return this.mintAsync(addressOrAlias, to, id, amount, null, callback);
    }

    public Call mintAsync(String addressOrAlias, String to, String id, String amount, ApiCallback<Kip37TransactionStatusResponse> callback) throws ApiException {
        return this.mintAsync(addressOrAlias, to, id, amount, null, callback);
    }

    public Call mintAsync(String addressOrAlias, String to, BigInteger id, BigInteger amount, String minter, ApiCallback<Kip37TransactionStatusResponse> callback) throws ApiException {
        return this.mintAsync(addressOrAlias, to, new BigInteger[]{id}, new BigInteger[]{amount}, minter, callback);
    }

    public Call mintAsync(String addressOrAlias, String to, String id, String amount, String minter, ApiCallback<Kip37TransactionStatusResponse> callback) throws ApiException {
        return this.mintAsync(addressOrAlias, to, new String[]{id}, new String[]{amount}, minter, callback);
    }

    public Call mintAsync(String addressOrAlias, String to, BigInteger[] ids, BigInteger[] amounts, ApiCallback<Kip37TransactionStatusResponse> callback) throws ApiException {
        return this.mintAsync(addressOrAlias, to, ids, amounts, null, callback);
    }

    public Call mintAsync(String addressOrAlias, String to, String[] ids, String[] amounts, ApiCallback<Kip37TransactionStatusResponse> callback) throws ApiException {
        return this.mintAsync(addressOrAlias, to, ids, amounts, null, callback);
    }

    public Call mintAsync(String addressOrAlias, String to, BigInteger[] ids, BigInteger[] amounts, String minter, ApiCallback<Kip37TransactionStatusResponse> callback) throws ApiException {
        String[] ids_hex = (String[])Arrays.stream(ids).map(Numeric::toHexStringWithPrefix).toArray(String[]::new);
        String[] amounts_hex = (String[])Arrays.stream(amounts).map(Numeric::toHexStringWithPrefix).toArray(String[]::new);
        return this.mintAsync(addressOrAlias, to, ids_hex, amounts_hex, minter, callback);
    }

    public Call mintAsync(String addressOrAlias, String to, String[] ids, String[] amounts, String sender, ApiCallback<Kip37TransactionStatusResponse> callback) throws ApiException {
        MintKip37TokenRequest request = new MintKip37TokenRequest();
        request.setSender(sender);
        request.setTo(to);
        request.setIds(Arrays.asList(ids));
        request.setAmounts(Arrays.asList(amounts));
        return this.tokenApi.mintTokenAsync(this.chainId, addressOrAlias, request, callback);
    }

    public Kip37TransactionStatusResponse transfer(String addressOrAlias, String sender, String owner, String to, BigInteger id, BigInteger amount) throws ApiException {
        return this.transfer(addressOrAlias, sender, owner, to, new BigInteger[]{id}, new BigInteger[]{amount});
    }

    public Kip37TransactionStatusResponse transfer(String addressOrAlias, String sender, String owner, String to, String id, String amount) throws ApiException {
        return this.transfer(addressOrAlias, sender, owner, to, new String[]{id}, new String[]{amount});
    }

    public Kip37TransactionStatusResponse transfer(String addressOrAlias, String sender, String owner, String to, BigInteger[] ids, BigInteger[] amounts) throws ApiException {
        String[] ids_hex = (String[])Arrays.stream(ids).map(Numeric::toHexStringWithPrefix).toArray(String[]::new);
        String[] amounts_hex = (String[])Arrays.stream(amounts).map(Numeric::toHexStringWithPrefix).toArray(String[]::new);
        return this.transfer(addressOrAlias, sender, owner, to, ids_hex, amounts_hex);
    }

    public Kip37TransactionStatusResponse transfer(String addressOrAlias, String sender, String owner, String to, String[] ids, String[] amounts) throws ApiException {
        TransferKip37TokenRequest request = new TransferKip37TokenRequest();
        request.setSender(sender);
        request.setOwner(owner);
        request.setTo(to);
        request.setIds(Arrays.asList(ids));
        request.setAmounts(Arrays.asList(amounts));
        return this.tokenApi.transferToken(this.chainId, addressOrAlias, request);
    }

    public Call transferAsync(String addressOrAlias, String sender, String owner, String to, BigInteger id, BigInteger amount, ApiCallback<Kip37TransactionStatusResponse> callback) throws ApiException {
        return this.transferAsync(addressOrAlias, sender, owner, to, new BigInteger[]{id}, new BigInteger[]{amount}, callback);
    }

    public Call transferAsync(String addressOrAlias, String sender, String owner, String to, String id, String amount, ApiCallback<Kip37TransactionStatusResponse> callback) throws ApiException {
        return this.transferAsync(addressOrAlias, sender, owner, to, new String[]{id}, new String[]{amount}, callback);
    }

    public Call transferAsync(String addressOrAlias, String sender, String owner, String to, BigInteger[] ids, BigInteger[] amounts, ApiCallback<Kip37TransactionStatusResponse> callback) throws ApiException {
        String[] ids_hex = (String[])Arrays.stream(ids).map(Numeric::toHexStringWithPrefix).toArray(String[]::new);
        String[] amounts_hex = (String[])Arrays.stream(amounts).map(Numeric::toHexStringWithPrefix).toArray(String[]::new);
        return this.transferAsync(addressOrAlias, sender, owner, to, ids_hex, amounts_hex, callback);
    }

    public Call transferAsync(String addressOrAlias, String sender, String owner, String to, String[] ids, String[] amounts, ApiCallback<Kip37TransactionStatusResponse> callback) throws ApiException {
        TransferKip37TokenRequest request = new TransferKip37TokenRequest();
        request.setSender(sender);
        request.setOwner(owner);
        request.setTo(to);
        request.setIds(Arrays.asList(ids));
        request.setAmounts(Arrays.asList(amounts));
        return this.tokenApi.transferTokenAsync(this.chainId, addressOrAlias, request, callback);
    }

    public Kip37TransactionStatusResponse pauseToken(String addressOrAlias, BigInteger tokenId) throws ApiException {
        return this.pauseToken(addressOrAlias, tokenId, null);
    }

    public Kip37TransactionStatusResponse pauseToken(String addressOrAlias, String tokenId) throws ApiException {
        return this.pauseToken(addressOrAlias, tokenId, null);
    }

    public Kip37TransactionStatusResponse pauseToken(String addressOrAlias, BigInteger tokenId, String pauser) throws ApiException {
        return this.pauseToken(addressOrAlias, Numeric.toHexStringWithPrefix((BigInteger)tokenId), pauser);
    }

    public Kip37TransactionStatusResponse pauseToken(String addressOrAlias, String tokenId, String pauser) throws ApiException {
        OperateKip37ContractRequest request = new OperateKip37ContractRequest();
        request.setSender(pauser);
        return this.tokenApi.pauseToken(this.chainId, addressOrAlias, tokenId, request);
    }

    public Call pauseTokenAsync(String addressOrAlias, BigInteger tokenId, ApiCallback<Kip37TransactionStatusResponse> callback) throws ApiException {
        return this.pauseTokenAsync(addressOrAlias, tokenId, null, callback);
    }

    public Call pauseTokenAsync(String addressOrAlias, String tokenId, ApiCallback<Kip37TransactionStatusResponse> callback) throws ApiException {
        return this.pauseTokenAsync(addressOrAlias, tokenId, null, callback);
    }

    public Call pauseTokenAsync(String addressOrAlias, BigInteger tokenId, String pauser, ApiCallback<Kip37TransactionStatusResponse> callback) throws ApiException {
        return this.pauseTokenAsync(addressOrAlias, Numeric.toHexStringWithPrefix((BigInteger)tokenId), pauser, callback);
    }

    public Call pauseTokenAsync(String addressOrAlias, String tokenId, String pauser, ApiCallback<Kip37TransactionStatusResponse> callback) throws ApiException {
        OperateKip37ContractRequest request = new OperateKip37ContractRequest();
        request.setSender(pauser);
        return this.tokenApi.pauseTokenAsync(this.chainId, addressOrAlias, tokenId, request, callback);
    }

    public Kip37TransactionStatusResponse unpauseToken(String addressOrAlias, BigInteger tokenId) throws ApiException {
        return this.unpauseToken(addressOrAlias, tokenId, null);
    }

    public Kip37TransactionStatusResponse unpauseToken(String addressOrAlias, String tokenId) throws ApiException {
        return this.unpauseToken(addressOrAlias, tokenId, null);
    }

    public Kip37TransactionStatusResponse unpauseToken(String addressOrAlias, BigInteger tokenId, String pauser) throws ApiException {
        return this.unpauseToken(addressOrAlias, Numeric.toHexStringWithPrefix((BigInteger)tokenId), pauser);
    }

    public Kip37TransactionStatusResponse unpauseToken(String addressOrAlias, String tokenId, String pauser) throws ApiException {
        OperateKip37ContractRequest request = new OperateKip37ContractRequest();
        request.setSender(pauser);
        return this.tokenApi.unpauseToken(this.chainId, addressOrAlias, tokenId, request);
    }

    public Call unpauseTokenAsync(String addressOrAlias, BigInteger tokenId, ApiCallback<Kip37TransactionStatusResponse> callback) throws ApiException {
        return this.unpauseTokenAsync(addressOrAlias, tokenId, null, callback);
    }

    public Call unpauseTokenAsync(String addressOrAlias, String tokenId, ApiCallback<Kip37TransactionStatusResponse> callback) throws ApiException {
        return this.unpauseTokenAsync(addressOrAlias, tokenId, null, callback);
    }

    public Call unpauseTokenAsync(String addressOrAlias, BigInteger tokenId, String pauser, ApiCallback<Kip37TransactionStatusResponse> callback) throws ApiException {
        return this.unpauseTokenAsync(addressOrAlias, Numeric.toHexStringWithPrefix((BigInteger)tokenId), pauser, callback);
    }

    public Call unpauseTokenAsync(String addressOrAlias, String tokenId, String pauser, ApiCallback<Kip37TransactionStatusResponse> callback) throws ApiException {
        OperateKip37ContractRequest request = new OperateKip37ContractRequest();
        request.setSender(pauser);
        return this.tokenApi.unpauseTokenAsync(this.chainId, addressOrAlias, tokenId, request, callback);
    }

    public Kip37TokenListResponse getTokenListByOwner(String addressOrAlias, String ownerAddress) throws ApiException {
        return this.getTokenListByOwner(addressOrAlias, ownerAddress, new KIP37QueryOptions());
    }

    public Kip37TokenListResponse getTokenListByOwner(String addressOrAlias, String ownerAddress, KIP37QueryOptions queryOptions) throws ApiException {
        return this.tokenOwnershipApi.getTokensByOwner(addressOrAlias, ownerAddress, this.chainId, queryOptions.getSize(), queryOptions.getCursor());
    }

    public Call getTokenListByOwnerAsync(String addressOrAlias, String ownerAddress, ApiCallback<Kip37TokenListResponse> callback) throws ApiException {
        return this.getTokenListByOwnerAsync(addressOrAlias, ownerAddress, new KIP37QueryOptions(), callback);
    }

    public Call getTokenListByOwnerAsync(String addressOrAlias, String ownerAddress, KIP37QueryOptions queryOptions, ApiCallback<Kip37TokenListResponse> callback) throws ApiException {
        return this.tokenOwnershipApi.getTokensByOwnerAsync(addressOrAlias, ownerAddress, this.chainId, queryOptions.getSize(), queryOptions.getCursor(), callback);
    }

    public Kip37DeployerResponse getDeployer() throws ApiException {
        return this.deployerApi.getDefaultDeployer(this.chainId);
    }

    public Call getDeployerAsync(ApiCallback<Kip37DeployerResponse> callback) throws ApiException {
        return this.deployerApi.getDefaultDeployerAsync(this.chainId, callback);
    }

    public Kip37ContractApi getContractApi() {
        return this.contractApi;
    }

    public void setContractApi(Kip37ContractApi contractApi) {
        this.contractApi = contractApi;
    }

    public Kip37DeployerApi getDeployerApi() {
        return this.deployerApi;
    }

    public void setDeployerApi(Kip37DeployerApi deployerApi) {
        this.deployerApi = deployerApi;
    }

    public Kip37TokenApi getTokenApi() {
        return this.tokenApi;
    }

    public void setTokenApi(Kip37TokenApi tokenApi) {
        this.tokenApi = tokenApi;
    }

    public Kip37TokenOwnershipApi getTokenOwnershipApi() {
        return this.tokenOwnershipApi;
    }

    public void setTokenOwnershipApi(Kip37TokenOwnershipApi tokenOwnershipApi) {
        this.tokenOwnershipApi = tokenOwnershipApi;
    }

    public String getChainId() {
        return this.chainId;
    }

    public void setChainId(String chainId) {
        this.chainId = chainId;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
        this.setContractApi(new Kip37ContractApi(apiClient));
        this.setDeployerApi(new Kip37DeployerApi(apiClient));
        this.setTokenApi(new Kip37TokenApi(apiClient));
        this.setTokenOwnershipApi(new Kip37TokenOwnershipApi(apiClient));
    }
}

