/*
 * Decompiled with CFR 0.152.
 */
package xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="Cancel User Fee Delegation transaction request schema")
public class FDUserCancelTransactionRequest {
    @SerializedName(value="from")
    private String from = null;
    @SerializedName(value="transactionHash")
    private String transactionHash = null;
    @SerializedName(value="gas")
    private Long gas = 100000L;
    @SerializedName(value="submit")
    private Boolean submit = null;
    @SerializedName(value="feeRatio")
    private Long feeRatio = null;
    @SerializedName(value="feePayer")
    private String feePayer = null;
    @SerializedName(value="nonce")
    private Long nonce = null;

    public FDUserCancelTransactionRequest from(String from) {
        this.from = from;
        return this;
    }

    @Schema(example="0x60d0902c428D0E197F97a756011Fd4893C1E57B0", required=true, description="Klaytn transaction address to send transaction")
    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public FDUserCancelTransactionRequest transactionHash(String transactionHash) {
        this.transactionHash = transactionHash;
        return this;
    }

    @Schema(example="0xc886555413f0a9c13257ac0e2308981fe4d82b906370e81e49e1e52f5142e752", description="Transaction hash value")
    public String getTransactionHash() {
        return this.transactionHash;
    }

    public void setTransactionHash(String transactionHash) {
        this.transactionHash = transactionHash;
    }

    public FDUserCancelTransactionRequest gas(Long gas) {
        this.gas = gas;
        return this;
    }

    @Schema(example="0", description="Maximum gas fee to be used for sending the transaction (By entering 0, it will be set to default value))")
    public Long getGas() {
        return this.gas;
    }

    public void setGas(Long gas) {
        this.gas = gas;
    }

    public FDUserCancelTransactionRequest submit(Boolean submit) {
        this.submit = submit;
        return this;
    }

    @Schema(example="true", description="Shows whether to send the transaction to Klaytn")
    public Boolean isSubmit() {
        return this.submit;
    }

    public void setSubmit(Boolean submit) {
        this.submit = submit;
    }

    public FDUserCancelTransactionRequest feeRatio(Long feeRatio) {
        this.feeRatio = feeRatio;
        return this;
    }

    @Schema(example="20", description="The ratio of the gas fee to be delegated. When it's empty or 0, the entire fee will be delegated.")
    public Long getFeeRatio() {
        return this.feeRatio;
    }

    public void setFeeRatio(Long feeRatio) {
        this.feeRatio = feeRatio;
    }

    public FDUserCancelTransactionRequest feePayer(String feePayer) {
        this.feePayer = feePayer;
        return this;
    }

    @Schema(example="0x0E916319466895015cbcB453a1ff8c4134FEB902", required=true, description="Account address for user Fee Delegation")
    public String getFeePayer() {
        return this.feePayer;
    }

    public void setFeePayer(String feePayer) {
        this.feePayer = feePayer;
    }

    public FDUserCancelTransactionRequest nonce(Long nonce) {
        this.nonce = nonce;
        return this;
    }

    @Schema(example="1446", description="Unique identifier for the transactions being sent (By entering 0, the nonce will be automatically determined)")
    public Long getNonce() {
        return this.nonce;
    }

    public void setNonce(Long nonce) {
        this.nonce = nonce;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FDUserCancelTransactionRequest fdUserCancelTransactionRequest = (FDUserCancelTransactionRequest)o;
        return Objects.equals(this.from, fdUserCancelTransactionRequest.from) && Objects.equals(this.transactionHash, fdUserCancelTransactionRequest.transactionHash) && Objects.equals(this.gas, fdUserCancelTransactionRequest.gas) && Objects.equals(this.submit, fdUserCancelTransactionRequest.submit) && Objects.equals(this.feeRatio, fdUserCancelTransactionRequest.feeRatio) && Objects.equals(this.feePayer, fdUserCancelTransactionRequest.feePayer) && Objects.equals(this.nonce, fdUserCancelTransactionRequest.nonce);
    }

    public int hashCode() {
        return Objects.hash(this.from, this.transactionHash, this.gas, this.submit, this.feeRatio, this.feePayer, this.nonce);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FDUserCancelTransactionRequest {\n");
        sb.append("    from: ").append(this.toIndentedString(this.from)).append("\n");
        sb.append("    transactionHash: ").append(this.toIndentedString(this.transactionHash)).append("\n");
        sb.append("    gas: ").append(this.toIndentedString(this.gas)).append("\n");
        sb.append("    submit: ").append(this.toIndentedString(this.submit)).append("\n");
        sb.append("    feeRatio: ").append(this.toIndentedString(this.feeRatio)).append("\n");
        sb.append("    feePayer: ").append(this.toIndentedString(this.feePayer)).append("\n");
        sb.append("    nonce: ").append(this.toIndentedString(this.nonce)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

