/*
 * Decompiled with CFR 0.152.
 */
package xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="RLP Fee Delegation transaction request schema")
public class FDProcessRLPRequest {
    @SerializedName(value="rlp")
    private String rlp = null;
    @SerializedName(value="submit")
    private Boolean submit = null;
    @SerializedName(value="feeRatio")
    private Long feeRatio = null;

    public FDProcessRLPRequest rlp(String rlp) {
        this.rlp = rlp;
        return this;
    }

    @Schema(example="0x2af90209808505d21dba0083895440808094c48cd8576df1c5cf9e8cc054c2c9fa0f1e2b6796b9013a60806040526000805534801561001457600080fd5b50610116806100246000396000f3006080604052600436106053576000357c0100000000000000000000000000000000000000000000000000000000900463ffffffff16806306661abd14605857806342cbb15c146080578063d14e62b81460a8575b600080fd5b348015606357600080fd5b50606a60d2565b6040518082815260200191505060405180910390f35b348015608b57600080fd5b50609260d8565b6040518082815260200191505060405180910390f35b34801560b357600080fd5b5060d06004803603810190808035906020019092919050505060e0565b005b60005481565b600043905090565b80600081905550505600a165627a7a7230582059344095f4f4ad6d1a407f2f20de3e3e65e8ead0c1aaf64728546db62db6f76f0029801480f847f8458207f6a0226cf7995a62e1c47d3103a4203f8d1249301bf253109626604f0b606ec4aef6a03b70ab372b7a536a61baad6d3f5ab8bd5768bd68301e4c8d1934fb958358bde5941b71a63903e35371e2fc41c6012effb99b9a2c0ff847f8458207f5a0e1aa7d53d64a19579d71cce49a3c0cd9765285bfcfd4627caeea0b6f9a5b7f03a07242e172fb756bb56a03f88f4b6824bb57401f124f3bc0d12016fd140da2ee91", required=true, description="The Klaytn RLP formats SigRLP or TxHashRLP are accepted as RLP values and only (partial) fee delegation transaction type is allowed.")
    public String getRlp() {
        return this.rlp;
    }

    public void setRlp(String rlp) {
        this.rlp = rlp;
    }

    public FDProcessRLPRequest submit(Boolean submit) {
        this.submit = submit;
        return this;
    }

    @Schema(example="true", description="Shows whether to send the transaction to Klaytn")
    public Boolean isSubmit() {
        return this.submit;
    }

    public void setSubmit(Boolean submit) {
        this.submit = submit;
    }

    public FDProcessRLPRequest feeRatio(Long feeRatio) {
        this.feeRatio = feeRatio;
        return this;
    }

    @Schema(example="20", description="The ratio of the gas fee to be delegated. When it's empty or 0, the entire fee will be delegated.")
    public Long getFeeRatio() {
        return this.feeRatio;
    }

    public void setFeeRatio(Long feeRatio) {
        this.feeRatio = feeRatio;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FDProcessRLPRequest fdProcessRLPRequest = (FDProcessRLPRequest)o;
        return Objects.equals(this.rlp, fdProcessRLPRequest.rlp) && Objects.equals(this.submit, fdProcessRLPRequest.submit) && Objects.equals(this.feeRatio, fdProcessRLPRequest.feeRatio);
    }

    public int hashCode() {
        return Objects.hash(this.rlp, this.submit, this.feeRatio);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FDProcessRLPRequest {\n");
        sb.append("    rlp: ").append(this.toIndentedString(this.rlp)).append("\n");
        sb.append("    submit: ").append(this.toIndentedString(this.submit)).append("\n");
        sb.append("    feeRatio: ").append(this.toIndentedString(this.feeRatio)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

