/*
 * Decompiled with CFR 0.152.
 */
package xyz.groundx.caver_ext_kas.kas.kip7;

import com.squareup.okhttp.Call;
import java.math.BigInteger;
import org.web3j.utils.Numeric;
import xyz.groundx.caver_ext_kas.kas.kip7.KIP7QueryOptions;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.ApiCallback;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.ApiClient;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.ApiException;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip7.api.Kip7Api;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip7.api.Kip7DeployerApi;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip7.model.ApproveKip7TokenRequest;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip7.model.BurnFromKip7TokenRequest;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip7.model.BurnKip7TokenRequest;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip7.model.DeployKip7ContractRequest;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip7.model.Kip7ContractListResponse;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip7.model.Kip7ContractMetadataResponse;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip7.model.Kip7DeployerResponse;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip7.model.Kip7TokenBalanceResponse;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip7.model.Kip7TransactionStatusResponse;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip7.model.MintKip7TokenRequest;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip7.model.TransferKip7TokenFromRequest;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip7.model.TransferKip7TokenRequest;

public class KIP7 {
    Kip7Api kip7Api;
    Kip7DeployerApi kip7DeployerApi;
    String chainId;
    ApiClient apiClient;

    public KIP7(String chainId, ApiClient apiClient) {
        this.chainId = chainId;
        this.apiClient = apiClient;
        this.setKip7Api(new Kip7Api(apiClient));
        this.setKip7DeployerApi(new Kip7DeployerApi(apiClient));
    }

    public Kip7TransactionStatusResponse deploy(String name, String symbol, int decimals, BigInteger initialSupply, String alias) throws ApiException {
        return this.deploy(name, symbol, decimals, Numeric.toHexStringWithPrefix((BigInteger)initialSupply), alias);
    }

    public Call deployAsync(String name, String symbol, int decimals, BigInteger initialSupply, String alias, ApiCallback<Kip7TransactionStatusResponse> callback) throws ApiException {
        return this.deployAsync(name, symbol, decimals, Numeric.toHexStringWithPrefix((BigInteger)initialSupply), alias, callback);
    }

    public Kip7TransactionStatusResponse deploy(String name, String symbol, int decimals, String initialSupply, String alias) throws ApiException {
        DeployKip7ContractRequest request = new DeployKip7ContractRequest();
        request.setName(name);
        request.setSymbol(symbol);
        request.setDecimals(Long.valueOf(decimals));
        request.setInitialSupply(initialSupply);
        request.setAlias(alias);
        return this.kip7Api.deployContract(this.chainId, request);
    }

    public Call deployAsync(String name, String symbol, int decimals, String initialSupply, String alias, ApiCallback<Kip7TransactionStatusResponse> callback) throws ApiException {
        DeployKip7ContractRequest request = new DeployKip7ContractRequest();
        request.setName(name);
        request.setSymbol(symbol);
        request.setDecimals(Long.valueOf(decimals));
        request.setInitialSupply(initialSupply);
        request.setAlias(alias);
        return this.kip7Api.deployContractAsync(this.chainId, request, callback);
    }

    public Kip7ContractMetadataResponse getContract(String addressOrAlias) throws ApiException {
        return this.kip7Api.getContract(this.chainId, addressOrAlias);
    }

    public Call getContractAsync(String addressOrAlias, ApiCallback<Kip7ContractMetadataResponse> callback) throws ApiException {
        return this.kip7Api.getContractAsync(this.chainId, addressOrAlias, callback);
    }

    public Kip7ContractListResponse getContractList() throws ApiException {
        return this.getContractList(new KIP7QueryOptions());
    }

    public Call getContractListAsync(ApiCallback<Kip7ContractListResponse> callback) throws ApiException {
        return this.getContractListAsync(new KIP7QueryOptions(), callback);
    }

    public Kip7ContractListResponse getContractList(KIP7QueryOptions options) throws ApiException {
        String size = null;
        if (options.getSize() != null) {
            size = Integer.toString(options.getSize());
        }
        return this.kip7Api.listContractsInDeployerPool(this.chainId, size, options.getCursor(), options.getStatus());
    }

    public Call getContractListAsync(KIP7QueryOptions options, ApiCallback<Kip7ContractListResponse> callback) throws ApiException {
        String size = null;
        if (options.getSize() != null) {
            size = Integer.toString(options.getSize());
        }
        return this.kip7Api.listContractsInDeployerPoolAsync(this.chainId, size, options.getCursor(), options.getStatus(), callback);
    }

    public Kip7TokenBalanceResponse allowance(String addressOrAlias, String owner, String spender) throws ApiException {
        return this.kip7Api.getTokenAllowance(this.chainId, addressOrAlias, owner, spender);
    }

    public Call allowanceAsync(String addressOrAlias, String owner, String spender, ApiCallback<Kip7TokenBalanceResponse> callback) throws ApiException {
        return this.kip7Api.getTokenAllowanceAsync(this.chainId, addressOrAlias, owner, spender, callback);
    }

    public Kip7TokenBalanceResponse balance(String addressOrAlias, String owner) throws ApiException {
        return this.kip7Api.getTokenBalance(this.chainId, addressOrAlias, owner);
    }

    public Call balanceAsync(String addressOrAlias, String owner, ApiCallback<Kip7TokenBalanceResponse> callback) throws ApiException {
        return this.kip7Api.getTokenBalanceAsync(this.chainId, addressOrAlias, owner, callback);
    }

    public Kip7TransactionStatusResponse approve(String addressOrAlias, String spender, BigInteger amount) throws ApiException {
        return this.approve(addressOrAlias, null, spender, amount);
    }

    public Call approveAsync(String addressOrAlias, String spender, BigInteger amount, ApiCallback<Kip7TransactionStatusResponse> callback) throws ApiException {
        return this.approveAsync(addressOrAlias, null, spender, amount, callback);
    }

    public Kip7TransactionStatusResponse approve(String addressOrAlias, String spender, String amount) throws ApiException {
        return this.approve(addressOrAlias, null, spender, amount);
    }

    public Call approveAsync(String addressOrAlias, String spender, String amount, ApiCallback<Kip7TransactionStatusResponse> callback) throws ApiException {
        return this.approveAsync(addressOrAlias, null, spender, amount, callback);
    }

    public Kip7TransactionStatusResponse approve(String addressOrAlias, String owner, String spender, BigInteger amount) throws ApiException {
        return this.approve(addressOrAlias, owner, spender, Numeric.toHexStringWithPrefix((BigInteger)amount));
    }

    public Call approveAsync(String addressOrAlias, String owner, String spender, BigInteger amount, ApiCallback<Kip7TransactionStatusResponse> callback) throws ApiException {
        return this.approveAsync(addressOrAlias, owner, spender, Numeric.toHexStringWithPrefix((BigInteger)amount), callback);
    }

    public Kip7TransactionStatusResponse approve(String addressOrAlias, String owner, String spender, String amount) throws ApiException {
        ApproveKip7TokenRequest request = new ApproveKip7TokenRequest();
        request.setOwner(owner);
        request.setSpender(spender);
        request.setAmount(amount);
        return this.kip7Api.approveToken(this.chainId, addressOrAlias, request);
    }

    public Call approveAsync(String addressOrAlias, String owner, String spender, String amount, ApiCallback<Kip7TransactionStatusResponse> callback) throws ApiException {
        ApproveKip7TokenRequest request = new ApproveKip7TokenRequest();
        request.setOwner(owner);
        request.setSpender(spender);
        request.setAmount(amount);
        return this.kip7Api.approveTokenAsync(this.chainId, addressOrAlias, request, callback);
    }

    public Kip7TransactionStatusResponse transfer(String addressOrAlias, String to, BigInteger amount) throws ApiException {
        return this.transfer(addressOrAlias, null, to, Numeric.toHexStringWithPrefix((BigInteger)amount));
    }

    public Call transferAsync(String addressOrAlias, String to, BigInteger amount, ApiCallback<Kip7TransactionStatusResponse> callback) throws ApiException {
        return this.transferAsync(addressOrAlias, null, to, Numeric.toHexStringWithPrefix((BigInteger)amount), callback);
    }

    public Kip7TransactionStatusResponse transfer(String addressOrAlias, String to, String amount) throws ApiException {
        return this.transfer(addressOrAlias, null, to, amount);
    }

    public Call transferAsync(String addressOrAlias, String to, String amount, ApiCallback<Kip7TransactionStatusResponse> callback) throws ApiException {
        return this.transferAsync(addressOrAlias, null, to, amount, callback);
    }

    public Kip7TransactionStatusResponse transfer(String addressOrAlias, String from, String to, BigInteger amount) throws ApiException {
        return this.transfer(addressOrAlias, from, to, Numeric.toHexStringWithPrefix((BigInteger)amount));
    }

    public Call transferAsync(String addressOrAlias, String from, String to, BigInteger amount, ApiCallback<Kip7TransactionStatusResponse> callback) throws ApiException {
        return this.transferAsync(addressOrAlias, from, to, Numeric.toHexStringWithPrefix((BigInteger)amount), callback);
    }

    public Kip7TransactionStatusResponse transfer(String addressOrAlias, String from, String to, String amount) throws ApiException {
        TransferKip7TokenRequest request = new TransferKip7TokenRequest();
        request.setFrom(from);
        request.setTo(to);
        request.setAmount(amount);
        return this.kip7Api.transferToken(this.chainId, addressOrAlias, request);
    }

    public Call transferAsync(String addressOrAlias, String from, String to, String amount, ApiCallback<Kip7TransactionStatusResponse> callback) throws ApiException {
        TransferKip7TokenRequest request = new TransferKip7TokenRequest();
        request.setFrom(from);
        request.setTo(to);
        request.setAmount(amount);
        return this.kip7Api.transferTokenAsync(this.chainId, addressOrAlias, request, callback);
    }

    public Kip7TransactionStatusResponse transferFrom(String addressOrAlias, String spender, String owner, String to, BigInteger amount) throws ApiException {
        return this.transferFrom(addressOrAlias, spender, owner, to, Numeric.toHexStringWithPrefix((BigInteger)amount));
    }

    public Call transferFromAsync(String addressOrAlias, String spender, String owner, String to, BigInteger amount, ApiCallback<Kip7TransactionStatusResponse> callback) throws ApiException {
        return this.transferFromAsync(addressOrAlias, spender, owner, to, Numeric.toHexStringWithPrefix((BigInteger)amount), callback);
    }

    public Kip7TransactionStatusResponse transferFrom(String addressOrAlias, String spender, String owner, String to, String amount) throws ApiException {
        TransferKip7TokenFromRequest request = new TransferKip7TokenFromRequest();
        request.setSpender(spender);
        request.setOwner(owner);
        request.setTo(to);
        request.setAmount(amount);
        return this.kip7Api.transferFromToken(this.chainId, addressOrAlias, request);
    }

    public Call transferFromAsync(String addressOrAlias, String spender, String owner, String to, String amount, ApiCallback<Kip7TransactionStatusResponse> callback) throws ApiException {
        TransferKip7TokenFromRequest request = new TransferKip7TokenFromRequest();
        request.setSpender(spender);
        request.setOwner(owner);
        request.setTo(to);
        request.setAmount(amount);
        return this.kip7Api.transferFromTokenAsync(this.chainId, addressOrAlias, request, callback);
    }

    public Kip7TransactionStatusResponse mint(String addressOrAlias, String to, BigInteger amount) throws ApiException {
        return this.mint(addressOrAlias, to, Numeric.toHexStringWithPrefix((BigInteger)amount));
    }

    public Call mintAsync(String addressOrAlias, String to, BigInteger amount, ApiCallback<Kip7TransactionStatusResponse> callback) throws ApiException {
        return this.mintAsync(addressOrAlias, to, Numeric.toHexStringWithPrefix((BigInteger)amount), callback);
    }

    public Kip7TransactionStatusResponse mint(String addressOrAlias, String to, String amount) throws ApiException {
        MintKip7TokenRequest request = new MintKip7TokenRequest();
        request.setTo(to);
        request.setAmount(amount);
        return this.kip7Api.mintToken(this.chainId, addressOrAlias, request);
    }

    public Call mintAsync(String addressOrAlias, String to, String amount, ApiCallback<Kip7TransactionStatusResponse> callback) throws ApiException {
        MintKip7TokenRequest request = new MintKip7TokenRequest();
        request.setTo(to);
        request.setAmount(amount);
        return this.kip7Api.mintTokenAsync(this.chainId, addressOrAlias, request, callback);
    }

    public Kip7TransactionStatusResponse burn(String addressOrAlias, BigInteger amount) throws ApiException {
        return this.burn(addressOrAlias, null, Numeric.toHexStringWithPrefix((BigInteger)amount));
    }

    public Call burnAsync(String addressOrAlias, BigInteger amount, ApiCallback<Kip7TransactionStatusResponse> callback) throws ApiException {
        return this.burnAsync(addressOrAlias, null, amount, callback);
    }

    public Kip7TransactionStatusResponse burn(String addressOrAlias, String amount) throws ApiException {
        return this.burn(addressOrAlias, null, amount);
    }

    public Call burnAsync(String addressOrAlias, String amount, ApiCallback<Kip7TransactionStatusResponse> callback) throws ApiException {
        return this.burnAsync(addressOrAlias, null, amount, callback);
    }

    public Kip7TransactionStatusResponse burn(String addressOrAlias, String from, BigInteger amount) throws ApiException {
        return this.burn(addressOrAlias, from, Numeric.toHexStringWithPrefix((BigInteger)amount));
    }

    public Call burnAsync(String addressOrAlias, String from, BigInteger amount, ApiCallback<Kip7TransactionStatusResponse> callback) throws ApiException {
        return this.burnAsync(addressOrAlias, from, Numeric.toHexStringWithPrefix((BigInteger)amount), callback);
    }

    public Kip7TransactionStatusResponse burn(String addressOrAlias, String from, String amount) throws ApiException {
        BurnKip7TokenRequest request = new BurnKip7TokenRequest();
        request.setFrom(from);
        request.setAmount(amount);
        return this.kip7Api.burnToken(this.chainId, addressOrAlias, request);
    }

    public Call burnAsync(String addressOrAlias, String from, String amount, ApiCallback<Kip7TransactionStatusResponse> callback) throws ApiException {
        BurnKip7TokenRequest request = new BurnKip7TokenRequest();
        request.setFrom(from);
        request.setAmount(amount);
        return this.kip7Api.burnTokenAsync(this.chainId, addressOrAlias, request, callback);
    }

    public Kip7TransactionStatusResponse burnFrom(String addressOrAlias, String spender, String owner, BigInteger amount) throws ApiException {
        return this.burnFrom(addressOrAlias, spender, owner, Numeric.toHexStringWithPrefix((BigInteger)amount));
    }

    public Call burnFromAsync(String addressOrAlias, String spender, String owner, BigInteger amount, ApiCallback<Kip7TransactionStatusResponse> callback) throws ApiException {
        return this.burnFromAsync(addressOrAlias, spender, owner, Numeric.toHexStringWithPrefix((BigInteger)amount), callback);
    }

    public Kip7TransactionStatusResponse burnFrom(String addressOrAlias, String spender, String owner, String amount) throws ApiException {
        BurnFromKip7TokenRequest request = new BurnFromKip7TokenRequest();
        request.setSpender(spender);
        request.setOwner(owner);
        request.setAmount(amount);
        return this.kip7Api.burnFromToken(this.chainId, addressOrAlias, request);
    }

    public Call burnFromAsync(String addressOrAlias, String spender, String owner, String amount, ApiCallback<Kip7TransactionStatusResponse> callback) throws ApiException {
        BurnFromKip7TokenRequest request = new BurnFromKip7TokenRequest();
        request.setSpender(spender);
        request.setOwner(owner);
        request.setAmount(amount);
        return this.kip7Api.burnFromTokenAsync(this.chainId, addressOrAlias, request, callback);
    }

    public Kip7TransactionStatusResponse pause(String addressOrAlias) throws ApiException {
        return this.kip7Api.pauseContract(this.chainId, addressOrAlias);
    }

    public Call pauseAsync(String addressOrAlias, ApiCallback<Kip7TransactionStatusResponse> callback) throws ApiException {
        return this.kip7Api.pauseContractAsync(this.chainId, addressOrAlias, callback);
    }

    public Kip7TransactionStatusResponse unpause(String addressOrAlias) throws ApiException {
        return this.kip7Api.unpauseContract(this.chainId, addressOrAlias);
    }

    public Call unpauseAsync(String addressOrAlias, ApiCallback<Kip7TransactionStatusResponse> callback) throws ApiException {
        return this.kip7Api.unpauseContractAsync(this.chainId, addressOrAlias, callback);
    }

    public Kip7DeployerResponse getDeployer() throws ApiException {
        return this.kip7DeployerApi.getDefaultDeployer(this.chainId);
    }

    public Call getDeployerAsync(ApiCallback<Kip7DeployerResponse> callback) throws ApiException {
        return this.kip7DeployerApi.getDefaultDeployerAsync(this.chainId, callback);
    }

    public Kip7DeployerApi getKip7DeployerApi() {
        return this.kip7DeployerApi;
    }

    public void setKip7DeployerApi(Kip7DeployerApi kip7DeployerApi) {
        this.kip7DeployerApi = kip7DeployerApi;
    }

    public Kip7Api getKip7Api() {
        return this.kip7Api;
    }

    public void setKip7Api(Kip7Api kip7Api) {
        this.kip7Api = kip7Api;
    }

    public String getChainId() {
        return this.chainId;
    }

    public void setChainId(String chainId) {
        this.chainId = chainId;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
        this.setKip7Api(new Kip7Api(apiClient));
        this.setKip7DeployerApi(new Kip7DeployerApi());
    }
}

