/*
 * Decompiled with CFR 0.152.
 */
package xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip37.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.ApiCallback;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.ApiClient;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.ApiException;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.ApiResponse;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.Configuration;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.Pair;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.ProgressRequestBody;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.ProgressResponseBody;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip37.model.Kip37TokenListResponse;

public class Kip37TokenOwnershipApi {
    private ApiClient apiClient;

    public Kip37TokenOwnershipApi() {
        this(Configuration.getDefaultApiClient());
    }

    public Kip37TokenOwnershipApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call getTokensByOwnerCall(String contractAddressOrAlias, String ownerAddress, String xChainId, Integer size, String cursor, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v1/contract/{contract-address-or-alias}/owner/{owner-address}/token".replaceAll("\\{contract-address-or-alias\\}", this.apiClient.escapeString(contractAddressOrAlias.toString())).replaceAll("\\{owner-address\\}", this.apiClient.escapeString(ownerAddress.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (size != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("size", size));
        }
        if (cursor != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("cursor", cursor));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xChainId != null) {
            localVarHeaderParams.put("x-chain-id", this.apiClient.parameterToString(xChainId));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getTokensByOwnerValidateBeforeCall(String contractAddressOrAlias, String ownerAddress, String xChainId, Integer size, String cursor, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (contractAddressOrAlias == null) {
            throw new ApiException("Missing the required parameter 'contractAddressOrAlias' when calling getTokensByOwner(Async)");
        }
        if (ownerAddress == null) {
            throw new ApiException("Missing the required parameter 'ownerAddress' when calling getTokensByOwner(Async)");
        }
        if (xChainId == null) {
            throw new ApiException("Missing the required parameter 'xChainId' when calling getTokensByOwner(Async)");
        }
        Call call = this.getTokensByOwnerCall(contractAddressOrAlias, ownerAddress, xChainId, size, cursor, progressListener, progressRequestListener);
        return call;
    }

    public Kip37TokenListResponse getTokensByOwner(String contractAddressOrAlias, String ownerAddress, String xChainId, Integer size, String cursor) throws ApiException {
        ApiResponse<Kip37TokenListResponse> resp = this.getTokensByOwnerWithHttpInfo(contractAddressOrAlias, ownerAddress, xChainId, size, cursor);
        return resp.getData();
    }

    public ApiResponse<Kip37TokenListResponse> getTokensByOwnerWithHttpInfo(String contractAddressOrAlias, String ownerAddress, String xChainId, Integer size, String cursor) throws ApiException {
        Call call = this.getTokensByOwnerValidateBeforeCall(contractAddressOrAlias, ownerAddress, xChainId, size, cursor, null, null);
        Type localVarReturnType = new TypeToken<Kip37TokenListResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getTokensByOwnerAsync(String contractAddressOrAlias, String ownerAddress, String xChainId, Integer size, String cursor, final ApiCallback<Kip37TokenListResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getTokensByOwnerValidateBeforeCall(contractAddressOrAlias, ownerAddress, xChainId, size, cursor, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Kip37TokenListResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

