/*
 * Decompiled with CFR 0.152.
 */
package xyz.groundx.caver_ext_kas.exception;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import xyz.groundx.caver_ext_kas.exception.ExceptionDetail;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.ApiException;

public class KASAPIException
extends RuntimeException {
    private int code = 0;
    private Map<String, List<String>> responseHeaders = null;
    private ExceptionDetail responseBody = null;

    public KASAPIException() {
    }

    public KASAPIException(Throwable throwable) {
        super(throwable);
    }

    public KASAPIException(String message) {
        super(message);
    }

    public KASAPIException(String message, Throwable throwable) {
        super(message, throwable);
    }

    public KASAPIException(ApiException e) {
        this(e.getMessage(), e.getCause(), e.getCode(), e.getResponseHeaders(), e.getResponseBody());
    }

    public KASAPIException(String message, Throwable throwable, int code, Map<String, List<String>> responseHeaders, String responseBody) {
        super(message, throwable);
        this.code = code;
        this.responseHeaders = responseHeaders;
        if (responseBody != null && !responseBody.isEmpty()) {
            this.setResponseBody(responseBody);
        }
    }

    public KASAPIException(String message, int code, Map<String, List<String>> responseHeaders, String responseBody) {
        this(message, null, code, responseHeaders, responseBody);
    }

    public KASAPIException(String message, Throwable throwable, int code, Map<String, List<String>> responseHeaders) {
        this(message, throwable, code, responseHeaders, null);
    }

    public KASAPIException(int code, Map<String, List<String>> responseHeaders, String responseBody) {
        this(null, null, code, responseHeaders, responseBody);
    }

    public KASAPIException(int code, String message) {
        super(message);
        this.code = code;
    }

    public KASAPIException(int code, String message, Map<String, List<String>> responseHeaders, String responseBody) {
        this(code, message);
        this.responseHeaders = responseHeaders;
        if (responseBody != null && !responseBody.isEmpty()) {
            this.setResponseBody(responseBody);
        }
    }

    public int getCode() {
        return this.code;
    }

    public Map<String, List<String>> getResponseHeaders() {
        return this.responseHeaders;
    }

    public ExceptionDetail getResponseBody() {
        return this.responseBody;
    }

    public void setResponseBody(String responseBody) {
        try {
            ExceptionDetail detail;
            this.responseBody = detail = (ExceptionDetail)new ObjectMapper().readValue(responseBody, ExceptionDetail.class);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to parsed json string : " + responseBody);
        }
    }
}

