/*
 * Decompiled with CFR 0.152.
 */
package xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="User Fee Delegation Transaction Request Scheme Using RLP")
public class FDUserProcessRLPRequest {
    @SerializedName(value="rlp")
    private String rlp = null;
    @SerializedName(value="feePayer")
    private String feePayer = null;
    @SerializedName(value="feeRatio")
    private Long feeRatio = null;
    @SerializedName(value="submit")
    private Boolean submit = null;

    public FDUserProcessRLPRequest rlp(String rlp) {
        this.rlp = rlp;
        return this;
    }

    @Schema(required=true, description="The RLP value is used to receive a Klaytn RLP format (SigRLP or TxHashRLP). This scheme just allow (partial) fee delegation transaction type.")
    public String getRlp() {
        return this.rlp;
    }

    public void setRlp(String rlp) {
        this.rlp = rlp;
    }

    public FDUserProcessRLPRequest feePayer(String feePayer) {
        this.feePayer = feePayer;
        return this;
    }

    @Schema(example="0x85B98485444c89880cD9C48807CEF727C296F2da", required=true, description="Account address for fee delegation of transaction fee")
    public String getFeePayer() {
        return this.feePayer;
    }

    public void setFeePayer(String feePayer) {
        this.feePayer = feePayer;
    }

    public FDUserProcessRLPRequest feeRatio(Long feeRatio) {
        this.feeRatio = feeRatio;
        return this;
    }

    @Schema(example="76", description="Ratio to be paid by the Proxy fee payer for the entire transaction fee(1~99). If value is empty or 0, fee payer will pay all fees")
    public Long getFeeRatio() {
        return this.feeRatio;
    }

    public void setFeeRatio(Long feeRatio) {
        this.feeRatio = feeRatio;
    }

    public FDUserProcessRLPRequest submit(Boolean submit) {
        this.submit = submit;
        return this;
    }

    @Schema(example="true", description="Whether to send the transaction to Klaytn")
    public Boolean isSubmit() {
        return this.submit;
    }

    public void setSubmit(Boolean submit) {
        this.submit = submit;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FDUserProcessRLPRequest fdUserProcessRLPRequest = (FDUserProcessRLPRequest)o;
        return Objects.equals(this.rlp, fdUserProcessRLPRequest.rlp) && Objects.equals(this.feePayer, fdUserProcessRLPRequest.feePayer) && Objects.equals(this.feeRatio, fdUserProcessRLPRequest.feeRatio) && Objects.equals(this.submit, fdUserProcessRLPRequest.submit);
    }

    public int hashCode() {
        return Objects.hash(this.rlp, this.feePayer, this.feeRatio, this.submit);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FDUserProcessRLPRequest {\n");
        sb.append("    rlp: ").append(this.toIndentedString(this.rlp)).append("\n");
        sb.append("    feePayer: ").append(this.toIndentedString(this.feePayer)).append("\n");
        sb.append("    feeRatio: ").append(this.toIndentedString(this.feeRatio)).append("\n");
        sb.append("    submit: ").append(this.toIndentedString(this.submit)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

