/*
 * Decompiled with CFR 0.152.
 */
package xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model.Signature;

@Schema(description="Transaction information sent to Klaytn")
public class TransactionResult {
    @SerializedName(value="from")
    private String from = null;
    @SerializedName(value="gas")
    private Long gas = null;
    @SerializedName(value="gasPrice")
    private String gasPrice = null;
    @SerializedName(value="input")
    private String input = null;
    @SerializedName(value="nonce")
    private Long nonce = null;
    @SerializedName(value="rlp")
    private String rlp = null;
    @SerializedName(value="signatures")
    private List<Signature> signatures = null;
    @SerializedName(value="status")
    private String status = null;
    @SerializedName(value="transactionHash")
    private String transactionHash = null;
    @SerializedName(value="typeInt")
    private Long typeInt = null;
    @SerializedName(value="value")
    private String value = null;
    @SerializedName(value="to")
    private String to = null;
    @SerializedName(value="code")
    private Long code = null;
    @SerializedName(value="message")
    private String message = null;
    @SerializedName(value="transactionId")
    private String transactionId = null;
    @SerializedName(value="accountKey")
    private String accountKey = null;

    public TransactionResult from(String from) {
        this.from = from;
        return this;
    }

    @Schema(example="0xf7093ab1f23bc6d5cdf73b222692d0de2696bcab", required=true, description="Klaytn account address sending a transaction")
    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public TransactionResult gas(Long gas) {
        this.gas = gas;
        return this;
    }

    @Schema(example="1000000", required=true, description="Max. transaction fee (gas) for sending the transaction")
    public Long getGas() {
        return this.gas;
    }

    public void setGas(Long gas) {
        this.gas = gas;
    }

    public TransactionResult gasPrice(String gasPrice) {
        this.gasPrice = gasPrice;
        return this;
    }

    @Schema(example="0x5d21dba00", required=true, description="Gas price for sending the transaction")
    public String getGasPrice() {
        return this.gasPrice;
    }

    public void setGasPrice(String gasPrice) {
        this.gasPrice = gasPrice;
    }

    public TransactionResult input(String input) {
        this.input = input;
        return this;
    }

    @Schema(example="0x60806040526000805534801561001457600080fd5b50610116806100246000396000f3006080604052600436106053576000357c0100000000000000000000000000000000000000000000000000000000900463ffffffff16806306661abd14605857806342cbb15c146080578063d14e62b81460a8575b600080fd5b348015606357600080fd5b50606a60d2565b6040518082815260200191505060405180910390f35b348015608b57600080fd5b50609260d8565b6040518082815260200191505060405180910390f35b34801560b357600080fd5b5060d06004803603810190808035906020019092919050505060e0565b005b60005481565b600043905090565b80600081905550505600a165627a7a7230582064856de85a2706463526593b08dd790054536042ef66d3204018e6790a2208d10029", description="Data attached to and used for executing the outgoing transaction")
    public String getInput() {
        return this.input;
    }

    public void setInput(String input) {
        this.input = input;
    }

    public TransactionResult nonce(Long nonce) {
        this.nonce = nonce;
        return this;
    }

    @Schema(example="1", required=true, description="No. of current user\u2019s previous transactions")
    public Long getNonce() {
        return this.nonce;
    }

    public void setNonce(Long nonce) {
        this.nonce = nonce;
    }

    public TransactionResult rlp(String rlp) {
        this.rlp = rlp;
        return this;
    }

    @Schema(example="0xf9018f018505d21dba00830f42408012b9013a60806040526000805534801561001457600080fd5b50610116806100246000396000f3006080604052600436106053576000357c0100000000000000000000000000000000000000000000000000000000900463ffffffff16806306661abd14605857806342cbb15c146080578063d14e62b81460a8575b600080fd5b348015606357600080fd5b50606a60d2565b6040518082815260200191505060405180910390f35b348015608b57600080fd5b50609260d8565b6040518082815260200191505060405180910390f35b34801560b357600080fd5b5060d06004803603810190808035906020019092919050505060e0565b005b60005481565b600043905090565b80600081905550505600a165627a7a7230582064856de85a2706463526593b08dd790054536042ef66d3204018e6790a2208d100298207f6a02930c607ddb95575ef88b63a45caa0231da1f88fe99a0cad411a5a99bd4b6d5ba042adbae28a65c32220505e1c7a1509635b59143ddc65e6b7e266d5b3797370d4", required=true, description="RLP serialization value of the transaction")
    public String getRlp() {
        return this.rlp;
    }

    public void setRlp(String rlp) {
        this.rlp = rlp;
    }

    public TransactionResult signatures(List<Signature> signatures) {
        this.signatures = signatures;
        return this;
    }

    public TransactionResult addSignaturesItem(Signature signaturesItem) {
        if (this.signatures == null) {
            this.signatures = new ArrayList<Signature>();
        }
        this.signatures.add(signaturesItem);
        return this;
    }

    @Schema(description="")
    public List<Signature> getSignatures() {
        return this.signatures;
    }

    public void setSignatures(List<Signature> signatures) {
        this.signatures = signatures;
    }

    public TransactionResult status(String status) {
        this.status = status;
        return this;
    }

    @Schema(example="Submitted", description="Status of the transaction(\u201cSubmitted\u201d or \u201cPending\u201d)")
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public TransactionResult transactionHash(String transactionHash) {
        this.transactionHash = transactionHash;
        return this;
    }

    @Schema(example="0x49a92d67aafc1e503a345ee9c5b9a5c58df10706e054fdcc18447398d553cef7", description="Transaction hash value")
    public String getTransactionHash() {
        return this.transactionHash;
    }

    public void setTransactionHash(String transactionHash) {
        this.transactionHash = transactionHash;
    }

    public TransactionResult typeInt(Long typeInt) {
        this.typeInt = typeInt;
        return this;
    }

    @Schema(example="0", required=true, description="Numeric value of transaction type")
    public Long getTypeInt() {
        return this.typeInt;
    }

    public void setTypeInt(Long typeInt) {
        this.typeInt = typeInt;
    }

    public TransactionResult value(String value) {
        this.value = value;
        return this;
    }

    @Schema(example="0x12", description="KLAY converted into PEB unit")
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public TransactionResult to(String to) {
        this.to = to;
        return this;
    }

    @Schema(example="0xa311e7022a4db250689c89d99848f74ea5098f7d", description="Klaytn account address to receive KLAY")
    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public TransactionResult code(Long code) {
        this.code = code;
        return this;
    }

    @Schema(example="1065001", description="")
    public Long getCode() {
        return this.code;
    }

    public void setCode(Long code) {
        this.code = code;
    }

    public TransactionResult message(String message) {
        this.message = message;
        return this;
    }

    @Schema(example="failed to send a raw transaction to klaytn node; -32000::insufficient funds of the sender for value ", description="")
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public TransactionResult transactionId(String transactionId) {
        this.transactionId = transactionId;
        return this;
    }

    @Schema(example="0x7ee5d33b931e1c172dee21027aeeca31c33ddd44efd02cd3fd4fdfa0a86f888e", description="Multisig transaction ID")
    public String getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public TransactionResult accountKey(String accountKey) {
        this.accountKey = accountKey;
        return this;
    }

    @Schema(example="0x04f89303f890e301a1021c5c34cafdefddfd5d0c8baa9e9f75ff6aa6dc597776e5bf06e231c57926a2cbe301a1025552e73f34964eb04cad0d3c3dbd7cfeebbfb420ca83b1e7c640a9c76b42a4cae301a102ab9910325fd645a556fee3c6bbd8651be4fbff6688634d826474f3ef4baff7b1e301a103a1c4e3830f19d1fb2c78d00cd5b29f75cdcc706a8611cbf4192c2d20f4899cba", description="Updated account key")
    public String getAccountKey() {
        return this.accountKey;
    }

    public void setAccountKey(String accountKey) {
        this.accountKey = accountKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactionResult transactionResult = (TransactionResult)o;
        return Objects.equals(this.from, transactionResult.from) && Objects.equals(this.gas, transactionResult.gas) && Objects.equals(this.gasPrice, transactionResult.gasPrice) && Objects.equals(this.input, transactionResult.input) && Objects.equals(this.nonce, transactionResult.nonce) && Objects.equals(this.rlp, transactionResult.rlp) && Objects.equals(this.signatures, transactionResult.signatures) && Objects.equals(this.status, transactionResult.status) && Objects.equals(this.transactionHash, transactionResult.transactionHash) && Objects.equals(this.typeInt, transactionResult.typeInt) && Objects.equals(this.value, transactionResult.value) && Objects.equals(this.to, transactionResult.to) && Objects.equals(this.code, transactionResult.code) && Objects.equals(this.message, transactionResult.message) && Objects.equals(this.transactionId, transactionResult.transactionId) && Objects.equals(this.accountKey, transactionResult.accountKey);
    }

    public int hashCode() {
        return Objects.hash(this.from, this.gas, this.gasPrice, this.input, this.nonce, this.rlp, this.signatures, this.status, this.transactionHash, this.typeInt, this.value, this.to, this.code, this.message, this.transactionId, this.accountKey);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransactionResult {\n");
        sb.append("    from: ").append(this.toIndentedString(this.from)).append("\n");
        sb.append("    gas: ").append(this.toIndentedString(this.gas)).append("\n");
        sb.append("    gasPrice: ").append(this.toIndentedString(this.gasPrice)).append("\n");
        sb.append("    input: ").append(this.toIndentedString(this.input)).append("\n");
        sb.append("    nonce: ").append(this.toIndentedString(this.nonce)).append("\n");
        sb.append("    rlp: ").append(this.toIndentedString(this.rlp)).append("\n");
        sb.append("    signatures: ").append(this.toIndentedString(this.signatures)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    transactionHash: ").append(this.toIndentedString(this.transactionHash)).append("\n");
        sb.append("    typeInt: ").append(this.toIndentedString(this.typeInt)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    to: ").append(this.toIndentedString(this.to)).append("\n");
        sb.append("    code: ").append(this.toIndentedString(this.code)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    transactionId: ").append(this.toIndentedString(this.transactionId)).append("\n");
        sb.append("    accountKey: ").append(this.toIndentedString(this.accountKey)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

