/*
 * Decompiled with CFR 0.152.
 */
package xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="User Fee Delegation Anchoring Transaction Request Scheme")
public class FDUserAnchorTransactionRequest {
    @SerializedName(value="from")
    private String from = null;
    @SerializedName(value="input")
    private String input = null;
    @SerializedName(value="nonce")
    private Long nonce = null;
    @SerializedName(value="gas")
    private Long gas = 100000L;
    @SerializedName(value="submit")
    private Boolean submit = null;
    @SerializedName(value="feePayer")
    private String feePayer = null;
    @SerializedName(value="feeRatio")
    private Long feeRatio = null;

    public FDUserAnchorTransactionRequest from(String from) {
        this.from = from;
        return this;
    }

    @Schema(example="0x5bb85d4032354E88020595AFAFC081C24098202e", required=true, description="Klaytn account address sending a transaction")
    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public FDUserAnchorTransactionRequest input(String input) {
        this.input = input;
        return this;
    }

    @Schema(example="0x123", required=true, description="Data attached to a transaction (anchored to the main chain)")
    public String getInput() {
        return this.input;
    }

    public void setInput(String input) {
        this.input = input;
    }

    public FDUserAnchorTransactionRequest nonce(Long nonce) {
        this.nonce = nonce;
        return this;
    }

    @Schema(example="0", description="Unique value of the outgoing transaction")
    public Long getNonce() {
        return this.nonce;
    }

    public void setNonce(Long nonce) {
        this.nonce = nonce;
    }

    public FDUserAnchorTransactionRequest gas(Long gas) {
        this.gas = gas;
        return this;
    }

    @Schema(example="1000000", description="Max. transaction fee (gas) for sending the transaction")
    public Long getGas() {
        return this.gas;
    }

    public void setGas(Long gas) {
        this.gas = gas;
    }

    public FDUserAnchorTransactionRequest submit(Boolean submit) {
        this.submit = submit;
        return this;
    }

    @Schema(example="true", description="Whether to send the transaction to Klaytn")
    public Boolean isSubmit() {
        return this.submit;
    }

    public void setSubmit(Boolean submit) {
        this.submit = submit;
    }

    public FDUserAnchorTransactionRequest feePayer(String feePayer) {
        this.feePayer = feePayer;
        return this;
    }

    @Schema(example="0x85B98485444c89880cD9C48807CEF727C296F2da", required=true, description="Account address for fee delegation of transaction fee")
    public String getFeePayer() {
        return this.feePayer;
    }

    public void setFeePayer(String feePayer) {
        this.feePayer = feePayer;
    }

    public FDUserAnchorTransactionRequest feeRatio(Long feeRatio) {
        this.feeRatio = feeRatio;
        return this;
    }

    @Schema(example="0", description="Ratio to be paid by the Proxy fee payer for the entire transaction fee(1~99). If value is empty or 0, fee payer will pay all fees")
    public Long getFeeRatio() {
        return this.feeRatio;
    }

    public void setFeeRatio(Long feeRatio) {
        this.feeRatio = feeRatio;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FDUserAnchorTransactionRequest fdUserAnchorTransactionRequest = (FDUserAnchorTransactionRequest)o;
        return Objects.equals(this.from, fdUserAnchorTransactionRequest.from) && Objects.equals(this.input, fdUserAnchorTransactionRequest.input) && Objects.equals(this.nonce, fdUserAnchorTransactionRequest.nonce) && Objects.equals(this.gas, fdUserAnchorTransactionRequest.gas) && Objects.equals(this.submit, fdUserAnchorTransactionRequest.submit) && Objects.equals(this.feePayer, fdUserAnchorTransactionRequest.feePayer) && Objects.equals(this.feeRatio, fdUserAnchorTransactionRequest.feeRatio);
    }

    public int hashCode() {
        return Objects.hash(this.from, this.input, this.nonce, this.gas, this.submit, this.feePayer, this.feeRatio);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FDUserAnchorTransactionRequest {\n");
        sb.append("    from: ").append(this.toIndentedString(this.from)).append("\n");
        sb.append("    input: ").append(this.toIndentedString(this.input)).append("\n");
        sb.append("    nonce: ").append(this.toIndentedString(this.nonce)).append("\n");
        sb.append("    gas: ").append(this.toIndentedString(this.gas)).append("\n");
        sb.append("    submit: ").append(this.toIndentedString(this.submit)).append("\n");
        sb.append("    feePayer: ").append(this.toIndentedString(this.feePayer)).append("\n");
        sb.append("    feeRatio: ").append(this.toIndentedString(this.feeRatio)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

