/*
 * Decompiled with CFR 0.152.
 */
package xyz.groundx.caver_ext_kas.kas.anchor;

import com.squareup.okhttp.Call;
import java.security.InvalidParameterException;
import java.util.Map;
import xyz.groundx.caver_ext_kas.kas.anchor.AnchorQueryOptions;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.ApiCallback;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.ApiClient;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.ApiException;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.anchor.api.DataAnchoringTransactionApi;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.anchor.api.OperatorApi;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.anchor.model.AnchorBlockPayload;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.anchor.model.AnchorBlockRequest;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.anchor.model.AnchorBlockStatus;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.anchor.model.AnchorTransactionDetail;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.anchor.model.AnchorTransactions;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.anchor.model.Operator;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.anchor.model.Operators;

public class Anchor {
    DataAnchoringTransactionApi dataAnchoringTransactionApi;
    OperatorApi operatorApi;
    String chainId;
    ApiClient apiClient;

    public Anchor(String chainId, ApiClient anchorApiClient) {
        this.setChainId(chainId);
        this.setApiClient(anchorApiClient);
    }

    public AnchorBlockStatus sendAnchoringData(String operatorId, AnchorBlockPayload payload) throws ApiException {
        this.checkPayload(payload);
        AnchorBlockRequest anchorRequest = new AnchorBlockRequest();
        anchorRequest.setOperator(operatorId);
        anchorRequest.setPayload(payload);
        return this.getDataAnchoringTransactionApi().anchorBlock(this.getChainId(), anchorRequest);
    }

    public Call sendAnchoringDataAsync(String operatorId, AnchorBlockPayload payload, ApiCallback<AnchorBlockStatus> callback) throws ApiException {
        this.checkPayload(payload);
        AnchorBlockRequest anchorRequest = new AnchorBlockRequest();
        anchorRequest.setOperator(operatorId);
        anchorRequest.setPayload(payload);
        return this.getDataAnchoringTransactionApi().anchorBlockAsync(this.getChainId(), anchorRequest, callback);
    }

    public AnchorTransactions getAnchoringTransactionList(String operatorId) throws ApiException {
        AnchorQueryOptions params = new AnchorQueryOptions();
        return this.getAnchoringTransactionList(operatorId, params);
    }

    public AnchorTransactions getAnchoringTransactionList(String operatorId, AnchorQueryOptions queryParams) throws ApiException {
        return this.dataAnchoringTransactionApi.retrieveAnchorBlock(this.getChainId(), operatorId, queryParams.getSize(), queryParams.getCursor(), queryParams.getFromTimestamp(), queryParams.getToTimestamp());
    }

    public Call getAnchoringTransactionListAsync(String operatorId, ApiCallback<AnchorTransactions> callback) throws ApiException {
        AnchorQueryOptions params = new AnchorQueryOptions();
        return this.getAnchoringTransactionListAsync(operatorId, params, callback);
    }

    public Call getAnchoringTransactionListAsync(String operatorId, AnchorQueryOptions queryParams, ApiCallback<AnchorTransactions> callback) throws ApiException {
        return this.dataAnchoringTransactionApi.retrieveAnchorBlockAsync(this.getChainId(), operatorId, queryParams.getSize(), queryParams.getCursor(), queryParams.getFromTimestamp(), queryParams.getToTimestamp(), callback);
    }

    public AnchorTransactionDetail getAnchoringTransactionByTxHash(String operatorId, String txHash) throws ApiException {
        return this.dataAnchoringTransactionApi.getAnchorBlockByTx(this.getChainId(), operatorId, txHash);
    }

    public Call getAnchoringTransactionByTxHashAsync(String operatorId, String txHash, ApiCallback<AnchorTransactionDetail> callback) throws ApiException {
        return this.dataAnchoringTransactionApi.getAnchorBlockByTxAsync(this.getChainId(), operatorId, txHash, callback);
    }

    public AnchorTransactionDetail getAnchoringTransactionByPayloadId(String operatorId, String payloadId) throws ApiException {
        return this.dataAnchoringTransactionApi.getAnchorBlockByPayloadID(this.getChainId(), operatorId, payloadId);
    }

    public Call getAnchoringTransactionByPayloadIdAsync(String operatorId, String payloadId, ApiCallback<AnchorTransactionDetail> callback) throws ApiException {
        return this.dataAnchoringTransactionApi.getAnchorBlockByPayloadIDAsync(this.getChainId(), operatorId, payloadId, callback);
    }

    public Operators getOperatorList() throws ApiException {
        AnchorQueryOptions queryParams = new AnchorQueryOptions();
        return this.getOperatorList(queryParams);
    }

    public Operators getOperatorList(AnchorQueryOptions queryParams) throws ApiException {
        return this.getOperatorApi().retrieveOperators(this.getChainId(), queryParams.getSize(), queryParams.getCursor(), queryParams.getFromTimestamp(), queryParams.toTimestamp);
    }

    public Call getOperatorListAsync(ApiCallback<Operators> callback) throws ApiException {
        AnchorQueryOptions queryParams = new AnchorQueryOptions();
        return this.getOperatorListAsync(queryParams, callback);
    }

    public Call getOperatorListAsync(AnchorQueryOptions queryParams, ApiCallback<Operators> callback) throws ApiException {
        return this.getOperatorApi().retrieveOperatorsAsync(this.getChainId(), queryParams.getSize(), queryParams.getCursor(), queryParams.getFromTimestamp(), queryParams.getToTimestamp(), callback);
    }

    public Operator getOperator(String operatorId) throws ApiException {
        return this.getOperatorApi().getOperator(this.chainId, operatorId);
    }

    public Call getOperatorAsync(String operatorId, ApiCallback<Operator> callback) throws ApiException {
        return this.getOperatorApi().getOperatorAsync(this.chainId, operatorId, callback);
    }

    public DataAnchoringTransactionApi getDataAnchoringTransactionApi() {
        return this.dataAnchoringTransactionApi;
    }

    public OperatorApi getOperatorApi() {
        return this.operatorApi;
    }

    public String getChainId() {
        return this.chainId;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setDataAnchoringTransactionApi(DataAnchoringTransactionApi dataAnchoringTransactionApi) {
        this.dataAnchoringTransactionApi = dataAnchoringTransactionApi;
    }

    public void setOperatorApi(OperatorApi operatorApi) {
        this.operatorApi = operatorApi;
    }

    public void setChainId(String chainId) {
        this.chainId = chainId;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
        this.setDataAnchoringTransactionApi(new DataAnchoringTransactionApi(apiClient));
        this.setOperatorApi(new OperatorApi(apiClient));
    }

    private void checkPayload(Map payload) {
        if (payload.get("id") == null) {
            throw new NullPointerException("Payload must have an 'id' of String type.");
        }
        if (!(payload.get("id") instanceof String)) {
            throw new InvalidParameterException("Payload id must be String type.");
        }
    }
}

