/*
 * Decompiled with CFR 0.152.
 */
package xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="Contract Execution Transaction Request Scheme")
public class ContractExecutionTransactionRequest {
    @SerializedName(value="from")
    private String from = null;
    @SerializedName(value="value")
    private String value = null;
    @SerializedName(value="to")
    private String to = null;
    @SerializedName(value="input")
    private String input = null;
    @SerializedName(value="nonce")
    private Long nonce = null;
    @SerializedName(value="gas")
    private Long gas = 100000L;
    @SerializedName(value="submit")
    private Boolean submit = null;

    public ContractExecutionTransactionRequest from(String from) {
        this.from = from;
        return this;
    }

    @Schema(example="0x5bb85d4032354E88020595AFAFC081C24098202e", required=true, description="Klaytn account address sending a transaction")
    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public ContractExecutionTransactionRequest value(String value) {
        this.value = value;
        return this;
    }

    @Schema(example="0x0", description="KLAY converted into PEB unit")
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public ContractExecutionTransactionRequest to(String to) {
        this.to = to;
        return this;
    }

    @Schema(example="0x71ca8095264fdf58f1a2007e0f91140d67292736", required=true, description="Contract address")
    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public ContractExecutionTransactionRequest input(String input) {
        this.input = input;
        return this;
    }

    @Schema(example="0xd14e62b80000000000000000000000000000000000000000000000000000000000000005", required=true, description="Data attached to and used for executing the outgoing transaction")
    public String getInput() {
        return this.input;
    }

    public void setInput(String input) {
        this.input = input;
    }

    public ContractExecutionTransactionRequest nonce(Long nonce) {
        this.nonce = nonce;
        return this;
    }

    @Schema(example="0", description="Unique value of the outgoing transaction")
    public Long getNonce() {
        return this.nonce;
    }

    public void setNonce(Long nonce) {
        this.nonce = nonce;
    }

    public ContractExecutionTransactionRequest gas(Long gas) {
        this.gas = gas;
        return this;
    }

    @Schema(example="1000000", description="Max. transaction fee (gas) for sending the transaction")
    public Long getGas() {
        return this.gas;
    }

    public void setGas(Long gas) {
        this.gas = gas;
    }

    public ContractExecutionTransactionRequest submit(Boolean submit) {
        this.submit = submit;
        return this;
    }

    @Schema(example="true", description="Whether to send the transaction to Klaytn")
    public Boolean isSubmit() {
        return this.submit;
    }

    public void setSubmit(Boolean submit) {
        this.submit = submit;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContractExecutionTransactionRequest contractExecutionTransactionRequest = (ContractExecutionTransactionRequest)o;
        return Objects.equals(this.from, contractExecutionTransactionRequest.from) && Objects.equals(this.value, contractExecutionTransactionRequest.value) && Objects.equals(this.to, contractExecutionTransactionRequest.to) && Objects.equals(this.input, contractExecutionTransactionRequest.input) && Objects.equals(this.nonce, contractExecutionTransactionRequest.nonce) && Objects.equals(this.gas, contractExecutionTransactionRequest.gas) && Objects.equals(this.submit, contractExecutionTransactionRequest.submit);
    }

    public int hashCode() {
        return Objects.hash(this.from, this.value, this.to, this.input, this.nonce, this.gas, this.submit);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ContractExecutionTransactionRequest {\n");
        sb.append("    from: ").append(this.toIndentedString(this.from)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    to: ").append(this.toIndentedString(this.to)).append("\n");
        sb.append("    input: ").append(this.toIndentedString(this.input)).append("\n");
        sb.append("    nonce: ").append(this.toIndentedString(this.nonce)).append("\n");
        sb.append("    gas: ").append(this.toIndentedString(this.gas)).append("\n");
        sb.append("    submit: ").append(this.toIndentedString(this.submit)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

