/*
 * Decompiled with CFR 0.152.
 */
package xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.anchor.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.ApiCallback;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.ApiClient;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.ApiException;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.ApiResponse;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.Configuration;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.Pair;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.ProgressRequestBody;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.ProgressResponseBody;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.anchor.model.Operator;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.anchor.model.Operators;

public class OperatorApi {
    private ApiClient apiClient;

    public OperatorApi() {
        this(Configuration.getDefaultApiClient());
    }

    public OperatorApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call getOperatorCall(String xChainId, String operatorId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v1/operator/{operator-id}".replaceAll("\\{operator-id\\}", this.apiClient.escapeString(operatorId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xChainId != null) {
            localVarHeaderParams.put("x-chain-id", this.apiClient.parameterToString(xChainId));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getOperatorValidateBeforeCall(String xChainId, String operatorId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (xChainId == null) {
            throw new ApiException("Missing the required parameter 'xChainId' when calling getOperator(Async)");
        }
        if (operatorId == null) {
            throw new ApiException("Missing the required parameter 'operatorId' when calling getOperator(Async)");
        }
        Call call = this.getOperatorCall(xChainId, operatorId, progressListener, progressRequestListener);
        return call;
    }

    public Operator getOperator(String xChainId, String operatorId) throws ApiException {
        ApiResponse<Operator> resp = this.getOperatorWithHttpInfo(xChainId, operatorId);
        return resp.getData();
    }

    public ApiResponse<Operator> getOperatorWithHttpInfo(String xChainId, String operatorId) throws ApiException {
        Call call = this.getOperatorValidateBeforeCall(xChainId, operatorId, null, null);
        Type localVarReturnType = new TypeToken<Operator>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getOperatorAsync(String xChainId, String operatorId, final ApiCallback<Operator> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getOperatorValidateBeforeCall(xChainId, operatorId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Operator>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call retrieveOperatorsCall(String xChainId, Long size, String cursor, Long fromTimestamp, Long toTimestamp, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v1/operator";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (size != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("size", size));
        }
        if (cursor != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("cursor", cursor));
        }
        if (fromTimestamp != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("from-timestamp", fromTimestamp));
        }
        if (toTimestamp != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("to-timestamp", toTimestamp));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xChainId != null) {
            localVarHeaderParams.put("x-chain-id", this.apiClient.parameterToString(xChainId));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call retrieveOperatorsValidateBeforeCall(String xChainId, Long size, String cursor, Long fromTimestamp, Long toTimestamp, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (xChainId == null) {
            throw new ApiException("Missing the required parameter 'xChainId' when calling retrieveOperators(Async)");
        }
        Call call = this.retrieveOperatorsCall(xChainId, size, cursor, fromTimestamp, toTimestamp, progressListener, progressRequestListener);
        return call;
    }

    public Operators retrieveOperators(String xChainId, Long size, String cursor, Long fromTimestamp, Long toTimestamp) throws ApiException {
        ApiResponse<Operators> resp = this.retrieveOperatorsWithHttpInfo(xChainId, size, cursor, fromTimestamp, toTimestamp);
        return resp.getData();
    }

    public ApiResponse<Operators> retrieveOperatorsWithHttpInfo(String xChainId, Long size, String cursor, Long fromTimestamp, Long toTimestamp) throws ApiException {
        Call call = this.retrieveOperatorsValidateBeforeCall(xChainId, size, cursor, fromTimestamp, toTimestamp, null, null);
        Type localVarReturnType = new TypeToken<Operators>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call retrieveOperatorsAsync(String xChainId, Long size, String cursor, Long fromTimestamp, Long toTimestamp, final ApiCallback<Operators> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.retrieveOperatorsValidateBeforeCall(xChainId, size, cursor, fromTimestamp, toTimestamp, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Operators>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

