/*
 * Decompiled with CFR 0.152.
 */
package xyz.groundx.caver_ext_kas;

import com.klaytn.caver.Caver;
import com.klaytn.caver.rpc.RPC;
import com.klaytn.caver.wallet.IWallet;
import com.squareup.okhttp.Credentials;
import org.web3j.protocol.Web3jService;
import org.web3j.protocol.http.HttpService;
import xyz.groundx.caver_ext_kas.kas.KAS;
import xyz.groundx.caver_ext_kas.wallet.KASWallet;

public class CaverExtKAS
extends Caver {
    private static final String URL_NODE_API = "https://node-api.klaytnapi.com/v1/klaytn";
    private static final String URL_ANCHOR_API = "https://anchor-api.klaytnapi.com";
    private static final String URL_TH_API = "https://th-api.klaytnapi.com";
    private static final String URL_WALLET_API = "https://wallet-api.klaytnapi.com";
    private static final String URL_KIP17_API = "https://kip17-api.klaytnapi.com";
    public KAS kas = new KAS();
    public KASWallet wallet;

    public CaverExtKAS() {
    }

    public CaverExtKAS(int chainId, String accessKeyId, String secretAccessKey) {
        this.initKASAPI(chainId, accessKeyId, secretAccessKey);
    }

    public CaverExtKAS(String chainId, String accessKeyId, String secretAccessKey) {
        this.initKASAPI(chainId, accessKeyId, secretAccessKey);
    }

    public void initKASAPI(int chainId, String accessKeyId, String secretAccessKey) {
        this.initKASAPI(String.valueOf(chainId), accessKeyId, secretAccessKey);
    }

    public void initKASAPI(String chainId, String accessKeyId, String secretAccessKey) {
        this.initNodeAPI(chainId, accessKeyId, secretAccessKey);
        this.initAnchorAPI(chainId, accessKeyId, secretAccessKey);
        this.initTokenHistoryAPI(chainId, accessKeyId, secretAccessKey);
        this.initWalletAPI(chainId, accessKeyId, secretAccessKey);
        this.initKIP17API(chainId, accessKeyId, secretAccessKey);
    }

    public void initNodeAPI(int chainId, String accessKeyId, String secretAccessKey) {
        this.initNodeAPI(chainId, accessKeyId, secretAccessKey, URL_NODE_API);
    }

    public void initNodeAPI(String chainId, String accessKeyId, String secretAccessKey) {
        this.initNodeAPI(chainId, accessKeyId, secretAccessKey, URL_NODE_API);
    }

    public void initNodeAPI(int chainId, String accessKeyId, String secretAccessKey, String url) {
        this.initNodeAPI(String.valueOf(chainId), accessKeyId, secretAccessKey, url);
    }

    public void initNodeAPI(String chainId, String accessKeyId, String secretAccessKey, String url) {
        if (url.equals("https://node-api.klaytnapi.com")) {
            url = url + "/v1/klaytn";
        }
        HttpService httpService = new HttpService(url);
        httpService.addHeader("Authorization", Credentials.basic((String)accessKeyId, (String)secretAccessKey));
        httpService.addHeader("x-chain-id", chainId);
        this.rpc = new RPC((Web3jService)httpService);
    }

    public void initAnchorAPI(int chainId, String accessKeyId, String secretAccessKey) {
        this.initAnchorAPI(chainId, accessKeyId, secretAccessKey, URL_ANCHOR_API);
    }

    public void initAnchorAPI(String chainId, String accessKeyId, String secretAccessKey) {
        this.initAnchorAPI(chainId, accessKeyId, secretAccessKey, URL_ANCHOR_API);
    }

    public void initAnchorAPI(int chainId, String accessKeyId, String secretAccessKey, String url) {
        this.initAnchorAPI(String.valueOf(chainId), accessKeyId, secretAccessKey, url);
    }

    public void initAnchorAPI(String chainId, String accessKeyId, String secretAccessKey, String url) {
        this.kas.initAnchorAPI(chainId, accessKeyId, secretAccessKey, url);
    }

    public void initWalletAPI(int chainId, String accessKeyId, String secretAccessKey) {
        this.initWalletAPI(chainId, accessKeyId, secretAccessKey, URL_WALLET_API);
    }

    public void initWalletAPI(String chainId, String accessKeyId, String secretAccessKey) {
        this.initWalletAPI(chainId, accessKeyId, secretAccessKey, URL_WALLET_API);
    }

    public void initWalletAPI(int chainId, String accessKeyId, String secretAccessKey, String url) {
        this.initWalletAPI(String.valueOf(chainId), accessKeyId, secretAccessKey, url);
    }

    public void initWalletAPI(String chainId, String accessKeyId, String secretAccessKey, String url) {
        this.kas.initWalletAPI(chainId, accessKeyId, secretAccessKey, url);
        this.setWallet(new KASWallet(this.kas.wallet));
    }

    public void initTokenHistoryAPI(int chainId, String accessKeyId, String secretAccessKey) {
        this.initTokenHistoryAPI(chainId, accessKeyId, secretAccessKey, URL_TH_API);
    }

    public void initTokenHistoryAPI(String chainId, String accessKeyId, String secretAccessKey) {
        this.initTokenHistoryAPI(chainId, accessKeyId, secretAccessKey, URL_TH_API);
    }

    public void initTokenHistoryAPI(int chainId, String accessKeyId, String secretAccessKey, String url) {
        this.initTokenHistoryAPI(String.valueOf(chainId), accessKeyId, secretAccessKey, url);
    }

    public void initTokenHistoryAPI(String chainId, String accessKeyId, String secretAccessKey, String url) {
        this.kas.initTokenHistoryAPI(chainId, accessKeyId, secretAccessKey, url);
    }

    public void initKIP17API(int chainId, String accessKeyId, String secretAccessKey) {
        this.initTokenHistoryAPI(chainId, accessKeyId, secretAccessKey, URL_KIP17_API);
    }

    public void initKIP17API(String chainId, String accessKeyId, String secretAccessKey) {
        this.initTokenHistoryAPI(chainId, accessKeyId, secretAccessKey, URL_KIP17_API);
    }

    public void initKIP17API(int chainId, String accessKeyId, String secretAccessKey, String url) {
        this.initTokenHistoryAPI(String.valueOf(chainId), accessKeyId, secretAccessKey, url);
    }

    public void initKIP17API(String chainId, String accessKeyId, String secretAccessKey, String url) {
        this.kas.initKIP17API(chainId, accessKeyId, secretAccessKey, url);
    }

    public KAS getKas() {
        return this.kas;
    }

    public IWallet getWallet() {
        return this.wallet;
    }

    public void setKas(KAS kas) {
        this.kas = kas;
    }

    public void setWallet(KASWallet wallet) {
        this.wallet = wallet;
    }
}

