/*
 * Decompiled with CFR 0.152.
 */
package xyz.groundx.caver_ext_kas.kas.tokenhistory;

import com.squareup.okhttp.Call;
import java.util.Arrays;
import java.util.List;
import xyz.groundx.caver_ext_kas.kas.tokenhistory.TokenHistoryQueryOptions;
import xyz.groundx.caver_ext_kas.kas.utils.KASUtils;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.ApiCallback;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.ApiClient;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.ApiException;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.tokenhistory.api.TokenApi;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.tokenhistory.api.TokenContractApi;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.tokenhistory.api.TokenHistoryApi;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.tokenhistory.api.TokenOwnershipApi;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.tokenhistory.model.FtContractDetail;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.tokenhistory.model.MtContractDetail;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.tokenhistory.model.MtToken;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.tokenhistory.model.Nft;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.tokenhistory.model.NftContractDetail;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.tokenhistory.model.PageableFtContractDetails;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.tokenhistory.model.PageableMtContractDetails;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.tokenhistory.model.PageableMtTokens;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.tokenhistory.model.PageableMtTokensWithBalance;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.tokenhistory.model.PageableNftContractDetails;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.tokenhistory.model.PageableNftOwnershipChanges;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.tokenhistory.model.PageableNfts;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.tokenhistory.model.PageableTransfers;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.tokenhistory.model.Transfers;

public class TokenHistory {
    TokenApi tokenApi;
    TokenContractApi tokenContractApi;
    TokenHistoryApi tokenHistoryApi;
    TokenOwnershipApi tokenOwnershipApi;
    String chainId;
    ApiClient apiClient;

    public TokenHistory(String chainId, ApiClient client) {
        this.setChainId(chainId);
        this.setApiClient(client);
    }

    public PageableTransfers getTransferHistory(int preset) throws ApiException {
        TokenHistoryQueryOptions options = new TokenHistoryQueryOptions();
        return this.getTransferHistory(preset, options);
    }

    public PageableTransfers getTransferHistory(List<Integer> presets) throws ApiException {
        TokenHistoryQueryOptions options = new TokenHistoryQueryOptions();
        return this.getTransferHistory(presets, options);
    }

    public PageableTransfers getTransferHistory(int preset, TokenHistoryQueryOptions options) throws ApiException {
        return this.getTransferHistory(Arrays.asList(preset), options);
    }

    public PageableTransfers getTransferHistory(List<Integer> presets, TokenHistoryQueryOptions options) throws ApiException {
        return this.tokenHistoryApi.getTransfers(this.chainId, KASUtils.parameterToString(presets), options.getKind(), options.getRange(), options.getSize(), options.getCursor());
    }

    public Call getTransferHistoryAsync(int preset, ApiCallback<PageableTransfers> callback) throws ApiException {
        TokenHistoryQueryOptions options = new TokenHistoryQueryOptions();
        return this.getTransferHistoryAsync(preset, options, callback);
    }

    public Call getTransferHistoryAsync(List<Integer> presets, ApiCallback<PageableTransfers> callback) throws ApiException {
        TokenHistoryQueryOptions options = new TokenHistoryQueryOptions();
        return this.getTransferHistoryAsync(presets, options, callback);
    }

    public Call getTransferHistoryAsync(int preset, TokenHistoryQueryOptions options, ApiCallback<PageableTransfers> callback) throws ApiException {
        return this.getTransferHistoryAsync(Arrays.asList(preset), options, callback);
    }

    public Call getTransferHistoryAsync(List<Integer> presets, TokenHistoryQueryOptions options, ApiCallback<PageableTransfers> callback) throws ApiException {
        return this.tokenHistoryApi.getTransfersAsync(this.chainId, KASUtils.parameterToString(presets), options.getKind(), options.getRange(), options.getSize(), options.getCursor(), callback);
    }

    public Transfers getTransferHistoryByTxHash(String txHash) throws ApiException {
        return this.tokenHistoryApi.getTransfersByTxHash(this.chainId, txHash);
    }

    public Call getTransferHistoryByTxHashAsync(String txHash, ApiCallback<Transfers> callback) throws ApiException {
        return this.tokenHistoryApi.getTransfersByTxHashAsync(this.chainId, txHash, callback);
    }

    public PageableTransfers getTransferHistoryByAccount(String address) throws ApiException {
        TokenHistoryQueryOptions options = new TokenHistoryQueryOptions();
        return this.getTransferHistoryByAccount(address, options);
    }

    public PageableTransfers getTransferHistoryByAccount(String address, TokenHistoryQueryOptions options) throws ApiException {
        return this.tokenHistoryApi.getTransfersByEoa(this.chainId, address, options.getKind(), options.getCaFilter(), options.getRange(), options.getSize(), options.getCursor());
    }

    public Call getTransferHistoryAccountAsync(String address, ApiCallback<PageableTransfers> callback) throws ApiException {
        TokenHistoryQueryOptions options = new TokenHistoryQueryOptions();
        return this.getTransferHistoryAccountAsync(address, options, callback);
    }

    public Call getTransferHistoryAccountAsync(String address, TokenHistoryQueryOptions options, ApiCallback<PageableTransfers> callback) throws ApiException {
        return this.tokenHistoryApi.getTransfersByEoaAsync(this.chainId, address, options.getKind(), options.getCaFilter(), options.getRange(), options.getSize(), options.getCursor(), callback);
    }

    public PageableFtContractDetails getFTContractList() throws ApiException {
        TokenHistoryQueryOptions options = new TokenHistoryQueryOptions();
        return this.getFTContractList(options);
    }

    public PageableFtContractDetails getFTContractList(TokenHistoryQueryOptions options) throws ApiException {
        return this.tokenContractApi.getListofFtContracts(this.chainId, options.getStatus(), options.getType(), options.getSize(), options.getCursor());
    }

    public Call getFTContractListAsync(ApiCallback<PageableFtContractDetails> callback) throws ApiException {
        TokenHistoryQueryOptions options = new TokenHistoryQueryOptions();
        return this.getFTContractListAsync(options, callback);
    }

    public Call getFTContractListAsync(TokenHistoryQueryOptions options, ApiCallback<PageableFtContractDetails> callback) throws ApiException {
        return this.tokenContractApi.getListofFtContractsAsync(this.chainId, options.getStatus(), options.getType(), options.getSize(), options.getCursor(), callback);
    }

    public FtContractDetail getFTContract(String ftAddress) throws ApiException {
        return this.tokenContractApi.getFtContractDetail(this.chainId, ftAddress);
    }

    public Call getFTContractAsync(String ftAddress, ApiCallback<FtContractDetail> callback) throws ApiException {
        return this.tokenContractApi.getFtContractDetailAsync(this.chainId, ftAddress, callback);
    }

    public PageableNftContractDetails getNFTContractList() throws ApiException {
        TokenHistoryQueryOptions options = new TokenHistoryQueryOptions();
        return this.getNFTContractList(options);
    }

    public PageableNftContractDetails getNFTContractList(TokenHistoryQueryOptions options) throws ApiException {
        return this.tokenContractApi.getListOfNftContracts(this.chainId, options.getStatus(), options.getType(), options.getSize(), options.getCursor());
    }

    public Call getNFTContractListAsync(ApiCallback<PageableNftContractDetails> callback) throws ApiException {
        TokenHistoryQueryOptions options = new TokenHistoryQueryOptions();
        return this.getNFTContractListAsync(options, callback);
    }

    public Call getNFTContractListAsync(TokenHistoryQueryOptions options, ApiCallback<PageableNftContractDetails> callback) throws ApiException {
        return this.tokenContractApi.getListOfNftContractsAsync(this.chainId, options.getStatus(), options.getType(), options.getSize(), options.getCursor(), callback);
    }

    public NftContractDetail getNFTContract(String nftAddress) throws ApiException {
        return this.tokenContractApi.getNftContractDetail(this.chainId, nftAddress);
    }

    public Call getNFTContractAsync(String nftAddress, ApiCallback<NftContractDetail> callback) throws ApiException {
        return this.tokenContractApi.getNftContractDetailAsync(this.chainId, nftAddress, callback);
    }

    public PageableNfts getNFTList(String nftAddress) throws ApiException {
        TokenHistoryQueryOptions options = new TokenHistoryQueryOptions();
        return this.getNFTList(nftAddress, options);
    }

    public PageableNfts getNFTList(String nftAddress, TokenHistoryQueryOptions options) throws ApiException {
        return this.tokenApi.getNftsByContractAddress(this.chainId, nftAddress, options.getSize(), options.getCursor());
    }

    public Call getNFTListAsync(String nftAddress, ApiCallback<PageableNfts> callback) throws ApiException {
        TokenHistoryQueryOptions options = new TokenHistoryQueryOptions();
        return this.getNFTListAsync(nftAddress, options, callback);
    }

    public Call getNFTListAsync(String nftAddress, TokenHistoryQueryOptions options, ApiCallback<PageableNfts> callback) throws ApiException {
        return this.tokenApi.getNftsByContractAddressAsync(this.chainId, nftAddress, options.getSize(), options.getCursor(), callback);
    }

    public PageableNfts getNFTListByOwner(String nftAddress, String ownerAddress) throws ApiException {
        TokenHistoryQueryOptions options = new TokenHistoryQueryOptions();
        return this.getNFTListByOwner(nftAddress, ownerAddress, options);
    }

    public PageableNfts getNFTListByOwner(String nftAddress, String ownerAddress, TokenHistoryQueryOptions options) throws ApiException {
        return this.tokenApi.getNftsByOwnerAddress(this.chainId, nftAddress, ownerAddress, options.getSize(), options.getCursor());
    }

    public Call getNFTListByOwnerAsync(String nftAddress, String ownerAddress, ApiCallback<PageableNfts> callback) throws ApiException {
        TokenHistoryQueryOptions options = new TokenHistoryQueryOptions();
        return this.getNFTListByOwnerAsync(nftAddress, ownerAddress, options, callback);
    }

    public Call getNFTListByOwnerAsync(String nftAddress, String ownerAddress, TokenHistoryQueryOptions options, ApiCallback<PageableNfts> callback) throws ApiException {
        return this.tokenApi.getNftsByOwnerAddressAsync(this.chainId, nftAddress, ownerAddress, options.getSize(), options.getCursor(), callback);
    }

    public Nft getNFT(String nftAddress, String tokenId) throws ApiException {
        return this.tokenApi.getNftById(this.chainId, nftAddress, tokenId);
    }

    public Call getNFTAsync(String nftAddress, String tokenId, ApiCallback<Nft> callback) throws ApiException {
        return this.tokenApi.getNftByIdAsync(this.chainId, nftAddress, tokenId, callback);
    }

    public PageableNftOwnershipChanges getNFTOwnershipHistory(String nftAddress, String tokenId) throws ApiException {
        TokenHistoryQueryOptions options = new TokenHistoryQueryOptions();
        return this.getNFTOwnershipHistory(nftAddress, tokenId, options);
    }

    public PageableNftOwnershipChanges getNFTOwnershipHistory(String nftAddress, String tokenId, TokenHistoryQueryOptions options) throws ApiException {
        return this.tokenOwnershipApi.getListOfNftOwnershipChanges(this.chainId, nftAddress, tokenId, options.getSize(), options.getCursor());
    }

    public Call getNFTOwnershipHistoryAsync(String nftAddress, String tokenId, ApiCallback<PageableNftOwnershipChanges> callback) throws ApiException {
        TokenHistoryQueryOptions options = new TokenHistoryQueryOptions();
        return this.getNFTOwnershipHistoryAsync(nftAddress, tokenId, options, callback);
    }

    public Call getNFTOwnershipHistoryAsync(String nftAddress, String tokenId, TokenHistoryQueryOptions options, ApiCallback<PageableNftOwnershipChanges> callback) throws ApiException {
        return this.tokenOwnershipApi.getListOfNftOwnershipChangesAsync(this.chainId, nftAddress, tokenId, options.getSize(), options.getCursor(), callback);
    }

    public PageableMtTokensWithBalance getMTListByOwner(String mtAddress, String ownerAddress) throws ApiException {
        TokenHistoryQueryOptions options = new TokenHistoryQueryOptions();
        return this.getMTListByOwner(mtAddress, ownerAddress, options);
    }

    public PageableMtTokensWithBalance getMTListByOwner(String mtAddress, String ownerAddress, TokenHistoryQueryOptions options) throws ApiException {
        return this.tokenApi.getMtTokensByContractAddressAndOwnerAddress(this.chainId, mtAddress, ownerAddress, options.getCursor(), options.getSize());
    }

    public Call getMTListByOwnerAsync(String mtAddress, String ownerAddress, ApiCallback<PageableMtTokensWithBalance> callback) throws ApiException {
        TokenHistoryQueryOptions options = new TokenHistoryQueryOptions();
        return this.getMTListByOwnerAsync(mtAddress, ownerAddress, options, callback);
    }

    public Call getMTListByOwnerAsync(String mtAddress, String ownerAddress, TokenHistoryQueryOptions options, ApiCallback<PageableMtTokensWithBalance> callback) throws ApiException {
        return this.tokenApi.getMtTokensByContractAddressAndOwnerAddressAsync(this.chainId, mtAddress, ownerAddress, options.getCursor(), options.getSize(), callback);
    }

    public MtToken getMT(String mtAddress, String ownerAddress, String tokenID) throws ApiException {
        return this.tokenApi.getMtTokensByContractAddressAndOwnerAddressAndTokenId(this.chainId, mtAddress, ownerAddress, tokenID);
    }

    public Call getMTAsync(String mtAddress, String ownerAddress, String tokenID, ApiCallback<MtToken> callback) throws ApiException {
        return this.tokenApi.getMtTokensByContractAddressAndOwnerAddressAndTokenIdAsync(this.chainId, mtAddress, ownerAddress, tokenID, callback);
    }

    public PageableMtTokens getMTOwnerListByTokenId(String mtAddress, String tokenId) throws ApiException {
        TokenHistoryQueryOptions options = new TokenHistoryQueryOptions();
        return this.getMTOwnerListByTokenId(mtAddress, tokenId, options);
    }

    public PageableMtTokens getMTOwnerListByTokenId(String mtAddress, String tokenId, TokenHistoryQueryOptions options) throws ApiException {
        return this.tokenApi.getMtTokensByContractAddressAndTokenId(this.chainId, mtAddress, tokenId, options.getCursor(), options.getSize());
    }

    public Call getMTOwnerListByTokenIdAsync(String mtAddress, String tokenId, ApiCallback<PageableMtTokens> callback) throws ApiException {
        TokenHistoryQueryOptions options = new TokenHistoryQueryOptions();
        return this.getMTOwnerListByTokenIdAsync(mtAddress, tokenId, options, callback);
    }

    public Call getMTOwnerListByTokenIdAsync(String mtAddress, String tokenId, TokenHistoryQueryOptions options, ApiCallback<PageableMtTokens> callback) throws ApiException {
        return this.tokenApi.getMtTokensByContractAddressAndTokenIdAsync(this.chainId, mtAddress, tokenId, options.getCursor(), options.getSize(), callback);
    }

    public PageableMtContractDetails getMTContractList() throws ApiException {
        TokenHistoryQueryOptions options = new TokenHistoryQueryOptions();
        return this.getMTContractList(options);
    }

    public PageableMtContractDetails getMTContractList(TokenHistoryQueryOptions options) throws ApiException {
        return this.tokenContractApi.getListOfMtContracts(this.chainId, options.getStatus(), options.getType(), options.getSize(), options.getCursor());
    }

    public Call getMTContractListAsync(ApiCallback<PageableMtContractDetails> callback) throws ApiException {
        TokenHistoryQueryOptions options = new TokenHistoryQueryOptions();
        return this.getMTContractListAsync(options, callback);
    }

    public Call getMTContractListAsync(TokenHistoryQueryOptions options, ApiCallback<PageableMtContractDetails> callback) throws ApiException {
        return this.tokenContractApi.getListOfMtContractsAsync(this.chainId, options.getStatus(), options.getType(), options.getSize(), options.getCursor(), callback);
    }

    public MtContractDetail getMTContract(String mtAddress) throws ApiException {
        return this.tokenContractApi.getMtContractDetail(this.chainId, mtAddress);
    }

    public Call getMTContractAsync(String mtAddress, ApiCallback<MtContractDetail> callback) throws ApiException {
        return this.tokenContractApi.getMtContractDetailAsync(this.chainId, mtAddress, callback);
    }

    public TokenApi getTokenApi() {
        return this.tokenApi;
    }

    public TokenContractApi getTokenContractApi() {
        return this.tokenContractApi;
    }

    public TokenHistoryApi getTokenHistoryApi() {
        return this.tokenHistoryApi;
    }

    public TokenOwnershipApi getTokenOwnershipApi() {
        return this.tokenOwnershipApi;
    }

    public String getChainId() {
        return this.chainId;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setTokenApi(TokenApi tokenApi) {
        this.tokenApi = tokenApi;
    }

    public void setTokenContractApi(TokenContractApi tokenContractApi) {
        this.tokenContractApi = tokenContractApi;
    }

    public void setTokenHistoryApi(TokenHistoryApi tokenHistoryApi) {
        this.tokenHistoryApi = tokenHistoryApi;
    }

    public void setTokenOwnershipApi(TokenOwnershipApi tokenOwnershipApi) {
        this.tokenOwnershipApi = tokenOwnershipApi;
    }

    public void setChainId(String chainId) {
        this.chainId = chainId;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
        this.setTokenApi(new TokenApi(apiClient));
        this.setTokenContractApi(new TokenContractApi(apiClient));
        this.setTokenHistoryApi(new TokenHistoryApi(apiClient));
        this.setTokenOwnershipApi(new TokenOwnershipApi(apiClient));
    }
}

