/*
 * Decompiled with CFR 0.152.
 */
package xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.tokenhistory.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.ApiCallback;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.ApiClient;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.ApiException;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.ApiResponse;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.Configuration;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.Pair;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.ProgressRequestBody;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.ProgressResponseBody;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.tokenhistory.model.PageableNftOwnershipChanges;

public class TokenOwnershipApi {
    private ApiClient apiClient;

    public TokenOwnershipApi() {
        this(Configuration.getDefaultApiClient());
    }

    public TokenOwnershipApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call getListOfNftOwnershipChangesCall(String xChainId, String nftAddress, String tokenId, Long size, String cursor, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v2/contract/nft/{nft-address}/token/{token-id}/history".replaceAll("\\{nft-address\\}", this.apiClient.escapeString(nftAddress.toString())).replaceAll("\\{token-id\\}", this.apiClient.escapeString(tokenId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (size != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("size", size));
        }
        if (cursor != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("cursor", cursor));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xChainId != null) {
            localVarHeaderParams.put("x-chain-id", this.apiClient.parameterToString(xChainId));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getListOfNftOwnershipChangesValidateBeforeCall(String xChainId, String nftAddress, String tokenId, Long size, String cursor, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (xChainId == null) {
            throw new ApiException("Missing the required parameter 'xChainId' when calling getListOfNftOwnershipChanges(Async)");
        }
        if (nftAddress == null) {
            throw new ApiException("Missing the required parameter 'nftAddress' when calling getListOfNftOwnershipChanges(Async)");
        }
        if (tokenId == null) {
            throw new ApiException("Missing the required parameter 'tokenId' when calling getListOfNftOwnershipChanges(Async)");
        }
        Call call = this.getListOfNftOwnershipChangesCall(xChainId, nftAddress, tokenId, size, cursor, progressListener, progressRequestListener);
        return call;
    }

    public PageableNftOwnershipChanges getListOfNftOwnershipChanges(String xChainId, String nftAddress, String tokenId, Long size, String cursor) throws ApiException {
        ApiResponse<PageableNftOwnershipChanges> resp = this.getListOfNftOwnershipChangesWithHttpInfo(xChainId, nftAddress, tokenId, size, cursor);
        return resp.getData();
    }

    public ApiResponse<PageableNftOwnershipChanges> getListOfNftOwnershipChangesWithHttpInfo(String xChainId, String nftAddress, String tokenId, Long size, String cursor) throws ApiException {
        Call call = this.getListOfNftOwnershipChangesValidateBeforeCall(xChainId, nftAddress, tokenId, size, cursor, null, null);
        Type localVarReturnType = new TypeToken<PageableNftOwnershipChanges>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getListOfNftOwnershipChangesAsync(String xChainId, String nftAddress, String tokenId, Long size, String cursor, final ApiCallback<PageableNftOwnershipChanges> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getListOfNftOwnershipChangesValidateBeforeCall(xChainId, nftAddress, tokenId, size, cursor, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<PageableNftOwnershipChanges>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

