/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.core.view;

import java.io.Serializable;
import xyz.erupt.core.view.EruptApiModel;

public class R<T>
implements Serializable {
    private String msg;
    private T data;
    private boolean success;
    private EruptApiModel.Status status;
    private EruptApiModel.PromptWay promptWay = EruptApiModel.PromptWay.MESSAGE;

    public static <T> R<T> ok(final T data) {
        return new R<T>(){
            {
                this.setSuccess(true);
                this.setData(data);
                this.setStatus(EruptApiModel.Status.SUCCESS);
            }
        };
    }

    public static R<Void> error(final String msg) {
        return new R<Void>(){
            {
                this.setSuccess(false);
                this.setMsg(msg);
                this.setStatus(EruptApiModel.Status.ERROR);
            }
        };
    }

    public String getMsg() {
        return this.msg;
    }

    public T getData() {
        return this.data;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public EruptApiModel.Status getStatus() {
        return this.status;
    }

    public EruptApiModel.PromptWay getPromptWay() {
        return this.promptWay;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public void setData(T data) {
        this.data = data;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public void setStatus(EruptApiModel.Status status) {
        this.status = status;
    }

    public void setPromptWay(EruptApiModel.PromptWay promptWay) {
        this.promptWay = promptWay;
    }

    public static enum PromptWay {
        DIALOG,
        MESSAGE,
        NOTIFY,
        NONE;

    }

    public static enum Status {
        SUCCESS,
        ERROR,
        INFO,
        WARNING;

    }
}

