/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.core.view;

import com.google.gson.JsonObject;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import xyz.erupt.annotation.EruptField;
import xyz.erupt.annotation.sub_field.Edit;
import xyz.erupt.core.exception.EruptFieldAnnotationException;
import xyz.erupt.core.exception.ExceptionAnsi;
import xyz.erupt.core.proxy.AnnotationProcess;
import xyz.erupt.core.proxy.AnnotationProxy;
import xyz.erupt.core.proxy.EruptFieldProxy;
import xyz.erupt.core.proxy.ProxyContext;
import xyz.erupt.core.util.CloneSupport;
import xyz.erupt.core.util.ReflectUtil;
import xyz.erupt.core.util.TypeUtil;

public class EruptFieldModel
extends CloneSupport<EruptFieldModel> {
    private transient EruptField eruptField;
    private transient Field field;
    private transient String fieldReturnName;
    private transient AnnotationProxy<EruptField, Void> eruptFieldAnnotationProxy = new EruptFieldProxy();
    private String fieldName;
    private JsonObject eruptFieldJson;
    private Object value;
    private Object componentValue;

    public EruptFieldModel(Field field) {
        this.field = field;
        this.eruptField = field.getAnnotation(EruptField.class);
        Edit edit = this.eruptField.edit();
        this.fieldName = field.getName();
        this.fieldReturnName = TypeUtil.isNumberType(field.getType().getSimpleName()) ? "number" : field.getType().getSimpleName();
        switch (edit.type()) {
            case TAB_TREE: 
            case TAB_TABLE_ADD: 
            case TAB_TABLE_REFER: 
            case CHECKBOX: {
                try {
                    this.fieldReturnName = ReflectUtil.getFieldGenericName(field).get(0);
                    break;
                }
                catch (Exception e) {
                    throw ExceptionAnsi.styleEruptFieldException(this, "Component modification field is incorrect");
                }
            }
        }
        this.eruptField = this.eruptFieldAnnotationProxy.newProxy(this.getEruptField());
        EruptFieldAnnotationException.validateEruptFieldInfo(this);
    }

    public EruptField getEruptField() {
        ProxyContext.set(this.field);
        return this.eruptField;
    }

    public void serializable() {
        this.eruptFieldJson = AnnotationProcess.annotationToJsonByReflect((Annotation)this.getEruptField());
    }

    public Field getField() {
        return this.field;
    }

    public String getFieldReturnName() {
        return this.fieldReturnName;
    }

    public AnnotationProxy<EruptField, Void> getEruptFieldAnnotationProxy() {
        return this.eruptFieldAnnotationProxy;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public JsonObject getEruptFieldJson() {
        return this.eruptFieldJson;
    }

    public Object getValue() {
        return this.value;
    }

    public Object getComponentValue() {
        return this.componentValue;
    }

    public void setEruptField(EruptField eruptField) {
        this.eruptField = eruptField;
    }

    public void setField(Field field) {
        this.field = field;
    }

    public void setFieldReturnName(String fieldReturnName) {
        this.fieldReturnName = fieldReturnName;
    }

    public void setEruptFieldAnnotationProxy(AnnotationProxy<EruptField, Void> eruptFieldAnnotationProxy) {
        this.eruptFieldAnnotationProxy = eruptFieldAnnotationProxy;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public void setEruptFieldJson(JsonObject eruptFieldJson) {
        this.eruptFieldJson = eruptFieldJson;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public void setComponentValue(Object componentValue) {
        this.componentValue = componentValue;
    }
}

