/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.core.util;

import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.erupt.core.exception.EruptWebApiRuntimeException;

public class SecurityUtil {
    private static final Logger log = LoggerFactory.getLogger(SecurityUtil.class);

    public static boolean xssInspect(String value) {
        if (StringUtils.isNotBlank((CharSequence)value)) {
            Pattern scriptPattern = Pattern.compile("<script>(.*?)</script>", 2);
            if (scriptPattern.matcher(value).matches()) {
                return true;
            }
            scriptPattern = Pattern.compile("src[\r\n]*=[\r\n]*\\'(.*?)\\'", 42);
            if (scriptPattern.matcher(value).matches()) {
                return true;
            }
            if (scriptPattern.matcher(value).matches()) {
                return true;
            }
            scriptPattern = Pattern.compile("src[\r\n]*=[\r\n]*\\\"(.*?)\\\"", 42);
            if (scriptPattern.matcher(value).matches()) {
                return true;
            }
            scriptPattern = Pattern.compile("</script>", 2);
            if (scriptPattern.matcher(value).matches()) {
                return true;
            }
            scriptPattern = Pattern.compile("<script(.*?)>", 42);
            if (scriptPattern.matcher(value).matches()) {
                return true;
            }
            scriptPattern = Pattern.compile("eval\\((.*?)\\)", 42);
            if (scriptPattern.matcher(value).matches()) {
                return true;
            }
            scriptPattern = Pattern.compile("e\u00adxpression\\((.*?)\\)", 42);
            if (scriptPattern.matcher(value).matches()) {
                return true;
            }
            scriptPattern = Pattern.compile("javascript:", 2);
            if (scriptPattern.matcher(value).matches()) {
                return true;
            }
            scriptPattern = Pattern.compile("vbscript:", 2);
            if (scriptPattern.matcher(value).matches()) {
                return true;
            }
            scriptPattern = Pattern.compile("onload(.*?)=", 42);
            if (scriptPattern.matcher(value).matches()) {
                return true;
            }
            scriptPattern = Pattern.compile("onmouseover(.*?)=", 42);
            if (scriptPattern.matcher(value).matches()) {
                return true;
            }
            scriptPattern = Pattern.compile("onfocus(.*?)=", 42);
            if (scriptPattern.matcher(value).matches()) {
                return true;
            }
            scriptPattern = Pattern.compile("onerror(.*?)=", 42);
            return scriptPattern.matcher(value).matches();
        }
        return false;
    }

    public static boolean csrfInspect(HttpServletRequest request, HttpServletResponse response) {
        String origin = request.getHeader("Origin");
        if (null != origin && !origin.contains(request.getHeader("Host"))) {
            response.setCharacterEncoding(StandardCharsets.UTF_8.name());
            response.setContentType("text/plain; charset=utf-8");
            try {
                PrintWriter out = response.getWriter();
                Throwable throwable = null;
                try {
                    try {
                        String text = "Illegal cross-site request!";
                        out.append(text);
                        throw new EruptWebApiRuntimeException(text);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                catch (Throwable throwable3) {
                    if (out != null) {
                        if (throwable != null) {
                            try {
                                out.close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                        } else {
                            out.close();
                        }
                    }
                    throw throwable3;
                }
            }
            catch (IOException e) {
                log.error("csrf inspect error", (Throwable)e);
                return true;
            }
        }
        return false;
    }
}

