/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.core.util;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;

public class ReflectUtil {
    public static Field findClassField(Class<?> clazz, String fieldName) {
        while (clazz != null) {
            try {
                Field field = clazz.getDeclaredField(fieldName);
                field.setAccessible(true);
                return field;
            }
            catch (NoSuchFieldException e) {
                if (!Object.class.equals(clazz = clazz.getSuperclass())) continue;
                break;
            }
        }
        return null;
    }

    public static Object findFieldChain(String fieldName, Object obj) throws IllegalAccessException {
        String[] fields;
        for (String field : fields = fieldName.split("\\.")) {
            Field f = ReflectUtil.findClassField(obj.getClass(), field);
            if (f == null) {
                throw new RuntimeException(obj.getClass().getName() + "." + fieldName + " not found");
            }
            if (null != (obj = f.get(obj))) continue;
            return null;
        }
        return obj;
    }

    public static void findClassAllFields(Class<?> clazz, Consumer<Field> fieldConsumer) {
        for (Class<?> tempClass = clazz; null != tempClass; tempClass = tempClass.getSuperclass()) {
            for (Field field : tempClass.getDeclaredFields()) {
                int mod = field.getModifiers();
                if (Modifier.isStatic(mod) || Modifier.isInterface(mod)) continue;
                fieldConsumer.accept(field);
            }
        }
    }

    public static List<Class<?>> findClassExtendStack(Class<?> clazz) {
        ArrayList list = new ArrayList();
        Class<?> tempClass = clazz;
        while (null != tempClass) {
            if ((tempClass = tempClass.getSuperclass()) == null || tempClass == Object.class) continue;
            list.add(tempClass);
        }
        if (list.size() > 1) {
            Collections.reverse(list);
        }
        return list;
    }

    public static List<String> getFieldGenericName(Field field) {
        ArrayList<String> names = new ArrayList<String>();
        Type gType = field.getGenericType();
        if (gType instanceof ParameterizedType) {
            Type[] typeArguments;
            for (Type typeArgument : typeArguments = ((ParameterizedType)gType).getActualTypeArguments()) {
                String[] gArray = typeArgument.getTypeName().split("\\.");
                names.add(gArray[gArray.length - 1]);
            }
        }
        return names;
    }
}

