/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.core.util;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.erupt.annotation.EruptField;
import xyz.erupt.annotation.SceneEnum;
import xyz.erupt.annotation.config.QueryExpression;
import xyz.erupt.annotation.fun.AttachmentProxy;
import xyz.erupt.annotation.fun.ChoiceFetchHandler;
import xyz.erupt.annotation.fun.TagsFetchHandler;
import xyz.erupt.annotation.fun.VLModel;
import xyz.erupt.annotation.query.Condition;
import xyz.erupt.annotation.sub_field.Edit;
import xyz.erupt.annotation.sub_field.EditType;
import xyz.erupt.annotation.sub_field.EditTypeSearch;
import xyz.erupt.annotation.sub_field.View;
import xyz.erupt.annotation.sub_field.sub_edit.ChoiceType;
import xyz.erupt.annotation.sub_field.sub_edit.ReferenceTableType;
import xyz.erupt.annotation.sub_field.sub_edit.ReferenceTreeType;
import xyz.erupt.annotation.sub_field.sub_edit.TagsType;
import xyz.erupt.core.annotation.EruptAttachmentUpload;
import xyz.erupt.core.config.GsonFactory;
import xyz.erupt.core.exception.EruptApiErrorTip;
import xyz.erupt.core.i18n.I18nTranslate;
import xyz.erupt.core.proxy.AnnotationProcess;
import xyz.erupt.core.service.EruptApplication;
import xyz.erupt.core.service.EruptCoreService;
import xyz.erupt.core.util.DateUtil;
import xyz.erupt.core.util.EruptSpringUtil;
import xyz.erupt.core.util.ReflectUtil;
import xyz.erupt.core.util.SecretUtil;
import xyz.erupt.core.util.SecurityUtil;
import xyz.erupt.core.util.TypeUtil;
import xyz.erupt.core.view.EruptApiModel;
import xyz.erupt.core.view.EruptFieldModel;
import xyz.erupt.core.view.EruptModel;

public class EruptUtil {
    private static final Logger log = LoggerFactory.getLogger(EruptUtil.class);

    public static Map<String, Object> generateEruptDataMap(EruptModel eruptModel, Object obj) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        block8: for (EruptFieldModel fieldModel : eruptModel.getEruptFieldModels()) {
            if ("".equals(fieldModel.getEruptField().edit().title()) && !eruptModel.getErupt().primaryKeyCol().equals(fieldModel.getFieldName())) continue;
            Field field = fieldModel.getField();
            field.setAccessible(true);
            Object value = field.get(obj);
            if (null == value) continue;
            EruptField eruptField = fieldModel.getEruptField();
            switch (eruptField.edit().type()) {
                case REFERENCE_TREE: 
                case REFERENCE_TABLE: {
                    String label;
                    String id;
                    if (eruptField.edit().type() == EditType.REFERENCE_TREE) {
                        ReferenceTreeType referenceTreeType = eruptField.edit().referenceTreeType();
                        id = referenceTreeType.id();
                        label = referenceTreeType.label();
                    } else {
                        ReferenceTableType referenceTableType = eruptField.edit().referenceTableType();
                        id = referenceTableType.id();
                        label = referenceTableType.label();
                    }
                    HashMap<Object, Object> referMap = new HashMap<Object, Object>();
                    referMap.put(id, ReflectUtil.findFieldChain(id, value));
                    referMap.put(label, ReflectUtil.findFieldChain(label, value));
                    for (View view : eruptField.views()) {
                        String columnKey = view.column().replace(".", "_");
                        Object columnValue = ReflectUtil.findFieldChain(view.column(), value);
                        referMap.put(columnKey, columnValue);
                        map.put(field.getName() + "_" + (String)columnKey, columnValue);
                    }
                    map.put(field.getName(), referMap);
                    continue block8;
                }
                case COMBINE: {
                    map.put(field.getName(), EruptUtil.generateEruptDataMap(EruptCoreService.getErupt(fieldModel.getFieldReturnName()), value));
                    continue block8;
                }
                case CHECKBOX: 
                case TAB_TREE: {
                    EruptModel tabEruptModel = EruptCoreService.getErupt(fieldModel.getFieldReturnName());
                    Collection collection = (Collection)value;
                    if (collection.size() <= 0) continue block8;
                    HashSet<Object> idSet = new HashSet<Object>();
                    Field primaryField = ReflectUtil.findClassField(collection.iterator().next().getClass(), tabEruptModel.getErupt().primaryKeyCol());
                    for (Object o : collection) {
                        idSet.add(primaryField.get(o));
                    }
                    map.put(field.getName(), idSet);
                    continue block8;
                }
                case TAB_TABLE_REFER: 
                case TAB_TABLE_ADD: {
                    EruptModel tabEruptModelRef = EruptCoreService.getErupt(fieldModel.getFieldReturnName());
                    Collection collectionRef = (Collection)value;
                    ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
                    for (Object o : collectionRef) {
                        list.add(EruptUtil.generateEruptDataMap(tabEruptModelRef, o));
                    }
                    map.put(field.getName(), list);
                    continue block8;
                }
            }
            if (fieldModel.getField().getType() == Long.class || fieldModel.getField().getType() == Double.class || fieldModel.getField().getType() == BigDecimal.class) {
                map.put(field.getName(), value.toString());
                continue;
            }
            map.put(field.getName(), value);
        }
        return map;
    }

    public static Map<String, String> getChoiceMap(EruptModel eruptModel, ChoiceType choiceType) {
        LinkedHashMap<String, String> choiceMap = new LinkedHashMap<String, String>();
        EruptUtil.getChoiceList(eruptModel, choiceType).forEach(vl -> choiceMap.put(vl.getValue(), vl.getLabel()));
        return choiceMap;
    }

    public static List<VLModel> getChoiceList(EruptModel eruptModel, ChoiceType choiceType) {
        List<VLModel> vls = Stream.of(choiceType.vl()).map(vl -> new VLModel(vl.value(), vl.label(), vl.desc(), vl.disable())).collect(Collectors.toList());
        Stream.of(choiceType.fetchHandler()).filter(clazz -> !clazz.isInterface()).forEach(clazz -> Optional.ofNullable(((ChoiceFetchHandler)EruptSpringUtil.getBean(clazz)).fetch(choiceType.fetchHandlerParams())).ifPresent(vls::addAll));
        if (eruptModel.isI18n()) {
            vls.forEach(vl -> vl.setLabel(I18nTranslate.$translate(vl.getLabel())));
        }
        return vls;
    }

    public static List<String> getTagList(TagsType tagsType) {
        ArrayList<String> tags = new ArrayList<String>(Arrays.asList(tagsType.tags()));
        Stream.of(tagsType.fetchHandler()).filter(clazz -> !clazz.isInterface()).forEach(clazz -> tags.addAll(((TagsFetchHandler)EruptSpringUtil.getBean(clazz)).fetchTags(tagsType.fetchHandlerParams())));
        return tags;
    }

    public static Object convertObjectType(EruptFieldModel eruptFieldModel, Object obj) {
        if (null == obj) {
            return null;
        }
        if (null == eruptFieldModel) {
            if (obj instanceof Number) {
                return obj;
            }
            return obj.toString();
        }
        String str = obj.toString();
        Edit edit = eruptFieldModel.getEruptField().edit();
        switch (edit.type()) {
            case DATE: {
                if (EruptUtil.isDateField(eruptFieldModel.getFieldReturnName())) {
                    return DateUtil.getDate(eruptFieldModel.getField().getType(), str);
                }
                return str;
            }
            case REFERENCE_TREE: 
            case REFERENCE_TABLE: {
                String id = null;
                if (edit.type().equals((Object)EditType.REFERENCE_TREE)) {
                    id = eruptFieldModel.getEruptField().edit().referenceTreeType().id();
                } else if (edit.type().equals((Object)EditType.REFERENCE_TABLE)) {
                    id = edit.referenceTableType().id();
                }
                EruptFieldModel efm = EruptCoreService.getErupt(eruptFieldModel.getFieldReturnName()).getEruptFieldMap().get(id);
                Map map = (Map)obj;
                return TypeUtil.typeStrConvertObject(map.get(id), efm.getField().getType());
            }
        }
        return TypeUtil.typeStrConvertObject(str, eruptFieldModel.getField().getType());
    }

    public static List<Condition> geneEruptSearchCondition(EruptModel eruptModel, List<Condition> searchCondition) {
        EruptUtil.checkEruptSearchNotnull(eruptModel, searchCondition);
        ArrayList<Condition> legalConditions = new ArrayList<Condition>();
        if (null != searchCondition) {
            for (Condition condition : searchCondition) {
                Collection collection;
                Edit edit;
                EditTypeSearch editTypeSearch;
                EruptFieldModel eruptFieldModel = eruptModel.getEruptFieldMap().get(condition.getKey());
                if (null == eruptFieldModel || null == (editTypeSearch = AnnotationProcess.getEditTypeSearch((edit = eruptFieldModel.getEruptField().edit()).type())) || !editTypeSearch.value() || !edit.search().value() || null == condition.getValue() || condition.getValue() instanceof Collection && (collection = (Collection)condition.getValue()).size() == 0) continue;
                if (edit.search().vague()) {
                    condition.setExpression(editTypeSearch.vagueMethod());
                } else {
                    condition.setExpression(QueryExpression.EQ);
                }
                legalConditions.add(condition);
            }
        }
        return legalConditions;
    }

    public static void checkEruptSearchNotnull(EruptModel eruptModel, List<Condition> searchCondition) {
        HashMap conditionMap = new HashMap();
        if (null != searchCondition) {
            searchCondition.forEach(condition -> conditionMap.put(condition.getKey(), condition));
        }
        for (EruptFieldModel fieldModel : eruptModel.getEruptFieldModels()) {
            Edit edit = fieldModel.getEruptField().edit();
            if (!edit.search().value() || !edit.search().notNull()) continue;
            Condition condition2 = (Condition)conditionMap.get(fieldModel.getFieldName());
            if (null == condition2 || null == condition2.getValue()) {
                throw new EruptApiErrorTip(EruptApiModel.Status.INFO, edit.title() + " " + I18nTranslate.$translate("erupt.notnull"), EruptApiModel.PromptWay.MESSAGE);
            }
            if (!(condition2.getValue() instanceof List) || ((List)condition2.getValue()).size() != 0) continue;
            throw new EruptApiErrorTip((Object)((Object)EruptApiModel.Status.INFO) + edit.title() + " " + I18nTranslate.$translate("erupt.notnull"), EruptApiModel.PromptWay.MESSAGE);
        }
    }

    public static EruptApiModel validateEruptValue(EruptModel eruptModel, JsonObject jsonObject) {
        for (EruptFieldModel field : eruptModel.getEruptFieldModels()) {
            EruptApiModel eam;
            Edit edit = field.getEruptField().edit();
            JsonElement value = jsonObject.get(field.getFieldName());
            if (field.getEruptField().edit().notNull()) {
                if (null == value || value.isJsonNull()) {
                    return EruptApiModel.errorNoInterceptMessage(field.getEruptField().edit().title() + " " + I18nTranslate.$translate("erupt.notnull"));
                }
                if (String.class.getSimpleName().equals(field.getFieldReturnName()) && StringUtils.isBlank((CharSequence)value.getAsString())) {
                    return EruptApiModel.errorNoInterceptMessage(field.getEruptField().edit().title() + " " + I18nTranslate.$translate("erupt.notnull"));
                }
            }
            if (field.getEruptField().edit().type() == EditType.COMBINE && (eam = EruptUtil.validateEruptValue(EruptCoreService.getErupt(field.getFieldReturnName()), jsonObject.getAsJsonObject(field.getFieldName()))).getStatus() == EruptApiModel.Status.ERROR) {
                return eam;
            }
            if (null == value || "".equals(edit.title())) continue;
            if ((edit.type() == EditType.TEXTAREA || edit.type() == EditType.INPUT) && SecurityUtil.xssInspect(value.getAsString())) {
                return EruptApiModel.errorNoInterceptApi(field.getEruptField().edit().title() + " " + I18nTranslate.$translate("erupt.attack.xss"));
            }
            switch (edit.type()) {
                case NUMBER: 
                case SLIDER: {
                    if (NumberUtils.isCreatable((String)value.getAsString())) break;
                    return EruptApiModel.errorNoInterceptMessage(field.getEruptField().edit().title() + " " + I18nTranslate.$translate("erupt.must.number"));
                }
                case INPUT: {
                    String content;
                    if ("".equals(edit.inputType().regex()) || !StringUtils.isNotBlank((CharSequence)(content = value.getAsString())) || Pattern.matches(edit.inputType().regex(), content)) break;
                    return EruptApiModel.errorNoInterceptMessage(field.getEruptField().edit().title() + " " + I18nTranslate.$translate("erupt.incorrect_format"));
                }
            }
        }
        return EruptApiModel.successApi();
    }

    public static void processEruptWebValue(EruptModel eruptModel, JsonObject jsonObject) {
        for (EruptFieldModel field : eruptModel.getEruptFieldModels()) {
            JsonElement value = jsonObject.get(field.getFieldName());
            Edit edit = field.getEruptField().edit();
            if (null == value || value.isJsonNull()) continue;
            if (edit.type() == EditType.CODE_EDITOR) {
                jsonObject.addProperty(field.getFieldName(), SecretUtil.decodeSecret(value.getAsString()));
                continue;
            }
            if (value.isJsonObject() && edit.type() == EditType.COMBINE) {
                EruptUtil.processEruptWebValue(EruptCoreService.getErupt(field.getFieldReturnName()), value.getAsJsonObject());
                continue;
            }
            if (!value.isJsonArray()) continue;
            switch (edit.type()) {
                case TAB_TABLE_REFER: 
                case TAB_TABLE_ADD: {
                    value.getAsJsonArray().forEach(jsonElement -> Optional.ofNullable(EruptCoreService.getErupt(field.getFieldReturnName())).ifPresent(it -> EruptUtil.processEruptWebValue(it, jsonElement.getAsJsonObject())));
                }
            }
        }
    }

    public static Object toEruptId(EruptModel eruptModel, String id) {
        Field primaryField = ReflectUtil.findClassField(eruptModel.getClazz(), eruptModel.getErupt().primaryKeyCol());
        return TypeUtil.typeStrConvertObject(id, primaryField.getType());
    }

    public static Object dataTarget(EruptModel eruptModel, Object data, Object target, SceneEnum sceneEnum) {
        for (EruptFieldModel fieldModel : eruptModel.getEruptFieldModels()) {
            boolean readonly;
            EruptField eruptField = fieldModel.getEruptField();
            boolean bl = readonly = sceneEnum == SceneEnum.EDIT ? eruptField.edit().readonly().edit() : eruptField.edit().readonly().add();
            if (!StringUtils.isNotBlank((CharSequence)eruptField.edit().title()) || readonly) continue;
            Field f = fieldModel.getField();
            try {
                f.setAccessible(true);
                if (eruptField.edit().type() == EditType.TAB_TABLE_ADD) {
                    Collection s = (Collection)f.get(target);
                    if (null == s) {
                        f.set(target, f.get(data));
                        continue;
                    }
                    s.clear();
                    s.addAll((Collection)f.get(data));
                    f.set(target, s);
                    continue;
                }
                f.set(target, f.get(data));
            }
            catch (IllegalAccessException e) {
                log.error("erupt data copy error", (Throwable)e);
            }
        }
        return target;
    }

    public static void clearObjectDefaultValueByJson(Object obj, JsonObject data) {
        ReflectUtil.findClassAllFields(obj.getClass(), field -> {
            try {
                field.setAccessible(true);
                if (null != field.get(obj) && !data.has(field.getName())) {
                    field.set(obj, null);
                }
            }
            catch (IllegalAccessException e) {
                log.error("erupt clear error", (Throwable)e);
            }
        });
    }

    public static Object jsonToEruptEntity(EruptModel eruptModel, JsonObject json, Map<String, Object> extraData) throws InstantiationException, IllegalAccessException {
        Gson gson = GsonFactory.getGson();
        Object o = gson.fromJson(json.toString(), eruptModel.getClazz());
        EruptUtil.clearObjectDefaultValueByJson(o, json);
        Object obj = EruptUtil.dataTarget(eruptModel, o, eruptModel.getClazz().newInstance(), SceneEnum.ADD);
        if (null != extraData) {
            for (String key : extraData.keySet()) {
                Field field = ReflectUtil.findClassField(eruptModel.getClazz(), key);
                field.setAccessible(true);
                field.set(obj, gson.fromJson(extraData.get(key).toString(), field.getType()));
            }
        }
        return obj;
    }

    public static AttachmentProxy findAttachmentProxy() {
        EruptAttachmentUpload eruptAttachmentUpload = EruptApplication.getPrimarySource().getAnnotation(EruptAttachmentUpload.class);
        return null == eruptAttachmentUpload ? null : EruptSpringUtil.getBean(eruptAttachmentUpload.value());
    }

    public static boolean isDateField(String fieldType) {
        if (Date.class.getSimpleName().equals(fieldType)) {
            return true;
        }
        if (LocalDate.class.getSimpleName().equals(fieldType)) {
            return true;
        }
        return LocalDateTime.class.getSimpleName().equals(fieldType);
    }
}

