/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.core.service;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.core.annotation.Order;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedCaseInsensitiveMap;
import xyz.erupt.annotation.Erupt;
import xyz.erupt.annotation.EruptField;
import xyz.erupt.annotation.sub_field.Edit;
import xyz.erupt.annotation.sub_field.EditType;
import xyz.erupt.core.exception.EruptAnnotationException;
import xyz.erupt.core.module.EruptModuleInvoke;
import xyz.erupt.core.service.EruptApplication;
import xyz.erupt.core.toolkit.TimeRecorder;
import xyz.erupt.core.util.EruptSpringUtil;
import xyz.erupt.core.util.EruptUtil;
import xyz.erupt.core.util.ReflectUtil;
import xyz.erupt.core.view.EruptFieldModel;
import xyz.erupt.core.view.EruptModel;

@Order(value=100)
@Service
public class EruptCoreService
implements ApplicationRunner {
    private static final Logger log = LoggerFactory.getLogger(EruptCoreService.class);
    private static final Map<String, EruptModel> ERUPTS = new LinkedCaseInsensitiveMap();
    private static final List<EruptModel> ERUPT_LIST = new ArrayList<EruptModel>();
    private static final List<String> MODULES = new ArrayList<String>();

    public static List<String> getModules() {
        return MODULES;
    }

    public static List<EruptModel> getErupts() {
        return ERUPT_LIST;
    }

    public static EruptModel getErupt(String eruptName) {
        return ERUPTS.get(eruptName);
    }

    public static void registerErupt(Class<?> eruptClazz) {
        if (ERUPTS.containsKey(eruptClazz.getSimpleName())) {
            throw new RuntimeException(eruptClazz.getSimpleName() + " conflict !");
        }
        EruptModel eruptModel = EruptCoreService.initEruptModel(eruptClazz);
        ERUPTS.put(eruptClazz.getSimpleName(), eruptModel);
        ERUPT_LIST.add(eruptModel);
    }

    public static void unregisterErupt(Class<?> eruptClazz) {
        ERUPTS.remove(eruptClazz.getSimpleName());
        ERUPT_LIST.removeIf(model -> model.getEruptName().equals(eruptClazz.getSimpleName()));
    }

    public static EruptModel getEruptView(String eruptName) {
        EruptModel em = EruptCoreService.getErupt(eruptName).clone();
        for (EruptFieldModel fieldModel : em.getEruptFieldModels()) {
            Edit edit = fieldModel.getEruptField().edit();
            if (edit.type() == EditType.CHOICE) {
                fieldModel.setComponentValue(EruptUtil.getChoiceList(em, edit.choiceType()));
                continue;
            }
            if (edit.type() != EditType.TAGS) continue;
            fieldModel.setComponentValue(EruptUtil.getTagList(edit.tagsType()));
        }
        return em;
    }

    private static EruptModel initEruptModel(Class<?> clazz) {
        EruptModel eruptModel = new EruptModel(clazz);
        eruptModel.setEruptFieldModels(new ArrayList<EruptFieldModel>());
        eruptModel.setEruptFieldMap((Map<String, EruptFieldModel>)new LinkedCaseInsensitiveMap());
        ReflectUtil.findClassAllFields(clazz, field -> Optional.ofNullable(field.getAnnotation(EruptField.class)).ifPresent(ignore -> {
            EruptFieldModel eruptFieldModel = new EruptFieldModel((Field)field);
            eruptModel.getEruptFieldModels().add(eruptFieldModel);
            if (!eruptModel.getEruptFieldMap().containsKey(field.getName())) {
                eruptModel.getEruptFieldMap().put(field.getName(), eruptFieldModel);
            }
        }));
        eruptModel.getEruptFieldModels().sort(Comparator.comparingInt(a -> a.getEruptField().sort()));
        EruptAnnotationException.validateEruptInfo(eruptModel);
        return eruptModel;
    }

    public void run(ApplicationArguments args) {
        TimeRecorder totalRecorder = new TimeRecorder();
        TimeRecorder timeRecorder = new TimeRecorder();
        EruptSpringUtil.scannerPackage(EruptApplication.getScanPackage(), new TypeFilter[]{new AnnotationTypeFilter(Erupt.class)}, clazz -> {
            EruptModel eruptModel = EruptCoreService.initEruptModel(clazz);
            ERUPTS.put(clazz.getSimpleName(), eruptModel);
            ERUPT_LIST.add(eruptModel);
        });
        log.info("<" + this.repeat("===", 20) + ">");
        AtomicInteger moduleMaxCharLength = new AtomicInteger();
        EruptModuleInvoke.invoke(it -> {
            int length = it.info().getName().length();
            if (length > moduleMaxCharLength.get()) {
                moduleMaxCharLength.set(length);
            }
        });
        EruptModuleInvoke.invoke(it -> {
            it.run();
            MODULES.add(it.info().getName());
            log.info("\ud83d\ude80 -> {} module initialization completed in {}ms", (Object)this.fillCharacter(it.info().getName(), moduleMaxCharLength.get()), (Object)timeRecorder.recorder());
        });
        log.info("Erupt modules : " + MODULES.size());
        log.info("Erupt classes : " + ERUPTS.size());
        log.info("Erupt Framework initialization completed in {}ms", (Object)totalRecorder.recorder());
        log.info("<" + this.repeat("===", 20) + ">");
    }

    private String fillCharacter(String character, int targetWidth) {
        return character + this.repeat(" ", targetWidth - character.length());
    }

    private String repeat(String space, int num) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < num; ++i) {
            sb.append(space);
        }
        return sb.toString();
    }
}

