/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.core.controller;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import xyz.erupt.annotation.SceneEnum;
import xyz.erupt.annotation.fun.PowerObject;
import xyz.erupt.annotation.sub_erupt.LinkTree;
import xyz.erupt.core.annotation.EruptRecordOperate;
import xyz.erupt.core.annotation.EruptRouter;
import xyz.erupt.core.config.GsonFactory;
import xyz.erupt.core.exception.EruptApiErrorTip;
import xyz.erupt.core.exception.EruptWebApiRuntimeException;
import xyz.erupt.core.invoke.DataProcessorManager;
import xyz.erupt.core.invoke.DataProxyInvoke;
import xyz.erupt.core.naming.EruptRecordNaming;
import xyz.erupt.core.service.EruptCoreService;
import xyz.erupt.core.service.EruptService;
import xyz.erupt.core.service.IEruptDataService;
import xyz.erupt.core.util.EruptUtil;
import xyz.erupt.core.util.Erupts;
import xyz.erupt.core.util.ReflectUtil;
import xyz.erupt.core.view.EruptApiModel;
import xyz.erupt.core.view.EruptModel;

@RestController
@RequestMapping(value={"/erupt-api/data/modify"})
public class EruptModifyController {
    private static final Logger log = LoggerFactory.getLogger(EruptModifyController.class);
    private final EruptService eruptService;
    private final HttpServletRequest request;

    @Transactional
    @PostMapping(value={"/{erupt}"})
    @EruptRecordOperate(value="INSERT", dynamicConfig=EruptRecordNaming.class)
    @EruptRouter(skipAuthIndex=3, authIndex=1, verifyType=EruptRouter.VerifyType.ERUPT)
    public EruptApiModel addEruptData(@PathVariable(value="erupt") String erupt, @RequestBody JsonObject data) {
        EruptModel eruptModel = EruptCoreService.getErupt(erupt);
        Erupts.powerLegal(eruptModel, PowerObject::isAdd);
        HashMap<String, Object> extraData = new HashMap<String, Object>();
        this.setLinkValue(eruptModel, extraData);
        this.setDrillValue(eruptModel, extraData);
        EruptApiModel eruptApiModel = EruptUtil.validateEruptValue(eruptModel, data);
        if (eruptApiModel.getStatus() == EruptApiModel.Status.ERROR) {
            return eruptApiModel;
        }
        Object obj = EruptUtil.jsonToEruptEntity(eruptModel, data, extraData);
        DataProxyInvoke.invoke(eruptModel, dataProxy -> dataProxy.beforeAdd(obj));
        DataProcessorManager.getEruptDataProcessor(eruptModel.getClazz()).addData(eruptModel, obj);
        this.modifyLog(eruptModel, "ADD", data.toString());
        DataProxyInvoke.invoke(eruptModel, dataProxy -> dataProxy.afterAdd(obj));
        return EruptApiModel.successApi();
    }

    public void batchAddEruptData(EruptModel eruptModel, List<JsonObject> data) {
        ArrayList<Object> objectList = new ArrayList<Object>();
        for (JsonObject item : data) {
            EruptApiModel eruptApiModel = EruptUtil.validateEruptValue(eruptModel, item);
            if (eruptApiModel.getStatus() == EruptApiModel.Status.ERROR) {
                throw new EruptApiErrorTip(eruptApiModel);
            }
            HashMap<String, Object> extraData = new HashMap<String, Object>();
            this.setLinkValue(eruptModel, extraData);
            this.setDrillValue(eruptModel, extraData);
            Object obj = EruptUtil.jsonToEruptEntity(eruptModel, item, extraData);
            DataProxyInvoke.invoke(eruptModel, dataProxy -> dataProxy.beforeAdd(obj));
            objectList.add(obj);
        }
        DataProcessorManager.getEruptDataProcessor(eruptModel.getClazz()).batchAddData(eruptModel, objectList);
        for (Object obj : objectList) {
            DataProxyInvoke.invoke(eruptModel, dataProxy -> dataProxy.afterAdd(obj));
        }
    }

    private void setLinkValue(EruptModel eruptModel, Map<String, Object> extraData) {
        LinkTree dependTree = eruptModel.getErupt().linkTree();
        if (StringUtils.isNotBlank((CharSequence)dependTree.field()) && dependTree.dependNode()) {
            String linkVal = this.request.getHeader("link");
            if (dependTree.dependNode()) {
                if (StringUtils.isBlank((CharSequence)linkVal)) {
                    throw new EruptWebApiRuntimeException("Place select tree node");
                }
                String rm = ReflectUtil.findClassField(eruptModel.getClazz(), dependTree.field()).getType().getSimpleName();
                JsonObject sub = new JsonObject();
                sub.addProperty(EruptCoreService.getErupt(rm).getErupt().primaryKeyCol(), linkVal);
                extraData.put(dependTree.field(), sub);
            }
        }
    }

    private void setDrillValue(EruptModel eruptModel, Map<String, Object> extraData) {
        this.eruptService.drillProcess(eruptModel, (link, val) -> {
            String joinColumn = link.joinColumn();
            if (joinColumn.contains(".")) {
                String[] jc = joinColumn.split("\\.");
                JsonObject jo2 = new JsonObject();
                jo2.addProperty(jc[1], val.toString());
                extraData.put(jc[0], jo2);
            } else {
                extraData.put(joinColumn, val.toString());
            }
        });
    }

    @PostMapping(value={"/{erupt}/update"})
    @EruptRecordOperate(value="UPDATE", dynamicConfig=EruptRecordNaming.class)
    @EruptRouter(skipAuthIndex=3, authIndex=1, verifyType=EruptRouter.VerifyType.ERUPT)
    @Transactional
    public EruptApiModel updateEruptData(@PathVariable(value="erupt") String erupt, @RequestBody JsonObject data) throws IllegalAccessException {
        return this.putUpdateEruptData(erupt, data);
    }

    @PostMapping(value={"/{erupt}/delete"})
    @EruptRouter(skipAuthIndex=3, authIndex=1, verifyType=EruptRouter.VerifyType.ERUPT)
    @EruptRecordOperate(value="DELETE", dynamicConfig=EruptRecordNaming.class)
    public EruptApiModel deleteEruptData(@PathVariable(value="erupt") String erupt, @RequestBody String[] ids) {
        return this.deleteEruptDataList(erupt, ids);
    }

    @Deprecated
    @PutMapping(value={"/{erupt}"})
    @EruptRecordOperate(value="UPDATE", dynamicConfig=EruptRecordNaming.class)
    @EruptRouter(skipAuthIndex=3, authIndex=1, verifyType=EruptRouter.VerifyType.ERUPT)
    @Transactional
    public EruptApiModel putUpdateEruptData(@PathVariable(value="erupt") String erupt, @RequestBody JsonObject data) throws IllegalAccessException {
        EruptModel eruptModel = EruptCoreService.getErupt(erupt);
        Erupts.powerLegal(eruptModel, PowerObject::isEdit);
        EruptApiModel eruptApiModel = EruptUtil.validateEruptValue(eruptModel, data);
        if (eruptApiModel.getStatus() == EruptApiModel.Status.ERROR) {
            return eruptApiModel;
        }
        this.eruptService.verifyIdPermissions(eruptModel, data.get(eruptModel.getErupt().primaryKeyCol()).getAsString());
        Object o = GsonFactory.getGson().fromJson(data.toString(), eruptModel.getClazz());
        EruptUtil.clearObjectDefaultValueByJson(o, data);
        Object obj = EruptUtil.dataTarget(eruptModel, o, DataProcessorManager.getEruptDataProcessor(eruptModel.getClazz()).findDataById(eruptModel, ReflectUtil.findClassField(eruptModel.getClazz(), eruptModel.getErupt().primaryKeyCol()).get(o)), SceneEnum.EDIT);
        DataProxyInvoke.invoke(eruptModel, dataProxy -> dataProxy.beforeUpdate(obj));
        DataProcessorManager.getEruptDataProcessor(eruptModel.getClazz()).editData(eruptModel, obj);
        this.modifyLog(eruptModel, "EDIT", data.toString());
        DataProxyInvoke.invoke(eruptModel, dataProxy -> dataProxy.afterUpdate(obj));
        return EruptApiModel.successApi();
    }

    @Deprecated
    @DeleteMapping(value={"/{erupt}/{id}"})
    @EruptRecordOperate(value="DELETE", dynamicConfig=EruptRecordNaming.class)
    @EruptRouter(skipAuthIndex=3, authIndex=1, verifyType=EruptRouter.VerifyType.ERUPT)
    @Transactional
    public EruptApiModel deleteEruptData(@PathVariable(value="erupt") String erupt, @PathVariable(value="id") String id) {
        EruptModel eruptModel = EruptCoreService.getErupt(erupt);
        Erupts.powerLegal(eruptModel, PowerObject::isDelete);
        this.eruptService.verifyIdPermissions(eruptModel, id);
        IEruptDataService dataService = DataProcessorManager.getEruptDataProcessor(eruptModel.getClazz());
        Object obj = dataService.findDataById(eruptModel, EruptUtil.toEruptId(eruptModel, id));
        DataProxyInvoke.invoke(eruptModel, dataProxy -> dataProxy.beforeDelete(obj));
        dataService.deleteData(eruptModel, obj);
        this.modifyLog(eruptModel, "DELETE", id);
        DataProxyInvoke.invoke(eruptModel, dataProxy -> dataProxy.afterDelete(obj));
        return EruptApiModel.successApi();
    }

    @Deprecated
    @DeleteMapping(value={"/{erupt}"})
    @EruptRouter(skipAuthIndex=3, authIndex=1, verifyType=EruptRouter.VerifyType.ERUPT)
    @EruptRecordOperate(value="DELETES", dynamicConfig=EruptRecordNaming.class)
    public EruptApiModel deleteEruptDataList(@PathVariable(value="erupt") String erupt, @RequestParam(value="ids") String[] ids) {
        String id;
        EruptApiModel eruptApiModel = EruptApiModel.successApi();
        String[] stringArray = ids;
        int n = stringArray.length;
        for (int i = 0; i < n && (eruptApiModel = this.deleteEruptData(erupt, id = stringArray[i])).getStatus() != EruptApiModel.Status.ERROR; ++i) {
        }
        return eruptApiModel;
    }

    private void modifyLog(EruptModel eruptModel, String placeholder, String content) {
        log.info("[" + eruptModel.getEruptName() + " -> " + placeholder + "]:" + content);
    }

    public EruptModifyController(EruptService eruptService, HttpServletRequest request) {
        this.eruptService = eruptService;
        this.request = request;
    }
}

