/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.core.controller;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import xyz.erupt.annotation.config.QueryExpression;
import xyz.erupt.annotation.fun.OperationHandler;
import xyz.erupt.annotation.fun.PowerObject;
import xyz.erupt.annotation.model.Row;
import xyz.erupt.annotation.query.Condition;
import xyz.erupt.annotation.sub_erupt.Filter;
import xyz.erupt.annotation.sub_erupt.RowOperation;
import xyz.erupt.annotation.sub_erupt.Tree;
import xyz.erupt.annotation.sub_field.Edit;
import xyz.erupt.annotation.sub_field.sub_edit.CheckboxType;
import xyz.erupt.annotation.sub_field.sub_edit.ReferenceTableType;
import xyz.erupt.annotation.sub_field.sub_edit.ReferenceTreeType;
import xyz.erupt.core.annotation.EruptRecordOperate;
import xyz.erupt.core.annotation.EruptRouter;
import xyz.erupt.core.config.GsonFactory;
import xyz.erupt.core.exception.EruptNoLegalPowerException;
import xyz.erupt.core.i18n.I18nTranslate;
import xyz.erupt.core.invoke.DataProcessorManager;
import xyz.erupt.core.invoke.DataProxyInvoke;
import xyz.erupt.core.invoke.ExprInvoke;
import xyz.erupt.core.naming.EruptRowOperationNaming;
import xyz.erupt.core.query.Column;
import xyz.erupt.core.query.EruptQuery;
import xyz.erupt.core.service.EruptCoreService;
import xyz.erupt.core.service.EruptService;
import xyz.erupt.core.service.PreEruptDataService;
import xyz.erupt.core.util.EruptSpringUtil;
import xyz.erupt.core.util.EruptUtil;
import xyz.erupt.core.util.Erupts;
import xyz.erupt.core.util.TypeUtil;
import xyz.erupt.core.view.CheckboxModel;
import xyz.erupt.core.view.EruptApiModel;
import xyz.erupt.core.view.EruptFieldModel;
import xyz.erupt.core.view.EruptModel;
import xyz.erupt.core.view.Page;
import xyz.erupt.core.view.TableQuery;
import xyz.erupt.core.view.TreeModel;

@RestController
@RequestMapping(value={"/erupt-api/data"})
public class EruptDataController {
    private static final Logger log = LoggerFactory.getLogger(EruptDataController.class);
    private final EruptService eruptService;
    private final PreEruptDataService preEruptDataService;
    public static final int MAX_PAGE_SIZE = 50000;
    private final Gson gson = GsonFactory.getGson();
    public static final String OPERATOR_PATH_STR = "/operator";

    @PostMapping(value={"/table/{erupt}"})
    @EruptRouter(authIndex=2, verifyType=EruptRouter.VerifyType.ERUPT)
    public Page getEruptData(@PathVariable(value="erupt") String eruptName, @RequestBody TableQuery tableQuery) {
        if (tableQuery.getPageSize() > 50000) {
            tableQuery.setPageSize(50000);
        }
        return this.eruptService.getEruptData(EruptCoreService.getErupt(eruptName), tableQuery, null, new String[0]);
    }

    @GetMapping(value={"/tree/{erupt}"})
    @EruptRouter(authIndex=2, verifyType=EruptRouter.VerifyType.ERUPT)
    public Collection<TreeModel> getEruptTreeData(@PathVariable(value="erupt") String eruptName) {
        EruptModel eruptModel = EruptCoreService.getErupt(eruptName);
        Erupts.powerLegal(eruptModel, PowerObject::isQuery);
        Tree tree = eruptModel.getErupt().tree();
        return this.preEruptDataService.geneTree(eruptModel, tree.id(), tree.label(), tree.pid(), tree.rootPid(), EruptQuery.builder().build());
    }

    @GetMapping(value={"/init-value/{erupt}"})
    @EruptRouter(authIndex=2, verifyType=EruptRouter.VerifyType.ERUPT)
    public Map<String, Object> initEruptValue(@PathVariable(value="erupt") String eruptName) throws IllegalAccessException, InstantiationException {
        EruptModel eruptModel = EruptCoreService.getErupt(eruptName);
        Object obj = eruptModel.getClazz().newInstance();
        DataProxyInvoke.invoke(eruptModel, dataProxy -> dataProxy.addBehavior(obj));
        return EruptUtil.generateEruptDataMap(eruptModel, obj);
    }

    @GetMapping(value={"/{erupt}/{id}"})
    @EruptRouter(authIndex=1, verifyType=EruptRouter.VerifyType.ERUPT)
    public Map<String, Object> getEruptDataById(@PathVariable(value="erupt") String eruptName, @PathVariable(value="id") String id) {
        EruptModel eruptModel = EruptCoreService.getErupt(eruptName);
        Erupts.powerLegal(eruptModel, powerObject -> powerObject.isEdit() || powerObject.isViewDetails());
        this.eruptService.verifyIdPermissions(eruptModel, id);
        Object data = DataProcessorManager.getEruptDataProcessor(eruptModel.getClazz()).findDataById(eruptModel, EruptUtil.toEruptId(eruptModel, id));
        DataProxyInvoke.invoke(eruptModel, dataProxy -> dataProxy.editBehavior(data));
        return EruptUtil.generateEruptDataMap(eruptModel, data);
    }

    @PostMapping(value={"/{erupt}/operator/{code}"})
    @EruptRouter(authIndex=1, verifyType=EruptRouter.VerifyType.ERUPT)
    @EruptRecordOperate(value="", dynamicConfig=EruptRowOperationNaming.class)
    public EruptApiModel execEruptOperator(@PathVariable(value="erupt") String eruptName, @PathVariable(value="code") String code, @RequestBody JsonObject body) {
        EruptModel erupt;
        EruptApiModel eruptApiModel;
        EruptModel eruptModel = EruptCoreService.getErupt(eruptName);
        RowOperation rowOperation = Arrays.stream(eruptModel.getErupt().rowOperation()).filter(it -> code.equals(it.code())).findFirst().orElseThrow(EruptNoLegalPowerException::new);
        Erupts.powerLegal(ExprInvoke.getExpr(rowOperation.show()));
        if (rowOperation.eruptClass() != Void.TYPE && (eruptApiModel = EruptUtil.validateEruptValue(erupt = EruptCoreService.getErupt(rowOperation.eruptClass().getSimpleName()), body.getAsJsonObject("param"))).getStatus() == EruptApiModel.Status.ERROR) {
            return eruptApiModel;
        }
        if (rowOperation.operationHandler().isInterface()) {
            return EruptApiModel.errorApi("Please implement the 'OperationHandler' interface for " + rowOperation.title());
        }
        OperationHandler operationHandler = (OperationHandler)EruptSpringUtil.getBean(rowOperation.operationHandler());
        Object param = null;
        if (!body.get("param").isJsonNull()) {
            param = this.gson.fromJson((JsonElement)body.getAsJsonObject("param"), rowOperation.eruptClass());
        }
        if (rowOperation.mode() == RowOperation.Mode.BUTTON) {
            String eval = operationHandler.exec(null, param, rowOperation.operationParam());
            if (StringUtils.isNotBlank((CharSequence)eval)) {
                return EruptApiModel.successApi(eval);
            }
            return EruptApiModel.successApi(I18nTranslate.$translate("erupt.exec_success"), null);
        }
        if (body.get("ids").isJsonArray() && body.getAsJsonArray("ids").size() > 0) {
            ArrayList list = new ArrayList();
            body.getAsJsonArray("ids").forEach(id -> list.add(DataProcessorManager.getEruptDataProcessor(eruptModel.getClazz()).findDataById(eruptModel, EruptUtil.toEruptId(eruptModel, id.getAsString()))));
            String eval = operationHandler.exec(list, param, rowOperation.operationParam());
            if (StringUtils.isNotBlank((CharSequence)eval)) {
                return EruptApiModel.successApi(eval);
            }
        }
        return EruptApiModel.successApi(I18nTranslate.$translate("erupt.exec_success"), null);
    }

    @GetMapping(value={"/tab/tree/{erupt}/{tabFieldName}"})
    @EruptRouter(authIndex=3, verifyType=EruptRouter.VerifyType.ERUPT)
    public Collection<TreeModel> findTabTree(@PathVariable(value="erupt") String eruptName, @PathVariable(value="tabFieldName") String tabFieldName) {
        EruptModel eruptModel = EruptCoreService.getErupt(eruptName);
        EruptModel tabEruptModel = EruptCoreService.getErupt(eruptModel.getEruptFieldMap().get(tabFieldName).getFieldReturnName());
        Tree tree = tabEruptModel.getErupt().tree();
        EruptFieldModel eruptFieldModel = eruptModel.getEruptFieldMap().get(tabFieldName);
        EruptQuery eruptQuery = EruptQuery.builder().conditionStrings(Arrays.stream(eruptFieldModel.getEruptField().edit().filter()).map(Filter::value).collect(Collectors.toList())).build();
        return this.preEruptDataService.geneTree(tabEruptModel, tree.id(), tree.label(), tree.pid(), tree.rootPid(), eruptQuery);
    }

    @GetMapping(value={"/{erupt}/checkbox/{fieldName}"})
    @EruptRouter(authIndex=1, verifyType=EruptRouter.VerifyType.ERUPT)
    public Collection<CheckboxModel<Object, Object, Object>> findCheckbox(@PathVariable(value="erupt") String eruptName, @PathVariable(value="fieldName") String fieldName) {
        EruptModel eruptModel = EruptCoreService.getErupt(eruptName);
        EruptFieldModel eruptFieldModel = eruptModel.getEruptFieldMap().get(fieldName);
        EruptModel tabEruptModel = EruptCoreService.getErupt(eruptFieldModel.getFieldReturnName());
        CheckboxType checkboxType = eruptFieldModel.getEruptField().edit().checkboxType();
        ArrayList<Column> columns = new ArrayList<Column>();
        columns.add(new Column(checkboxType.id(), "id"));
        columns.add(new Column(checkboxType.label(), "name"));
        if (!"".equals(checkboxType.remark())) {
            columns.add(new Column(checkboxType.remark(), "remark"));
        }
        EruptQuery eruptQuery = EruptQuery.builder().conditionStrings(Arrays.stream(eruptFieldModel.getEruptField().edit().filter()).map(Filter::value).collect(Collectors.toList())).build();
        Collection<Map<String, Object>> collection = this.preEruptDataService.createColumnQuery(tabEruptModel, columns, eruptQuery);
        ArrayList<CheckboxModel<Object, Object, Object>> checkboxModels = new ArrayList<CheckboxModel<Object, Object, Object>>(collection.size());
        collection.forEach(map -> checkboxModels.add(new CheckboxModel(map.get("id"), map.get("name"), map.get("remark"))));
        return checkboxModels;
    }

    @PostMapping(value={"/{erupt}/reference-table/{fieldName}"})
    @EruptRouter(authIndex=1, verifyType=EruptRouter.VerifyType.ERUPT)
    public Page getReferenceTable(@PathVariable(value="erupt") String eruptName, @PathVariable(value="fieldName") String fieldName, @RequestParam(value="dependValue", required=false) Serializable dependValue, @RequestParam(value="tabRef", required=false) Boolean tabRef, @RequestBody TableQuery tableQuery) {
        EruptModel eruptModel = EruptCoreService.getErupt(eruptName);
        EruptFieldModel eruptFieldModel = eruptModel.getEruptFieldMap().get(fieldName);
        Edit edit = eruptFieldModel.getEruptField().edit();
        String dependField = edit.referenceTableType().dependField();
        ArrayList<Condition> serverConditions = new ArrayList<Condition>();
        List<String> conditions = Arrays.stream(edit.filter()).map(Filter::value).collect(Collectors.toList());
        if (!"".equals(dependField)) {
            Erupts.requireNonNull(dependValue, I18nTranslate.$translate("erupt.select") + " " + eruptModel.getEruptFieldMap().get(dependField).getEruptField().edit().title());
            EruptModel refErupt = EruptCoreService.getErupt(eruptFieldModel.getFieldReturnName());
            serverConditions.add(new Condition(eruptFieldModel.getFieldReturnName() + "." + edit.referenceTableType().dependColumn(), TypeUtil.typeStrConvertObject(dependValue, refErupt.getEruptFieldMap().get(refErupt.getErupt().primaryKeyCol()).getField().getType()), QueryExpression.EQ));
        }
        EruptModel eruptReferenceModel = EruptCoreService.getErupt(eruptFieldModel.getFieldReturnName());
        if (!tabRef.booleanValue()) {
            ReferenceTableType referenceTableType = eruptFieldModel.getEruptField().edit().referenceTableType();
            Erupts.requireTrue(eruptReferenceModel.getEruptFieldMap().containsKey(referenceTableType.label().split("\\.")[0]), eruptReferenceModel.getEruptName() + " not found '" + referenceTableType.label() + "' field\uff0cplease use @ReferenceTableType annotation 'label' config");
        }
        return this.eruptService.getEruptData(eruptReferenceModel, tableQuery, serverConditions, conditions.toArray(new String[0]));
    }

    @GetMapping(value={"/depend-tree/{erupt}"})
    @EruptRouter(authIndex=2, verifyType=EruptRouter.VerifyType.ERUPT)
    public Collection<TreeModel> getDependTree(@PathVariable(value="erupt") String erupt) {
        EruptModel eruptModel = EruptCoreService.getErupt(erupt);
        String field = eruptModel.getErupt().linkTree().field();
        if (null == eruptModel.getEruptFieldMap().get(field)) {
            String treeErupt = eruptModel.getClazz().getDeclaredField(field).getType().getSimpleName();
            return this.getEruptTreeData(treeErupt);
        }
        return this.getReferenceTree(eruptModel.getEruptName(), field, null);
    }

    @GetMapping(value={"/{erupt}/reference-tree/{fieldName}"})
    @EruptRouter(authIndex=1, verifyType=EruptRouter.VerifyType.ERUPT)
    public Collection<TreeModel> getReferenceTree(@PathVariable(value="erupt") String erupt, @PathVariable(value="fieldName") String fieldName, @RequestParam(value="dependValue", required=false) Serializable dependValue) {
        EruptModel eruptModel = EruptCoreService.getErupt(erupt);
        EruptFieldModel eruptFieldModel = eruptModel.getEruptFieldMap().get(fieldName);
        String dependField = eruptFieldModel.getEruptField().edit().referenceTreeType().dependField();
        if (!"".equals(dependField)) {
            Erupts.requireNonNull(dependValue, I18nTranslate.$translate("erupt.select") + " " + eruptModel.getEruptFieldMap().get(dependField).getEruptField().edit().title());
        }
        Edit edit = eruptFieldModel.getEruptField().edit();
        ReferenceTreeType treeType = edit.referenceTreeType();
        EruptModel referenceEruptModel = EruptCoreService.getErupt(eruptFieldModel.getFieldReturnName());
        Erupts.requireTrue(referenceEruptModel.getEruptFieldMap().containsKey(treeType.label().split("\\.")[0]), referenceEruptModel.getEruptName() + " not found " + treeType.label() + " field, please use @ReferenceTreeType annotation config");
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        if (StringUtils.isNotBlank((CharSequence)treeType.dependField()) && null != dependValue) {
            conditions.add(new Condition(edit.referenceTreeType().dependColumn(), (Object)dependValue, QueryExpression.EQ));
        }
        List<String> conditionStrings = Arrays.stream(edit.filter()).map(Filter::value).collect(Collectors.toList());
        return this.preEruptDataService.geneTree(referenceEruptModel, treeType.id(), treeType.label(), treeType.pid(), treeType.rootPid(), EruptQuery.builder().orderBy(edit.orderBy()).conditionStrings(conditionStrings).conditions(conditions).build());
    }

    @PostMapping(value={"/extra-row/{erupt}"})
    @EruptRouter(authIndex=2, verifyType=EruptRouter.VerifyType.ERUPT)
    public List<Row> extraRow(@PathVariable(value="erupt") String erupt, @RequestBody TableQuery tableQuery) {
        ArrayList<Row> rows = new ArrayList<Row>();
        DataProxyInvoke.invoke(EruptCoreService.getErupt(erupt), dataProxy -> Optional.ofNullable(dataProxy.extraRow(tableQuery.getCondition())).ifPresent(rows::addAll));
        return rows;
    }

    public EruptDataController(EruptService eruptService, PreEruptDataService preEruptDataService) {
        this.eruptService = eruptService;
        this.preEruptDataService = preEruptDataService;
    }
}

