/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.core.util;

import java.util.Arrays;
import java.util.function.Consumer;
import org.apache.commons.lang3.math.NumberUtils;

public class TypeUtil {
    private static final String[] SIMPLE_JPA_TYPE = new String[]{"byte", "short", "int", "integer", "long", "float", "double", "boolean", "char", "String", "date", "character", "char"};
    private static final String[] NUMBER_TYPE = new String[]{"short", "int", "integer", "long", "float", "double", "bigdecimal", "biginteger"};

    public static Object typeStrConvertObject(Object obj, Class<?> targetType) {
        String str = obj.toString();
        if (NumberUtils.isCreatable((String)str) && str.endsWith(".0")) {
            str = str.substring(0, str.length() - 2);
        }
        if (Integer.TYPE == targetType || Integer.class == targetType) {
            return Integer.valueOf(str);
        }
        if (Short.TYPE == targetType || Short.class == targetType) {
            return Short.valueOf(str);
        }
        if (Long.TYPE == targetType || Long.class == targetType) {
            return Long.valueOf(str);
        }
        if (Float.TYPE == targetType || Float.class == targetType) {
            return Float.valueOf(str);
        }
        if (Double.TYPE == targetType || Double.class == targetType) {
            return Double.valueOf(str);
        }
        if (Boolean.TYPE == targetType || Boolean.class == targetType) {
            return Boolean.valueOf(str);
        }
        return str;
    }

    public static void simpleNumberTypeArrayToObject(Object obj, String type, Consumer<Number> consumer) {
        block6: {
            block9: {
                block8: {
                    block7: {
                        block5: {
                            if (!Integer.TYPE.getSimpleName().equals(type)) break block5;
                            int[] nArray = (int[])obj;
                            int n = nArray.length;
                            for (int i = 0; i < n; ++i) {
                                Integer i2 = nArray[i];
                                consumer.accept(i2);
                            }
                            break block6;
                        }
                        if (!Short.TYPE.getSimpleName().equals(type)) break block7;
                        short[] sArray = (short[])obj;
                        int n = sArray.length;
                        for (int i = 0; i < n; ++i) {
                            Short i3 = sArray[i];
                            consumer.accept(i3);
                        }
                        break block6;
                    }
                    if (!Long.TYPE.getSimpleName().equals(type)) break block8;
                    long[] lArray = (long[])obj;
                    int n = lArray.length;
                    for (int i = 0; i < n; ++i) {
                        Long i4 = lArray[i];
                        consumer.accept(i4);
                    }
                    break block6;
                }
                if (!Float.TYPE.getSimpleName().equals(type)) break block9;
                float[] fArray = (float[])obj;
                int n = fArray.length;
                for (int i = 0; i < n; ++i) {
                    Float i5 = Float.valueOf(fArray[i]);
                    consumer.accept(i5);
                }
                break block6;
            }
            if (!Double.TYPE.getSimpleName().equals(type)) break block6;
            double[] dArray = (double[])obj;
            int n = dArray.length;
            for (int i = 0; i < n; ++i) {
                Double i6 = dArray[i];
                consumer.accept(i6);
            }
        }
    }

    public static boolean isFieldSimpleType(String typeName) {
        return Arrays.asList(SIMPLE_JPA_TYPE).contains(typeName.toLowerCase());
    }

    public static boolean isNumberType(String typeName) {
        return Arrays.asList(NUMBER_TYPE).contains(typeName.toLowerCase());
    }
}

