/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.core.service;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class I18NTranslateService {
    @Resource
    private HttpServletRequest request;
    private final Map<String, Properties> i18NMapping = new HashMap<String, Properties>();

    public void registerI18NMapping(Map<String, Properties> props) {
        this.i18NMapping.putAll(props);
    }

    public boolean isZh() {
        String lang = this.request.getHeader("lang");
        if (StringUtils.isNotBlank((CharSequence)lang)) {
            return lang.toLowerCase(Locale.ROOT).startsWith("zh");
        }
        return true;
    }

    public String translate(String key, Object ... args) {
        String result;
        String lang = this.request.getHeader("lang");
        if (null != lang && this.i18NMapping.containsKey(lang = lang.toLowerCase()) && StringUtils.isNotBlank((CharSequence)(result = this.i18NMapping.get(lang).getProperty(key)))) {
            return String.format(result, args);
        }
        return key;
    }
}

