/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.core.service;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.DVConstraint;
import org.apache.poi.hssf.usermodel.HSSFDataValidation;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.springframework.stereotype.Service;
import xyz.erupt.annotation.fun.VLModel;
import xyz.erupt.annotation.sub_field.Edit;
import xyz.erupt.annotation.sub_field.EditType;
import xyz.erupt.annotation.sub_field.View;
import xyz.erupt.annotation.sub_field.ViewType;
import xyz.erupt.annotation.sub_field.sub_edit.BoolType;
import xyz.erupt.core.invoke.DataProcessorManager;
import xyz.erupt.core.query.Column;
import xyz.erupt.core.query.EruptQuery;
import xyz.erupt.core.service.EruptCoreService;
import xyz.erupt.core.service.IEruptDataService;
import xyz.erupt.core.util.AnnotationUtil;
import xyz.erupt.core.util.DateUtil;
import xyz.erupt.core.util.EruptUtil;
import xyz.erupt.core.util.ExcelUtil;
import xyz.erupt.core.view.EruptFieldModel;
import xyz.erupt.core.view.EruptModel;
import xyz.erupt.core.view.Page;

@Service
public class EruptExcelService {
    public static final String XLS_FORMAT = ".xls";
    public static final String XLSX_FORMAT = ".xlsx";
    private static final String SIMPLE_CELL_ERR = "\u8bf7\u9009\u62e9\u6216\u8f93\u5165\u6709\u6548\u7684\u9009\u9879\uff0c\u6216\u4e0b\u8f7d\u6700\u65b0\u6a21\u7248\u91cd\u8bd5\uff01";

    public Workbook exportExcel(EruptModel eruptModel, Page page) {
        SXSSFWorkbook wb = new SXSSFWorkbook();
        Sheet sheet = wb.createSheet(eruptModel.getErupt().name());
        sheet.setZoom(160);
        sheet.createFreezePane(0, 1, 1, 1);
        int rowIndex = 0;
        int colNum = 0;
        Row row = sheet.createRow(rowIndex);
        CellStyle headStyle = ExcelUtil.beautifyExcelStyle((Workbook)wb);
        Font headFont = wb.createFont();
        headFont.setColor(IndexedColors.WHITE.index);
        headStyle.setFont(headFont);
        headStyle.setFillForegroundColor(IndexedColors.GREY_50_PERCENT.index);
        headStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        headFont.setBold(true);
        headStyle.setFont(headFont);
        int cellNum = 0;
        for (EruptFieldModel fieldModel : eruptModel.getEruptFieldModels()) {
            for (View view : fieldModel.getEruptField().views()) {
                ++cellNum;
                if (!view.show() || !view.export()) continue;
                sheet.setColumnWidth(cellNum, (view.title().length() + 10) * 256);
                Cell cell = row.createCell(colNum);
                cell.setCellStyle(headStyle);
                cell.setCellValue(view.title());
                ++colNum;
            }
        }
        CellStyle style = ExcelUtil.beautifyExcelStyle((Workbook)wb);
        for (Map<String, Object> map : page.getList()) {
            int dataColNum = 0;
            row = sheet.createRow(++rowIndex);
            for (EruptFieldModel fieldModel : eruptModel.getEruptFieldModels()) {
                for (View view : fieldModel.getEruptField().views()) {
                    if (!view.show() || !view.export()) continue;
                    Cell cell = row.createCell(dataColNum);
                    cell.setCellStyle(style);
                    Object val = StringUtils.isNotBlank((CharSequence)view.column()) ? map.get(fieldModel.getFieldName() + "_" + view.column().replace(".", "_")) : map.get(fieldModel.getFieldName());
                    Edit edit = fieldModel.getEruptField().edit();
                    Optional.ofNullable(val).ifPresent(it -> {
                        String str = it.toString();
                        if (edit.type() == EditType.BOOLEAN || view.type() == ViewType.BOOLEAN) {
                            if (edit.boolType().trueText().equals(str)) {
                                cell.setCellValue(edit.boolType().trueText());
                            } else if (edit.boolType().falseText().equals(str)) {
                                cell.setCellValue(edit.boolType().falseText());
                            }
                        } else {
                            cell.setCellValue(str);
                        }
                    });
                    ++dataColNum;
                }
            }
        }
        return wb;
    }

    public List<JsonObject> excelToEruptObject(EruptModel eruptModel, Workbook workbook) throws Exception {
        Sheet sheet = workbook.getSheetAt(0);
        Row titleRow = sheet.getRow(0);
        HashMap<String, EruptFieldModel> editTitleMappingEruptField = new HashMap<String, EruptFieldModel>(eruptModel.getEruptFieldModels().size());
        for (EruptFieldModel fieldModel : eruptModel.getEruptFieldModels()) {
            editTitleMappingEruptField.put(fieldModel.getEruptField().edit().title(), fieldModel);
        }
        HashMap<Integer, EruptFieldModel> cellIndexMapping = new HashMap<Integer, EruptFieldModel>(titleRow.getPhysicalNumberOfCells());
        HashMap cellIndexJoinEruptMap = new HashMap();
        block16: for (int i = 0; i < titleRow.getPhysicalNumberOfCells(); ++i) {
            String titleName = titleRow.getCell(i).getStringCellValue();
            EruptFieldModel eruptFieldModel = (EruptFieldModel)editTitleMappingEruptField.get(titleName);
            cellIndexMapping.put(i, eruptFieldModel);
            Edit edit = eruptFieldModel.getEruptField().edit();
            switch (edit.type()) {
                case CHOICE: {
                    Map<String, String> map = EruptUtil.getChoiceMap(edit.choiceType());
                    HashMap<String, String> choiceMap = new HashMap<String, String>(map.size());
                    for (Map.Entry<String, String> entry : map.entrySet()) {
                        choiceMap.put(entry.getValue(), entry.getKey());
                    }
                    cellIndexJoinEruptMap.put(i, choiceMap);
                    continue block16;
                }
                case BOOLEAN: {
                    HashMap<String, Boolean> boolMap = new HashMap<String, Boolean>(2);
                    BoolType boolType = eruptFieldModel.getEruptField().edit().boolType();
                    boolMap.put(boolType.trueText(), true);
                    boolMap.put(boolType.falseText(), false);
                    cellIndexJoinEruptMap.put(i, boolMap);
                    continue block16;
                }
                case REFERENCE_TREE: {
                    IEruptDataService iEruptDataService = DataProcessorManager.getEruptDataProcessor(eruptModel.getClazz());
                    ArrayList<Column> columns = new ArrayList<Column>();
                    columns.add(new Column(edit.referenceTreeType().id(), edit.referenceTreeType().id()));
                    columns.add(new Column(edit.referenceTreeType().label(), edit.referenceTreeType().label()));
                    Collection<Map<String, Object>> list = iEruptDataService.queryColumn(EruptCoreService.getErupt(eruptFieldModel.getFieldReturnName()), columns, EruptQuery.builder().build());
                    HashMap<String, Object> refTreeMap = new HashMap<String, Object>(list.size());
                    for (Map<String, Object> m : list) {
                        Object label = m.get(edit.referenceTreeType().label());
                        if (null == label) continue;
                        refTreeMap.put(label.toString(), m.get(edit.referenceTreeType().id()));
                    }
                    cellIndexJoinEruptMap.put(i, refTreeMap);
                    continue block16;
                }
                case REFERENCE_TABLE: {
                    IEruptDataService eruptDataProcessor = DataProcessorManager.getEruptDataProcessor(eruptModel.getClazz());
                    ArrayList<Column> columnList = new ArrayList<Column>();
                    columnList.add(new Column(edit.referenceTableType().id(), edit.referenceTableType().id()));
                    columnList.add(new Column(edit.referenceTableType().label(), edit.referenceTableType().label()));
                    Collection<Map<String, Object>> list2 = eruptDataProcessor.queryColumn(EruptCoreService.getErupt(eruptFieldModel.getFieldReturnName()), columnList, EruptQuery.builder().build());
                    HashMap<String, Object> refTreeMap2 = new HashMap<String, Object>(list2.size());
                    for (Map<String, Object> m : list2) {
                        Object label = m.get(edit.referenceTableType().label());
                        if (null == label) continue;
                        refTreeMap2.put(label.toString(), m.get(edit.referenceTableType().id()));
                    }
                    cellIndexJoinEruptMap.put(i, refTreeMap2);
                    continue block16;
                }
            }
        }
        ArrayList<JsonObject> listObject = new ArrayList<JsonObject>();
        for (int rowNum = 1; rowNum <= sheet.getLastRowNum(); ++rowNum) {
            Row row = sheet.getRow(rowNum);
            if (row.getPhysicalNumberOfCells() == 0) continue;
            JsonObject jsonObject = new JsonObject();
            block21: for (int cellNum = 0; cellNum < titleRow.getPhysicalNumberOfCells(); ++cellNum) {
                Cell cell = row.getCell(cellNum);
                EruptFieldModel eruptFieldModel = (EruptFieldModel)cellIndexMapping.get(cellNum);
                if (null == cell || CellType.BLANK == cell.getCellType()) continue;
                Edit edit = eruptFieldModel.getEruptField().edit();
                switch (edit.type()) {
                    case REFERENCE_TREE: 
                    case REFERENCE_TABLE: {
                        JsonObject jo = new JsonObject();
                        try {
                            if (edit.type() == EditType.REFERENCE_TREE) {
                                jo.addProperty(edit.referenceTreeType().id(), ((Map)cellIndexJoinEruptMap.get(cellNum)).get(cell.getStringCellValue()).toString());
                            } else if (edit.type() == EditType.REFERENCE_TABLE) {
                                jo.addProperty(edit.referenceTableType().id(), ((Map)cellIndexJoinEruptMap.get(cellNum)).get(cell.getStringCellValue()).toString());
                            }
                        }
                        catch (Exception e) {
                            throw new Exception(edit.title() + " -> " + this.getStringCellValue(cell) + "\u6570\u636e\u4e0d\u5b58\u5728");
                        }
                        jsonObject.add(eruptFieldModel.getFieldName(), (JsonElement)jo);
                        continue block21;
                    }
                    case CHOICE: {
                        try {
                            jsonObject.addProperty(eruptFieldModel.getFieldName(), ((Map)cellIndexJoinEruptMap.get(cellNum)).get(cell.getStringCellValue()).toString());
                            continue block21;
                        }
                        catch (Exception e) {
                            throw new Exception(edit.title() + " -> " + this.getStringCellValue(cell) + "\u6570\u636e\u4e0d\u5b58\u5728");
                        }
                    }
                    case BOOLEAN: {
                        Boolean bool = (Boolean)((Map)cellIndexJoinEruptMap.get(cellNum)).get(cell.getStringCellValue());
                        jsonObject.addProperty(eruptFieldModel.getFieldName(), bool);
                        continue block21;
                    }
                    default: {
                        String rn = eruptFieldModel.getFieldReturnName();
                        if (String.class.getSimpleName().equals(rn)) {
                            jsonObject.addProperty(eruptFieldModel.getFieldName(), this.getStringCellValue(cell));
                            continue block21;
                        }
                        if ("number".equals(rn)) {
                            jsonObject.addProperty(eruptFieldModel.getFieldName(), (Number)cell.getNumericCellValue());
                            continue block21;
                        }
                        if (!EruptUtil.isDateField(eruptFieldModel.getFieldReturnName())) continue block21;
                        jsonObject.addProperty(eruptFieldModel.getFieldName(), DateUtil.getSimpleFormatDate(cell.getDateCellValue()));
                    }
                }
            }
            listObject.add(jsonObject);
        }
        return listObject;
    }

    public String getStringCellValue(Cell cell) {
        cell.setCellType(CellType.STRING);
        return cell.getStringCellValue() + "";
    }

    public Workbook createExcelTemplate(EruptModel eruptModel) {
        HSSFWorkbook wb = new HSSFWorkbook();
        Sheet sheet = wb.createSheet(eruptModel.getErupt().name());
        sheet.setZoom(160);
        sheet.createFreezePane(0, 1, 1, 1);
        Row headRow = sheet.createRow(0);
        int cellNum = 0;
        for (EruptFieldModel fieldModel : eruptModel.getEruptFieldModels()) {
            Edit edit = fieldModel.getEruptField().edit();
            if (!edit.show() || edit.readonly().add() || !StringUtils.isNotBlank((CharSequence)edit.title()) || !AnnotationUtil.getEditTypeMapping(edit.type()).excelOperator()) continue;
            Cell cell = headRow.createCell(cellNum);
            sheet.setColumnWidth(cellNum, (edit.title().length() + 10) * 256);
            DataValidationHelper dvHelper = sheet.getDataValidationHelper();
            switch (edit.type()) {
                case BOOLEAN: {
                    sheet.addValidationData(this.generateValidation(cellNum, SIMPLE_CELL_ERR, (DataValidationConstraint)DVConstraint.createExplicitListConstraint((String[])new String[]{edit.boolType().trueText(), edit.boolType().falseText()})));
                    break;
                }
                case CHOICE: {
                    List<VLModel> vls = EruptUtil.getChoiceList(fieldModel.getEruptField().edit().choiceType());
                    String[] arr = new String[vls.size()];
                    long length = 0L;
                    for (int i = 0; i < vls.size(); ++i) {
                        arr[i] = vls.get(i).getLabel();
                        length += (long)arr[i].length();
                    }
                    if (length > 255L) break;
                    sheet.addValidationData(this.generateValidation(cellNum, SIMPLE_CELL_ERR, (DataValidationConstraint)DVConstraint.createExplicitListConstraint((String[])arr)));
                    break;
                }
                case SLIDER: {
                    sheet.addValidationData(this.generateValidation(cellNum, "\u8bf7\u9009\u62e9\u6216\u8f93\u5165\u6709\u6548\u7684\u9009\u9879\uff0c\u533a\u95f4\uff1a" + edit.sliderType().min() + " - " + edit.sliderType().max(), dvHelper.createNumericConstraint(1, 0, Integer.toString(edit.sliderType().min()), Integer.toString(edit.sliderType().max()))));
                    break;
                }
                case DATE: {
                    if (!fieldModel.getFieldReturnName().equals(Date.class.getSimpleName())) break;
                    sheet.addValidationData(this.generateValidation(cellNum, "\u8bf7\u9009\u62e9\u6216\u8f93\u5165\u6709\u6548\u65f6\u95f4\uff01", dvHelper.createDateConstraint(0, "1900-01-01", "2999-12-31", "yyyy-MM-dd")));
                    break;
                }
            }
            CellStyle style = wb.createCellStyle();
            style.setLocked(true);
            Font font = wb.createFont();
            style.setVerticalAlignment(VerticalAlignment.CENTER);
            style.setAlignment(HorizontalAlignment.CENTER);
            font.setBold(true);
            if (edit.notNull()) {
                font.setColor((short)10);
            }
            if (edit.type() == EditType.REFERENCE_TREE || edit.type() == EditType.REFERENCE_TABLE) {
                style.setFillForegroundColor(IndexedColors.YELLOW1.index);
                style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            }
            style.setFont(font);
            cell.setCellStyle(style);
            cell.setCellValue(fieldModel.getEruptField().edit().title());
            ++cellNum;
        }
        return wb;
    }

    private DataValidation generateValidation(int colIndex, String errHint, DataValidationConstraint constraint) {
        CellRangeAddressList regions = new CellRangeAddressList(1, 1000, colIndex, colIndex);
        HSSFDataValidation dataValidationList = new HSSFDataValidation(regions, constraint);
        dataValidationList.createErrorBox("\u9519\u8bef", errHint);
        return dataValidationList;
    }
}

