/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.core.service;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.ClassUtils;
import xyz.erupt.core.annotation.EruptScan;

public class EruptApplication
implements ImportBeanDefinitionRegistrar {
    private static Class<?> primarySource;
    private static final Set<String> scanPackage;

    public static Class<?> getPrimarySource() {
        return primarySource;
    }

    public static String[] getScanPackage() {
        return scanPackage.toArray(new String[0]);
    }

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        Class clazz = ClassUtils.forName((String)importingClassMetadata.getClassName(), (ClassLoader)ClassUtils.getDefaultClassLoader());
        Optional.ofNullable(clazz.getAnnotation(SpringBootApplication.class)).ifPresent(it -> {
            primarySource = clazz;
        });
        EruptScan eruptScan = clazz.getAnnotation(EruptScan.class);
        if (eruptScan.value().length == 0) {
            scanPackage.add(clazz.getPackage().getName());
        } else {
            Stream.of(eruptScan.value()).filter(pack -> !pack.equals("xyz.erupt")).forEach(scanPackage::add);
        }
    }

    static {
        scanPackage = new HashSet<String>();
    }
}

