/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.core.controller.advice;

import java.util.Date;
import java.util.HashMap;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import xyz.erupt.core.exception.EruptApiErrorTip;
import xyz.erupt.core.exception.EruptWebApiRuntimeException;
import xyz.erupt.core.view.EruptApiModel;

@ControllerAdvice
@Order(value=0x7FFFFFFE)
public class EruptExceptionHandlerAdvice {
    @ResponseBody
    @ExceptionHandler(value={EruptWebApiRuntimeException.class})
    public Object eruptWebApiRuntimeException(EruptWebApiRuntimeException e, HttpServletRequest request, HttpServletResponse response) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        response.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
        if (e.isPrintStackTrace()) {
            e.printStackTrace();
        }
        map.put("error", "erupt web api error");
        map.put("message", e.getMessage());
        map.put("timestamp", new Date());
        map.put("path", request.getServletPath());
        map.put("status", response.getStatus());
        Optional.ofNullable(e.getExtraMap()).ifPresent(map::putAll);
        return map;
    }

    @ExceptionHandler(value={EruptApiErrorTip.class})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public EruptApiModel eruptApiErrorTip(EruptApiErrorTip e) {
        e.eruptApiModel.setErrorIntercept(false);
        return e.eruptApiModel;
    }
}

